//************************************************
/*
 * User_Param_Config.h
 *
 *  Created on: Jun 18, 2020
 *      Author: Charles Chen
 */
//************************************************
//P1.5 SCLK
//P1.6 SIN
//P1.7 SOUT
//P5.6 Latch
//P2.4 GSCLK

#ifndef SYSTEM_HEAD_USER_PARAM_CONFIG_H_
#define SYSTEM_HEAD_USER_PARAM_CONFIG_H_

#define CASCADE_NUM 10

//Control data latch
#define DC_INIT 0x0F    //LSB 7bits
#define MC_INIT 0x01    //LSB 3bits
#define BC_INIT 0x7F    //LSB 7bits
#define FUNC_INIT 0x05  //LSB 5bits
//*************important****************************************
//LSDVLT, ESPWM, REFRESH, TMGRST, DSPRPT -> BIT4 TO BIT0
//REFERESH must be enabled for communication fault detection
//**************************************************************

//Brightness_1
#define GS_INIT_H 0xBB  //GSdata MSB 8bits
#define GS_INIT_L 0xAA  //GSdata LSB 8bits

//Brightness_2
#define GS_INIT_H_2 0x44  //GSdata MSB 8bits
#define GS_INIT_L_2 0xBB  //GSdata LSB 8bits

extern uint16_t LSD_fault_cnt_Latch;  //The number of LED short fault
extern uint16_t LOD_fault_cnt_Latch;  //The number of LED open fault
extern uint8_t SID_Data_Latch[40][97]; //SID data format for user
//The following is the SID data corresponding to the SID Load Description in datasheet
//SID_Data_Latch[i][84]:bit672~bit679 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][85]:bit680~bit687 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][86]:bit688~bit695 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][87]:bit696~bit703 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][88]:bit704~bit711 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][89]:bit712~bit719 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][90]:bit720~bit727 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][91]:bit728~bit735 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][92]:bit736~bit743 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][93]:bit744~bit751 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][94]:bit752~bit759 of SID for device i(the ith device in daisy chain)
//SID_Data_Latch[i][95]:bit760~bit767 of SID for device i(the ith device in daisy chain)

#endif /* SYSTEM_HEAD_USER_PARAM_CONFIG_H_ */
