//************************************************
/*
 * Brightness_Switch.c
 *
 *  Created on: Jun 18, 2020
 *      Author: Charles Chen
 */
//************************************************

#include <System_head/System_Init.h>

void Brightness_Switch(void)
{
    if(!LED_MODE)
    {
        Detec_data_H = GS_INIT_H;
        Detec_data_L = GS_INIT_L;

    }
    else
    {
        Detec_data_H = GS_INIT_H_2;
        Detec_data_L = GS_INIT_L_2;
    }

    for(LED_i = 0; LED_i < CASCADE_NUM; LED_i++)
         for(LED_j = 0; LED_j < 48; LED_j++)
         {
             GS_Data_Latch[LED_i][2*LED_j] = Detec_data_L;
             GS_Data_Latch[LED_i][2*LED_j+1] = Detec_data_H;
         }

    GS_data_merge();

    if(detect_blank_cnt==0)
    {
        Data_send(0,1);
        SID_data_merge();
        Fault_Detect();
    }
    else
    {
        if(detect_blank_cnt>0)
        {
            detect_blank_cnt--;
        }
        else
        {
            detect_blank_cnt=0;
        }
        Data_send(0,0);
        RED_LED_OFF();
    }
}


