//************************************************
/*
 * Con_data.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************

#include <System_head/System_Init.h>

uint8_t DC_data[40][48];
uint8_t MC_data[40][3];
uint8_t BC_data[40][3];
uint8_t FUNC_data[40];

uint8_t Control_Data_Latch[40][97];
uint8_t GS_Data_Latch[40][97];
uint8_t SID_Data[40][97];
uint8_t SID_Data_Latch[40][97];

uint8_t Data_Cat;
uint8_t read_en;
uint8_t GS_Data[40][6];

int8_t send_byte_cnt;
int8_t send_device_cnt;

uint8_t LED_MODE;
uint8_t LED_i,LED_j;
uint8_t detect_blank_cnt;
uint8_t Detec_data_H,Detec_data_L;
uint16_t LSD_fault_cnt_Latch;
uint16_t LOD_fault_cnt_Latch;
uint8_t com_fault_cnt_Latch;

void Con_Data_Init(void)
{
    uint8_t CDI_i=0,CDI_j=0;

    Data_Cat = 1;
    read_en = 0;
    send_device_cnt = 0;
    send_byte_cnt = 0;
    LED_MODE = 0;
    LED_i=0;
    LED_j=0;
    detect_blank_cnt = DETECT_BLANK_TIME;
    Detec_data_H=GS_INIT_H;
    Detec_data_L=GS_INIT_L;
    LSD_fault_cnt_Latch = 0;
    LOD_fault_cnt_Latch = 0;
    com_fault_cnt_Latch = 0;

    for(CDI_i=0; CDI_i < CASCADE_NUM; CDI_i++)
        for(CDI_j=0; CDI_j < 48; CDI_j++)
        {
            DC_data[CDI_i][CDI_j] = DC_INIT;
        }

    for(CDI_i=0; CDI_i < CASCADE_NUM; CDI_i++)
        for(CDI_j=0; CDI_j < 3; CDI_j++)
        {
            MC_data[CDI_i][CDI_j] = MC_INIT;
        }

    for(CDI_i=0; CDI_i < CASCADE_NUM; CDI_i++)
        for(CDI_j=0; CDI_j < 3; CDI_j++)
        {
            BC_data[CDI_i][CDI_j] = BC_INIT;
        }

    for(CDI_i=0; CDI_i < CASCADE_NUM; CDI_i++)
        {
            FUNC_data[CDI_i] = FUNC_INIT;
        }

    for(CDI_i=0; CDI_i < 40; CDI_i++)
         for(CDI_j=0; CDI_j < 97; CDI_j++)
         {
             Control_Data_Latch[CDI_i][CDI_j] = 0;
         }

    for(CDI_i=0; CDI_i < 40; CDI_i++)
    {
         for(CDI_j=0; CDI_j < 97; CDI_j++)
         {
                 GS_Data_Latch[CDI_i][CDI_j] = 0;
         }
    }

    for(CDI_i=0; CDI_i < CASCADE_NUM; CDI_i++)
         for(CDI_j=0; CDI_j < 48; CDI_j++)
         {
             GS_Data_Latch[CDI_i][2*CDI_j] = GS_INIT_L;
             GS_Data_Latch[CDI_i][2*CDI_j+1] = GS_INIT_H;
         }

    for(CDI_i=0; CDI_i < 40; CDI_i++)
         for(CDI_j=0; CDI_j < 97; CDI_j++)
         {
             SID_Data[CDI_i][CDI_j] = 0x00;
         }

    for(CDI_i=0; CDI_i < 40; CDI_i++)
         for(CDI_j=0; CDI_j < 97; CDI_j++)
         {
             SID_Data_Latch[CDI_i][CDI_j] = 0x00;
         }
}
