//************************************************
/*
 * Data_merge.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************
#include <System_head/System_Init.h>

void Control_data_merge(uint8_t DC[][48], uint8_t MC[][3], uint8_t BC[][3], uint8_t FUNC[])
{
    uint8_t merge_i=0, merge_j=0,merge_k=0;
    for(merge_k=0; merge_k<CASCADE_NUM; merge_k++)
    {
        for(merge_i=0; merge_i<6; merge_i++)
            for(merge_j=0; merge_j<7; merge_j++)
            {
                Control_Data_Latch[merge_k][merge_i*7+merge_j] = (DC[merge_k][merge_i*8+merge_j+1]<<(7-merge_j))
                        + (DC[merge_k][merge_i*8+merge_j]>>merge_j);
            }
        Control_Data_Latch[merge_k][42] = (MC[merge_k][0]) + (MC[merge_k][1]<<3) + (MC[merge_k][2]<<6);
        Control_Data_Latch[merge_k][43] = (BC[merge_k][0]<<1) + (MC[merge_k][2]>>2);
        Control_Data_Latch[merge_k][44] = (BC[merge_k][2]<<7) + (BC[merge_k][1]);
        Control_Data_Latch[merge_k][45] = (FUNC[merge_k]<<6) + (BC[merge_k][2]>>1);
        Control_Data_Latch[merge_k][46] = (FUNC[merge_k]>>2);
        Control_Data_Latch[merge_k][95] = 0x40;
        Control_Data_Latch[merge_k][96] = 0x65;
    }
}

void GS_data_merge(void)
{
    uint8_t merge_i=0;
    for(merge_i=0; merge_i<CASCADE_NUM; merge_i++)
    {
        GS_Data[merge_i][1] = GS_Data_Latch[merge_i][91];
        GS_Data[merge_i][2] = GS_Data_Latch[merge_i][92];
        GS_Data[merge_i][3] = GS_Data_Latch[merge_i][93];
        GS_Data[merge_i][4] = GS_Data_Latch[merge_i][94];
        GS_Data[merge_i][5] = GS_Data_Latch[merge_i][95];

        GS_Data_Latch[merge_i][91] = (GS_Data_Latch[merge_i][90]>>7) + (GS_Data[merge_i][1]<<1);
        GS_Data_Latch[merge_i][92] = (GS_Data[merge_i][1]>>6) + (GS_Data[merge_i][2]<<2);
        GS_Data_Latch[merge_i][93] = (GS_Data[merge_i][2]>>5) + (GS_Data[merge_i][3]<<3);
        GS_Data_Latch[merge_i][94] = (GS_Data[merge_i][3]>>4) + (GS_Data[merge_i][4]<<4);
        GS_Data_Latch[merge_i][95] = (GS_Data[merge_i][4]>>3) + (GS_Data[merge_i][5]<<5);
        GS_Data_Latch[merge_i][96] = (GS_Data[merge_i][5]>>2);
    }

}

void SID_data_merge(void)
{
    uint8_t merge_i=0, merge_j=0;

    for(merge_j=0; merge_j<CASCADE_NUM; merge_j++)
        for(merge_i=0; merge_i<6; merge_i++)
            SID_Data_Latch[merge_j][95-merge_i]=(SID_Data[merge_j][95-merge_i+1]<<(merge_i+2))+
            (SID_Data[merge_j][95-merge_i]>>(5-merge_i));

    for(merge_j=0; merge_j<CASCADE_NUM; merge_j++)
        for(merge_i=0; merge_i<6; merge_i++)
            SID_Data_Latch[merge_j][89-merge_i]= SID_Data[merge_j][89-merge_i];
}
