//************************************************
/*
 * Fault_Detect.c
 *
 *  Created on: Jun 16, 2020
 *      Author: Charles Chen
 */
//************************************************

#include <System_head/System_Init.h>

void Fault_Detect(void)
{
     uint8_t i,j,k;
     uint8_t wire_break_flag;
     uint16_t LSD_fault_cnt,LOD_fault_cnt;
     uint16_t com_fault_cnt;
     LSD_fault_cnt = 0;
     LOD_fault_cnt = 0;
     com_fault_cnt = 0;
     wire_break_flag = 0;
     for(i=0; i < CASCADE_NUM; i++)
     {
          for(j=84; j < 90; j++)
          {
              for(k=0; k<7; k++)
              {
                  if((SID_Data_Latch[i][j]>>k) & 0x01)
                  {
                      LSD_fault_cnt++;
                  }
              }
          }

          for(j=90; j < 96; j++)
          {
              for(k=0; k<7; k++)
             {
                if((SID_Data_Latch[i][j]>>k) & 0x01)
                {
                    LOD_fault_cnt++;
                }
             }
          }

     }

     for(i=0; i < CASCADE_NUM; i++)
         for(j=0; j < 42; j++)
         {
             if(!(SID_Data[i][2*j]==Detec_data_L))
             {
                 com_fault_cnt++;
             }
             if(!(SID_Data[i][2*j+1]==Detec_data_H))
             {
                 com_fault_cnt++;
             }
         }

     if(com_fault_cnt==0)
     {
         RED_LED_OFF();
         com_fault_cnt_Latch = 0;
     }
     else
     {
         RED_LED_ON();
         com_fault_cnt_Latch = com_fault_cnt;
         com_fault_cnt = 0;
     }

     for(i=0; i < CASCADE_NUM; i++)
     {
         for(j=42; j <48; j++)
         {
             if(!(SID_Data_Latch[i][2*j]==Detec_data_L))
             {
                 com_fault_cnt++;
             }
             if(!(SID_Data_Latch[i][2*j+1]==Detec_data_H))
             {
                 com_fault_cnt++;
             }
         }
         if(com_fault_cnt == 0)
         {
             wire_break_flag = 1;
             RED_LED_ON();
             com_fault_cnt = 0;
             break;
         }
         else
         {
             wire_break_flag = 0;
             if(com_fault_cnt_Latch==0)
             {
                 RED_LED_OFF();
             }
             com_fault_cnt = 0;
         }
         com_fault_cnt = 0;
     }

     if(wire_break_flag == 1)
     {
         RGB_G_ON();
         RGB_R_OFF();
         RGB_B_OFF();
     }
     else
     {
          if((LSD_fault_cnt==0) && (LOD_fault_cnt==0))
          {
              RGB_G_ON();
              RGB_R_OFF();
              RGB_B_OFF();
              LSD_fault_cnt_Latch = 0;
              LOD_fault_cnt_Latch = 0;
          }
          else
          {
              RGB_G_OFF();
              if(LSD_fault_cnt==0)
              {
                  RGB_R_OFF();
                  LSD_fault_cnt_Latch = 0;
              }
              else
              {
                  RGB_R_ON();
                  LSD_fault_cnt_Latch = LSD_fault_cnt;
                  LSD_fault_cnt = 0;
              }

              if(LOD_fault_cnt==0)
              {
                  RGB_B_OFF();
                  LOD_fault_cnt_Latch = 0;
              }
              else
              {
                  RGB_B_ON();
                  LOD_fault_cnt_Latch = LOD_fault_cnt;
                  LOD_fault_cnt = 0;
              }
          }

     }
}

