//************************************************
/*
 * IO.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************

#include <System_head/System_Init.h>

//P1.5 SCLK
//P1.6 SIN
//P1.7 SOUT
//P5.1 Latch
//P2.4 GSCLK
void IO_init(void)
{
    P1->SEL0 |= BIT5 | BIT6 | BIT7;
    // P1.5 SCLK,P1.6 SIN,P1.7 SOUT

    P5->DIR |= BIT6;    // P5.1 Latch
    P5->OUT &= ~BIT6;   // P5.1 output low

    P2->DIR |= BIT4;    // P2.4 set as GSCLK
    P2->OUT &= ~BIT4;   // P2.4 output low
    P2->SEL0 |= BIT4;   // P2.4 option selection TA0.1

    P2->DIR |= BIT0|BIT1|BIT2;  //MCU LED ON
    P2->OUT &= ~(BIT0|BIT1|BIT2);
    P1->DIR |= BIT0;
    P1->OUT &= ~BIT0;

    P1->DIR &= ~(uint8_t) BIT1;
    P1->OUT |= BIT1;
    P1->REN |= BIT1;                         // Enable pull-up resistor (P1.1 output high)
    P1->SEL0 &= ~BIT1;
    P1->SEL1 &= ~BIT1;
    P1->IES |= BIT1;                         // Interrupt on high-to-low transition
    P1->IFG &= ~BIT1;                            // Clear all P1 interrupt flags
    P1->IE |= BIT1;                          // Enable interrupt for P1.1
}

void PORT1_ISR(void)
{
    volatile uint32_t i;

    if(P1->IFG & BIT1)
    {
        if(LED_MODE<1)
        {
            LED_MODE++;
        }
        else
        {
            LED_MODE = 0;
        }
    }
    for(i = 0; i < 10000; i++)
    detect_blank_cnt = DETECT_BLANK_TIME;
    P1->IFG &= ~BIT1;
}


