//************************************************
/*
 * SPI.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************

#include <System_head/System_Init.h>

void SPI_Init(void)
{
    EUSCI_B0->CTLW0 |= EUSCI_B_CTLW0_SWRST; // Put eUSCI state machine in reset
    EUSCI_B0->CTLW0 = EUSCI_B_CTLW0_SWRST | // Remain eUSCI state machine in reset
            EUSCI_B_CTLW0_MST |             // Set as SPI master
            EUSCI_B_CTLW0_SYNC |            // Set as synchronous mode
            EUSCI_B_CTLW0_CKPL |            // Set clock polarity high
            EUSCI_B_CTLW0_MSB |             // MSB first
            EUSCI_B_CTLW0_SEVENBIT;
    EUSCI_B0->CTLW0 |= EUSCI_B_CTLW0_SSEL__SMCLK; // SMCLK
    EUSCI_B0->BRW = SCLK_FRE;                           //fBitClock = fBRCLK/(UCBRx+1). //2M, 24
    EUSCI_B0->CTLW0 &= ~EUSCI_B_CTLW0_SWRST;      // Initialize USCI state machine
}

void SPI_send_ISR(void)
{
    if (EUSCI_B0->IFG & EUSCI_B_IFG_TXIFG)
   {
       EUSCI_B0->IFG &= ~EUSCI_B_IFG_TXIFG;
       if(send_device_cnt>=0)
       {
           if(Data_Cat==1)
           {
               EUSCI_B0->TXBUF = Control_Data_Latch[send_device_cnt][send_byte_cnt];
           }
           else
           {
               EUSCI_B0->TXBUF = GS_Data_Latch[send_device_cnt][send_byte_cnt];
           }
           if(read_en == 1)
           {
               while(!(EUSCI_B0->IFG & EUSCI_B_IFG_RXIFG));
               SID_Data[send_device_cnt][send_byte_cnt]=EUSCI_B0->RXBUF;
           }
           send_byte_cnt--;
           if(send_byte_cnt == 89)
           {
              while(EUSCI_B0->STATW & 0x01);
              EUSCI_B0->CTLW0 |= EUSCI_B_CTLW0_SWRST;
              EUSCI_B0->CTLW0 &= ~EUSCI_B_CTLW0_SEVENBIT;
              EUSCI_B0->CTLW0 &= ~EUSCI_B_CTLW0_SWRST;
              EUSCI_B0->IFG |= EUSCI_B_IFG_TXIFG;
              EUSCI_B0->IE |= EUSCI_B_IE_TXIE;
           }
           if(send_byte_cnt == -1)
           {
               send_device_cnt--;
               send_byte_cnt = 96;
               while(EUSCI_B0->STATW & 0x01);
               EUSCI_B0->CTLW0 |= EUSCI_B_CTLW0_SWRST;
               EUSCI_B0->CTLW0 |= EUSCI_B_CTLW0_SEVENBIT;
               EUSCI_B0->CTLW0 &= ~EUSCI_B_CTLW0_SWRST;
               EUSCI_B0->IFG |= EUSCI_B_IFG_TXIFG;
               EUSCI_B0->IE |= EUSCI_B_IE_TXIE;
           }
       }
       else
       {
           while(EUSCI_B0->STATW & 0x01);
           EUSCI_B0->IE &= ~EUSCI_B_IE_TXIE;
           P5->OUT |= BIT6;
           delay_us(10);
           P5->OUT &= ~BIT6;
       }
   }
}


