//************************************************
/*
 * Sys_Init.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************
#include <System_head/System_Init.h>

void Sys_Init(void)
{
    WDT_A->CTL = WDT_A_CTL_PW |             // Stop watchdog timer
               WDT_A_CTL_HOLD;

    delay_ms(20);
    IO_init();
    Con_Data_Init();
    Control_data_merge(DC_data,MC_data,BC_data,FUNC_data);
    GS_data_merge();
    SID_data_merge();
    Timer_Init();
    GSCLK_disable();
    SPI_Init();
    delay_ms(2);
    RGB_G_ON();

    __enable_irq();                         // Enable global interrupt

    NVIC->ISER[0] = 1 << ((EUSCIB0_IRQn) & 31);     // Enable eUSCI_B0 interrupt in NVIC module
    NVIC->ISER[1] = 1 << ((PORT1_IRQn) & 31);
}

