//************************************************
/*
 * main.c
 *
 *  Created on: Jun 10, 2020
 *      Author: Charles Chen
 */
//************************************************

#include "ti/devices/msp432p4xx/inc/msp.h"
#include <stdint.h>
#include <System_head/System_Init.h>

int main(void)
{
    Sys_Init();

    Single_Configure_Test();
    Single_Configure_Test();

    SCB->SCR &= ~SCB_SCR_SLEEPONEXIT_Msk;       // Wake up on exit from ISR
    __DSB();                                    // Ensures SLEEPONEXIT takes effect immediately

    while(1)
    {
        delay_ms(UPDATE_RATE);
        Brightness_Switch();
    }
}

void EUSCIB0_IRQHandler(void)
{
    SPI_send_ISR();
}

void PORT1_IRQHandler(void)
{
    PORT1_ISR();
}

