/* 
 * File:   TPS25751.h
 * Author: design4
 *
 * Created on 10 August, 2025, 4:59 PM
 */

#ifndef TPS25751_H
#define	TPS25751_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <xc.h>          // include processor files - each processor file is guarded.  
#include "definitions.h" // IWYU pragma: keep

#define TPS_PATCH_SIZE 11392
    
#define MODE_REGISTER 0x03
#define COMMAND_REGISTER_FOR_I2C1_REGISTER 0x08
#define DATA_REGISTER_FOR_CMD1_REGISTER 0x09
#define INTERRRUPT_MASK_FOR_I2C1_REGISTER 0x16
#define INTERRRUPT_CLEAR_FOR_I2C1_REGISTER 0x18
#define RECEIVED_SOURCE_CAPABILITIES_REGISTER 0x30
    
#define TPS25751_I2C_ADDR   0x47  // Placed pull-down resistor
#define TPS25751_I2C_ADDR_READ  ((TPS25751_I2C_ADDR << 1) | (1 << 0))
#define TPS25751_I2C_ADDR_WRITE ((TPS25751_I2C_ADDR << 1) | (0 << 0))
    
#define READ_I2Ct_IRQ_VALUE() TP19_GetValue()
    
typedef enum
{
    OK,
    ERROR
} Status;


Status ptch_to_app(void); // This Function is call to the main.c application firmware


#ifdef	__cplusplus
}
#endif

#endif	/* TPS25751_H */

