#include "r_cg_macrodriver.h"
#include "r_cg_userdefine.h"
#include "Config_CSIH0.h"


#define NULL ((void*)0)

uint16_t spi_frame(uint8_t cmd, uint8_t addr, uint8_t data);
void tps92682_write_reg(uint8_t reg_addr, uint8_t reg_data);
uint8_t count_ones_16(uint16_t ones);
uint16_t tps92682_read_reg(uint8_t reg_addr);
void init_tps92682_boost(void);

typedef enum {
	TPS92682_REG_EN = 0x00,
	TPS92682_REG_CFG1 = 0x01,
	TPS92682_REG_SWDIV = 0x03,
	TPS92682_REG_ISLOPE = 0x04,
	TPS92682_REG_SOFTSTART = 0x06,
	TPS92682_REG_CH1IADJ = 0x07,
	TPS92682_REG_CH1PWMH = 0x0B,
	TPS92682_REG_CH1PWML = 0x0A,
	TPS92682_REG_CH2PWMH = 0x0D,
	TPS92682_REG_CH2PWML = 0x0C,
	TPS92682_REG_ILIM = 0x0E,
	TPS92682_REG_OV = 0x16,
	TPS92682_REG_FLT1 = 0x11,
	TPS92682_REG_FLT2 = 0x12,	
}tps92682_reg_t;

typedef struct {
    tps92682_reg_t reg;
    uint8_t value;
} tps92682_reg_init_t;

tps92682_reg_init_t tps92682_init_seq[] ={
 {TPS92682_REG_EN,  0xB0},
 {TPS92682_REG_CFG1,  0x63},
 {TPS92682_REG_SWDIV, 0x03},//Change
 {TPS92682_REG_ISLOPE, 0x04},//Change
 {TPS92682_REG_SOFTSTART, 0xFF},
 {TPS92682_REG_CH1IADJ, 0x44},//Change
  {TPS92682_REG_CH1PWMH, 0x03},
  {TPS92682_REG_CH1PWML, 0xFF},
  {TPS92682_REG_CH2PWMH, 0x03},
  {TPS92682_REG_CH2PWML, 0xFF},
  {TPS92682_REG_ILIM, 0x55},//Change
  {TPS92682_REG_OV, 0x66},//Change
  //Read register FLT1 and FLT2
  {TPS92682_REG_EN, 0xB3},
  //Read register FLT1 and FLT2
};

//for counting number of 1's in 16 bit frame
uint8_t count_ones_16(uint16_t ones)
{
    uint8_t cnt = 0;
    while (ones) 
    { 
    cnt += (ones & 1); 
    ones >>= 1; 
    }
    return cnt;
}

uint16_t spi_frame(uint8_t cmd, uint8_t addr, uint8_t data)
{
    uint16_t frame = 0;
    uint16_t mask_frame;
     uint8_t ones;
    frame |= ((uint16_t)(cmd & 0x1) << 15);
    frame |= ((uint16_t)(addr & 0x3F) << 9);
    frame |= (uint16_t)(data);
    
 
    mask_frame = frame & 0xFEFF;   //0xFF7F; 
   
    ones = count_ones_16(mask_frame);
    if ((ones % 2) == 0) {
        // Set parity bit if needed to make total ones odd
        frame |= (1 << 8);
    }
    return frame;
}
/* Wait until TX/RX transfer completes */
static void spi_wait_complete(void)
{
    while(g_csih0_tx_num < g_csih0_total_num) 
    {  }
}


   
//SPI Write Register
void tps92682_write_reg(uint8_t reg_addr, uint8_t reg_data)
{
    uint16_t tx_frame, rx_frame;
    tx_frame = spi_frame(1, reg_addr, reg_data);
    R_Config_CSIH0_Send_Receive(&tx_frame, 1, &rx_frame, _CSIH_SELECT_CHIP_0);
   spi_wait_complete();
}

//SPI read Register
uint16_t tps92682_read_reg(uint8_t reg_addr)
{
    uint16_t tx_frame, rx_frame;
    tx_frame = spi_frame(0, reg_addr, 0x00);
   if(R_Config_CSIH0_Send_Receive(&tx_frame, 1, NULL, _CSIH_SELECT_CHIP_0) != MD_OK)
        return 0xFFFF;
    spi_wait_complete();
   
    //Send dummy frame to receive data
    tx_frame = 0xDEAD;  // Dummy
       if(R_Config_CSIH0_Send_Receive(&tx_frame, 1, &rx_frame, _CSIH_SELECT_CHIP_0) != MD_OK)
        return 0xFFFF;
    spi_wait_complete();
   return rx_frame ;
	
}
//Initalize boost
void init_tps92682_boost(void)
{
	uint16_t frame;
	//tps92682_write_reg(0x26, 0xc3);
	frame = tps92682_read_reg(tps92682_init_seq[0].reg);
	if(frame == 0xFFFF)
	{
		uint8_t value;
		value = 1;
		
	}
  	tps92682_write_reg(tps92682_init_seq[0].reg, tps92682_init_seq[0].value);
	//tps92682_read_reg(tps92682_init_seq[0].reg);
	//tps92682_write_reg(tps92682_init_seq[1].reg, tps92682_init_seq[1].value);
	//tps92682_write_reg(tps92682_init_seq[2].reg, tps92682_init_seq[2].value);
//	tps92682_write_reg(tps92682_init_seq[3].reg, tps92682_init_seq[3].value);
//	tps92682_write_reg(tps92682_init_seq[4].reg, tps92682_init_seq[4].value);
//	tps92682_write_reg(tps92682_init_seq[5].reg, tps92682_init_seq[5].value);
//	tps92682_write_reg(tps92682_init_seq[6].reg, tps92682_init_seq[6].value);
//	tps92682_write_reg(tps92682_init_seq[7].reg, tps92682_init_seq[7].value);
//	tps92682_write_reg(tps92682_init_seq[8].reg, tps92682_init_seq[8].value);
//	tps92682_write_reg(tps92682_init_seq[9].reg, tps92682_init_seq[9].value);
//	tps92682_write_reg(tps92682_init_seq[10].reg, tps92682_init_seq[10].value);
//	tps92682_write_reg(tps92682_init_seq[11].reg, tps92682_init_seq[11].value);
	//tps92682_read_reg(tps92682_init_seq[12].reg);
	//tps92682_read_reg(tps92682_init_seq[13].reg);
	//tps92682_write_reg(tps92682_init_seq[0].reg, tps92682_init_seq[12].value);
	//tps92682_read_reg(tps92682_init_seq[12].reg);
	//tps92682_read_reg(tps92682_init_seq[13].reg);
	
}