
#include "stm32f4xx_ll_system.h"
#include "stm32f4xx_ll_exti.h"
#include "stm32f4xx_ll_cortex.h"
#include "stm32f4xx_ll_gpio.h"
#include "stm32f4xx.h"
#include "i2c.h"
#include "printf.h"
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* I2C1 init function */


/* USER CODE BEGIN Private defines */
/* 类型定义 ------------------------------------------------------------------*/
/* 宏定义 --------------------------------------------------------------------*/
unsigned char address_select_volt[32][3]={      //写，读，PMBUS地址                          
            {0xB0,0xB1,0x58},                   //<=0.039V
            {0xB2,0xB3,0x59},                   //0.073V ± 15mV
            {0xB4,0xB5,0x5A},                   //0.122V ± 15mV
            {0xB6,0xB7,0x5B},                   //0.171V ± 15mV
            {0xB8,0xB9,0x5C},                   //0.219V ± 15mV
            {0xBA,0xBB,0x5D},                   //0.268V ± 15mV
            {0xBC,0xBD,0x5E},                   //0.317V ± 15mV
            {0xBE,0xBF,0x5F},                   //0.366V ± 15mV
            {0xC0,0xC1,0x60},                   //0.415V ± 15mV
            {0xC2,0xC3,0x61},                   //0.464V ± 15mV
            {0xC4,0xC5,0x62},                   //0.513V ± 15mV
            {0xC6,0xC7,0x63},                   //0.562V ± 15mV
            {0xC8,0xC9,0x64},                   //0.610V ± 15mV
            {0xCA,0xCB,0x65},                   //0.660V ± 15mV
            {0xCC,0xCD,0x66},                   //0.708V ± 15mV
            {0xCE,0xCF,0x67},                   //0.757V ± 15mV
            {0xD0,0xD1,0x68},                   //0.806V ± 15mV
            {0xD2,0xD3,0x69},                   //0.854V ± 15mV
            {0xD4,0xD5,0x6A},               
            {0xD6,0xD7,0x6B},               
            {0xD8,0xD9,0x6C},               
            {0xDA,0xDB,0x6D},               
            {0xDC,0xDD,0x6E},               
            {0xDE,0xDF,0x6F},               
            {0xE0,0xE1,0x70},               
            {0xE2,0xE3,0x71},               
            {0xE4,0xE5,0x72},               
            {0xE6,0xE7,0x73},               
            {0xE8,0xE9,0x74},               
            {0xEA,0xEB,0x75},               
            {0xEC,0xED,0x76},               
            {0xEE,0xEF,0x77}                           
        };


/* USER CODE BEGIN 1 */

/* USER CODE END 1 */
void Vr_En_Up(void)
{
    LL_GPIO_SetOutputPin(GPIOA, LL_GPIO_PIN_0);
    LL_mDelay(10);
}

/**
  * @}
  */
void i2c_gpio_init(void)
{
    /* 
    * PB8  -- IIC_SCL
    * PB9  -- IIC_SDA
    */

    /* SCL-OUTPUT-High */
    //LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
    /* SDA-OUTPUT-High */
    //LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);

    /* SCL/SDA-OUTPUT */
		/**/
	LL_GPIO_InitTypeDef GPIO_InitStruct;
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);

	GPIO_InitStruct.Pin = LL_GPIO_PIN_8|LL_GPIO_PIN_9;
	GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
	GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
	GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
	GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
	LL_GPIO_Init(GPIOB, &GPIO_InitStruct);
	
    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_8, LL_GPIO_MODE_OUTPUT);
    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_9, LL_GPIO_MODE_OUTPUT);
    LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);
    /* 
    * PB6  -- IIC_SCL
    * PB7  -- IIC_SDA
    */

    /* SCL-OUTPUT-High */
    //LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_8);
    /* SDA-OUTPUT-High */
    //LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_9);

    /* SCL/SDA-OUTPUT */
		/**/
		LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_6);
		LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_7);
		GPIO_InitStruct.Pin = LL_GPIO_PIN_6|LL_GPIO_PIN_7;
		GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
		GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
		GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
		GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
		LL_GPIO_Init(GPIOB, &GPIO_InitStruct);
	
//    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_6, LL_GPIO_MODE_OUTPUT);
//    LL_GPIO_SetPinMode(GPIOB, LL_GPIO_PIN_7, LL_GPIO_MODE_OUTPUT);
    LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_6);
	LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_7);
    //LL_mDelay(1);
}


/*PB8 PB9*/
void I2C_Delay(int ms)
{
   LL_mDelay(ms);

    #if 0
    unsigned int i,j;
    for(i=ms;i>0;i--)
    {
        for(j=5000;j>0;j--);
    }
    #endif
}
    
            
void I2C_Start(void)
{
     /* 当SCL高电平时，SDA出现一个下跳沿表示I2C总线启动信号 */
      I2C_SDA_OUT();

      I2C_SCL_LOW();
      I2C_Delay(1);
      
      I2C_SDA_HIGH();
      I2C_Delay(1);
      I2C_SCL_HIGH();
      I2C_Delay(1);
      I2C_SDA_LOW();
      I2C_Delay(1);
      I2C_SCL_LOW();
}        
        
void I2C_Stop(void)
{
     /* 当SCL高电平时，SDA出现一个上跳沿表示I2C总线停止信号 */    
     I2C_SDA_OUT();
     I2C_SCL_LOW();
     I2C_Delay(1);              
     I2C_SDA_LOW();        
     I2C_Delay(1);          
     I2C_SCL_HIGH();
     I2C_Delay(2);        
     I2C_SDA_HIGH();
     //I2C_SDA_IN();
     //I2C_SDA_READ();
     I2C_Delay(1);
}
       
        

uint8_t I2C_WaitAck(void)
{
    uint8_t re;    
    
    I2C_SCL_LOW(); /* CPU驱动SCL = 1, 此时器件会返回ACK应答 */
    I2C_Delay(1);
    I2C_SDA_IN();

    if(I2C_SDA_READ())
        re = 1;
    else
        re = 0;

    I2C_Delay(1);           
    I2C_SCL_HIGH();
    I2C_Delay(2);          

    return re;
}
        

void I2C_Ack(void)
{ 
    I2C_SCL_LOW();
    I2C_SDA_OUT();
    I2C_SDA_LOW();  /* CPU驱动SDA = 0 */
    I2C_Delay(2);
    I2C_SCL_HIGH(); /* CPU产生1个时钟 */
    I2C_Delay(2);
    I2C_SCL_LOW();
    I2C_Delay(1);
}
        

void I2C_NAck(void)
{
    I2C_SCL_LOW();
    I2C_SDA_OUT();
    I2C_SDA_HIGH(); /* CPU驱动SDA = 1 */
    I2C_Delay(2);
    I2C_SCL_HIGH(); /* CPU产生1个时钟 */
    I2C_Delay(2);
    I2C_SCL_LOW(); 
    I2C_Delay(1);
}

void I2C_SendByte(uint8_t Byte)
{
       uint8_t i;
        
       /* 先发送字节的高位bit7 */
        I2C_SDA_OUT();
        I2C_SCL_LOW();
        
        for (i = 0; i < 8; i++)
        { 
           I2C_SCL_LOW();
           I2C_Delay(1);     
           if(Byte&0x80)
           {
                I2C_SDA_HIGH();
           }else
           {
                I2C_SDA_LOW();
           }

           Byte<<=1;
           
          
           I2C_Delay(1);
           I2C_SCL_HIGH();
           I2C_Delay(2);
          
       }

}
        
        
uint8_t I2C_ReadByte(void)
{
    uint8_t i;
    uint8_t value;

    /* 读到第1个bit为数据的bit7 */
    I2C_SDA_IN();
    //I2C_SDA_HIGH();
    value = 0;
    for (i = 0; i < 8; i++)
    {
        value <<= 1;
        I2C_SCL_LOW();
        I2C_Delay(1);
        
        value |= (uint8_t)I2C_SDA_READ();
        I2C_Delay(1);
        I2C_SCL_HIGH();
        I2C_Delay(2);
    }
    I2C_SCL_LOW();
    return value;
}       

 void I2C_InitGPIO(void)
{
  /* 打开GPIO时钟 */
    
  /* 给一个停止信号, 复位I2C总线上的所有设备到待机模式 */
  I2C_Stop();
}

uint8_t I2C_CheckDevice(uint8_t _Address)
{
    uint8_t ucAck;

    I2C_Start();        /* 发送启动信号 */
    /* 发送设备地址+读写控制bit（0 = w， 1 = r) bit7 先传 */
    I2C_SendByte(_Address);
    I2C_WaitAck();
    I2C_Stop();         /* 发送停止信号 */
    return ucAck;
}

uint8_t I2C_CheckOk(void)
{
     if(I2C_CheckDevice(TPS53681_DEV_ADDR_W) == 0)
    {
        return 1;
    }
    else
    {
        /* 失败后，切记发送I2C总线停止信号 */
        I2C_Stop();     
        return 0;
    }
}
        
/**
  * 函数功能: 从串行EEPROM指定地址处开始读取若干数据
  * 输入参数: ReadBuf : 存放读到的数据的缓冲区指针
  *           Address : 起始地址  
  *           Size : 数据长度，单位为字节
  * 返 回 值:  0 表示失败，1表示成功
  * 说    明：无
  */
uint8_t I2C_ReadBytes(uint8_t *ReadBuf, uint8_t Address, uint8_t Size)
{
    uint16_t i;
    
    /* 采用串行EEPROM随即读取指令序列，连续读取若干字节 */
    
    /* 第1步：发起I2C总线启动信号 */
    I2C_Start();    
  
    /* 第2步：发起控制字节，高7bit是地址，bit0是读写控制位，0表示写，1表示读 */
    I2C_SendByte(TPS53681_DEV_ADDR_W); /* 此处是写指令 */    
  
    /* 第3步：等待ACK */
    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail;  /* EEPROM器件无应答 */
    }
    /* 第4步：发送字节地址，24C02只有256字节，因此1个字节就够了，如果是24C04以上，那么此处需要连发多个地址 */
    I2C_SendByte((uint8_t)Address); 
    /* 第3步：等待ACK */
    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail;  /* EEPROM器件无应答 */
    }

#if 1
    /* 第6步：重新启动I2C总线。前面的代码的目的向EEPROM传送地址，下面开始读取数据 */
    I2C_Start();    
  
    /* 第7步：发起控制字节，高7bit是地址，bit0是读写控制位，0表示写，1表示读 */
    I2C_SendByte(TPS53681_DEV_ADDR_R); /* 此处是读指令 */

    //uart_printf("ret = %d\r\n",ret);
    /* 第8步：发送ACK */
    if (I2C_WaitAck() != 0)
    {
        goto cmd_fail;  /* EEPROM器件无应答 */
    }   
    /* 第9步：循环读取数据 */
    for (i = 0; i < Size; i++)
    {
        ReadBuf[i] = I2C_ReadByte();    /* 读1个字节 */

        I2C_Ack();
        #if 0        
        /* 每读完1个字节后，需要发送Ack， 最后一个字节不需要Ack，发Nack */
        if (i != Size - 1)
        {
            I2C_Ack();  /* 中间字节读完后，CPU产生ACK信号(驱动SDA = 0) */
        }
        else
        {
            I2C_NAck(); /* 最后1个字节读完后，CPU产生NACK信号(驱动SDA = 1) */
        }
        #endif
    }
#endif
    /* 发送I2C总线停止信号 */
    I2C_Stop();
    return 1;   /* 执行成功 */

cmd_fail: /* 命令执行失败后，切记发送停止信号，避免影响I2C总线上其他设备 */
    /* 发送I2C总线停止信号 */
    I2C_Stop();
    return 0;
}


uint8_t I2C_SendBytes(uint8_t Address)
{
        uint16_t i=0;
        uint8_t usAddr;
        
        usAddr = Address;
        /* 第1步：发起I2C总线启动信号 */
        I2C_Start();
        
        /* 第2步：发起控制字节，高7bit是地址，bit0是读写控制位，0表示写，1表示读 */
        I2C_SendByte(TPS53681_DEV_ADDR_W); /* 此处是写指令 */
        
        /* 第3步：发送一个时钟，判断器件是否正确应答 */
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;
        }

        I2C_SendByte(usAddr);
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;  /* EEPROM器件无应答 */
        }  
        
    #if 0
        for (i = 0; i < Size; i++)
        {
            /* 第6步：开始写入数据 */
            I2C_SendByte(WriteBuf[i]);
        
            /* 第7步：发送ACK */
            if (I2C_WaitAck() != 0)
            {
                goto cmd_fail;  /* EEPROM器件无应答 */
            }
        }

  #endif       
        /* 命令执行成功，发送I2C总线停止信号 */
        I2C_Stop();

        return 1;
    
    cmd_fail: /* 命令执行失败后，切记发送停止信号，避免影响I2C总线上其他设备 */
        /* 发送I2C总线停止信号 */
        I2C_Stop();
        return 0;
    }

/**
  * 函数功能: 向串行EEPROM指定地址写入若干数据，采用页写操作提高写入效率
  * 输入参数: WriteBuf : 存放带写入的数据的缓冲区指针
  *           Address : 起始地址
  *           Size : 数据长度，单位为字节 
  * 返 回 值:  0 表示失败，1表示成功
  * 说    明：无
  */
uint8_t I2C_WriteBytes(uint8_t *WriteBuf, uint8_t Address, uint8_t Size)
{
        uint16_t i=0;
        uint8_t usAddr;
        
        usAddr = Address;
        /* 第1步：发起I2C总线启动信号 */
        I2C_Start();
        
        /* 第2步：发起控制字节，高7bit是地址，bit0是读写控制位，0表示写，1表示读 */
        I2C_SendByte(TPS53681_DEV_ADDR_W); /* 此处是写指令 */
        
        /* 第3步：发送一个时钟，判断器件是否正确应答 */
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;
        }

        I2C_SendByte(usAddr);
        if (I2C_WaitAck() != 0)
        {
            goto cmd_fail;  /* EEPROM器件无应答 */
        }  
        
   // #if(Address == TPS53681_CLEAR_FAULT)
        for (i = 0; i < Size; i++)
        {
            /* 第6步：开始写入数据 */
            I2C_SendByte(WriteBuf[i]);
        
            /* 第7步：发送ACK */
            if (I2C_WaitAck() != 0)
            {
                goto cmd_fail;  /* EEPROM器件无应答 */
            }
        }
   // #endif
            
        /* 命令执行成功，发送I2C总线停止信号 */
        I2C_Stop();
        return 1;
    
    cmd_fail: /* 命令执行失败后，切记发送停止信号，避免影响I2C总线上其他设备 */
        /* 发送I2C总线停止信号 */
        I2C_Stop();
        return 0;
    }

   
void tps_power_en(int val)
{
    uint8_t read_buf[16];
    uint8_t addr = 0;
    uint8_t len = 0;
    uint8_t send_buf[16];
    uart_printf("==============spi_set_power_en........\r\n");

    //I2C_CheckDevice(TPS53681_DEV_ADDR_W);
    //LL_mDelay(100);

    //memset(send_buf,0,sizeof(send_buf));
    //send_buf[0]=0x00;
    //I2C_SendBytes(TPS53681_CLEAR_FAULT);  
    
#if 1
    //I2C_CheckDevice(TPS53681_DEV_ADDR_W);
    //uart_printf("==============Vr_En_Up........\r\n");
   

    int i = 0x78;
    for(i=0x78;i<0x81;i++)
    {
        if(i==0x79)
        {
            memset(read_buf,0,sizeof(read_buf));  
            I2C_ReadBytes(read_buf, i, 2);
            uart_printf("(0x%02x) ReadBuf: 0x%02x,0x%02x\r\n",i,read_buf[1],read_buf[0]);
        }
        else{
            memset(read_buf,0,sizeof(read_buf));  
            I2C_ReadBytes(read_buf, i, 1);
            uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",i,read_buf[0]);
        }
    }    

   memset(send_buf,0,sizeof(send_buf));
   send_buf[0]=0x00;
   I2C_SendBytes(TPS53681_CLEAR_FAULT);   

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
        
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_PAGE, 1);
    uart_printf("TPS53681_PAGE(0x00) 0 ReadBuf: 0x%02x\r\n",read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x00;
    I2C_WriteBytes(send_buf, TPS53681_PAGE, 1);             

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_PAGE, 1);
    uart_printf("TPS53681_PAGE(0x00) 1 ReadBuf: 0x%02x\r\n",read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_PHASE, 1);
    uart_printf("TPS53681_PHASE(0x04) 0 ReadBuf: 0x%02x\r\n",read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0xFF;
    I2C_WriteBytes(send_buf, TPS53681_PHASE, 1);             

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_PHASE, 1);
    uart_printf("TPS53681_PHASE(0x04) 1 ReadBuf: 0x%02x\r\n",read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VBOOT, 1);
    uart_printf("TPS53681_VBOOT(0xDB) 0 ReadBuf: 0x%02x\r\n",read_buf[0]);

    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x1D;
    I2C_WriteBytes(send_buf, TPS53681_VBOOT, 1);             

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VBOOT, 1);
    uart_printf("TPS53681_VBOOT(0xDB) 1 ReadBuf: 0x%02x\r\n",read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_COMMAND, 2);
    uart_printf("TPS53681_VOUT_COMMAND(0x21) 0 ReadBuf: 0x%02x,0x%02x\r\n",read_buf[1],read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x1D;
    send_buf[1]=0x00;
    I2C_WriteBytes(send_buf, TPS53681_VOUT_COMMAND, 2);             

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_COMMAND, 2);
    uart_printf("TPS53681_VOUT_COMMAND(0x21) 1 ReadBuf: 0x%02x,0x%02x\r\n",read_buf[1],read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_MIN, 2);
    uart_printf("TPS53681_VOUT_MIN(0x2B) 0 ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x15;                                
    send_buf[1]=0x00;
    I2C_WriteBytes(send_buf, TPS53681_VOUT_MIN, 2); 

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_MIN, 2);
    uart_printf("TPS53681_VOUT_MIN(0x2B) 1 ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_MAX, 2);
    uart_printf("TPS53681_VOUT_MAX(0x24) 0 ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x29;                                
    send_buf[1]=0x00;
    I2C_WriteBytes(send_buf, TPS53681_VOUT_MAX, 2); 

    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_VOUT_MAX, 2);
    uart_printf("TPS53681_VOUT_MAX(0x24) 1 ReadBuf: 0x%02x, 0x%02x\r\n",read_buf[1],read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_ON_OFF_CONFIG, 1);
    uart_printf("TPS53681_ON_OFF_CONFIG(0x02) 0 ReadBuf: 0x%02x\r\n",read_buf[0]);

    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x18;                                            
    I2C_WriteBytes(send_buf, TPS53681_ON_OFF_CONFIG, 1);             
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_ON_OFF_CONFIG, 1);
    uart_printf("TPS53681_ON_OFF_CONFIG(0x02) 1 ReadBuf: 0x%02x\r\n",read_buf[0]);

        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_OPERATE, 1);
    uart_printf("TPS53681_OPERATE(0x01) 0 ReadBuf: 0x%02x\r\n",read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=0x80;
    I2C_WriteBytes(send_buf, TPS53681_OPERATE, 1);             
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_OPERATE, 1);
    uart_printf("TPS53681_OPERATE(0x01) 1 ReadBuf: 0x%02x\r\n",read_buf[0]);
        #ifdef TEST_REG_7E
        memset(read_buf,0,sizeof(read_buf));  
        I2C_ReadBytes(read_buf, 0x7E, 1);
        uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",0x7E,read_buf[0]);
        #endif
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_MFR_SPECIFIC_14, 2);
    uart_printf("TPS53681_MFR_SPECIFIC_14(0xDE) 0 ReadBuf: 0x%02x,0x%02x\r\n",read_buf[1],read_buf[0]);
    
    memset(send_buf,0,sizeof(send_buf));
    send_buf[0]=read_buf[0]|0x80;
    send_buf[1]=read_buf[1];
    I2C_WriteBytes(send_buf, TPS53681_MFR_SPECIFIC_14, 2);             
    
    memset(read_buf,0,sizeof(read_buf));  
    I2C_ReadBytes(read_buf, TPS53681_MFR_SPECIFIC_14, 2);
    uart_printf("TPS53681_MFR_SPECIFIC_14(0xDE) 1 ReadBuf: 0x%02x,0x%02x\r\n",read_buf[1],read_buf[0]);
    
        
    uart_printf("Input 12V\r\n");    
    LL_mDelay(1000);
    uart_printf("1\r\n");
    LL_mDelay(1000);
    uart_printf("2\r\n");
    LL_mDelay(1000);
    uart_printf("3\r\n");
    LL_mDelay(1000);
  
    Vr_En_Up();
        
    while(1)
    {
         for(i=0x78;i<0x81;i++)
        {
            if(i==0x79)
            {
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 2);
                uart_printf("(0x%02x) ReadBuf: 0x%02x,0x%02x\r\n",i,read_buf[1],read_buf[0]);
            }
            else
            {
                memset(read_buf,0,sizeof(read_buf));  
                I2C_ReadBytes(read_buf, i, 1);
                uart_printf("(0x%02x) ReadBuf: 0x%02x\r\n",i,read_buf[0]);
            }
        }
         LL_mDelay(100);
         uart_printf("\r\n\r\n");
         
         memset(send_buf,0,sizeof(send_buf));
         send_buf[0]=0x00;
         I2C_SendBytes(TPS53681_CLEAR_FAULT);  
    }
 #endif
    uart_printf("==============spi_set_power_en End........\r\n\r\n");
      
}

int main(void)
{
    //int delay = 10;
	int i = 0;
	
    hardware_init();
	LL_mDelay(10);
	i2c_gpio_init();
	
	uart_printf("dsgfjhgkgihj ryujryufjuynj\r\n");
	//LL_mDelay(delay);   
    //LL_GPIO_SetOutputPin(GPIOB, LL_GPIO_PIN_15);
    //LL_mDelay(delay);   
    //LL_GPIO_ResetOutputPin(GPIOB, LL_GPIO_PIN_15);
  
	//while(1){
		//mcp_test(1);
        tps_power_en(1);
		LL_mDelay(300 + (i * 100));
		i++;
   //}
  
  //return 0;
}

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
