
#ifndef CALIBRATION_H_
#define CALIBRATION_H_


#include <stdint.h>
#include "cyclone_device.h"
#include "function_definitions.h"

#define CALIBRATION_STRUCT_VERSION      (8U)

typedef struct calibration_data_
{
    Uint16 StructVersion;

    Uint16 hw_version;

    Uint16 vout_cmd;
    Uint16 ibatt_cmd;

    Uint32 vout_sns_offset;
    Uint16 iload_sns_offset;
    Uint16 ibatt_sns_offset;
    Uint16 temp_sns_offset;
    Uint16 vin_sns_offset;
    Uint16 iin_sns_offset;

    Uint16 ibatt_dac_offset;
    Uint16 vout_dac_offset;

    Uint16 vin_ov_cmd;
    Uint16 vin_uv_cmd;
} calibration_data_t;

void Calibration_Initialize(void);
Uint8 Calibration_Initialization(void);
void Calibration_Main(void);

Uint8 Calibration_Status(void);










#endif



