
#ifndef ADC_GAINS_H_
#define ADC_GAINS_H_

#include "cyclone_device.h"

#include "variables.h"
#include "dcdc_parameters.h"
#include "stdint.h"

typedef struct SensorScaling_
{
    uint32_t CountsPerUnit; // Counts per Unit
    int32_t OffsetCounts; // Counts
    uint32_t UnitsPerCount; // Unit per Counts
} SensorScaling_t;

typedef struct ADC_GainTable_
{
    SensorScaling_t LVDC_FB;
    SensorScaling_t EADC_LVDC_FB;
    SensorScaling_t LV_BATTI_SNS;
    SensorScaling_t EADC_LV_BATTI_SNS;

    SensorScaling_t IOUT_MON;
    SensorScaling_t VOUT_SNS;
    SensorScaling_t OV_MON;
    SensorScaling_t BATTI_MON;
    SensorScaling_t HVI_MON;
    SensorScaling_t HVV_MON;
} ADC_GainTable_t;
#define KG 100000
#define ADC_CalcGain(MaxCounts, SensorMV2U, SensorMVmax)     ((((uint32_t)(MaxCounts))*((uint32_t)(SensorMV2U)))/((uint32_t)(SensorMVmax)))
#define ADC_CalcOffset(SensorMV0, MaxCounts, SensorMVmax)    ((((uint32_t)(SensorMV0))*((uint32_t)(MaxCounts)))/((uint32_t)(SensorMVmax)))

#define ADC_CalcScaling(SensorMV2U, SensorMV0, MaxCounts, SensorMVmax) \
    { ADC_CalcGain(MaxCounts, SensorMV2U, SensorMVmax), ADC_CalcOffset(SensorMV0, MaxCounts, SensorMVmax), ((1000*KG)/(ADC_CalcGain(MaxCounts, SensorMV2U, SensorMVmax))) }

#define UCD_ADC12_Scaling(SensorMV2U, SensorMV0)             ADC_CalcScaling(SensorMV2U, SensorMV0, ((1U<<12) - 1U), 2500U)
#define UCD_ADC14_Scaling(SensorMV2U, SensorMV0)             ADC_CalcScaling(SensorMV2U, SensorMV0, ((1U<<14) - 1U), 1600U)
#define UCD_EADC_Scaling(SensorMV2U, SensorMV0)              ADC_CalcScaling(SensorMV2U, SensorMV0, ((1U<<10) - 1U), 1600U)


extern const ADC_GainTable_t HW_Gains[];
extern const Uint8 HW_Gains_Count;


//************************************************************//
// IBat MON  Values - For Battery Charge Curent
//************************************************************//
#define IBAT_MON_COUNTS_TO_MILLIAMP(counts)          ((int32)((((counts)-(HW_Gains[hw_version].BATTI_MON.OffsetCounts))*((HW_Gains[hw_version].BATTI_MON.UnitsPerCount))))/1000)
#define IBAT_MON_MILLIAMP_TO_COUNTS(milliamps)       ((Uint32)((((int32_t)(milliamps)*(HW_Gains[hw_version].BATTI_MON.CountsPerUnit))/KG+HW_Gains[hw_version].BATTI_MON.OffsetCounts)))

//************************************************************//
// IOut MON  Values - For Integrated Charge Curent
//************************************************************//
#define IOUT_MON_COUNTS_TO_MILLIAMP(counts)          ((int32_t)((((counts)-(HW_Gains[hw_version].IOUT_MON.OffsetCounts))*((HW_Gains[hw_version].IOUT_MON.UnitsPerCount))))/1000)
#define IOUT_MON_MILLIAMP_TO_COUNTS(milliamps)       ((Uint32)((((int32_t)(milliamps)*(HW_Gains[hw_version].IOUT_MON.CountsPerUnit))/KG+HW_Gains[hw_version].IOUT_MON.OffsetCounts)))

#define VOUT_COUNTS_TO_MILLIVOLTS(counts)	 	     ((int32_t)(((counts)-(HW_Gains[hw_version].VOUT_SNS.OffsetCounts))*((HW_Gains[hw_version].VOUT_SNS.UnitsPerCount)))/1000)
#define VOUT_SNS_MILLIVOLTS_TO_COUNTS(millivolts)       ((Uint32)((((int32_t)(millivolts)*(HW_Gains[hw_version].VOUT_SNS.CountsPerUnit))/KG+HW_Gains[hw_version].VOUT_SNS.OffsetCounts)))

#define VIN_MON_COUNTS_TO_MILLIVOLTS(counts)           ((uint32_t)((counts)*(HW_Gains[hw_version].HVV_MON.UnitsPerCount)/1000))
#define VIN_MON_MILLIVOLTS_TO_COUNTS(millivolts)       ((Uint32)((((int32_t)(millivolts)*(HW_Gains[hw_version].HVV_MON.CountsPerUnit))/KG+HW_Gains[hw_version].HVV_MON.OffsetCounts)))


#define DAC_IBAT_COUNTS_TO_MILLIAMP(counts)          ((int32_t)(((counts)-(HW_Gains[hw_version].LV_BATTI_SNS.OffsetCounts))*((HW_Gains[hw_version].LV_BATTI_SNS.UnitsPerCount)))/1000)
#define DAC_IBAT_MILLIAMPS_TO_COUNTS(milliamps)      ((int32_t)((((int32_t)(milliamps)*(HW_Gains[hw_version].LV_BATTI_SNS.CountsPerUnit))/KG+(int32_t)HW_Gains[hw_version].LV_BATTI_SNS.OffsetCounts)))

#define EADC_IBAT_COUNTS_TO_MILLIAMP(counts)         ((int32_t)(((counts)-(HW_Gains[hw_version].EADC_LV_BATTI_SNS.OffsetCounts))*((HW_Gains[hw_version].EADC_LV_BATTI_SNS.UnitsPerCount)))/1000)
#define EADC_IBAT_MILLIAMPS_TO_COUNTS(milliamps)     ((int32_t)((((int32_t)(milliamps)*(HW_Gains[hw_version].EADC_LV_BATTI_SNS.CountsPerUnit))/KG+(int32_t)HW_Gains[hw_version].EADC_LV_BATTI_SNS.OffsetCounts)))

//************************************************************//
#define UV_OV_COUNTS_MILIVOLTS_SCALER 	3
//to eliminate float data, x100
//This scalar willbe sued to convert the UV and OV values - Obtained from the Schematic which shows 1.83mV/V as a transfer function for HVDC Batt Monitor
#define UV_OV_COUNTS_MILIVOLTS_SCALER_G 100

#define UV_FAULT_SETPOINT_DEFAULT		(525)	//Set to 175VDC
#define OV_FAULT_SETPOINT_DEFAULT 		(960)	//Set to 320VDC













#endif /* #ifndef ADC_GAINS_H_ */
