#include "system_defines.h"
#include "cyclone_device.h"
#include "pmbus_commands.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"

#define program_flash_integrity_word (*((volatile unsigned long *) 0x7ffc))


void clear_program_flash(void)
{
#ifdef UCD3138128
	DecRegs.PFLASHCTRL_0.bit.MASS_ERASE = 1; //erase it all
	while(DecRegs.PFLASHCTRL_0.bit.BUSY != 0)
#elif UCD3138A64
	DecRegs.PFLASHCTRL_0.bit.MASS_ERASE = 1; //erase it all
	while(DecRegs.PFLASHCTRL_0.bit.BUSY != 0)
#elif UCD3138
	DecRegs.PFLASHCTRL.bit.MASS_ERASE = 1; //erase it all

	while(DecRegs.PFLASHCTRL.bit.BUSY != 0)
#elif UCD3138064
	DecRegs.PFLASHCTRL1.bit.MASS_ERASE = 1; //erase it all
	while(DecRegs.PFLASHCTRL1.bit.BUSY != 0)
#endif
	{
		; //do nothing while it programs
	}
	
	//now reset processor.
//	TimerRegs.WDCTRL.bit.CPU_RESET_EN = 1;  // Make sure the watchdog is enabled.
//	TimerRegs.WDCTRL.bit.WD_PERIOD = 1;		// Set WD period to timeout faster.

	return;
}
