#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"


int DeadTime = 4000;


//KP Change Vout Over Here -- Not Sure what the scaling is. pmbus_dcdc_config[0].vout_cmd
void configure_vout_cmd(void)
{
	struct qnote constant_DAC_VALUE_SCALER = {17486 , -4}; //{DAC_VALUE_SCALER, 0};
	pmbus_dcdc_config_translated[0].vout_cmd = qnote_linear16_multiply_fit14(constant_DAC_VALUE_SCALER, pmbus_dcdc_config[0].vout_cmd, -VOUT_MODE_EXP);
	//VoutCommand = pmbus_dcdc_config_translated[0].vout_cmd;
   // FeCtrl0Regs.RAMPDACEND.all = pmbus_dcdc_config_translated[0].vout_cmd;
}


//KP Change  fault levels here
void configure_fault_levels(void)
{
	//This struct represents the floating point number: 8.05896
	struct qnote vin_scale = {16505 , -11}; //8.05896
	//struct qnote vout_scale = {23357 , -8}; //91.2366
    struct qnote constant_10_24 = {20972 , -11};
	//pmbus_dcdc_config_translated[0].vout_uv_fault_limit = qnote_linear16_multiply_fit(vout_scale, pmbus_dcdc_config[0].vout_uv_fault_limit, -VOUT_MODE_EXP, MAX_VALUE_FIT_12_BITS))>>1;
    // This is converting Vin to a number of counts
	pmbus_dcdc_config_translated[0].temp_ot_fault_limit = qnote_linear11_multiply_fit(constant_10_24, pmbus_dcdc_config[0].temp_ot_fault_limit, MAX_VALUE_FIT_12_BITS) + 694;
	pmbus_dcdc_config_translated[0].vin_ov_fault_limit  = qnote_linear11_multiply_fit(vin_scale, pmbus_dcdc_config[0].vin_ov_fault_limit, MAX_VALUE_FIT_12_BITS);
	pmbus_dcdc_config_translated[0].vin_uv_fault_limit  = qnote_linear11_multiply_fit(vin_scale, pmbus_dcdc_config[0].vin_uv_fault_limit, MAX_VALUE_FIT_12_BITS);
}

//KP Change Minimum Vin On and Off values here/


void configure_cpcc(void)
{
	//struct qnote constant_316_46 = {26253, -6};

	pcmd = linear11_to_qnote(pmbus_dcdc_config[0].cpcc_pmax);

	pnom_value = (Uint32)((int64)pcmd.mantissa * 14000);

	if(pcmd.exponent > 0)
	{
		pnom_value = pnom_value << pcmd.exponent;
	}
	else
	{
		pnom_value = pnom_value >> pcmd.exponent;
	}

	//imax_value = qnote_linear11_multiply_fit(constant_316_46, pmbus_dcdc_config[0].cpcc_imax, 0x0fffff);

	//pout = pnom_value;
	//iout_max = imax_value;
	//cpcc_on = pmbus_dcdc_config[0].cpcc_enable;
}


//KP Change Max Vout limit here
void configure_ovp(void)
{
	Uint16 ovp_limit;
//	struct qnote vdac_scaler = {DAC_OVP, -OVP_EXP};
    struct qnote constant_5_12 = {20972 , -12}; //This struct represents the floating point number: 5.12
	ovp_limit = qnote_linear16_multiply_fit7(constant_5_12,/*pmbus_dcdc_config[0].vout_ov_fault_limit*/0x1F00, -VOUT_MODE_EXP);
	FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_THRESH = ovp_limit;
}

void configure_iout_ocp(void)
{

//This struct represents the floating point number: 2.414
struct qnote constant_2_414 = {23300 , -13};
 FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_THRESH = qnote_linear11_multiply_fit7(constant_2_414, pmbus_dcdc_config[0].iout_oc_fault_limit);

}

void configure_ipri_cycle_by_cycle(void) 
{
//This struct represents the floating point number: 5.125
	struct qnote constant_5_125 = {20992 , -12};

	FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_D_THRESH = 
			qnote_linear11_multiply_fit7(constant_5_125, 
			pmbus_dcdc_config[0].iin_oc_fault_limit);
	//ipri_cbc_limit = FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_D_THRESH;
}



void configure_vout_ramp_rate(void)
{
    //This struct represents the floating point number: 0.25
    struct qnote constant_0_25 = {16384 , -16};
	struct qnote tran_scaler;
	Uint32 ramp_step;

	tran_scaler = qnote_scale_int32(constant_0_25, pmbus_dcdc_config[0].period);
	ramp_step = qnote_linear11_multiply_fit18(tran_scaler, pmbus_dcdc_config[0].vout_transition_rate);
	FeCtrl0Regs.DACSTEP.bit.DAC_STEP = ramp_step;
}

#define TON_RISE_EXP (1)
void configure_ton_rise(void)
{
	Uint32 tempo;
	pmbus_dcdc_config[0].period = 40000; //100Khz Frequency = 40000
	
    tempo = pmbus_dcdc_config_translated[0].vout_cmd * pmbus_dcdc_config[0].period;
	FeCtrl0Regs.DACSTEP.bit.DAC_STEP = tempo / ((Uint32)pmbus_dcdc_config[0].ton_rise * (Uint32)3885);
}

void start_up_reset(void)
{
	FeCtrl0Regs.RAMPCTRL.bit.FIRMWARE_START = 0;
	FeCtrl0Regs.RAMPCTRL.bit.RAMP_EN = 0;
	FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = 0;
	FeCtrl0Regs.RAMPCTRL.bit.RAMP_EN = 1;
}


void configure_dpwm_timing(void)
{

  	Dpwm0Regs.DPWMEV2.bit.EVENT2 = (pmbus_dcdc_config[0].period >> 1)
  	                               - pmbus_dcdc_config[0].dead_time_2;
    
    Dpwm0Regs.DPWMEV4.bit.EVENT4 = (pmbus_dcdc_config[0].period
                                   - pmbus_dcdc_config[0].dead_time_1) + 540;

  	if(Dpwm0Regs.DPWMEV4.bit.EVENT4 > pmbus_dcdc_config[0].period )
  		Dpwm0Regs.DPWMEV4.bit.EVENT4 = Dpwm0Regs.DPWMEV4.bit.EVENT4 - pmbus_dcdc_config[0].period;
  	else
  		Dpwm0Regs.DPWMEV4.bit.EVENT4 = Dpwm0Regs.DPWMEV4.bit.EVENT4;

  	//////////////////////////////////////////////////////////////////
  	Dpwm1Regs.DPWMEV2.bit.EVENT2 = (pmbus_dcdc_config[0].period >> 1)
  	                               - pmbus_dcdc_config[0].dead_time_4;
  	   
    Dpwm1Regs.DPWMEV4.bit.EVENT4 = (pmbus_dcdc_config[0].period
                                   - pmbus_dcdc_config[0].dead_time_3) + 540;

  	if(Dpwm1Regs.DPWMEV4.bit.EVENT4 > pmbus_dcdc_config[0].period )
  		Dpwm1Regs.DPWMEV4.bit.EVENT4 = Dpwm1Regs.DPWMEV4.bit.EVENT4 - pmbus_dcdc_config[0].period;
  	else
  		Dpwm1Regs.DPWMEV4.bit.EVENT4 = Dpwm1Regs.DPWMEV4.bit.EVENT4;

}

void configure_burst_mode(void)
{
	LoopMuxRegs.LLCTRL.bit.LL_EN = 1;
	LoopMuxRegs.LLENTHRESH.bit.TURN_ON_THRESH = 3600;
	LoopMuxRegs.LLDISTHRESH.bit.TURN_OFF_THRESH = 2000;
}

void copy_coefficients_to_filter(volatile struct FILTER_REGS *dest, 
								 const FILTER_PMBUS_REGS *source)
{

	dest->COEFCONFIG.all    	 = source->COEFCONFIG.all;
	dest->FILTERKPCOEF0.all 	 = source->FILTERKPCOEF0.all;
	dest->FILTERKPCOEF1.all 	 = source->FILTERKPCOEF1.all;
	dest->FILTERKICOEF0.all 	 = source->FILTERKICOEF0.all;
	dest->FILTERKICOEF1.all 	 = source->FILTERKICOEF1.all;
	dest->FILTERKDCOEF0.all 	 = source->FILTERKDCOEF0.all;
	dest->FILTERKDCOEF1.all  	 = source->FILTERKDCOEF1.all;
	dest->FILTERKDALPHA.all 	 = source->FILTERKDALPHA.all;
	dest->FILTERNL0.all     	 = source->FILTERNL0.all;
	dest->FILTERNL1.all     	 = source->FILTERNL1.all;
	dest->FILTERNL2.all     	 = source->FILTERNL2.all;
	dest->FILTERKICLPHI.all 	 = source->FILTERKICLPHI.all;
	dest->FILTERKICLPLO.all 	 = source->FILTERKICLPLO.all;
	dest->FILTERYNCLPHI.all 	 = source->FILTERYNCLPHI.all;
	dest->FILTERYNCLPLO.all 	 = source->FILTERYNCLPLO.all;
	dest->FILTEROCLPHI.all		 = source->FILTEROCLPHI.all;
	dest->FILTEROCLPLO.all		 = source->FILTEROCLPLO.all;
	dest->FILTERCTRL.bit.NL_MODE = source->FILTER_MISC.bit.NL_MODE;
	
}

void copy_coefficients_to_ram(volatile FILTER_PMBUS_REGS *dest, 
							  volatile struct FILTER_REGS *source)
{
	dest->COEFCONFIG.all 	  	  = source->COEFCONFIG.all;
	dest->FILTERKPCOEF0.all 	  = source->FILTERKPCOEF0.all;
	dest->FILTERKPCOEF1.all 	  = source->FILTERKPCOEF1.all;
	dest->FILTERKICOEF0.all 	  = source->FILTERKICOEF0.all;
	dest->FILTERKICOEF1.all 	  = source->FILTERKICOEF1.all;
	dest->FILTERKDCOEF0.all 	  = source->FILTERKDCOEF0.all;
	dest->FILTERKDCOEF1.all 	  = source->FILTERKDCOEF1.all;
	dest->FILTERKDALPHA.all 	  = source->FILTERKDALPHA.all;
	dest->FILTERNL0.all 		  = source->FILTERNL0.all;
	dest->FILTERNL1.all 	  	  = source->FILTERNL1.all;
	dest->FILTERNL2.all 		  = source->FILTERNL2.all;
	dest->FILTERKICLPHI.all 	  = source->FILTERKICLPHI.all;
	dest->FILTERKICLPLO.all 	  = source->FILTERKICLPLO.all;
	dest->FILTERYNCLPHI.all 	  = source->FILTERYNCLPHI.all;
	dest->FILTERYNCLPLO.all 	  = source->FILTERYNCLPLO.all;
	dest->FILTEROCLPHI.all		  = source->FILTEROCLPHI.all;
	dest->FILTEROCLPLO.all		  = source->FILTEROCLPLO.all;
	dest->FILTER_MISC.bit.NL_MODE = source->FILTERCTRL.bit.NL_MODE;
}

void configure_filter_parameters(void)
{
	copy_coefficients_to_filter(&Filter0Regs, &filter0_pmbus_regs);
	copy_coefficients_to_filter(&Filter1Regs, &filter1_pmbus_regs);
	copy_coefficients_to_filter(&Filter2Regs, &filter2_pmbus_regs);
	//Filter2Regs.FILTEROCLPHI.bit.OUTPUT_CLAMP_HIGH = pmbus_dcdc_config[0].period * 1; //0x3FFFF;           // 100% max dity
    //Filter2Regs.FILTEROCLPLO.bit.OUTPUT_CLAMP_LOW = pmbus_dcdc_config[0].period * 0.4; //0x3FFFFF
}


