#ifndef dcdc_parameters_h					// Header file guard
#define dcdc_parameters_h

#include "adc_gains.h"

//************************************************************//
// DCDC General parameters
//************************************************************//

#define MFR_FIRMWARE_V_MAJOR    7
#define MFR_FIRMWARE_V_MINOR    0
#define MFR_FIRMWARE_V_BUILD    3

#define HW_VERSION_SEATTLE_PLANA            (0U)
#define HW_VERSION_SEATTLE_PLANB            (1U)

#define HW_VERSION_DEFAULT                  (HW_VERSION_SEATTLE_PLANA)

extern int x;
extern volatile Uint16 PMBus_HVDC_UV_Command; 	// HVDC Under Voltage Set Point - Generates a Fault
extern volatile Uint16 PMBus_HVDC_OV_Command; 	// HVDC Over Voltage Set Point - Generates a Fault
extern volatile  int16 pmbus_Ibat_offset; 	// Ibat ADC Calibration
extern volatile  int16 pmbus_Iout_offset; 	// Ibat ADC Calibration
extern volatile  int32 pmbus_Vout_offset; 	// Vout ADC Calibration
extern volatile  int16 dac_ibatt_offset;
extern volatile  int16 dac_vout_offset;
extern volatile  int16 temp_offset;
//extern Uint16 BatteryLost; 				//Battery Disconnected While in Operation
extern int GateDriveFault; 			    // Gate Driver Fault

#define BATT_LOSS_CURRENT_MA           (100)

#define BATT_LOSS_VOLTAGE_HIGH_MV               (14471)
#define BATT_LOSS_VOLTAGE_LOW_MV                (10000)

#define DAC_CALIBRATION_IBAT_TOLERANCE_mA       (50)

//************************************************************//
// Sensor Offset Limits
//************************************************************//
#define MAX_VOUT_OFFSET_cV             (500)
#define MAX_IBATT_OFFSET_mA            (5000)
#define MAX_ILOAD_OFFSET_mA            (10000)

#define MAX_DAC_IBATT_OFFSET_mA         (5000)

#define IRAMP_STABILITY_DELAY_MS        (500)

#define IBATT_SETPOINT_STEP_DELAY_MS    (5000)
#define IBATT_SETPOINT_STEP_SIZE_MA     (500)


//************************************************************//
// DCDC Parameters
//************************************************************//
#define noop    	asm(" nop ");
#define SF_TIME_INTERVAL          		(5000)
#define PERIOD							(int)(32000) // 8 us
#define DEAD_TIME						(int)(4000) // 1.0uS

#define R0_23C 							(4280)  //(2580)    //initial resistance at 23C 0.0258 *100000
#define AD13_OFFSET 					(41)
#define FACTOR 							(1.15)  //1.109e-5  *e5 =1.709
#define ADC_COUNT_23C 					(905)
#define IBATT_ZERO 						(2000)  //800mV Offset on the Battery current Sensor
#define IBATT_LIMIT  					(75)    //Limit Battery Current to 2A's 

//************************************************************//
// Vout Set Point Values
//************************************************************//
#define VOUT_SETPOINT_DEFAULT			        (14000)  //Battery Voltage Setpoint set to 14VDC (1281 Counts)
#define VOUT_SETPOINT_MAX  				        (15000)  //15VDC - As max Battery Voltage Set Point
#define VOUT_SETPOINT_MIN  				        (9000)   //9VDC - As minimum Battery Voltage Set Point

#define	MAX_TOTAL_I_OUT					(3200)  //Maximum total output current Battery + Load ~35A's (3200)
//************************************************************//
// IBat  Values - For Battery Charge Curent
//************************************************************//
#define IBAT_SETPOINT_MAX  				(DAC_IBAT_MILLIAMPS_TO_COUNTS(6000))  //6Amps - Maximum permitted current set point
#define IBAT_SETPOINT_INITIAL			(DAC_IBAT_MILLIAMPS_TO_COUNTS(0)) // (8600)  //Battery Current Setpoint initally
#define IBAT_SETPOINT_DEFAULT			(8683)  //Default Battery Current Setpoint set to 2A's (8800)
#define IBAT_SETPOINT_MIN  				(DAC_IBAT_MILLIAMPS_TO_COUNTS(500))  //0.5Amps - As minimum Battery Charge Current Set Point

//************************************************************//
// DAC IBat  Values - For Battery Charge Curent
//************************************************************//
#define DAC_IBAT_mV_PER_A                           (16.307)
#define DAC_IBAT_MAX_mV                             (1600)
#define DAC_IBAT_MAX_COUNTS                         (1<<14) // 16384
#define DAC_IBAT_mV_AT_0A                           (800)


//************************************************************//
// DCDC Operation State
//************************************************************//
#define DCDC_OP_STATE_ON				(1U << 0U)
#define DCDC_OP_STATE_STARTUP			(1U << 1U)
#define DCDC_OP_STATE_CALIBRATED		(1U << 2U)
#define DCDC_OP_STATE_ILOOP				(1U << 4U)
#define DCDC_OP_STATE_VLOOP				(1U << 5U)
#define DCDC_OP_STATE_PEAKV				(1U << 6U)
#define DCDC_OP_STATE_PEAKI				(1U << 7U)
#define DCDC_OP_STATE_SYNCHRO			(1U << 8U)


//************************************************************//
// Fault Values
//************************************************************//
#define GLOBAL_FAULT_GATEDRIVER			(1U <<  0U)
#define GLOBAL_FAULT_VIN_OVERVOLTAGE	(1U <<  1U)
#define GLOBAL_FAULT_VIN_UNDERVOLTAGE	(1U <<  2U)
#define GLOBAL_FAULT_TEMPERATURE		(1U <<  3U)
#define GLOBAL_FAULT_IOUT_OC 			(1U <<  4U)
#define GLOBAL_FAULT_VOUT_OV 			(1U <<  5U)
#define GLOBAL_FAULT_NO_BATT 			(1U <<  6U)
#define GLOBAL_FAULT_BATT_DETACHED		(1U <<  7U)
#define GLOBAL_FAULT_UNKNOWN 			(1U << 14U)
#define GLOBAL_FAULT_OTHER 				(1U << 15U)

// These ADC Values must all be re-checked as the Schematics and ADC Gains have changed
// Once the new ADC Values have been put in place - remove these comments
#define GATE_DRIVER_FAULT 				(GateDriveFault)
#define INPUT_OVER_VOLTAGE_FAULT 		(adc_values.Vin > PMBus_HVDC_OV_Command)    
#define INPUT_UNDER_VOLTAGE_FAULT		(adc_values.Vin < (PMBus_HVDC_UV_Command))
#define OUTPUT_OVER_VOLTAGE_FAULT		(vout_mV > 15000)   //~ Shut off around 15VDC 
#define OUTPUT_OVER_VOLTAGE_HARD_FAULT	(vout_mV > 18000)   //~ Shut off around 15VDC 
#define NO_12V_BATT_FAULT				(vout_mV < (9000))    //~ Shut off around 9VDC
#define OVER_TEMPERATURE_FAULT			(Synchro_Temp >= 124)
#define POWER_SUPPLY_FAULT  			(power_supply_fault)
#define BATTERY_LOSS_FAULT  			(BatteryLost)

//************************************************************//


//************************************************************//
// Start-up Soft Start Parameters
//************************************************************//
#define STARTUP_STATE_ONE				(1)
#define STARTUP_STATE_TWO				(2)
#define STARTUP_STATE_THREE				(3)
#define STARTUP_STATE_FOUR				(4)
#define STARTUP_DUTY_CYCLE				(3)


#endif // End of header guard: #ifndef main_h


