#include "Cyclone_Device.h"     // UCD30xx Headers Include File
#include "software_interrupts.h"
#include "system_defines.h"
#include "adc_gains.h"

//KP Set Up ADC's here
void init_ADC_polled(void)
{
	/*

	Signal -----  Function  ----- ADC Input

	LV_DCDC_TEMP_SNS     --	MOSFET TEMP SES	--	AD00
	IOUT_SNS   		     --	Output Current	--	AD01
	DCDC_V_SNS_SCALED	 --	Output Voltage	--	AD02
	LVDC_OV_MON		     --	Output Voltage	--	AD03
	LV_BATT_I_N		     --	Batt Current 	--	AD04
	HV_BATT_I_MON_DDC	 --	HV Batt Current --	AD06
	HV_BATT_V_MON_DDC	 --	Input Voltage   --	AD13

	*/

	//For the DC-DC Converter

	  AdcRegs.ADCCTRL.bit.SAMPLING_SEL= 6; 	  // Means: ADC sampling rate is set to 267 KS/s (best performance)
	  AdcRegs.ADCCTRL.bit.MAX_CONV = 6;       // A total of 6+1 conversions,
	  AdcRegs.ADCCTRL.bit.SINGLE_SWEEP = 1;	  // Single conversion loop runs
	  AdcRegs.ADCCTRL.bit.ADC_EN = 1;


	  AdcRegs.ADCSEQSEL0.bit.SEQ0 = 1;        //IOUT_SNS   		     --	Output Current	--	AD01
	  AdcRegs.ADCSEQSEL0.bit.SEQ1 = 2;        //DCDC_V_SNS_SCALED	 --	Output Voltage	--	AD02
	  AdcRegs.ADCSEQSEL0.bit.SEQ2 = 3;        //LVDC_OV_MON		     --	Output Voltage	--	AD03
	  AdcRegs.ADCSEQSEL0.bit.SEQ3 = 4;        //LV_BATT_I_N		     --	Batt Current 	--	AD04
	  AdcRegs.ADCSEQSEL1.bit.SEQ4 = 6;        //HV_BATT_I_MON_DDC	 --	HV Batt Current --	AD06
	  AdcRegs.ADCSEQSEL1.bit.SEQ5 = 13;       //HV_BATT_V_MON_DDC	 --	Input Voltage   --	AD13
	  AdcRegs.ADCSEQSEL1.bit.SEQ6 = 0;        //LV_DCDC_TEMP_SNS     --	MOSFET TEMP SES	--	AD00

	  AdcRegs.ADCAVGCTRL.bit.AVG0_CONFIG = 2; // Average 16 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG0_EN = 1;     // Module0 averaging enabled
	  AdcRegs.ADCAVGCTRL.bit.AVG1_CONFIG = 2; // Average 16 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG1_EN = 1;     // Module1 averaging enabled
	  AdcRegs.ADCAVGCTRL.bit.AVG2_CONFIG = 2; // Average 16 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG2_EN = 1;     // Module2 averaging enabled
	  AdcRegs.ADCAVGCTRL.bit.AVG3_CONFIG = 3; // Average 32 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG3_EN = 1;     // Module3 averaging enabled
	  AdcRegs.ADCAVGCTRL.bit.AVG4_CONFIG = 3; // Average 32 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG4_EN = 1;     // Module4 averaging enabled
	  AdcRegs.ADCAVGCTRL.bit.AVG5_CONFIG = 2; // Average 16 samples
	  AdcRegs.ADCAVGCTRL.bit.AVG5_EN = 1;     // Module5 averaging enabled

	  /*
	  AdcRegs.ADCCOMPLIM[0].bit.LOWER_LIMIT=0;
	  AdcRegs.ADCCOMPLIM[0].bit.UPPER_LIMIT= IOUT_MON_MILLIAMP_TO_COUNTS(10000);


      AdcRegs.ADCCOMPEN.bit.COMP0_LO_INT_EN=0;
      AdcRegs.ADCCOMPEN.bit.COMP0_UP_INT_EN=1;
      AdcRegs.ADCCOMPEN.bit.COMP0_DATA_SEL=1;
      AdcRegs.ADCCOMPEN.bit.COMP0_EN=1;
	   */


}






