#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"
#include "dcdc_parameters.h"
#include "standard_interrupt.h"
#include <stdlib.h>
#include <stdint.h>
void init_dpwm0_OL(void) // DPWM1B is Used to drive Sync-FET
{

    Dpwm0Regs.DPWMCTRL0.bit.PWM_EN = 0;

 	Dpwm0Regs.DPWMEV1.all = 0; // deadtime_CD;
	Dpwm0Regs.DPWMEV2.all = (PERIOD >> 1)-DEAD_TIME;
	Dpwm0Regs.DPWMEV3.all = (PERIOD >> 1 ); // (period >> 1) + 0; // deadtime_EF;   // Modified for Single_Frame
    Dpwm0Regs.DPWMEV4.all = PERIOD-DEAD_TIME;
	Dpwm0Regs.DPWMCTRL0.bit.PWM_MODE = 0;  // Set to normal mode
	Dpwm0Regs.DPWMCTRL0.bit.CLA_EN = 1;

    Dpwm0Regs.DPWMCTRL1.bit.EVENT_UP_SEL = 1; // Events update at the end of period
	Dpwm0Regs.DPWMCTRL1.bit.CHECK_OVERRIDE = 1; // Normally CLA == 0 is considered a fault; Set the check-override so cla==0 is valid
	Dpwm0Regs.DPWMCTRL1.bit.ALL_PHASE_CLK_ENA = 1; // Need all phases for hi Resolution
	Dpwm0Regs.DPWMCTRL2.bit.SAMPLE_TRIG_1_EN = 1;
	Dpwm0Regs.DPWMCTRL0.bit.PWM_EN = 1;
	Dpwm0Regs.DPWMSAMPTRIG1.all = (pmbus_dcdc_config[0].period)- 6240; //2100; 279*16ns = 4.464us;-5000; // Writing to all in order to normalize to high resolution
//    Dpwm0Regs.DPWMINT.bit.PRD_INT_SCALE = 1; // generate an interrupt on each 16 switching cycles(used to reset the integrator)
//    Dpwm0Regs.DPWMINT.bit.PRD_INT_EN = 2;
	Dpwm0Regs.DPWMCTRL1.bit.GPIO_A_EN = 0;
	//Dpwm0Regs.DPWMCTRL1.bit.GPIO_B_EN = 0;
    Dpwm0Regs.DPWMCTRL1.bit.SYNC_FET_EN =0;
    Dpwm0Regs.DPWMCTRL1.bit.GLOBAL_PERIOD_EN = 1; //Enable Global Period control
	Dpwm0Regs.DPWMPRD.all = PERIOD;
//*******************************************************
//this is only for unbalancing current without blocking cap
	Dpwm0Regs.DPWMCYCADJA.all = 0;
//******************************************************
	Dpwm0Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN =0; // DPWm0 is master

    Dpwm0Regs.DPWMINT.bit.PRD_INT_SCALE=0;
	Dpwm0Regs.DPWMINT.bit.PRD_INT_EN=1;
}

void init_dpwm1_OL(void) // DPWM1B is Used to drive Sync-FET/
{

    Dpwm1Regs.DPWMCTRL0.bit.PWM_EN = 0;     //disable locally for init
	Dpwm1Regs.DPWMCTRL0.bit.CLA_EN = 1;		//default is 1 - use cla
	Dpwm1Regs.DPWMPRD.all = PERIOD;         // use .all for all values, so that the scaling matches
	Dpwm1Regs.DPWMEV4.all = (0);//+;         // set EVENT 1 to 0% (start) of period
	Dpwm1Regs.DPWMEV3.all = (PERIOD >> 1)-DEAD_TIME;         // set EVENT 2 to 25% of period
	Dpwm1Regs.DPWMEV2.all = (PERIOD >> 1);//+;         // set EVENT 3 to 50% of period
	Dpwm1Regs.DPWMEV1.all = (PERIOD)-DEAD_TIME;         // set EVENT 4 to 75% of period  */
//	Dpwm1Regs.DPWMCNTPRE.all = pmbus_dcdc_config[0].period >> 1; // Shift by 180 degree ( half the period)
	Dpwm1Regs.DPWMCTRL0.bit.D_ENABLE = 1; //Duty Cycle is 1-D
	Dpwm1Regs.DPWMCYCADJA.all = DEAD_TIME*2;
	Dpwm1Regs.DPWMSAMPTRIG1.all = (PERIOD)/3; //3/4 of period
	Dpwm1Regs.DPWMCTRL2.bit.SAMPLE_TRIG_1_EN = 1; //enable 1 sample trigger
	Dpwm1Regs.DPWMCTRL1.bit.EVENT_UP_SEL = 1; //update at end of period
	Dpwm1Regs.DPWMCTRL0.bit.PWM_MODE = 4;   //Leading Mode
	Dpwm1Regs.DPWMCTRL0.bit.PWM_EN = 1;     // enable DPWM1 locally
    LoopMuxRegs.DPWMMUX.bit.DPWM1_SYNC_SEL = 0;
	Dpwm1Regs.DPWMCTRL0.bit.MSYNC_SLAVE_EN = 1;	// DPWm0 is master, DPWM1 is slave

	Dpwm1Regs.DPWMCTRL1.bit.GPIO_A_EN = 0;
	//Dpwm1Regs.DPWMCTRL1.bit.GPIO_B_EN = 0;

	//*******************************************************
	//Enable Sync Fets
    Dpwm1Regs.DPWMCTRL2.bit.IDE_DUTY_B_EN = 1; //enable ide
	//*******************************************************
    Dpwm1Regs.DPWMCTRL1.bit.GLOBAL_PERIOD_EN = 1; //Enable Global Period control
    LoopMuxRegs.PWMGLBPER.all=PERIOD;
    Dpwm1Regs.DPWMCTRL2.bit.FILTER_DUTY_SEL=0;//1;
}


void global_enable_iCtrl(void)
{
	LoopMuxRegs.GLBEN.all = 0x203;
}

void global_enable_vCtrl(void)
{
	LoopMuxRegs.GLBEN.all = 0x203;
}

//////////////////////*************************************************************\\\\\\\\\\\\\\\\\\\\\\\

/*Notes:
--The minimum DAC step size is 1.5625mV per bit. So setting 100 in the DAC = 100 * 1.5625mV = 156.25mV
--However, the DAC has a 4 bit dither setup, therefore, everything must be multiplied by 16 so 156.25mV = 100 * 16 Counts
--AFEGAIN - changes the resolution of the EAP signal
Gain = 1 = range of -256mV to +248mV  --> Therefore the measurement resolution = (256mV + 248mV)/2^6 = 8mV per step
Gain = 2 = range -128 to +124mV  --> measurement resolution is 4mV
Gain = 8 = range is -32mV to +31mV --> measurement resolution is 1mV
*/

void init_front_end1_PIDCTRL(void)
{
	  FeCtrl1Regs.EADCDAC.bit.DAC_DITHER_EN = 0;// default, Disable dithering
	  FeCtrl1Regs.EADCDAC.bit.DAC_VALUE = 0; // Start point for ramp-up


	  FeCtrl1Regs.EADCCTRL.bit.AFE_GAIN = 3;// Gain X8/
	  FeCtrl1Regs.EADCCTRL.bit.EADC_MODE = 1;//Averaging mode
	  FeCtrl1Regs.EADCCTRL.bit.AVG_MODE_SEL=2; //8x Averaging
	  FeCtrl1Regs.EADCCTRL.bit.SCFE_GAIN_FILTER_SEL = 1;//Switched Cap Noise Filter Enable
	  FeCtrl1Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 0 ;//Switched Cap Front End Clock Divider Select
	  FeCtrl1Regs.EADCCTRL.bit.SCFE_ENA = 1;//Switch Cap Front Enable
	  FeCtrl1Regs.EADCCTRL.bit.EADC_ENA = 1;//EADC Enable
}
void init_Filter1_OL_PIDCTRL(void) // DPWM1B is Used to drive Sync-FET
{
	Filter1Regs.FILTERCTRL.bit.USE_CPU_SAMPLE = 0; 	// disable CPU Sample // TODO: Comment out ??? (JKL 20200911)
    // Set Maximum duty cycle
    Filter1Regs.FILTEROCLPHI.bit.OUTPUT_CLAMP_HIGH = (uint32_t)(PERIOD/2);
    // Set Minimum duty cycle
    Filter1Regs.FILTEROCLPLO.bit.OUTPUT_CLAMP_LOW = (uint32_t)((uint32_t)(PERIOD)/20);//1/20=5%
	Filter1Regs.FILTERCTRL.bit.KD_OFF=1;
	Filter1Regs.FILTERKPCOEF0.bit.KP_COEF_0 = 16000/4; //full pass through of XN value.
	Filter1Regs.FILTERKICOEF0.bit.KI_COEF_0 = 0; //300;
	Filter1Regs.FILTERKDCOEF0.bit.KD_COEF_0 = 0;
	Filter1Regs.FILTERKDALPHA.bit.KD_ALPHA_0 = 0;
	Filter1Regs.FILTERKICLPHI.bit.KI_CLAMP_HIGH = (uint32_t)(0x400000);//0x7FFFFF;
	Filter1Regs.FILTERKICLPLO.bit.KI_CLAMP_LOW = (uint32_t)(0x800000/20);//1/20=5%
	Filter1Regs.FILTERYNCLPHI.bit.YN_CLAMP_HIGH=(uint32_t)(0x400000);
	Filter1Regs.FILTERYNCLPLO.bit.YN_CLAMP_LOW=(uint32_t)(0x800000/20);//1/20=5%

     //enable OK here, because nothing will happen until DPWM and front end are globally enabled
	Filter1Regs.FILTERCTRL.bit.OUTPUT_MULT_SEL = 0; 		// Multiply output by KCOMP
	Filter1Regs.FILTERCTRL.bit.OUTPUT_SCALE = 0; // right shift by 2 to divide by 4 scaling
}

void init_LoopMux_PID_Current_CTRL(void) 
{

    LoopMuxRegs.PWMGLBPER.all = pmbus_dcdc_config[0].period;
    LoopMuxRegs.GLBEN.all|= 0x03;//Enable DPWM0,DPWM1
    LoopMuxRegs.DPWMMUX.bit.DPWM0_SYNC_SEL =0;   //DPWm0 is a master

    //init_loop_mux
	LoopMuxRegs.DPWMMUX.bit.DPWM0_FILTER_SEL = 1; 		// use filter 1 for DPWM 0
	LoopMuxRegs.DPWMMUX.bit.DPWM1_FILTER_SEL = 1; 		// use filter 1 for DPWM 1
	LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 1; // use DPWM0 for filter0 sample trigger
	LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM1_EN = 1; // use DPWM0 for filter1 sample trigger


	LoopMuxRegs.FILTERMUX.bit.FILTER0_PER_SEL = 0;//CLA1 switching period select from KCOMP
	LoopMuxRegs.FILTERMUX.bit.FILTER1_PER_SEL = 0;//CLA1 switching period select from KCOMP
	// Better option for handling shoot through - uses full dynamic range of filter
	LoopMuxRegs.FILTERKCOMPA.bit.KCOMP0 = (PERIOD >> 4); 	// KCOMP is at 4 ns, period is at 250 ps

}

void init_dpwm_pidctrl_fe1(void)
{
	//Filter0Regs.CPUXN.bit.CPU_SAMPLE = 0;
	Filter1Regs.CPUXN.bit.CPU_SAMPLE = 0;
	pmbus_dcdc_config[0].period = PERIOD;
    init_dpwm0_OL();
    init_dpwm1_OL();    
    //init_Filter0_OL_PIDCTRL();
    init_Filter1_OL_PIDCTRL();
    //init_front_end0_PIDCTRL();
	init_front_end1_PIDCTRL(); 
	init_LoopMux_PID_Current_CTRL();
	global_enable_iCtrl();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Funcion: update_DPWMs_freq_dither()
//  once the new period is set - all event values Must be updated with new set points
//  this will prevent shoot through due to dead band encroachment
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
void update_DPWMs_freq_dither(void) // DPWM1B is Used to drive Sync-FET
{

	Dpwm0Regs.DPWMEV1.all = 0; // deadtime_CD;
	Dpwm0Regs.DPWMEV2.all = (switching_period >> 1)-DEAD_TIME;
	Dpwm0Regs.DPWMEV3.all = (switching_period >> 1 ); // (period >> 1) + 0; // deadtime_EF;   // Modified for Single_Frame
    Dpwm0Regs.DPWMEV4.all = switching_period -  DEAD_TIME;
	Dpwm0Regs.DPWMPRD.all = switching_period;         // use .all for all values, so that the scaling matches

	Dpwm1Regs.DPWMEV4.all = 0;         // set EVENT 1 to 0% (start) of period
	Dpwm1Regs.DPWMEV3.all = (switching_period >> 1)-DEAD_TIME;         // set EVENT 2 to 25% of period
	Dpwm1Regs.DPWMEV2.all = (switching_period >> 1);         // set EVENT 3 to 50% of period
	Dpwm1Regs.DPWMEV1.all = switching_period -  DEAD_TIME;         // set EVENT 4 to 75% of period
    Dpwm1Regs.DPWMPRD.all = switching_period; //new period for new frequency

    LoopMuxRegs.PWMGLBPER.all = switching_period;
    LoopMuxRegs.FILTERKCOMPA.bit.KCOMP0 = (switching_period >> 4);

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Funcion: init_freq_dither()
//  Initializes frequency dither parameters
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Funcion: frequency_dithering()
//  Will dither the frequenccy around +/- a dither max and min frequency value by varying the period
//  Once the Period has been changed, the global period enable register will be updated
//  All PWM's have been set up to use the global period value at all times. 
//  There is a specific sequency to updating the Period and KCOMP values which is documented in the code below
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

void frequency_dithering(void)
{
#define PERIOD_CHG (PERIOD/100)
    //if(dither_enabled == 1)
    {
        srand(RTC_ms);  //set RTC_ms as the seed to generate a random number
        switching_period=(Uint16)(PERIOD+(((Uint32)(PERIOD_CHG*(rand()-(RAND_MAX/2))))/RAND_MAX));
        update_DPWMs_freq_dither();
    }
#undef PERIOD_CHG
}




