#include "Cyclone_Device.h"     // UCD30xx Headers Include File
#include "software_interrupts.h"
#include "system_defines.h"
#include "variables.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "function_definitions.h"
#include "adc_gains.h"



///////////////////////////////////////////////////////////////////////////////////
// Used for Output voltage Over voltage detection
///////////////////////////////////////////////////////////////////////////////////

void init_vout_fault(void) // Analog comparator B
{
    register uint32_t x;
    x=((uint32_t)VOUT_SNS_MILLIVOLTS_TO_COUNTS(18000))>>5;  //x is for 12 bits, comparator is 7 bits
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_THRESH = x;//(uint8_t)x;
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_POL = 1;
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_SEL = 0;

    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_E_EN = 1; // ACOMP-B will turn off DPWM0
    FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_E_EN = 1; // ACOMP-B will turn off DPWM1

    x=((uint32_t)VOUT_SNS_MILLIVOLTS_TO_COUNTS(8000))>>5;

    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_THRESH = x;//(uint8_t)x;
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_POL = 0;
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_SEL = 0;

    FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;

    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_F_EN = 1; // ACOMP-B will turn off DPWM0
    FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_F_EN = 1; // ACOMP-B will turn off DPWM1

}


void init_iout_fault(void) // Using analog comparator E
{
    register uint32_t x;
    x=FaultMuxRegs.FAULTMUXINTSTAT.all;
    x=FaultMuxRegs.FAULTMUXRAWSTAT.all;
    //x=(IOUT_MON_MILLIAMP_TO_COUNTS(30000))>>5;
    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_THRESH = (IOUT_MON_MILLIAMP_TO_COUNTS(30000))>>5;;
    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_POL = 1;
    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_SEL = 0;

    FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;

    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_C_EN = 1; // ACOMP-E will turn off DPWM0
    FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_C_EN = 1; // ACOMP-E will turn off DPWM1

    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_INT_EN=1;

}


void init_dpwm_faults(void)
{

    FaultMuxRegs.EXTFAULTCTRL.bit.FAULT2_POL=0;
    FaultMuxRegs.EXTFAULTCTRL.bit.FAULT2_DET_EN=1;
    FaultMuxRegs.DPWM0FLTABDET.bit.FAULT2_EN = 1;
    FaultMuxRegs.DPWM1FLTABDET.bit.FAULT2_EN = 1;

    Dpwm0Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
    Dpwm0Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0;
	Dpwm1Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
    Dpwm1Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0;
    FaultMuxRegs.EXTFAULTCTRL.bit.FAULT2_INT_EN=0;

}



void init_faults(void)
{
    register uint32_t x;
    x=FaultMuxRegs.FAULTMUXINTSTAT.all;
    x=FaultMuxRegs.FAULTMUXRAWSTAT.all;
    //init_vout_fault();
    //init_iout_fault();
    init_dpwm_faults();
}




///////////////////////////////////////////////////////////////////////////////////
// Used for cycle by cycle output current limiting and latching after 20 attempts
///////////////////////////////////////////////////////////////////////////////////
/*
void init_ipri_cycle_by_cycle(void) // Analog comparator 3(AD04 pin)  
{

//Analog comparator 3(AD04 pin).

//  FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_D_THRESH = 40; // resolution is 19.5mv/bit, 27A cyc
  FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_D_POL = 1;
  FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_D_SEL = 0;

  FaultMuxRegs.DPWM0CLIM.bit.ACOMP_D_EN = 1;
  FaultMuxRegs.DPWM1CLIM.bit.ACOMP_D_EN = 1;
  FaultMuxRegs.DPWM2CLIM.bit.ACOMP_D_EN = 0;
  FaultMuxRegs.DPWM3CLIM.bit.ACOMP_D_EN = 0;


  FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1; 

  // New configuration for board  with changes, using DPWM0A, DPWM1A for primary and  DPWM0B, DPWM1B for secondary

  Dpwm0Regs.DPWMCTRL0.bit.BLANK_A_EN =1;
  Dpwm0Regs.DPWMBLKABEG.bit.BLANK_A_BEGIN =0;
  Dpwm0Regs.DPWMBLKAEND.bit.BLANK_A_END =30; //50 x 4ns =200ns

  Dpwm1Regs.DPWMCTRL0.bit.BLANK_A_EN =1;
  Dpwm1Regs.DPWMBLKABEG.bit.BLANK_A_BEGIN =0;
  Dpwm1Regs.DPWMBLKAEND.bit.BLANK_A_END = 30; // 50 x 4ns =200ns


  // old configuration for board  without changes, using DPWM2, DPW3 for primary side; DPWM0B, DPWM1B for secondary side
  Dpwm2Regs.DPWMCTRL0.bit.BLANK_A_EN =0;
  Dpwm2Regs.DPWMCTRL0.bit.BLANK_B_EN =0;
  Dpwm2Regs.DPWMBLKABEG.bit.BLANK_A_BEGIN =0;
  Dpwm2Regs.DPWMBLKAEND.bit.BLANK_A_END =30;
  Dpwm2Regs.DPWMBLKBBEG.bit.BLANK_B_BEGIN = (pmbus_dcdc_config[0].period >> 5) - 2;
  Dpwm2Regs.DPWMBLKBEND.bit.BLANK_B_END = (pmbus_dcdc_config[0].period >> 5) + 50; //200ns blanking time



  Dpwm0Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
  Dpwm0Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN = 1;

  Dpwm1Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
  Dpwm1Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN = 1;

  Dpwm2Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 0;
  Dpwm2Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN = 0;

  Dpwm3Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 0;
  Dpwm3Regs.DPWMCTRL0.bit.CBC_ADV_CNT_EN = 0;


  configure_ipri_cycle_by_cycle();
  
}
*/


