#include "Cyclone_Device.h"   // UCD30xx Headers Include File
#include "software_interrupts.h"
#include "system_defines.h"
#include "variables.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "function_definitions.h"









void init_loop_mux(void)
{
    /////////////////////////////////////////////////////////////
// Feed Forward Configuration
////////////////////////////////////////////////////////////////
  LoopMuxRegs.FILTERMUX.bit.FILTER0_FFWD_SEL = 1; // Filter2 is routed to feed-forward Module0
/////////////////////////////////////////////////////////////
  // Following supports SyncFET soft on/off
  /////////////////////////////////////////////////////////////
  LoopMuxRegs.DPWMMUX.bit.DPWM0_SYNC_FET_SEL = 2; // Front End 2 Ramp output drives DPWM0B SyncFET soft on/off
  LoopMuxRegs.DPWMMUX.bit.DPWM1_SYNC_FET_SEL = 2; // Front End 2 Ramp output drives DPWM1B SyncFET soft on/off

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //We have to configure the step size for soft syc on/off Front end (FE2)
 
  FeCtrl2Regs.RAMPCYCLE.bit.SWITCH_CYC_PER_STEP = 1;//? Number of switching cycles pre DAC step
  FeCtrl2Regs.RAMPCTRL.bit.SYNC_FET_EN = 1; // Use the value SYNC_FET_RAMP_START for start
  FeCtrl2Regs.RAMPCTRL.bit.RAMP_EN = 1; //Ramp by Hradware
  FeCtrl2Regs.RAMPCTRL.bit.SYNC_FET_RAMP_START = 0; // default
  FeCtrl2Regs.RAMPDACEND.bit.RAMP_DAC_VALUE = 1100; // We will set this in IDLE_STATE
  FeCtrl2Regs.DACSTEP.bit.DAC_STEP = 10;//200;  
  
//  LoopMuxRegs.GLBEN.bit.FE_CTRL2_EN = 1; //Enable FE2 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  LoopMuxRegs.FECTRL0MUX.bit.DPWM0_FRAME_SYNC_EN = 1;
//  LoopMuxRegs.FECTRL0MUX.bit.DPWM0_A_TRIG_EN = 1;      // Enables DPWM Trigger from DPWM0_A to Front End Control 0
  LoopMuxRegs.SAMPTRIGCTRL.bit.FE0_TRIG_DPWM0_EN = 1;  // Enables Sample Trigger from DPWM 0 to Front End Control 0

  LoopMuxRegs.FECTRL2MUX.bit.DPWM1_FRAME_SYNC_EN = 1;
//  LoopMuxRegs.FECTRL2MUX.bit.DPWM1_A_TRIG_EN = 1;   //Enables DPWM Trigger from DPWM2_A to Front End Control 2
  LoopMuxRegs.SAMPTRIGCTRL.bit.FE2_TRIG_DPWM0_EN = 1;  //Enables Sample Trigger from DPWM 0 to Front End Control 2
  LoopMuxRegs.SAMPTRIGCTRL.bit.FE2_TRIG_DPWM1_EN = 0;  //Enables Sample Trigger from DPWM 2 to Front End Control 2

  LoopMuxRegs.FECTRL1MUX.bit.DPWM2_FRAME_SYNC_EN = 1;
//  LoopMuxRegs.FECTRL1MUX.bit.DPWM2_A_TRIG_EN = 1;
  LoopMuxRegs.SAMPTRIGCTRL.bit.FE1_TRIG_DPWM2_EN = 1;


  LoopMuxRegs.FILTERMUX.bit.FILTER0_FE_SEL = 0; //default
  LoopMuxRegs.FILTERMUX.bit.FILTER0_PER_SEL =0;//default

  LoopMuxRegs.FILTERMUX.bit.FILTER1_FE_SEL = 1;

  LoopMuxRegs.FILTERKCOMPA.bit.KCOMP0 = (pmbus_dcdc_config[0].period) >> 4; //In 4ns
  LoopMuxRegs.FILTERKCOMPA.bit.KCOMP1 = 6000; //(1<<13); //In 4ns  //
  LoopMuxRegs.FILTERKCOMPB.bit.KCOMP2 = pmbus_dcdc_config[0].period >> 4;//In 4ns


#ifdef CURRENT_MODE   //average current mode control

  LoopMuxRegs.DPWMMUX.bit.DPWM0_FILTER_SEL =1; // default filter1 is providing duty input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM1_FILTER_SEL =1; // default filter1 is providing input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM2_FILTER_SEL =1; // default filter1 is providing input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM3_FILTER_SEL =1; // default filter1 is providing input to this DPWM
  LoopMuxRegs.EXTDACCTRL.bit.DAC1_SEL = 4; //Filter 0 Output Selected
  LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC1_EN =1;
  Filter0Regs.FILTERCTRL.bit.OUTPUT_SCALE = 0;
  LoopMuxRegs.FILTERMUX.bit.FILTER0_KCOMP_SEL =1;   //use 14 bits KCOM for current mode reference calculation
 



#else  //voltage mode
  LoopMuxRegs.FILTERMUX.bit.FILTER0_KCOMP_SEL =0;  //use for voltage  mode duty generation
  LoopMuxRegs.DPWMMUX.bit.DPWM0_FILTER_SEL =0; // default filter0 is providing duty input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM1_FILTER_SEL =0; // default filter0 is providing input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM2_FILTER_SEL =0; // default filter0 is providing input to this DPWM
  LoopMuxRegs.DPWMMUX.bit.DPWM3_FILTER_SEL =0; // default filter0 is providing input to this DPWM

#endif

  LoopMuxRegs.FILTERMUX.bit.FILTER2_KCOMP_SEL =2;  //
  LoopMuxRegs.FILTERMUX.bit.FILTER1_KCOMP_SEL =0;  //

  LoopMuxRegs.GLBEN.bit.FE_CTRL0_EN = 1;//Enable FE0
  LoopMuxRegs.GLBEN.bit.FE_CTRL1_EN = 1;//Enable FE1
  LoopMuxRegs.GLBEN.bit.FE_CTRL2_EN = 1;//Enable FE2

  LoopMuxRegs.DPWMMUX.bit.DPWM0_SYNC_SEL =0;   //DPWm0 is a master
  LoopMuxRegs.DPWMMUX.bit.DPWM1_SYNC_SEL =0;//DPWm1 is a slave, syc with DPWM0
  LoopMuxRegs.DPWMMUX.bit.DPWM2_SYNC_SEL =0;//DPWm2 is a slave, syc with DPWM0
  LoopMuxRegs.DPWMMUX.bit.DPWM3_SYNC_SEL =0;//DPWm3 is a slave, syc with DPWM0
}



void handle_light_load_mode_configuration(void)
{

  Dpwm0Regs.DPWMCTRL1.bit.BURST_EN = 1; //Burst (Light Load) Mode Detection Enable
  Dpwm1Regs.DPWMCTRL1.bit.BURST_EN = 1;
  Dpwm2Regs.DPWMCTRL1.bit.BURST_EN = 1;
//  Dpwm3Regs.DPWMCTRL1.bit.BURST_EN = 1;
  LoopMuxRegs.LLCTRL.bit.CYCLE_CNT_EN = 0; //Enables Switching Cycle Counter for enabling constant pulse widths 
  // when configured in Light Load operation
  LoopMuxRegs.LLCTRL.bit.DPWM_ON_TIME = 0; // default, I guess this is irelevant, we don't use this in kilimanjaro approach
  LoopMuxRegs.LLCTRL.bit.LL_FILTER_SEL = 0; // Configures source of filter data for Light Load comparisons 
  LoopMuxRegs.LLENTHRESH.bit.CYCLE_CNT_THRESH = 0; // Don't care// Disabled// Switching Cycle threshold where constant width DPWM pulses 
  // are enabled when number of switching cycles without pulses exceeds threshold

  configure_burst_mode();
}

