#include "system_defines.h"
#include "Cyclone_Device.h"
#include "variables.h"
#include "function_definitions.h"
#include "standard_interrupt.h"
#include "fault.h"
extern void Disable_Converter(void);
#pragma INTERRUPT(abort_prefetch_exception,PABT)
void abort_prefetch_exception(void)
{
	watchdog_reset();
}

#pragma INTERRUPT(abort_data_fetch_exception,DABT)
void abort_data_fetch_exception(void)
{
	watchdog_reset();
}



#pragma INTERRUPT(undefined_instruction_exception,UDEF)
void undefined_instruction_exception(void)
{
	watchdog_reset();
}



#pragma INTERRUPT(fast_interrupt,FIQ)
void fast_interrupt(void)
{
	int32 fiq_number, interrupt_bits;
	fiq_number = CimRegs.FIQIVEC.all; // Clear on read
	interrupt_bits = FaultMuxRegs.FAULTMUXINTSTAT.all; // Clear on read

	if (GioRegs.FAULTINTPEND.bit.FLT2_INT_PEND)
	{
		CHECK_GATEDRIVER();
		GioRegs.FAULTINTPEND.bit.FLT2_INT_PEND = 1; // write "1" to reset the fault
	}
}





