#define MAIN 1

#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"
#include "cyclone_defines.h"
#include "dcdc_parameters.h"
#include "fault.h"
#include "Calibration.h"
#include "led.h"
#include "standard_interrupt.h"

#include "adc_gains.h"
#define watchdog_kick() (TimerRegs.WDCTRL.bit.CNT_RESET = 1U)
extern void control(void);

//int x;

//int ram_cpu_sample; // comment for hyperknob [min=0, max=255, step=8]
//int ram_eadcdac;   /// comment for hyperknob [min=0, max=16383, step=256]
//int ram_eadcdac_old;
//int TestFault = 0;
//int ctr=0;


void init_interrupts(void)
{
    disable_interrupt();
    disable_fast_interrupt();  //make sure fast interrupt is disabled
    /*
	TimerRegs.T16PWM0CMP0DAT.bit.CMP_DAT = 15870;  	//Threshold to send the pwm low. Approx 10KHz. by spec.64ns clock period
	TimerRegs.T16PWM0CMP1DAT.all = 15870/2;	//Threshold to send the pwm high
	TimerRegs.T16PWM0CMPCTRL.bit.CMP0_INT_ENA = 1;		//Enables compare 0 (reset) interrupt
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ACTION0=3;
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ACTION1=3;
    TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ENA=1;

	TimerRegs.T16PWM0CNTCTRL.all = 0x00c;	//PWM counter is running & enables PWM counter reset by compare action on compare 0
	*/

	TimerRegs.T16PWM0CMP0DAT.bit.CMP_DAT = 15625;//value to reset counter, clock frequency: 15.625MHz, 1ms: 15.625MHz/1000=15625
	TimerRegs.T16PWM0CMP1DAT.bit.CMP_DAT = 15625/2; //50%50 duty cycle half of comp 0
    TimerRegs.T16PWM0CMPCTRL.bit.CMP0_INT_ENA = 1;      //Enables compare 0 (reset) interrupt
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ACTION0 = 3;//3: toggle the pin
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ACTION1 = 3;//
	TimerRegs.T16PWM0CNTCTRL.bit.CMP_RESET_ENA = 1; //enable reset by comp 0
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT = 0; //make sure that default is a 0
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_DRV = 1; //put zero into output latch
	TimerRegs.T16PWM0CMPCTRL.bit.PWM_OUT_ENA = 1; //enable pin as an output
	TimerRegs.T16PWM0CNTCTRL.bit.SW_RESET = 1; //allow counter to run
#ifdef EVB                                      //output PWM0 only in EVB
	MiscAnalogRegs.IOMUX.bit.EXT_TRIG_MUX_SEL=3;
	MiscAnalogRegs.IOMUX.bit.JTAG_CLK_MUX_SEL=0;
	MiscAnalogRegs.IOMUX.bit.SYNC_MUX_SEL=0;
#endif
    //TimerRegs.T16PWM0CMP1DAT.bit.CMP_DAT = 15870/2; //50%50 duty cycle half of comp 0

    //Dpwm2Regs.DPWMINT.bit.PRD_INT_SCALE = 2; // generate an interrupt on each 16 switching cycles(used to reset the integrator)
    //Dpwm2Regs.DPWMINT.bit.PRD_INT_EN = 1;
    //LoopMuxRegs.GLBEN.all|= 0x004;
	//Dpwm2Regs.DPWMCTRL0.bit.PWM_EN = 1;

	//Set Up Fault 2 pin to generate a fault
	GioRegs.FAULTINTPEND.all=0xffffffff;        //clear all the flags
	GioRegs.FAULTINTENA.bit.FLT2_INT_EN = 1;
	GioRegs.FAULTDIR.bit.FLT2_DIR = 0;
	GioRegs.FAULTIN.bit.FLT2_IN = 0; 			//1 - Fault pin must be driven High. 0 - Driven Low to trigger Interrupt
	GioRegs.FAULTINTPOL.bit.FLT2_INT_POL = 0;  //Interrupt will be generated on 1 = Rising Edge, 0 = Falling Edge
	
 	AdcRegs.ADCCTRL.bit.ADC_INT_EN = 1U;        //enable ADC completed interrupt


	//write_reqmask(CIMINT_ALL_DPWM2 | CIMINT_ALL_PWM2_COMP); //enable pwm2cmp and DPWM0 interrupt(End of 16th period)(int-priority29)
    //write_firqpr (CIMINT_ALL_DPWM2); //  DPWM0 interrupt(End of 16th period) is mapped to FIQ
	//write_reqmask( CIMINT_ALL_DPWM2 | CIMINT_ALL_PWM2_COMP | CIMINT_ALL_FAULT_PIN | CIMINT_ALL_ADC_CONV); //enable pwm2cmp and DPWM0 interrupt(End of 16th period)(int-priority29)
    //write_firqpr (CIMINT_ALL_DPWM2 | CIMINT_ALL_FAULT_PIN); //  DPWM0 interrupt(End of 16th period) is mapped to FIQ
    write_reqmask(CIMINT_ALL_DPWM0 | CIMINT_ALL_PWM0_COMP | CIMINT_ALL_ADC_CONV|CIMINT_ALL_FAULT_PIN|CIMINT_ALL_FAULT_MUX); //TIMER_PWM0, ADC completed, and FAULT2 pin interrupt enabled.
    write_firqpr(CIMINT_ALL_FAULT_PIN|CIMINT_ALL_FAULT_MUX); //Gate driver fault mapped to fast interrupt, other interrupt are standard interrupt.

	enable_interrupt();
    enable_fast_interrupt();
	
}

void init_variables(void)
{
  //Enable_OpenLoop = 0;
  PSON = 0;
  GateDriveFault = 0;
  //power_supply_fault = 0;//
  FaultReset = 0;
  //batRes=0;
  //PREVIOUS_PSON=0;
  PMBus_Vout_Command = VOUT_SETPOINT_DEFAULT; 			//Initialize PMBus Vout Command
  PMBus_HVDC_UV_Command = UV_FAULT_SETPOINT_DEFAULT;	//Initialize Under Voltage Fault Set point
  PMBus_HVDC_OV_Command = OV_FAULT_SETPOINT_DEFAULT;	//Initialize Over Voltage Fault Set point

  //if(PSON)
//	  supply_state = STATE_OPENLOOP;
//  else
	  supply_state = STATE_DISABLED;

  //current_share_kp = 40;
  //current_share_ki = 2;
  //fault_status = 0;
  debug_buffer[0]=1;
  debug_buffer[1]=2;
  debug_buffer[2]=3;
  debug_buffer[3]=4;
  debug_buffer[4]=5;
  debug_buffer[5]=6;
  debug_buffer[6]=7;
  debug_buffer[7]=8;

/*
  Filter1Regs.FILTERPRESET.bit.PRESET_VALUE = 0; //put a 0
  Filter1Regs.FILTERPRESET.bit.PRESET_REG_SEL = 0; //into I holding register
  Filter1Regs.FILTERPRESET.bit.PRESET_EN = 1; //set bit to make it happen
  
  Filter1Regs.FILTERPRESET.bit.PRESET_VALUE = 0; //put a 0
  Filter1Regs.FILTERPRESET.bit.PRESET_REG_SEL = 1; //into I holding register
  Filter1Regs.FILTERPRESET.bit.PRESET_EN = 1; //set bit to make it happen
  
  Filter1Regs.FILTERPRESET.bit.PRESET_VALUE = 0; //put a 0
  Filter1Regs.FILTERPRESET.bit.PRESET_REG_SEL = 2; //into I holding register
  Filter1Regs.FILTERPRESET.bit.PRESET_EN = 1; //set bit to make it happen
  
  Filter1Regs.FILTERPRESET.bit.PRESET_VALUE = 0; //put a 0
  Filter1Regs.FILTERPRESET.bit.PRESET_REG_SEL = 3; //into I holding register
  Filter1Regs.FILTERPRESET.bit.PRESET_EN = 1; //set bit to make it happen
  
  Filter1Regs.FILTERPRESET.bit.PRESET_VALUE = 0; //put a 0
  Filter1Regs.FILTERPRESET.bit.PRESET_REG_SEL = 4; //into I holding register
  Filter1Regs.FILTERPRESET.bit.PRESET_EN = 1; //set bit to make it happen
*/
  //dither_enabled = 1;     // Enable or Disable Dither


}

void main()
{
	//volatile unsigned int dummy;

#if (UCD3138|UCD3138064)
	MiscAnalogRegs.CLKTRIM.bit.HFO_LN_FILTER_EN = 0;
	MiscAnalogRegs.CSTRIM.bit.RESISTOR_TRIM =23; //28;
#endif //(UCD3138|UCD3138064)

	init_gpio();
    restore_default_all();
	init_variables();
	LED_Init();
	LED_Set_Error(1U);
	init_pmbus(0x58);
	init_faults();
	//init_freq_dither(); // Initialize Frequency Dither Parameters

#ifdef  SINGLE_FRAME_ENABLE
   //init_dpwms_for_single_frame();///
#else
	init_dpwms();
#endif
	handle_light_load_mode_configuration();
    init_ADC_polled();
#ifdef IDE_ENABLE
	init_ide();
#endif
	init_interrupts();
	init_watchdog();
	//ram_cpu_sample = 0; //50; //Filter0Regs.CPUXN.bit.CPU_SAMPLE; 		// initialize hyperknob
	//ram_eadcdac = 0; //3000;//FeCtrl0Regs.EADCDAC.bit.DAC_VALUE; //initialize hyperknob

	NoFault=fault_handler();
	watchdog_kick();
#ifdef EVB
	PSON=1;
#endif
//	watchdog_reset();
	//FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = 1500;
	for(;;)
	{
		//AdcRegs.ADCCTRL.bit.SW_START = 1;
		Calibration_Main();
		if (erase_segment_counter > 0)
		{
		  erase_task();	//  Handle the DFlash segment erases
		}
		pmbus_handler();
		control();
		//fault_handler();
		//poll_adc();
		watchdog_kick();
	}
}
//#pragma INTERRUPT(c_int00,RESET)
// __attribute__((__section__(".cint00")))
// void c_int00(void)
// {
// 	main();
// }
