//system_defines.h
#include "Cyclone_Device.h"

#define FLASH_CONFIG (0)

#define SINGLE_FRAME_ENABLE    (1)
#define CURRENT_SHARING_ENABLE (1)
#define HD_OBC_DCDC_CODE	 (1)

#define min(a,b)					(((a)>(b)) ? (b):(a))



#define INOMVP (30)
#define INOMPV (INOMVP)
#define IMAXPI (35)
#define IMAXIP (IMAXPI)
#define ISCALE (22.43)

#define DAC_0 (int)(VOUT / 12.0 * 1.056 / 1.6 * (1 << 14) + 0.5) 	//DAC value required to achieve VOUT
#define HSFB_NOM_VOLTAGE ((Uint32)pmbus_dcdc_config[0].vout_cmd * DAC_VALUE_SCALER >> (VOUT_MODE_EXP + 4))

#define HSFB_NOM_CURRENT_LOWER (int)(INOMPV * ISCALE)
#define HSFB_NOM_CURRENT_UPPER (int)(INOMVP * ISCALE)
#define HSFB_MAX_POWER (HSFB_NOM_CURRENT_LOWER * HSFB_NOM_VOLTAGE)

#define HSFB_MAX_CURRENT_LOWER (int)(IMAXIP * ISCALE)
#define HSFB_MAX_CURRENT_UPPER (int)(IMAXPI * ISCALE)
#define HSFB_MAX_CURRENT (int)(IMAX * ISCALE)
#define DAC_1 (HSFB_MAX_CURRENT * 16)//DAC value required to achieve Imax


#define MASK_CTRL_PIN     (CONTROL_GLBIO_BIT_MASK) //(1 << 14)
#define MASK_PGOOD        (TMS_GLBIO_BIT_MASK)     //(1 << 25)                    
#define MASK_FAILURE      (FAULT2_GLBIO_BIT_MASK)  //(1 << 11)
#define MASK_VINOK        (TCK_GLBIO_BIT_MASK)     //(1 << 27)


//#define PSON (MiscAnalogRegs.GLBIOREAD.all & MASK_CTRL_PIN)
#define DAC_OCP_PRI (IPRI_OCP / 2.5 * ((1<<7) - 1.0) + 1)			//DAC value required to achieve Ipri_OCP
#define DAC_STEP_0 (DAC_0 * (1 << 11) * TSAMP / TSS + 0.5)			//DAC step size required to achieve TSS
#define PMAX (int)(IMAXPI * VOUT * (float)(1 << 14) * (float)(1 << 12) * 1.08 * 54e-3 / 12.0 / 1.6 / 2.5)	//Firmware CP value
#define IPMAX (int)(PMAX / DAC_0)
#define ICCMAX (int)(25.0 * (float)(1 << 12) * 54e-3 / 2.5)

//==========================================================================================
// Memory allocation constants
//==========================================================================================
// ****VOYAGER#define MFBALR2_HALF0_DATA_FLASH_BASE_ADDRESS 0x8800

// This limitation check is required because the flash access routines in flash.c make the
// assumption that the size of the segments of the data flash are an integral power of two.
#if (DATA_FLASH_SEGMENT_SIZE & (DATA_FLASH_SEGMENT_SIZE - 1)) != 0
#error "DATA_FLASH_SEGMENT_SIZE must be defined as an integral power of two"
#endif
	

#define MFBALR2_HALF0_DATA_FLASH_BASE_ADDRESS (0x8800)
#define MFBALRX_BYTE0_BLOCK_SIZE_2K     	(0x20) 		
#define MFBALRX_BYTE0_RONLY					(0x02)		   //Read-only protection
#define MFBALRX_BYTE0_BLOCK_SIZE_32K    	(0x60)

#define UART_RX_SIZE (10) //total number of bytes for received data packet
#define UART_TX_SIZE (10) //total number of bytes for transmitted data packet

// Flash Error codes
#define FLASH_SUCCESS 				(0)
#define FLASH_INVALID_SEGMENT 		(1)
#define	FLASH_INVALID_ADDRESS		(2)
#define	FLASH_MISCOMPARE			(3)

//#define NULL						(0)
#define ROM_PASSWORD_BYTES      (4)
#define NUMBER_OF_FAULTY_TRIALS (5) // Number of time wrog password may be entered

#define DCDC_PAGE_NUMS (1)

// 912 = 16 * Round(1.065 / (12 * 1.6) * (1 << 10))
#define VOUT_MODE_EXP	 (9)
#define DAC_VALUE_SCALER (996)

/*
DAC0 * (1 << 11) * TSAMP / TSS calculates the DAC step required to achieve a
soft start time of TSS from 0V. Where TSS is in seconds and DAC0 is the 14 bit version. 
TSAMP is the sample rate of the EADC. For the LLC converter this has been fixed 
to 500ns independant of the switching frequency.

The factor of 1000 below is to convert the units from mV/us to V/s. DAC_VALUE_SCALER is included
to convert the voltage to DAC LSBs. The factor VOUT_MODE_EXP is not needed since 
the original units of the transition rate do not include it.
*/
#define VOUT_TRANSITION_EXP (9)
#define VOUT_TRANSITION_RATE_SCALER (int32)(TSAMP * 1000 * (1 << (11 + VOUT_TRANSITION_EXP)) * DAC_VALUE_SCALER)

/*
DAC0 * (1 << 11) * TSAMP / TSS calculates the DAC step required to achieve a
soft start time of TSS from 0V. Where TSS is in seconds and DAC0 is the 14 bit version. 
TSAMP is the sample rate of the EADC. 

The factor of 1000 below is to convert the units from V/ms to V/s. DAC_VALUE_SCALER is included
to convert the voltage to DAC LSBs. The factor VOUT_MODE_EXP is needed here since the units of the
voltage command are scaled by this factor. See the code implementation for this term.
*/
//#define TON_RISE_EXP (0)
//#define TON_RISE_SCALER (int32)(TSAMP * 1000 * (1 << (11 + TON_RISE_EXP)) * DAC_VALUE_SCALER)

//((1 / 12.0 * 1.065 / 2.5 * ((1 << 7) - 1)) << OVP_EXP)
#define OVP_EXP (6)
#define DAC_OVP (289)

//These two together properly scale the VOUT from the ADC to the Literal value.
//((12 / 1.065) * 2.5 / 4096) << (16 + VOUT_MODE_EXP - VOUT_ADC_TO_LITERAL_SHIFT)
//The factor of 16 appears due to the unsigned_short_q_multiply function
#define VOUT_ADC_TO_LITERAL_SHIFT 	(3)
#define VOUT_ADC_TO_LITERAL_SCALER  (25223)//(25746)//(25823) 

//Status Word aliases
#define PMBUS_STATUS_WORD_GATEDRIVER		(0x1)
#define PMBUS_STATUS_WORD_BATT_LOST			(0x2)
#define PMBUS_STATUS_WORD_TEMPERATURE 		(0x4)
#define PMBUS_STATUS_WORD_VIN_UV 			(0x8)
#define PMBUS_STATUS_WORD_IOUT_OC 			(0x10)
#define PMBUS_STATUS_WORD_VOUT_OV 			(0x20)
#define PMBUS_STATUS_WORD_OFF 				(0x40)
#define PMBUS_STATUS_WORD_BUSY 				(0x80)
#define PMBUS_STATUS_WORD_UNKNOWN 			(0x100)
#define PMBUS_STATUS_WORD_OTHER 			(0x200)
#define PMBUS_STATUS_WORD_VIN_OV 			(0x400)
#define PMBUS_STATUS_WORD_DISABLED		 	(0x800)
#define PMBUS_STATUS_WORD_HIGH_BYTE   		(0x1000)
#define PMBUS_STATUS_WORD_POWERSUPPLY		(0x2000)
#define PMBUS_STATUS_WORD_IOUT  			(0x4000)
#define PMBUS_STATUS_WORD_VOUT  			(0x8000)

#define ACOMPA_INT_STATUS_MASK 	(0x01)
#define ACOMPB_INT_STATUS_MASK 	(0x02)
#define ACOMPC_INT_STATUS_MASK 	(0x04)
#define ACOMPD_INT_STATUS_MASK 	(0x08)
#define ACOMPE_INT_STATUS_MASK 	(0x10)
#define ACOMPF_INT_STATUS_MASK 	(0x20)
#define ACOMPG_INT_STATUS_MASK 	(0x40)
#define COMP_INT_STATUS_MASK	(ACOMPB_INT_STATUS_MASK | ACOMPE_INT_STATUS_MASK)


#define EADC_DAC_TARGET  12000 //((int32)(pmbus_dcdc_config[0].vout_cmd * DAC_VALUE_SCALER >> VOUT_MODE_EXP)) //used to be (393 << EADC_DAC_SHIFT)
#define EADC_DAC_MAX 13000 //((int32)((float)(pmbus_dcdc_config[0].vout_cmd * DAC_VALUE_SCALER >> VOUT_MODE_EXP)* ((float)1.01)))
#define EADC_DAC_MIN 11000 //((int32)((float)(pmbus_dcdc_config[0].vout_cmd * DAC_VALUE_SCALER >> VOUT_MODE_EXP)* ((float)0.99)))
#define CS_INT_MAN (1)
#define CS_INT_EXP (10)

#define AVERAGE_Vout_SHIFT (11)
#define AVERAGE_Vin_SHIFT (11)
#define AVERAGE_Temp_SHIFT (3)
#define AVERAGE_ISHARE_SHIFT (6)
#define AVERAGE_IOUT_SHIFT (11)


#define DROP_COUNT_OFFSET            (0xc2000)
#define COPPER_TEMP_COEFF            (0.003863)
#define CURRENT_GAIN_FACTOR          (-13693)  //(13077) Change later on to convert into same lavel as current measured by ADC12
            

#define CALIB_TEMPERATURE (23)
#define TEMP_COUNT_AT_CALIB_TEMPERATURE (1856)
#define TEMP_COUNT_PER_DEG_C (104)


#define DPWM_FAULT_AB_STATUS_MASK (0x2)


//#define MAX_VALUE_FIT_5_BITS  (0x1F)
//#define MAX_VALUE_FIT_6_BITS  (0x3F)
#define MAX_VALUE_FIT_7_BITS  (0x7F)
//#define MAX_VALUE_FIT_8_BITS  (0xFF)
//#define MAX_VALUE_FIT_9_BITS  (0x1FF)
#define MAX_VALUE_FIT_10_BITS (0x3FF)
//#define MAX_VALUE_FIT_11_BITS (0x7FF)
#define MAX_VALUE_FIT_12_BITS (0xFFF)
//#define MAX_VALUE_FIT_13_BITS (0x1FFF)
#define MAX_VALUE_FIT_14_BITS (0x3FFF)
//#define MAX_VALUE_FIT_15_BITS (0x7FFF)
#define MAX_VALUE_FIT_16_BITS (0xFFFF)
//#define MAX_VALUE_FIT_17_BITS (0x1FFFF)
#define MAX_VALUE_FIT_18_BITS (0x3FFFF)
//#define MAX_VALUE_FIT_19_BITS (0x7FFFF)
//#define MAX_VALUE_FIT_20_BITS (0xFFFFF)

#define qnote_linear11_multiply_fit7(qnote_a,linear11_b)\
qnote_linear11_multiply_fit(qnote_a,linear11_b,MAX_VALUE_FIT_7_BITS)
#define qnote_linear11_multiply_fit10(qnote_a,linear11_b)\
qnote_linear11_multiply_fit(qnote_a,linear11_b,MAX_VALUE_FIT_10_BITS)
#define qnote_linear11_multiply_fit12(qnote_a,linear11_b)\
qnote_linear11_multiply_fit(qnote_a,linear11_b,MAX_VALUE_FIT_12_BITS)
#define qnote_linear11_multiply_fit18(qnote_a,linear11_b)\
qnote_linear11_multiply_fit(qnote_a,linear11_b,MAX_VALUE_FIT_18_BITS)

#define qnote_linear16_multiply_fit7(qnote_a,linear16_b,vout_mode_c)\
qnote_linear16_multiply_fit(qnote_a,linear16_b,vout_mode_c,MAX_VALUE_FIT_7_BITS)
#define qnote_linear16_multiply_fit12(qnote_a,linear16_b,vout_mode_c)\
qnote_linear16_multiply_fit(qnote_a,linear16_b,vout_mode_c,MAX_VALUE_FIT_12_BITS)
#define qnote_linear16_multiply_fit14(qnote_a,linear16_b,vout_mode_c)\
qnote_linear16_multiply_fit(qnote_a,linear16_b,vout_mode_c,MAX_VALUE_FIT_14_BITS)




#define OVOUT_WARN 	(adc_average.Vout          > pmbus_dcdc_config_translated[0].vout_ov_warn_limit)
#define UVOUT_WARN 	(adc_average.Vout          < pmbus_dcdc_config_translated[0].vout_uv_warn_limit)
#define OCOUT_WARN 	(adc_average.isec          > pmbus_dcdc_config_translated[0].iout_oc_warn_limit)
#define OCIN_WARN 	(adc_average.i_pri 	      > pmbus_dcdc_config_translated[0].iin_oc_warn_limit)
#define OT_WARN 	(adc_average.current_temp  < pmbus_dcdc_config_translated[0].temp_ot_warn_limit)
#define OVVIN_WARN 	(adc_average.Vin           > pmbus_dcdc_config_translated[0].vin_ov_warn_limit)
#define UVVIN_WARN 	(adc_average.Vin           < pmbus_dcdc_config_translated[0].vin_uv_warn_limit)

#define UVOUT_FAULT ((adc_average.Vout         < pmbus_dcdc_config_translated[0].vout_uv_fault_limit) && (supply_state == STATE_CURRENT_REGULATED))
#define OT_FAULT 	(adc_average.current_temp  > pmbus_dcdc_config_translated[0].temp_ot_fault_limit << AVERAGE_Temp_SHIFT)
//#define OVER_TEMPERATURE_FAULT_NOT 	(adc_average.current_temp  < pmbus_dcdc_config_translated[0].temp_ot_fault_limit)


//#define OVVIN_FAULT (adc_average.vin           > pmbus_dcdc_config_translated[0].vin_ov_fault_limit)
//#define UVVIN_FAULT (adc_average.vin           < pmbus_dcdc_config_translated[0].vin_uv_fault_limit)

#define OVVIN_FAULT (vin_eadc_sns           > pmbus_dcdc_config_translated[0].vin_ov_fault_limit) //correction made Oct 27 2015
#define UVVIN_FAULT (vin_eadc_sns           < pmbus_dcdc_config_translated[0].vin_uv_fault_limit) //correction made Oct 27 2015

#define PGOOD_ON  (adc_average.Vout            > pmbus_dcdc_config_translated[0].pgood_on_limit)
#define PGOOD_OFF (adc_average.Vout            < pmbus_dcdc_config_translated[0].pgood_off_limit)


//#define SUFFICIENT_INPUT_VOLTAGE     1 // (vin_single_frame > pmbus_dcdc_config_translated[0].vin_on_limit)
//#define INSUFFICIENT_INPUT_VOLTAGE    0 //(vin_single_frame < pmbus_dcdc_config_translated[0].vin_off_limit)

#define SUFFICIENT_INPUT_VOLTAGE    (vin_eadc_sns > pmbus_dcdc_config_translated[0].vin_on_limit)
#define INSUFFICIENT_INPUT_VOLTAGE  (vin_eadc_sns < pmbus_dcdc_config_translated[0].vin_off_limit)

#define OVER_CURRENT_FAULT      	(0)			//oc set at 27A //(CURR_OFFSET + CURRENT_GAIN * Iout) // CURR_OFFSET =16;  CURRENT_GAIN =10.667
#define OVER_CURRENT_FAULT_NOT      (1)		// current recovery threshold at 25A

#define OVER_TEMPERATURE_FAULT_NOT (!(OT_FAULT))


//=========================================================================================
// CIM module definitions
//=========================================================================================
// FIRQPR, INTREQ, REQMASK Registers
// interrupts listed highest priority to lowest priority:
#define CIMINT_ALL_SYS_SOFT		(0x80000000)	// 31	System Software Interrupt
#define CIMINT_ALL_FAULT_PIN	(0x40000000)	// 30	Fault Pin Interrupt
#define CIMINT_ALL_DPWM0		(0x20000000)	// 29	Every(1-16)DPWM0 switching cycles or CLF flag shutdown Interrupt
#define CIMINT_ALL_DPWM1		(0x10000000)	// 28	Every(1-16)DPWM1 switching cycles or CLF flag shutdown Interrupt
#define CIMINT_ALL_DPWM2		(0x08000000)	// 27	Every(1-16)DPWM2 switching cycles or CLF flag shutdown Interrupt
#define CIMINT_ALL_DPWM3		(0x04000000)	// 26	Every(1-16)DPWM3 switching cycles or CLF flag shutdown Interrupt
#define CIMINT_ALL_FAULT_MUX	(0x02000000)	// 25	Fault Mux Interrupt
#define CIMINT_ALL_ADC_CONV		(0x01000000)	// 24	ADC-12 End of Conversion Interrupt
#define CIMINT_ALL_CPCC			(0x00800000)	// 23	CPCC Interrupt, Mode switched in CPCC module Flag needs to be read for details
#define CIMINT_ALL_TMR_COMP0	(0x00400000)	// 22	24-bit Timer Compare 0 interrupt
#define CIMINT_ALL_TMR_CAPT0	(0x00200000)	// 21	24-bit Timer Capture 0 interrupt
#define CIMINT_ALL_TMR_COMP1	(0x00100000)	// 20	24-bit Timer Compare 1 interrupt
#define CIMINT_ALL_TMR_CAPT1	(0x00080000)	// 19	24-bit Timer Capture 1 interrupt
#define CIMINT_ALL_TMR_OVFL		(0x00040000)	// 18	24-bit Timer counter overflow interrupt
#define CIMINT_ALL_PWM0_COMP	(0x00020000)	// 17	16-bit Timer PWM0 counter overflow or Compare interrupt
#define CIMINT_ALL_PWM1_COMP	(0x00010000)	// 16	16-bit Timer PWM1 counter overflow or Compare interrupt
#define CIMINT_ALL_PWM2_COMP	(0x00008000)	// 15	16-bit Timer PWM2 counter overflow or Compare interrupt
#define CIMINT_ALL_PWM3_COMP	(0x00004000)	// 14	16-bit Timer PWM3 counter overflow or Compare interrupt
#define CIMINT_ALL_FRONT_END2	(0x00002000)	// 13	Front End 2 Interrupt
#define CIMINT_ALL_FRONT_END1	(0x00001000)	// 12	Front End 1 Interrupt
#define CIMINT_ALL_FRONT_END0	(0x00000800)	// 11	Front End 0 Interrupt
#define CIMINT_ALL_DIGI_COMP 	(0x00000400)	// 10	Digital comparator interrupt
#define CIMINT_ALL_PMBUS		(0x00000200)	// 9	PMBus related interrupt
#define CIMINT_ALL_UART2_TX		(0x00000100)	// 8	UART2 TX buffer empty
#define CIMINT_ALL_UART2_RX		(0x00000080)	// 7	UART2 RX buffer has a byte
#define CIMINT_ALL_UART1_TX		(0x00000040)	// 6	UART1 TX buffer empty
#define CIMINT_ALL_UART1_RX		(0x00000020)	// 5	UART1 RX buffer has a byte
#define CIMINT_ALL_UART_ERR		(0x00000010)	// 4	UART or SCI error Interrupt. Frame, parity or Overrun
#define CIMINT_ALL_WTDG_WAKE	(0x00000008)	// 3	Wakeup interrupt when watchdog equals half of set watch time
#define CIMINT_ALL_WTDG_RSET	(0x00000004)	// 2	Interrupt from watchdog exceeded (reset)
#define CIMINT_ALL_EXT_INT	    (0x00000002)	// 1	Interrupt on one or all external input pins
#define CIMINT_ALL_BRWN_OUT		(0x00000001)	// 0	Brown Out Interrupt


//=========================================================================================
// Global I/O definitions
//=========================================================================================
//Bit positions:
#define FAULT3_GLBIO_BIT_POSITION                (29)
#define ADC_EXT_TRIG_GLBIO_BIT_POSITION          (28)
#define TCK_GLBIO_BIT_POSITION                   (27)
#define TDO_GLBIO_BIT_POSITION                   (26)
#define TMS_GLBIO_BIT_POSITION                   (25)
#define TDI_GLBIO_BIT_POSITION                   (24)
#define SCI_TX1_GLBIO_BIT_POSITION               (23)
#define SCI_TX0_GLBIO_BIT_POSITION               (22)
#define SCI_RX1_GLBIO_BIT_POSITION               (21)
#define SCI_RX0_GLBIO_BIT_POSITION               (20)
#define TMR_CAP_GLBIO_BIT_POSITION               (19)
#define TMR_PWM1_GLBIO_BIT_POSITION              (18)
#define TMR_PWM0_GLBIO_BIT_POSITION              (17)
#define PMBUS_CLK_GLBIO_BIT_POSITION             (16)
#define PMBUS_DATA_GLBIO_BIT_POSITION            (15)
#define CONTROL_GLBIO_BIT_POSITION               (14)
#define ALERT_GLBIO_BIT_POSITION                 (13)
#define EXT_INT_GLBIO_BIT_POSITION               (12)
#define FAULT2_GLBIO_BIT_POSITION                (11)
#define FAULT1_GLBIO_BIT_POSITION                (10)
#define FAULT0_GLBIO_BIT_POSITION                 (9)
#define SYNC_GLBIO_BIT_POSITION                   (8)
#define DPWM3B_GLBIO_BIT_POSITION                 (7)
#define DPWM3A_GLBIO_BIT_POSITION                 (6)
#define DPWM2B_GLBIO_BIT_POSITION                 (5)
#define DPWM2A_GLBIO_BIT_POSITION                 (4)
#define DPWM1B_GLBIO_BIT_POSITION                 (3)
#define DPWM1A_GLBIO_BIT_POSITION                 (2)
#define DPWM0B_GLBIO_BIT_POSITION                 (1)
#define DPWM0A_GLBIO_BIT_POSITION                 (0)

//Bit masks:
#define FAULT3_GLBIO_BIT_MASK                 (1 << FAULT3_GLBIO_BIT_POSITION)
#define ADC_EXT_TRIG_GLBIO_BIT_MASK           (1 << ADC_EXT_TRIG_GLBIO_BIT_POSITION)
#define TCK_GLBIO_BIT_MASK                    (1 << TCK_GLBIO_BIT_POSITION)
#define TDO_GLBIO_BIT_MASK                    (1 << TDO_GLBIO_BIT_POSITION)
#define TMS_GLBIO_BIT_MASK                    (1 << TMS_GLBIO_BIT_POSITION)
#define TDI_GLBIO_BIT_MASK                    (1 << TDI_GLBIO_BIT_POSITION)
#define SCI_TX1_GLBIO_BIT_MASK                (1 << SCI_TX1_GLBIO_BIT_POSITION)
#define SCI_TX0_GLBIO_BIT_MASK                (1 << SCI_TX0_GLBIO_BIT_POSITION)
#define SCI_RX1_GLBIO_BIT_MASK                (1 << SCI_RX1_GLBIO_BIT_POSITION)
#define SCI_RX0_GLBIO_BIT_MASK                (1 << SCI_RX0_GLBIO_BIT_POSITION)
#define TMR_CAP_GLBIO_BIT_MASK                (1 << TMR_CAP_GLBIO_BIT_POSITION)
#define TMR_PWM1_GLBIO_BIT_MASK               (1 << TMR_PWM1_GLBIO_BIT_POSITION)
#define TMR_PWM0_GLBIO_BIT_MASK               (1 << TMR_PWM0_GLBIO_BIT_POSITION)
#define PMBUS_CLK_GLBIO_BIT_MASK              (1 << PMBUS_CLK_GLBIO_BIT_POSITION)
#define PMBUS_DATA_GLBIO_BIT_MASK             (1 << PMBUS_DATA_GLBIO_BIT_POSITION)
#define CONTROL_GLBIO_BIT_MASK                (1 << CONTROL_GLBIO_BIT_POSITION)
#define ALERT_GLBIO_BIT_MASK                  (1 << ALERT_GLBIO_BIT_POSITION)
#define EXT_INT_GLBIO_BIT_MASK                (1 << EXT_INT_GLBIO_BIT_POSITION)
#define FAULT2_GLBIO_BIT_MASK                 (1 << FAULT2_GLBIO_BIT_POSITION)
#define FAULT1_GLBIO_BIT_MASK                 (1 << FAULT1_GLBIO_BIT_POSITION)
#define FAULT0_GLBIO_BIT_MASK                 (1 << FAULT0_GLBIO_BIT_POSITION)
#define SYNC_GLBIO_BIT_MASK                   (1 << SYNC_GLBIO_BIT_POSITION)
#define DPWM3B_GLBIO_BIT_MASK                 (1 << DPWM3B_GLBIO_BIT_POSITION)
#define DPWM3A_GLBIO_BIT_MASK                 (1 << DPWM3A_GLBIO_BIT_POSITION)
#define DPWM2B_GLBIO_BIT_MASK                 (1 << DPWM2B_GLBIO_BIT_POSITION)
#define DPWM2A_GLBIO_BIT_MASK                 (1 << DPWM2A_GLBIO_BIT_POSITION)
#define DPWM1B_GLBIO_BIT_MASK                 (1 << DPWM1B_GLBIO_BIT_POSITION)
#define DPWM1A_GLBIO_BIT_MASK                 (1 << DPWM1A_GLBIO_BIT_POSITION)
#define DPWM0B_GLBIO_BIT_MASK                 (1 << DPWM0B_GLBIO_BIT_POSITION)
#define DPWM0A_GLBIO_BIT_MASK                 (1 << DPWM0A_GLBIO_BIT_POSITION)


//#define EVB 1
#undef EVB
