#include "system_defines.h"
#include "cyclone_device.h"
#include "pmbus_commands.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"

unsigned int interrupt_time;


#define program_flash_integrity_word (*((volatile unsigned long *) 0x7ffc))
//last word in flash, when executing from Flash.  used to store integrity code

void zero_out_integrity_word(void)
{

    DecRegs.FLASHILOCK.all = 0x42DC157E;// Write key to Program Flash Interlock Register
    DecRegs.MFBALR1.all = MFBALRX_BYTE0_BLOCK_SIZE_32K; //enable program flash write
    program_flash_integrity_word = 0;
    DecRegs.MFBALR1.all = MFBALRX_BYTE0_BLOCK_SIZE_32K + //expand program flash out to 4x real size
                            MFBALRX_BYTE0_RONLY;
#ifdef UCD3138128
    while(DecRegs.PFLASHCTRL_0.bit.BUSY != 0)
#elif UCD3138A64
    while(DecRegs.PFLASHCTRL_0.bit.BUSY != 0)
#elif UCD3138
    while(DecRegs.PFLASHCTRL.bit.BUSY != 0)
#elif UCD3138064
    while(DecRegs.PFLASHCTRL1.bit.BUSY!= 0)
#elif UCD3138064A
    while(DecRegs.PFLASHCTRL1.bit.BUSY!= 0)
#endif
    	{
    		; //do nothing while it programs
    	}
//    interrupt_time = TimerRegs.T24CNTDAT.bit.CNT_DAT - interrupt_time;
    SysRegs.SYSECR.bit.RESET = 2;   //now reset processor.
    return;
}

