//###########################################################################
//
// FILE:   F2802x0_Device.h
//
// TITLE:  F2802x0 Device Definitions.
//
//###########################################################################
// $TI Release: f2802x0 Support Library v110 $
// $Release Date: Mon Apr 30 15:56:43 CDT 2012 $
//###########################################################################

#ifndef F2802x0_DEVICE_H
#define F2802x0_DEVICE_H

#ifdef __cplusplus
extern "C" {
#endif

#define   TARGET   1
//---------------------------------------------------------------------------
// User To Select Target Device:

#define   DSP28_280220PT   0
#define   DSP28_280220DA   0

#define   DSP28_280230PT   0
#define   DSP28_280230DA   0

#define   DSP28_280260PT   0
#define   DSP28_280260DA   0

#define   DSP28_280270PT   TARGET
#define   DSP28_280270DA   0


//---------------------------------------------------------------------------
// Common CPU Definitions:
//

extern cregister volatile unsigned int IFR;
extern cregister volatile unsigned int IER;

#define  EINT   asm(" clrc INTM")
#define  DINT   asm(" setc INTM")
#define  ERTM   asm(" clrc DBGM")
#define  DRTM   asm(" setc DBGM")
#define  EALLOW asm(" EALLOW")
#define  EDIS   asm(" EDIS")
#define  ESTOP0 asm(" ESTOP0")

#define M_INT1  0x0001
#define M_INT2  0x0002
#define M_INT3  0x0004
#define M_INT4  0x0008
#define M_INT5  0x0010
#define M_INT6  0x0020
#define M_INT7  0x0040
#define M_INT8  0x0080
#define M_INT9  0x0100
#define M_INT10 0x0200
#define M_INT11 0x0400
#define M_INT12 0x0800
#define M_INT13 0x1000
#define M_INT14 0x2000
#define M_DLOG  0x4000
#define M_RTOS  0x8000

#define BIT0    0x0001
#define BIT1    0x0002
#define BIT2    0x0004
#define BIT3    0x0008
#define BIT4    0x0010
#define BIT5    0x0020
#define BIT6    0x0040
#define BIT7    0x0080
#define BIT8    0x0100
#define BIT9    0x0200
#define BIT10   0x0400
#define BIT11   0x0800
#define BIT12   0x1000
#define BIT13   0x2000
#define BIT14   0x4000
#define BIT15   0x8000

//---------------------------------------------------------------------------
// For Portability, User Is Recommended To Use the C99 Standard integer types
//

#include <assert.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

// C99 defines boolean type to be _Bool, but this doesn't match the format of
// the other standard integer types.  bool_t has been defined to fill this gap.
typedef _Bool bool_t;

// Work around for code that might accidently use uint8_t
typedef unsigned char uint8_t;

//---------------------------------------------------------------------------
// The following data types are included for compatability with legacy code,
// they are not recommended for use in new software.  Please use the C99
// types included above
//

#ifndef DSP28_DATA_TYPES
#define DSP28_DATA_TYPES
typedef int             int16;
typedef long            int32;
typedef unsigned int    Uint16;
typedef unsigned long   Uint32;
typedef float           float32;
typedef long double     float64;
#endif

//---------------------------------------------------------------------------
// Include All Driver Header Files:
//
#ifdef INCLUDE_ALL
#include "f2802x0_common/include/adc.h"
#include "f2802x0_common/include/cap.h"
#include "f2802x0_common/include/clk.h"
#include "f2802x0_common/include/comp.h"
#include "f2802x0_common/include/cpu.h"
#include "f2802x0_common/include/flash.h"
#include "f2802x0_common/include/gpio.h"
#include "f2802x0_common/include/osc.h"
#include "f2802x0_common/include/pie.h"
#include "f2802x0_common/include/pll.h"
#include "f2802x0_common/include/pwm.h"
#include "f2802x0_common/include/pwmdac.h"
#include "f2802x0_common/include/pwr.h"
#include "f2802x0_common/include/sci.h"
#include "f2802x0_common/include/spi.h"
#include "f2802x0_common/include/timer.h"
#include "f2802x0_common/include/wdog.h"
#endif  //end INCLUDE_ALL


//---------------------------------------------------------------------------
// Include All Peripheral Header Files:
//

#include "F2802x0_Adc.h"                // ADC Registers
#include "F2802x0_BootVars.h"           // Boot ROM Variables
#include "F2802x0_DevEmu.h"             // Device Emulation Registers
#include "F2802x0_Comp.h"               // Comparator Registers
#include "F2802x0_CpuTimers.h"          // 32-bit CPU Timers
#include "F2802x0_ECap.h"               // Enhanced Capture
#include "F2802x0_EPwm.h"               // Enhanced PWM
#include "F2802x0_Gpio.h"               // General Purpose I/O Registers
#include "F2802x0_I2c.h"                // I2C Registers
#include "F2802x0_NmiIntrupt.h"         // NMI Interrupt Registers
#include "F2802x0_PieCtrl.h"            // PIE Control Registers
#include "F2802x0_PieVect.h"            // PIE Vector Table
#include "F2802x0_Spi.h"                // SPI Registers
#include "F2802x0_Sci.h"                // SCI Registers
#include "F2802x0_SysCtrl.h"            // System Control/Power Modes
#include "F2802x0_XIntrupt.h"           // External Interrupts

#if (DSP28_280220PT||DSP28_280230PT||DSP28_280260PT||DSP28_280270PT)
#define DSP28_COMP1    1
#define DSP28_COMP2    1
#define DSP28_EPWM1    1
#define DSP28_EPWM2    1
#define DSP28_EPWM3    1
#define DSP28_ECAP1    1
#define DSP28_SPIA     1
#define DSP28_SCIA     1
#define DSP28_I2CA     1
#endif  // end 2802x0 PT package

#if (DSP28_280220DA||DSP28_280230DA||DSP28_280260DA||DSP28_280270DA)
#define DSP28_COMP1    1
#define DSP28_COMP2    0
#define DSP28_EPWM1    1
#define DSP28_EPWM2    1
#define DSP28_EPWM3    1
#define DSP28_ECAP1    1
#define DSP28_SPIA     1
#define DSP28_SCIA     1
#define DSP28_I2CA     1
#endif  // end 2802x0 DA package


// Timer definitions based on System Clock

// 50 MHz devices (280260/280270)
#if (DSP28_280260PT||DSP28_280260DA||DSP28_280270PT||DSP28_280270DA) 
    #define      mSec0_5          25000           // 0.5 mS
    #define      mSec0_75         37500           // 0.75 mS
    #define      mSec1            50000           // 1.0 mS
    #define      mSec2            100000          // 2.0 mS
    #define      mSec5            250000          // 5.0 mS
    #define      mSec7_5          375000          // 7.5 mS
    #define      mSec10           500000          // 10 mS
    #define      mSec20           1000000         // 20 mS
    #define      mSec50           2500000         // 50 mS
    #define      mSec75           3750000         // 75 mS
    #define      mSec100          5000000         // 100 mS
    #define      mSec200          10000000        // 200 mS
    #define      mSec500          25000000        // 500 mS
    #define      mSec750          37500000        // 750 mS
    #define      mSec1000         50000000        // 1000 mS
    #define      mSec2000         100000000       // 2000 mS
    #define      mSec5000         250000000       // 5000 mS
#endif

//40 MHz devices (280220/280230)
#if (DSP28_28022PT||DSP28_28022DA||DSP28_28023PT||DSP28_28023DA)
    #define      mSec0_5          20000           // 0.5 mS
    #define      mSec0_75         30000           // 0.75 mS
    #define      mSec1            40000           // 1.0 mS
    #define      mSec2            80000           // 2.0 mS
    #define      mSec5            200000          // 5.0 mS
    #define      mSec7_5          300000          // 7.5 mS
    #define      mSec10           400000          // 10 mS
    #define      mSec20           800000          // 20 mS
    #define      mSec50           2000000         // 50 mS
    #define      mSec75           3000000         // 75 mS
    #define      mSec100          4000000         // 100 mS
    #define      mSec200          8000000         // 200 mS
    #define      mSec500          20000000        // 500 mS
    #define      mSec750          30000000        // 750 mS
    #define      mSec1000         40000000        // 1000 mS
    #define      mSec2000         80000000        // 2000 mS
    #define      mSec5000         200000000       // 5000 mS
#endif

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif  // end of F2802x0_DEVICE_H definition

//===========================================================================
// End of file.
//===========================================================================
