//corrected PWM configuration setting
//Inverter control loop
//switch over with relay.
//15A constant current charging
/*###########################################################################

FILE:    main_LFInverter.c
This code sense the ac mains connected to Inverter &
when ac mains presents works in charging mode i.e. converts 230V to 14.4V around.
When ac mains fails, It works in inverter mode i.e. converts 12V to 230V.

It is basic code written for showing demo. We have given provision for synchronisation
of ac mains once it comes back by using zero crossing detection with phase shifting/frequency \
shifting method.

Also one can work on further on short circuit/over load detection etc as hardware provisions
are made keeping in view of this requirement.

Lead acid battery charging chemistry (i.e. charge @c/10 or c/5 till 13.6V & then by c/100
till 14.4V) can be implemented in charging section.

//###########################################################################*/
// Prototype statements for functions found within this file.
#include "math.h"
#include "DSP28x_Project.h"     // Device Headerfile
#include "IQmathLib.h"


#define GLOBAL_Q	20		// for all IQ match operation.So -2048<variable value<2047.999999
#define  TWO_PI   _IQ(6.283185)

interrupt void adc_isr(void);	//ADc interrupt routine ,called every 50uS

void ConfigEPwmInverter(void);
void ConfigEPwmCharger(void);
void StartEPwmInverter(void);
void StopEPwmInverter(void);
void CheckTemperature(void);
void CheckBatteryStatus(void);

//Extern Variables used in this file
extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadEnd;
extern Uint16 RamfuncsRunStart;

// Preprocessor Directives used in this file
#define	SINE_GEN_PRD			1250//Up down mode so PWM Peripheral clock/(modulated frequency*2)
									//= System clock(50MHz)/(20KHz*2)=1250

/************************* Main State Values**********************/
#define WAIT_STATE				0x01
#define INVERTER_STATE			0x02
#define INVERTER_STATE_ON		0x03
#define BATTERY_CHARGING		0x04
#define BATTERY_CHARGING_ON		0x05
#define FAULT_STATE				0x08


#define DB_UP   1
unsigned int CHARGECYCLE= 900;		//Variable adjusted for charging current
#define DUTYCYCLE 	325				//just a initial value of PWM width while configuring PWMs
#define EPWM1_MIN_DB		   50	//Dead band Cycle
#define EPWM2_MIN_DB		   50	//Dead band Cycle

/************** Value for Inverter_state*****************************/
#define INVERTER_ACTION_OFF		1
#define INVERTER_ACTION_ON		2
/***************Value for charging state****************************/
#define BATTERYCHARGING_ON		4
#define BATTERYCHARGING_OFF		8

Uint16 Mains_Missingcounter = 0;		//Mains fails counting register
Uint16 Mains_DetectionCounter = 0;		//mains detection counting register

// Global variables used in this file
Uint32 EPwm1TimerIntCount;
Uint32 EPwm2TimerIntCount;
Uint32 EPwm3TimerIntCount;
Uint16 EPwm1_DB_Direction;
Uint16 EPwm2_DB_Direction;
Uint16 EPwm3_DB_Direction;
Uint16 SineCounter = 0;


/*************************** variable used in application**********************/
Uint16 Main_State = WAIT_STATE;
//Uint16 Voltage1[400];
Uint32 Mains_volt_sum = 0;	// Used for averaging of mains voltage
Uint16 Mains_Voltage;		//ac mains voltage
Uint16 VoltageSampleCounter = 0;	// Used for averaging of mains voltage
_iq gain_coeff = _IQ(1.0), corr_coeff = _IQ(0.1); // Coefficient used for maintaining
													//inverter voltage constant
unsigned char Frequency = 50;	// Inverter Mode Generated frequency
unsigned int Freq_count=400;	// Freq count= Modulation freq /Frequency=20KHz/50=400
char Inverter_Status = INVERTER_ACTION_OFF;
unsigned int Inp_Mains,Out_sense,Charging_current;	// Value of ac mains voltage,
													//Output volatge of inverter & charging current repectively
unsigned char charge_cnt=0;		//used in averaging of charging current
unsigned int out_sense_cnt=0;	//used in averaging of Inverter o/p voltage
unsigned long Out_sense_sum=0,Charging_current_sum=0;//used in averaging of Inverter op voltage & charging current

void main(void)
{
// Step 1. Initialize System Control:

	InitSysCtrl();			//Oscillator @50MHz using PLL (OSCCLK * 10)/2--- DIVSEL=2, PLLCR=10
	/* Calling flash functions from RAM*/

	MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);

// Call Flash Initialization to setup flash wait states

	InitFlash();

// Initialize Gpio pins
	InitEPwm1Gpio();
	InitEPwm2Gpio();
	EALLOW;

	GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 0;		//Relay pin
	GpioCtrlRegs.GPBDIR.bit.GPIO33 = 1;
	GpioDataRegs.GPBCLEAR.bit.GPIO33 = 1;

	GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 0;		//FAN pin
	GpioCtrlRegs.GPADIR.bit.GPIO7 = 1;
	GpioDataRegs.GPASET.bit.GPIO7 = 1;
	EDIS;

// Disable CPU interrupts
	DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
	InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
	IER = 0x0000;
	IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt

	InitPieVectTable();

	EALLOW;
	PieVectTable.ADCINT1 = &adc_isr;
	EDIS;

	EALLOW;
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
	EDIS;

	InitAdcAio();
	InitAdc();
	ConfigEPwmInverter();

	PieCtrlRegs.PIEIER1.bit.INTx1 = 1; // Enable INT 1.1 in the PIE

	IER |= M_INT1; // Enable CPU Interrupt 1
	EINT;
	// Enable Global interrupt INTM
	ERTM;
	// Enable Global realtime interrupt DBGM
	Main_State = INVERTER_STATE;//Main_State = WAIT_STATE;

	while (1)
	{
//		CheckBatteryStatus();
//		CheckTemperature();
		switch (Main_State)
		{
		case WAIT_STATE:
		break;

		case INVERTER_STATE:
			GpioDataRegs.GPBCLEAR.bit.GPIO33=1;
			Inverter_Status=INVERTER_ACTION_OFF;
			ConfigEPwmInverter();
			StartEPwmInverter();
			Main_State=INVERTER_STATE_ON;
			Inverter_Status=INVERTER_ACTION_ON;
		break;

		case INVERTER_STATE_ON:

			//StartEPwmInverter();
			//Main_State=INVERTER_STATE_ON;
			//Inverter_Status=INVERTER_ACTION_ON;
		break;


		case BATTERY_CHARGING:

			StopEPwmInverter();
			ConfigEPwmCharger();
			 /* Switchover Relay*/
			GpioDataRegs.GPBSET.bit.GPIO33=1;
			Inverter_Status=BATTERYCHARGING_ON;

		break;

		case FAULT_STATE:

		break;

		default:
		;
		break;
		}
	}

}
void CheckTemperature(void)
{
	;
}
void CheckBatteryStatus(void)
{
	;
}


void StopEPwmInverter(void)
{
	if (Inverter_Status==INVERTER_ACTION_ON)
	{
	  EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HI;
   	  EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HI;
	  EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;
	  EPwm1Regs.AQCTLA.bit.CBU = AQ_CLEAR;// Set PWM1A on Zero
	  EPwm1Regs.AQCTLA.bit.CBD=AQ_CLEAR;
      EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;
      EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;
      EPwm1Regs.AQCTLA.bit.PRD=AQ_CLEAR;
      EPwm1Regs.AQCTLB.bit.CAU = AQ_CLEAR;             // Set PWM2A on Zero
           EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;
           EPwm1Regs.AQCTLB.bit.CBD = AQ_CLEAR;
           EPwm1Regs.AQCTLB.bit.CAD = AQ_CLEAR;
           EPwm1Regs.AQCTLB.bit.ZRO = AQ_CLEAR;
           EPwm1Regs.AQCTLB.bit.PRD=AQ_CLEAR;
      EPwm2Regs.AQCTLB.bit.CAU = AQ_CLEAR;             // Set PWM2A on Zero
      EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;
      EPwm2Regs.AQCTLB.bit.CBD = AQ_CLEAR;
      EPwm2Regs.AQCTLB.bit.CAD = AQ_CLEAR;
      EPwm2Regs.AQCTLB.bit.ZRO = AQ_CLEAR;
      EPwm2Regs.AQCTLB.bit.PRD=AQ_CLEAR;
      EPwm2Regs.AQCTLA.bit.CAU = AQ_CLEAR;
      	  EPwm2Regs.AQCTLA.bit.CBU = AQ_CLEAR;// Set PWM1A on Zero
      	  EPwm2Regs.AQCTLA.bit.CBD=AQ_CLEAR;
            EPwm2Regs.AQCTLA.bit.CAD = AQ_CLEAR;
            EPwm2Regs.AQCTLA.bit.ZRO = AQ_CLEAR;
      Inverter_Status=INVERTER_ACTION_OFF;
	}
}
void StartEPwmInverter(void)
{
	if (Inverter_Status==INVERTER_ACTION_OFF)
	{
	 EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;//DB_ACTV_LOC;//
   	 EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
   	 EPwm1Regs.AQCTLA.all=0x0;
   	 EPwm2Regs.AQCTLA.all=0x0;
   	 EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on Zero
     EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;
     //EPwm1Regs.AQCTLA.bit.ZRO = AQ_NO_ACTION;
     EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM2A on Zero
     EPwm2Regs.AQCTLA.bit.CAD = AQ_CLEAR;
     Inverter_Status=INVERTER_ACTION_ON;
	}

}
void ConfigEPwmInverter()
{

   EALLOW;
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;      // Stop all the TB clocks
   EDIS;

   EPwm1Regs.ETSEL.bit.SOCAEN	= 1;		// Enable SOC on A group
   EPwm1Regs.ETSEL.bit.SOCASEL	= 4;		// Select SOC from from CPMA on upcount
   EPwm1Regs.ETPS.bit.SOCAPRD 	= 1;		// Generate pulse on 1st event

   EPwm1Regs.TBPRD = SINE_GEN_PRD;                        // Set timer period
   EPwm1Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm1Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
   EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;
   EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_CTR_ZERO;  // Pass through

   EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
   EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
   EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

   // Setup compare
   EPwm1Regs.CMPA.half.CMPA = DUTYCYCLE;

   // Set actions
//   EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on Zero
//   EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;
//   EPwm1Regs.AQCTLA.bit.ZRO = AQ_NO_ACTION;

	EPwm1Regs.AQCTLA.bit.CAU = AQ_CLEAR;             // Set PWM1A on Zero
   	EPwm1Regs.AQCTLA.bit.CAD = AQ_CLEAR;
   	EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;

   // Active Low PWMs - Setup Deadband
     EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
     EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;
     EPwm1Regs.DBRED = EPWM1_MIN_DB;
     EPwm1Regs.DBFED = EPWM1_MIN_DB;
     EPwm1_DB_Direction = DB_UP;

   // Interrupt where we will change the Deadband
   EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
   EPwm1Regs.ETSEL.bit.INTEN = 0;                // Enable INT
   EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;           // Generate INT on 3rd event

   EPwm2Regs.TBPRD = SINE_GEN_PRD;                        // Set timer period
   EPwm2Regs.TBPHS.half.TBPHS = SINE_GEN_PRD;           // Phase is 180

   EPwm2Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
   EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;        // Disable phase loading
   EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;          // Slow just to observe on the scope

   // Setup compare
   EPwm2Regs.CMPA.half.CMPA = DUTYCYCLE;

	EPwm2Regs.AQCTLB.bit.CAU = AQ_CLEAR;             // Set PWM2A on Zero
   	EPwm2Regs.AQCTLB.bit.CAD = AQ_CLEAR;
   	EPwm2Regs.AQCTLB.bit.ZRO = AQ_CLEAR;

   // Active Low complementary PWMs - setup the deadband
   EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
//   EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;
   EPwm2Regs.DBCTL.bit.IN_MODE = DBA_ALL;
   EPwm2Regs.DBRED = EPWM2_MIN_DB;
   EPwm2Regs.DBFED = EPWM2_MIN_DB;
   EPwm2_DB_Direction = DB_UP;

   // Interrupt where we will modify the deadband
   EPwm2Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;      // Select INT on Zero event
   EPwm2Regs.ETSEL.bit.INTEN = 0;                 // Enable INT
   EPwm2Regs.ETPS.bit.INTPRD = ET_3RD;            // Generate INT on 3rd event

    EALLOW;
   EPwm1Regs.TZSEL.bit.CBC2 = 1;
   EPwm1Regs.TZSEL.bit.CBC3 = 1;
   EPwm2Regs.TZSEL.bit.CBC2 = 1;
   EPwm2Regs.TZSEL.bit.CBC3 = 1;

   // What do we want the TZ1 and TZ2 to do?
   EPwm1Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
   EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_LO;
   EPwm2Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
   EPwm2Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

/* Inserted Code*/
	// Clear TB counter
	EPwm1Regs.TBCTR            		= 0x0;         		// Clear counter
	EPwm2Regs.TBCTR            		= 0x0;         		// Clear counter


   	EALLOW;
 			SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
 			SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;         // Start all the timers synced
   	EDIS;
}

void ConfigEPwmCharger(void)
{

   EALLOW;
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;      // Stop all the TB clocks
   EDIS;


   EPwm1Regs.TBPRD = SINE_GEN_PRD;                        // Set timer period
   EPwm1Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm1Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;        // Disable phase loading
   EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;
   EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;  // Pass through

   EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // Load registers every ZERO
   EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
   EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
   EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

   // Setup compare
   EPwm1Regs.CMPA.half.CMPA = CHARGECYCLE;

   // Set actions
   	EPwm1Regs.AQCTLA.all = 0x00;             // Set PWM1A on Zero
   	EPwm1Regs.AQCTLA.bit.ZRO = AQ_CLEAR;

	EPwm1Regs.AQCTLB.bit.CAU = AQ_SET;             // Set PWM1A on Zero
   	EPwm1Regs.AQCTLB.bit.CAD = AQ_CLEAR;
   	EPwm1Regs.AQCTLB.bit.ZRO = AQ_NO_ACTION;
   	EPwm1Regs.AQCTLB.bit.PRD = AQ_NO_ACTION;
   	EPwm1Regs.AQCTLB.bit.CBU = AQ_NO_ACTION;
   	EPwm1Regs.AQCTLB.bit.CBD = AQ_NO_ACTION;

   // Active Low PWMs - Setup Deadband
     EPwm1Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;

   // Interrupt where we will change the Deadband
   EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;     // Select INT on Zero event
   EPwm1Regs.ETSEL.bit.INTEN = 0;                // Enable INT
   EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;           // Generate INT on 3rd event

   EPwm2Regs.TBPRD = SINE_GEN_PRD;                        // Set timer period
   EPwm2Regs.TBPHS.half.TBPHS = 0x0000;           // Phase is 0
   EPwm2Regs.TBCTR = 0x0000;                      // Clear counter

   // Setup TBCLK
   EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN; // Count up
   EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;        // Enable phase loading
   EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;       // Clock ratio to SYSCLKOUT
   EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;          // Slow just to observe on the scope
   EPwm2Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;  // Pass through

   // Setup compare
   EPwm2Regs.CMPA.half.CMPA = CHARGECYCLE;

   // Set actions
      	EPwm2Regs.AQCTLB.all = 0x00;             // Set PWM1A on Zero
     	EPwm2Regs.AQCTLB.bit.ZRO = AQ_CLEAR;

   	EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;             // Set PWM1A on Zero
      	EPwm2Regs.AQCTLA.bit.CAD = AQ_CLEAR;
      	EPwm2Regs.AQCTLA.bit.ZRO = AQ_NO_ACTION;
      	EPwm2Regs.AQCTLA.bit.PRD = AQ_NO_ACTION;
      	EPwm2Regs.AQCTLA.bit.CBU = AQ_NO_ACTION;
      	EPwm2Regs.AQCTLA.bit.CBD = AQ_NO_ACTION;

   // Active Low complementary PWMs - setup the deadband
   EPwm2Regs.DBCTL.bit.OUT_MODE = DB_DISABLE;

   // Interrupt where we will modify the deadband
   EPwm2Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;      // Select INT on Zero event
   EPwm2Regs.ETSEL.bit.INTEN = 0;                 // Enable INT
   EPwm2Regs.ETPS.bit.INTPRD = ET_3RD;            // Generate INT on 3rd event

    EALLOW;
   EPwm1Regs.TZSEL.bit.CBC2 = 1;
   EPwm1Regs.TZSEL.bit.CBC3 = 1;
   EPwm2Regs.TZSEL.bit.CBC2 = 1;
   EPwm2Regs.TZSEL.bit.CBC3 = 1;

   // What do we want the TZ1 and TZ2 to do?
   EPwm1Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
   EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_LO;
   EPwm2Regs.TZCTL.bit.TZA = TZ_FORCE_LO;
   EPwm2Regs.TZCTL.bit.TZB = TZ_FORCE_LO;

/* Inserted Code*/
	// Clear TB counter
	EPwm1Regs.TBCTR            		= 0x0;         		// Clear counter
	EPwm2Regs.TBCTR            		= 0x0;         		// Clear counter


   	EALLOW;
 			SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
 			SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;         // Start all the timers synced
   	EDIS;
   	Main_State=BATTERY_CHARGING_ON;
}


/* This ISR is called every 50uS for putting new value for 20KHz Modulated sine wave or adjusting
 * charging current also all VOltage & current are samples and averaged here for 1 complete
 * cycle of Voltage as per frequency.******************************************/

interrupt void adc_isr(void)
{

	unsigned int PWM_Width;
	_iq20 sin_ang, temp;
	Inp_Mains = AdcResult.ADCRESULT0;
	Out_sense = AdcResult.ADCRESULT1;
	Charging_current=AdcResult.ADCRESULT2;

//	 Voltage1[VoltageSampleCounter]=Out_sense;
		/* If Inverter PWM is ON*/
	/*****************************************
	 * mains ac is rectified by software,mains ac voltagemounted on 1.65V which is
	 * corresponding to 2055 as ADC result.
	******************************************/

//	if (Inp_Mains > 2055)
//		Inp_Mains = Inp_Mains - 2055;
//	else
//		Inp_Mains = 2055 - Inp_Mains;
//	Mains_volt_sum += Inp_Mains;
//	//Voltage1[VoltageSampleCounter] = AC_in; //AdcResult.ADCRESULT0;
//	VoltageSampleCounter++;
//	if (VoltageSampleCounter == 400)	// Assuming ac mains frequency as 50Hz
//	{
//		VoltageSampleCounter = 0;
//		Mains_Voltage = (Mains_volt_sum / 400);
//		Mains_volt_sum = 0;
//
//		if (Mains_Voltage < 700)			//700 is corresponding to 140V ac mains voltage,
//											//One can change it as per their setting
//		{
//			Mains_DetectionCounter = 0;
//			Mains_Missingcounter++;
//			if (Mains_Missingcounter > 50)
//			{
//				Mains_Missingcounter = 0;
//
//				Main_State = INVERTER_STATE;
//
//			}
//		}
//		else
//		{
//			Mains_DetectionCounter++;
//			if (Mains_DetectionCounter > 50)
//			{
//				Mains_DetectionCounter = 0;
//				Mains_Missingcounter = 0;
//				Main_State = BATTERY_CHARGING;
//
//			}
//		}
//	}



	if (Inverter_Status == INVERTER_ACTION_ON)
	{
		//Freq_count = 20000 / Frequency;
//		Out_sense_sum +=Out_sense;
//		out_sense_cnt++;
//
//		if (out_sense_cnt>=800)
//		{
//			Out_sense = Out_sense_sum/out_sense_cnt;
//			Out_sense_sum=0;
//			out_sense_cnt=0;
//			corr_coeff = (_IQ(680)/Out_sense);// 680 value is corresponding to 230V,
//											//One can tune inverter o/p voltage by changing this
//			gain_coeff=_IQmpy(gain_coeff,corr_coeff);
//			if(gain_coeff>=_IQ(3.0))
//				gain_coeff=_IQ(3.0);
//			else if (gain_coeff<=_IQ(0.2))
//				gain_coeff=_IQ(0.2);
//
//		}


		if (SineCounter >= Freq_count)
		{
			SineCounter = 0;


		}

		temp = SineCounter * _IQ(0.000050) * Frequency;
		sin_ang = _IQ20sin(_IQ20mpy(TWO_PI,temp));
		temp = _IQmpy(sin_ang,580); //475
		temp = _IQmpy(gain_coeff,temp);
		if (temp >623)
			temp = 623;
		else if (temp < -623)
			temp = -623;

		PWM_Width = 625 + temp;

		EPwm1Regs.CMPA.half.CMPA = PWM_Width;
		EPwm2Regs.CMPA.half.CMPA = PWM_Width;
		SineCounter++;
	}

//	else if (Inverter_Status==BATTERYCHARGING_ON)
//	{
//
//		Charging_current_sum +=Charging_current;
//		charge_cnt++;
//		if (charge_cnt>=200)
//		{
//			charge_cnt=0;
//			Charging_current=Charging_current_sum/200;
//			Charging_current_sum=0;
//			if (Charging_current<2460)
//			{
//				CHARGECYCLE--;
//				if (CHARGECYCLE<20)
//					CHARGECYCLE=20;
//			}
//			else
//			{
//				CHARGECYCLE++;
//				if (CHARGECYCLE>1230)
//					CHARGECYCLE=1230;
//			}
//			 EPwm1Regs.CMPA.half.CMPA = CHARGECYCLE;
//			 EPwm2Regs.CMPA.half.CMPA = CHARGECYCLE;
//		}
//
//	}

	AdcRegs.ADCINTFLGCLR.bit.ADCINT1 = 1; //Clear ADCINT1 flag reinitialize for next SOC
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; // Acknowledge interrupt to PIE
	return;
}
