
#include "adc_gains.h"

#include "cyclone_device.h"

#include "variables.h"
#include "dcdc_parameters.h"


//to make the gain integer, all gains multiplied by 100,000

const ADC_GainTable_t HW_Gains[] = {
    
    //************************************************************//
    // Plan A
    //************************************************************//
    {
        /*                                       Scale                       Offset               */
        //.LVDC_FB =            UCD_ADC14_Scaling( 0.108,                      0                    ),
        .LVDC_FB =            UCD_ADC14_Scaling( 10800,                      0                    ),
        //.EADC_LVDC_FB =       UCD_EADC_Scaling ( 0.108,                      0                    ),
        .EADC_LVDC_FB =       UCD_EADC_Scaling ( 10800,                      0                    ),
        //.LV_BATTI_SNS =       UCD_ADC14_Scaling( 0.01631,                    815                  ),
        .LV_BATTI_SNS =       UCD_ADC14_Scaling( 1631,                    815                  ),
        //.EADC_LV_BATTI_SNS =  UCD_EADC_Scaling ( 0.01631,                    815                  ),
        .EADC_LV_BATTI_SNS =  UCD_EADC_Scaling ( 1631,                    815                  ),
        // ---
        //.IOUT_MON =           UCD_ADC12_Scaling( 0.0176,                     1257                 ),
        .IOUT_MON =           UCD_ADC12_Scaling( 1760,                     1257                 ),
        //.VOUT_SNS =           UCD_ADC12_Scaling( 0.0557,                     0                    ),
        .VOUT_SNS =           UCD_ADC12_Scaling( 5570,                     0                    ),
        //.OV_MON =             UCD_ADC12_Scaling( 0.145,                      0                    ),
        .OV_MON =             UCD_ADC12_Scaling( 14500,                      0                    ),
        //.BATTI_MON =          UCD_ADC12_Scaling( 0.02973,                    1250                 ),
        .BATTI_MON =          UCD_ADC12_Scaling( 2973,                    1250                 ),
        //.HVI_MON =            UCD_ADC12_Scaling( 0.025,                      0                    ),
        .HVI_MON =            UCD_ADC12_Scaling( 2500,                      0                    ),
        //.HVV_MON =            UCD_ADC12_Scaling( 0.001842,                   0                    ),
        .HVV_MON =            UCD_ADC12_Scaling( 184,                   0                    ),
    },

    //************************************************************//
    // Plan B
    //************************************************************//
    {
        /*                                       Scale                       Offset               */
        //.LVDC_FB =            UCD_ADC14_Scaling( 0.118,                      0                    ),
        .LVDC_FB =            UCD_ADC14_Scaling( 11800,                      0                    ),
        //.EADC_LVDC_FB =       UCD_EADC_Scaling ( 0.118,                      0                    ),
        .EADC_LVDC_FB =       UCD_EADC_Scaling ( 11800,                      0                    ),
        //.LV_BATTI_SNS =       UCD_ADC14_Scaling( 0.01633,                    815                  ),
        .LV_BATTI_SNS =       UCD_ADC14_Scaling( 1633,                    815                  ),
        //.EADC_LV_BATTI_SNS =  UCD_EADC_Scaling ( 0.01633,                    815                  ),
        .EADC_LV_BATTI_SNS =  UCD_EADC_Scaling ( 1633,                    815                  ),
        // ---
        //.IOUT_MON =           UCD_ADC12_Scaling( 0.01774,                    1256                 ),
        .IOUT_MON =           UCD_ADC12_Scaling( 1774,                    1256                 ),
        //.VOUT_SNS =           UCD_ADC12_Scaling( 0.05571,                    0                    ),
        .VOUT_SNS =           UCD_ADC12_Scaling( 5571,                    0                    ),
        //.OV_MON =             UCD_ADC12_Scaling( 0.1667,                     0                    ),
        .OV_MON =             UCD_ADC12_Scaling( 16670,                     0                    ),
        //.BATTI_MON =          UCD_ADC12_Scaling( 0.02508,                    1251                 ),
        .BATTI_MON =          UCD_ADC12_Scaling( 2508,                    1251                 ),
        //.HVI_MON =            UCD_ADC12_Scaling( 0.025,                      0                    ),
        .HVI_MON =            UCD_ADC12_Scaling( 2500,                      0                    ),
        //.HVV_MON =            UCD_ADC12_Scaling( 0.001842,                   0                    ),
        .HVV_MON =            UCD_ADC12_Scaling( 184,                   0                    ),
    }
};

const Uint8 HW_Gains_Count = sizeof(HW_Gains)/sizeof(ADC_GainTable_t);


#if HW_VERSION_DEFAULT > (HW_Gains_Count - 1)
#error "HW_VERSION_DEFAULT must be less than (HW_Gains_Count - 1)"
#endif


















