
#include "cyclone_device.h"
#include "function_definitions.h"

extern Uint32 
    __cinit__,
    __RAM_START__,
    __RAM_END__;

#define BASE_ADDRESS ((Uint32)(&__RAM_START__))
#define END_ADDRESS  ((Uint32)(&__RAM_END__))

#define CINIT_START (__cinit__)

void Ram_Clear(void)
{
    register Uint32 address;
    for (address = BASE_ADDRESS; address < END_ADDRESS; address+=4U)
    {
        *((Uint32*)(address)) = 0U;
    }
}

void cinit_load(void)
{
    register Uint32
        length,
        address,
        ndx;
    register Uint32 data;
    ndx = (Uint32)(&CINIT_START);
    length = *((Uint32*)(ndx));
    while (0U != length)
    {
        ndx += 4U;
        address = *((Uint32*)(ndx));
        ndx += 4U;
        while (4U <= length)
        {
            data = *((Uint32*)(ndx));
            *((Uint32*)(address)) = data;
            address += 4U;
            ndx += 4U;
            length -= 4U;
        }
        while (length != 0U)
        {
            data = *((Uint8*)(ndx));
            *((Uint8*)(address)) = (Uint8)(0xFFU & data);
            address++;
            ndx++;
            length--;
        }
        while (ndx % 4U)
        {
            ndx++;
        }

        length = *((Uint32*)(ndx));
    }
}



