#include "Cyclone_Device.h"     // UCD31xx Headers Include File
#include "variables.h"
#include "system_defines.h"
#include "pmbus_common.h"
#include "pmbus_topology.h"
#include "dcdc_parameters.h"
#include "fault.h"
#include "standard_interrupt.h"
#include "function_definitions.h"

extern void Disable_Converter(void);
Uint16 Global_Fault_Reg = 0U;

#define FAULT_RETRY				(0U)
Uint16 Fault_Retry_Counter = 0U;

#define VOUT_OV_FAULT_COUNT     (5U)
#define VOUT_UV_FAULT_COUNT     (5U)
#define VIN_OV_FAULT_COUNT     (5U)
#define VIN_UV_FAULT_COUNT     (5U)
Uint16 VOUT_OV_counter = 0U;
Uint16 VOUT_UV_counter = 0U;
Uint16 VIN_OV_counter = 0U;
Uint16 VIN_UV_counter = 0U;

#define FAULT_AUTO_CLEAR		(1U)
#define BATT_LOSS_ON_OV			(0U)

typedef Uint8 (*FaultCheck_d)(void);
typedef int (*FaultTrigger_d)(void);
typedef struct FaultTableEntry_
{
	const FaultCheck_d FaultCheck;
	const FaultTrigger_d FaultTrigger;
	const Uint16 StatusMask;
	const Uint16 FaultRegisterMask;
	const Uint8 AutoClear;
} FaultTableEntry_t;

Uint8 GateDrive_Check(void);
Uint8 InputOV_Check(void);
Uint8 InputUV_Check(void);
Uint8 OutputOV_Check(void);
Uint8 OutputUV_Check(void);

int Generic_FaultTrigger(void);
int OutputOV_FaultTrigger(void);

void (*const vReset)(void) = (void*)(0x20U);
Uint8 GDF_Read = 0U;

const FaultTableEntry_t FaultTable[] = 
{
	{	GateDrive_Check,		Generic_FaultTrigger,		PMBUS_STATUS_WORD_GATEDRIVER,		GLOBAL_FAULT_GATEDRIVER,			0U,		},
	{	InputOV_Check,			Generic_FaultTrigger,		PMBUS_STATUS_WORD_VIN_OV,			GLOBAL_FAULT_VIN_OVERVOLTAGE,		1U,		},
	{	InputUV_Check,			Generic_FaultTrigger,		PMBUS_STATUS_WORD_VIN_UV,			GLOBAL_FAULT_VIN_UNDERVOLTAGE,		1U,		},
	{	OutputOV_Check,			OutputOV_FaultTrigger,		PMBUS_STATUS_WORD_VOUT_OV,			GLOBAL_FAULT_VOUT_OV,				0U,		},
	{	OutputUV_Check,			Generic_FaultTrigger,		PMBUS_STATUS_WORD_BATT_LOST,		GLOBAL_FAULT_NO_BATT,				0U,		},
};
const Uint32 FaultTable_Count = sizeof(FaultTable)/sizeof(FaultTableEntry_t);

// Clearing fault flags inside DPWM module by turning it off and On
void clear_dpwm_faults(void)
{
 LoopMuxRegs.GLBEN.all &= 0xFFFC;//Disable all DPWMs
 LoopMuxRegs.GLBEN.all |= 0x0003;//Enable all DPWMs 
}

void handle_warnings(void)
{
	if(OVOUT_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_VOUT | PMBUS_STATUS_WORD_HIGH_BYTE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
	if(UVOUT_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_VOUT | PMBUS_STATUS_WORD_HIGH_BYTE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
	if(OCOUT_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_IOUT | PMBUS_STATUS_WORD_IOUT_OC | PMBUS_STATUS_WORD_HIGH_BYTE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
	if(OT_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_TEMPERATURE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
	if(OVVIN_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_INPUT | PMBUS_STATUS_WORD_HIGH_BYTE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
	if(UVVIN_WARN)
	{
		//pmbus_status_word |= PMBUS_STATUS_WORD_INPUT | PMBUS_STATUS_WORD_HIGH_BYTE;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 1;  //Set SMBus alert ( Pull the pin down)
	}
}

Uint8 GateDrive_Check(void)
{
    //return 0;
	CHECK_GATEDRIVER();
	static Uint64 timeout = 0U, delay = 0U;
	static Uint8 trig = 0U;
	if (GateDriveFault != 0)
	{ 
		if (0U == trig) 
		{
			trig = 1U;
			timeout = RTC_ms;
			GDF_Read = 0U;
		}
		else if (1U == trig)
		{
			if ((0U != GDF_Read)||((RTC_ms - timeout) > 200U))
			{
				delay = RTC_ms;
				trig = 2U;
			}
		}
		else
		{
			if (((RTC_ms - delay) > 10U))
			{
				watchdog_disable();
				vReset();

			    //if(GioRegs.FAULTIN.bit.FLT2_IN)
			    //{
			    //    GateDriveFault=0;
			    //    Disable_Converter();
			    //}
			}
		}
	}
	else 
	{
		if (0U != trig)
		{
			trig = 0U;
		}
	}
	
	return (GateDriveFault != 0);
}

Uint8 InputOV_Check(void)
{
    Uint8 ans = 0U;
    if(INPUT_OVER_VOLTAGE_FAULT)
    {
        if(++VIN_OV_counter>VIN_OV_FAULT_COUNT)
        {
            ans=1;
        }
    }
    else
    {
        if(VIN_OV_counter)
        {
            VIN_OV_counter--;
        }
    }
	return ans;
}

Uint8 InputUV_Check(void)
{
    Uint8 ans = 0U;
	if(INPUT_UNDER_VOLTAGE_FAULT)
	{
        if(++VIN_UV_counter>VIN_UV_FAULT_COUNT)
        {
            ans=1;
        }
    }
    else
    {
        if(VIN_UV_counter)
        {
            VIN_UV_counter--;
        }

	}
	return ans;
}

Uint8 OutputOV_Check(void)
{
    Uint8 ans = 0U;
    if ((OUTPUT_OVER_VOLTAGE_FAULT))    //||(OUTPUT_OVER_VOLTAGE_HARD_FAULT)): this is unnecessary, since if OUTPUT_OVER_VOLTAGE_HARD_FAULT is TRUE, OUTPUT_OVER_VOLTAGE_FAULT must be true.
    {
        if(OUTPUT_OVER_VOLTAGE_HARD_FAULT)
        {
            VOUT_OV_counter +=3;        //if voltage >18V, count up by 3; to set the fault flag immediately, count up by VOUT_OV_FAULT_COUNT
        }
        else
        {
            VOUT_OV_counter++;          //otherwise, count by 1
        }
        #if BATT_LOSS_ON_OV
        if (!BatteryLost)
        {
            BattLoss_Action();
        }
        #endif

        if ((VOUT_OV_FAULT_COUNT < VOUT_OV_counter))
        {
                VOUT_OV_counter = VOUT_OV_FAULT_COUNT;
                ans = 1U;
        }
    }
    else                        //no fault detected, count down
    {
        if(VOUT_OV_counter>0)
        {
            VOUT_OV_counter--;
        }
    }
    return ans;
}

Uint8 OutputUV_Check(void)
{
    Uint8 ans=0;
    if(NO_12V_BATT_FAULT)       //voltage below 9V, fault;
    {
        VOUT_UV_counter++;
        if(VOUT_UV_counter>VOUT_UV_FAULT_COUNT)
        {
            VOUT_UV_counter=VOUT_UV_FAULT_COUNT;
            ans=1U;
        }

    }
    else        //voltage >9V, no fault;
    {
        if(VOUT_UV_counter>0)
        {
            VOUT_UV_counter--;
        }
    }
    return ans;

}
int Generic_FaultTrigger(void)
{
	int ans = 1;
	//VOUT_OV_counter = VOUT_OV_FAULT_COUNT;

    MiscAnalogRegs.GLBIOEN.all |=0xf;
	supply_state = STATE_DISABLED;
	ans = 0;
	return ans;
}

int OutputOV_FaultTrigger(void)
{
	int ans = 1;
	#if BATT_LOSS_ON_OV
	if (!BatteryLost)
	{
		BattLoss_Action();
		VOUT_OV_counter = 0U;
	}
	else
	#endif
	{
		if(VOUT_OV_counter >= VOUT_OV_FAULT_COUNT)
		{

            //MiscAnalogRegs.GLBIOEN.bit.DPWM0A_IO_EN = 1;
            //MiscAnalogRegs.GLBIOEN.bit.DPWM0B_IO_EN = 1;
            //MiscAnalogRegs.GLBIOEN.bit.DPWM1A_IO_EN = 1;
            //MiscAnalogRegs.GLBIOEN.bit.DPWM1B_IO_EN = 1;
            MiscAnalogRegs.GLBIOEN.all |=0xf;
            supply_state = STATE_DISABLED;
            ans = 0;
		}
	}
	return ans;
}


void kill_supply_quick(void)
{
//	Dpwm3Regs.DPWMINT.bit.PRD_INT_EN = 0;
	MiscAnalogRegs.GLBIOEN.all |= 0xFF;
	supply_state = STATE_DISABLED;

}


int fault_handler(void)
{
	//Poll DPWM for fault status and then poll comparator interrupt status registers
	//dpwm_fault_status =1;// |= (Dpwm0Regs.DPWMFLTSTAT.all & DPWM_FAULT_AB_STATUS_MASK);
	//fault_status |= (FaultMuxRegs.FAULTMUXINTSTAT.all & COMP_INT_STATUS_MASK);
	if(RTC_ms<100)
	{
	    return 1;
	}

	Uint32 ndx = 0;
	int return_value = 1;

	for (ndx = 0U; ndx < FaultTable_Count; ndx++)
	{
		if (FaultTable[ndx].FaultCheck())
		{
			return_value = FaultTable[ndx].FaultTrigger();
			if (FAULT_RETRY > Fault_Retry_Counter)
			{
				Fault_Retry_Counter++;
			}
			else
			{
				Fault_Retry_Counter = 0U;
				Global_Fault_Reg  |= FaultTable[ndx].FaultRegisterMask;
				pmbus_status_word |= FaultTable[ndx].StatusMask;
				PSON = 0;
			}
		}
		else
		{
#if FAULT_AUTO_CLEAR
			if (FaultTable[ndx].AutoClear)
			{
				Global_Fault_Reg  &= UINT16_MAX ^ (FaultTable[ndx].FaultRegisterMask);
			}
#endif
			pmbus_status_word &= UINT16_MAX ^ (FaultTable[ndx].StatusMask);
		}
	}

// Kamal - what is this for???
	if(return_value)
	{

		pmbus_status_word = 0;
        // PMBusRegs.PMBCTRL3.bit.ALERT_EN = 0; 
		MiscAnalogRegs.GLBIOVAL.all &= ~MASK_FAILURE;
		MiscAnalogRegs.GLBIOVAL.all |= (MASK_PGOOD|MASK_VINOK);
		//MiscAnalogRegs.GLBIOVAL.all |= MASK_VINOK;
		// PMBusRegs.PMBCTRL3.bit.ALERT_EN = 0;

	}

	if(PSON==0)
	{

		//MiscAnalogRegs.GLBIOEN.bit.DPWM0A_IO_EN = 1;
		//MiscAnalogRegs.GLBIOEN.bit.DPWM0B_IO_EN = 1;
		//MiscAnalogRegs.GLBIOEN.bit.DPWM1A_IO_EN = 1;
		//MiscAnalogRegs.GLBIOEN.bit.DPWM1B_IO_EN = 1;
        MiscAnalogRegs.GLBIOEN.all |=0xf;
		pmbus_status_word |= PMBUS_STATUS_WORD_DISABLED | PMBUS_STATUS_WORD_OFF;
		supply_state = STATE_DISABLED;
		//PSON = 0;
		FeCtrl1Regs.EADCDAC.bit.DAC_VALUE =0;
		FeCtrl0Regs.EADCDAC.bit.DAC_VALUE =0;
		//PMBusRegs.PMBCTRL3.bit.ALERT_EN = 0;
		clear_dpwm_faults();
		//fault_status = 0;
		//power_supply_fault = 0;
		pmbus_status_word |= PMBUS_STATUS_WORD_OFF;
		return_value =0;

	}

	//If at the end of checking all the faults and there are no errors - 
	//and a new PSON Command has been received - Reset the Fault Register
	//if(PSON)
	else
	{
		Global_Fault_Reg = 0;
		pmbus_status_word &= UINT16_MAX ^ (PMBUS_STATUS_WORD_OFF);
	}


//**********************************************************************
//12V Batt Lost during operation
//**********************************************************************
    if(BatteryLost) 
	{
    	Global_Fault_Reg  |= GLOBAL_FAULT_BATT_DETACHED;
		pmbus_status_word |= PMBUS_STATUS_WORD_BATT_LOST;
	}
#if FAULT_AUTO_CLEAR
	else
	{
    	Global_Fault_Reg  &= UINT16_MAX ^ (GLOBAL_FAULT_BATT_DETACHED);
		pmbus_status_word &= UINT16_MAX ^ (PMBUS_STATUS_WORD_POWERSUPPLY | PMBUS_STATUS_WORD_BATT_LOST);
	}
#endif

	return return_value;
}





