

#ifndef FAULT_H_
#define FAULT_H_


#include <stdint.h>

#include "cyclone_device.h"
#include "variables.h"


#define ABORT() \
    do {\
        Dpwm0Regs.DPWMCTRL0.bit.PWM_EN = 0;\
        Dpwm1Regs.DPWMCTRL0.bit.PWM_EN = 0;\
        MiscAnalogRegs.GLBIOEN.all |=0xf;\
    } while(0)

#define CHECK_GATEDRIVER() \
    do {\
        if ((0U == GioRegs.FAULTIN.bit.FLT2_IN))\
        {\
            ABORT();\
            GateDriveFault = 1;\
        }\
        else if (0U != GateDriveFault)\
        {\
            GateDriveFault = 0;\
        }\
    } while(0)

extern void (*const vReset)(void);

extern Uint8 GDF_Read;

extern Uint16 Global_Fault_Reg;		// Global Fault Register

extern Uint16 Fault_Retry_Counter;











































#endif /* #ifndef FAULT_H_ */











