#include "system_defines.h"
#include "pmbus_commands.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"
#include "cyclone_defines.h"

void init_gpio(void)
{
                      
#ifdef UCD3138128
#elif UCD3138A64
#elif UCD3138
	// enable JTAG
	MiscAnalogRegs.IOMUX.all = 0;
	MiscAnalogRegs.IOMUX.bit.JTAG_DATA_MUX_SEL = 1;  // Accommodate TDO/TDI pins for RXD/TXD use      //KP Changed this from 1 to 0 to enable ROM for Jtag debugging
	MiscAnalogRegs.IOMUX.bit.UART_MUX_SEL = 0;
#elif UCD3138064
    MiscAnalogRegs.IOMUX.bit.JTAG_DATA_MUX_SEL = 0;  // Accommodate TDO/TDI pins for RXD/TXD use     //KP Changed this from 2 to 0 to enable ROM for Jtag debugging
	MiscAnalogRegs.IOMUX.bit.UART_MUX_SEL = 0;
#endif
	//MiscAnalogRegs.GLBIOVAL.bit.FAULT2_IO_VALUE =0;  //debug state


	// Set outputs to 0.
	MiscAnalogRegs.GLBIOVAL.all = 0;
	// 1 - Output, 0 - Input
	MiscAnalogRegs.GLBIOOE.all = MASK_PGOOD | MASK_FAILURE | MASK_VINOK |
								 DPWM0A_GLBIO_BIT_MASK | DPWM0B_GLBIO_BIT_MASK |
								 DPWM1A_GLBIO_BIT_MASK | DPWM1B_GLBIO_BIT_MASK | 
								 DPWM2A_GLBIO_BIT_MASK | DPWM2B_GLBIO_BIT_MASK | 
								 DPWM3A_GLBIO_BIT_MASK | DPWM3B_GLBIO_BIT_MASK;

	MiscAnalogRegs.GLBIOEN.all = MASK_PGOOD | MASK_FAILURE | MASK_VINOK |
								 CONTROL_GLBIO_BIT_MASK;

	/*MiscAnalogRegs.GLBIOEN.bit.PMBUS_CLK_IO_EN = 1;
	MiscAnalogRegs.GLBIOOE.bit.PMBUS_CLK_IO_OE = 0;

	MiscAnalogRegs.GLBIOEN.bit.PMBUS_DATA_IO_EN = 1;
	MiscAnalogRegs.GLBIOOE.bit.PMBUS_DATA_IO_OE = 0;*/


	//MiscAnalogRegs.GLBIOOE.bit.FAULT2_IO_OE = 0; // Set Fault 2 as input pin



}

void gpio_sr_on(void)
{
	MiscAnalogRegs.GLBIOEN.all &= ~((Uint32)(DPWM0B_GLBIO_BIT_MASK | DPWM1B_GLBIO_BIT_MASK|
                                        	 DPWM2B_GLBIO_BIT_MASK | DPWM3B_GLBIO_BIT_MASK));
}

void gpio_sr_off(void)
{
	MiscAnalogRegs.GLBIOEN.all |=  ((Uint32)(DPWM0B_GLBIO_BIT_MASK | DPWM1B_GLBIO_BIT_MASK|
	                                         DPWM2B_GLBIO_BIT_MASK | DPWM3B_GLBIO_BIT_MASK));
}

void gpio_dpwm_on(void)
{
	MiscAnalogRegs.GLBIOEN.all &= ~((Uint32)(DPWM0A_GLBIO_BIT_MASK | DPWM0B_GLBIO_BIT_MASK|
								 	 		 DPWM1A_GLBIO_BIT_MASK | DPWM1B_GLBIO_BIT_MASK|
											 DPWM2A_GLBIO_BIT_MASK | DPWM2B_GLBIO_BIT_MASK|
											 DPWM3A_GLBIO_BIT_MASK | DPWM3B_GLBIO_BIT_MASK));
}

void gpio_dpwm_off(void)
{
	MiscAnalogRegs.GLBIOEN.all |=  ((Uint32)(DPWM0A_GLBIO_BIT_MASK | DPWM0B_GLBIO_BIT_MASK|
								 		     DPWM1A_GLBIO_BIT_MASK | DPWM1B_GLBIO_BIT_MASK|
											 DPWM2A_GLBIO_BIT_MASK | DPWM2B_GLBIO_BIT_MASK|
											 DPWM3A_GLBIO_BIT_MASK | DPWM3B_GLBIO_BIT_MASK));
}
