#include "system_defines.h"
#include "Cyclone_Device.h"
#include "pmbus_commands.h"
#include "variables.h"
#include "function_definitions.h"
#include "software_interrupts.h"






void init_front_end0(void)
{
  FeCtrl0Regs.RAMPCYCLE.bit.SWITCH_CYC_PER_STEP = 0;// every switching cycles pre DAC step
  FeCtrl0Regs.RAMPCTRL.bit.RAMP_EN = 1; // Ramp by Hradware
  FeCtrl0Regs.RAMPCTRL.bit.SYNC_FET_RAMP_START = 0; // default, start sync-FET at zero 
  FeCtrl0Regs.EADCDAC.bit.DAC_DITHER_EN = 0;// default, Disable dithering
//  FeCtrl0Regs.RAMPDACEND.bit.RAMP_DAC_VALUE = 12000; // 0.09765625 mV/Count
  FeCtrl0Regs.EADCDAC.bit.DAC_VALUE = 0; // Start point for ramp-up
//  FeCtrl0Regs.DACSTEP.bit.DAC_STEP = 1024;//  increment by 0.096mV per step. Getting ramp up time at 60ms

  FeCtrl0Regs.RAMPCTRL.bit.RAMP_SAT_EN = 0; //Ramp Saturation
  FeCtrl0Regs.RAMPCYCLE.bit.DELAY_CYCLES = 0;


  FeCtrl0Regs.EADCCTRL.bit.AFE_GAIN = 3;// Gain X8
  FeCtrl0Regs.EADCCTRL.bit.EADC_MODE = 0;//continuous mode
  FeCtrl0Regs.EADCCTRL.bit.SCFE_GAIN_FILTER_SEL = 1;//Switched Cap Noise Filter Enable
  FeCtrl0Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 0 ;//Switched Cap Front End Clock Divider Select
  FeCtrl0Regs.EADCCTRL.bit.SCFE_ENA = 1;//Switch Cap Front Enable
  FeCtrl0Regs.EADCCTRL.bit.EADC_ENA = 1;//EADC Enable
}




void init_front_end1(void)
{
  FeCtrl1Regs.EADCDAC.bit.DAC_DITHER_EN = 0;// default, Disable dithering
  FeCtrl1Regs.EADCDAC.bit.DAC_VALUE = 00; // Start point for ramp-up


  FeCtrl1Regs.EADCCTRL.bit.AFE_GAIN = 3;// Gain X8
  FeCtrl1Regs.EADCCTRL.bit.EADC_MODE = 0;//?
  FeCtrl1Regs.EADCCTRL.bit.AVG_MODE_SEL=1;
  FeCtrl1Regs.EADCCTRL.bit.SCFE_GAIN_FILTER_SEL = 1;//
  FeCtrl1Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 0 ;//?
  FeCtrl1Regs.EADCCTRL.bit.SCFE_ENA = 1;//
  FeCtrl1Regs.EADCCTRL.bit.EADC_ENA = 1;
  
}


////////////////////////////////////////////////////////////////
//
// Used for feed forward Vin sensing   (EADC2(FE2))
/////////////////////////////////////////////////////////////////

void init_front_end2(void)

{

    FeCtrl2Regs.EADCDAC.bit.DAC_DITHER_EN = 0;// Disable dithering
    FeCtrl2Regs.EADCDAC.bit.DAC_VALUE = 7000; // (70/193.55)*1.6 Volts //4000 for primary side 20V
    FeCtrl2Regs.EADCCTRL.bit.AFE_GAIN = 0;// Gain X1
    FeCtrl2Regs.EADCCTRL.bit.EADC_MODE = 0;//
    FeCtrl2Regs.EADCCTRL.bit.SCFE_GAIN_FILTER_SEL = 0;// For faster signal acquisition
    FeCtrl2Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 1 ;     // For faster conversion
    FeCtrl2Regs.EADCCTRL.bit.SCFE_ENA = 1;//
    FeCtrl2Regs.EADCCTRL.bit.EADC_ENA = 1;
}


void init_fe1_sar(void)
{
  FeCtrl1Regs.EADCCTRL.bit.AFE_GAIN       = 0;
  // Use 8MHz sampling frequency for Error EADC in SAR mode
  FeCtrl1Regs.EADCCTRL.bit.SCFE_CLK_DIV_2 = 0;
  // Initialize EADC counter to synchronize with SAR mode and MCLK
  FeCtrl1Regs.EADCCTRL.bit.SCFE_CNT_INIT  = 0xD;
  // Set Front End in Non-Continuous Mode
  FeCtrl1Regs.EADCCTRL.bit.EADC_MODE      = 2;
  // Set Processor DAC to MAX_CURRENT value for Error calculation
  FeCtrl1Regs.EADCDAC.bit.DAC_VALUE       = 3100; //(int)((0.3 / 1.6 * ((1 << 10) - 1))*16);
  // Configure SAR Parameters for starting AFE Gain of 0 and Final Gain of 3
  FeCtrl1Regs.SARCTRL.bit.EADC_WINDOW_1        = 0x4D;
  FeCtrl1Regs.SARCTRL.bit.EADC_WINDOW_2        = 0x2D;
  FeCtrl1Regs.SARCTRL.bit.SAR_RANGE            = 16; //0x20;
  FeCtrl1Regs.SARCTRL.bit.SAR_RESOLUTION       = 1; //0x2;
}
 


void init_prebias(void)
{
	FeCtrl0Regs.PREBIASCTRL0.bit.PRE_BIAS_EN=0;
	FeCtrl0Regs.PREBIASCTRL0.bit.PRE_BIAS_LIMIT = 10; //10 samples to claim the prebias is done;
	FeCtrl0Regs.PREBIASCTRL0.bit.PRE_BIAS_POL=0;
	FeCtrl0Regs.PREBIASCTRL0.bit.PRE_BIAS_RANGE =10;
	FeCtrl0Regs.PREBIASCTRL1.bit.MAX_DAC_ADJ =0xFFF;
	FeCtrl0Regs.PREBIASCTRL1.bit.SAMPLES_PER_ADJ =10;
}


