
#include "cyclone_device.h"
#include "led.h"
#include "variables.h"




void LED_Init(void)
{
    PMBusRegs.PMBCTRL3.bit.ALERT_DIR = 0U;
    PMBusRegs.PMBCTRL3.bit.ALERT_MODE = 0U;

    PMBusRegs.PMBCTRL3.bit.CNTL_DIR = 0U;
    PMBusRegs.PMBCTRL3.bit.CNTL_MODE = 0U;

    GioRegs.FAULTDIR.bit.TMS_DIR = 1U;
}

void LED_Set_All(Uint8 VMode_State, Uint8 CMode_State, Uint8 Error_State)
{
    LED_Set_VMode(VMode_State);
    LED_Set_CMode(CMode_State);
    LED_Set_Error(Error_State);
}

void LED_Set_VMode(Uint8 State)
{
    PMBusRegs.PMBCTRL3.bit.ALERT_VALUE = (0U != State);
}

void LED_Set_CMode(Uint8 State)
{
    PMBusRegs.PMBCTRL3.bit.CNTL_VALUE = (0U != State);
}

void LED_Set_Error(Uint8 State)
{
    GioRegs.FAULTOUT.bit.TMS_OUT = (0U != State);
}




