#include "Cyclone_Device.h"     // UCD30xx Headers Include File
#include "software_interrupts.h"
#include "system_defines.h"
#include "variables.h"

void init_uart0(void)
{
	volatile Uint32 rx_byte0; //volatile to make warning go away about set but not read

	Uart0Regs.UARTCTRL3.bit.SW_RESET = 0; //software reset while initializing UART

	Uart0Regs.UARTCTRL0.bit.DATA_SIZE = 7; //8 bits
	Uart0Regs.UARTCTRL0.bit.STOP = 1; //2 stop bits
	Uart0Regs.UARTCTRL0.bit.SYNC_MODE = 1; //asynchronous mode

	Uart0Regs.UARTHBAUD.all = 0;
	Uart0Regs.UARTMBAUD.all = 0;
	Uart0Regs.UARTLBAUD.all = 50;  //for 38400 //47 for control board, 44 for open loop

	Uart0Regs.UARTRXST.bit.RX_ENA = 1 ;//enable RX

	Uart0Regs.UARTTXST.bit.TX_ENA = 1;//enable TX

	Uart0Regs.UARTINTST.all = 0xff;  //these two statements are supposed to clear the status bits
	Uart0Regs.UARTINTST.all = 0;

	rx_byte0 = Uart0Regs.UARTRXBUF.all; //clear RXRDY flag

	Uart0Regs.UARTIOCTRLTX.bit.IO_FUNC = 1; //enable transmit pin
	Uart0Regs.UARTIOCTRLRX.bit.IO_FUNC = 1; //enable receive pin

	Uart0Regs.UARTCTRL3.bit.CLOCK = 1; //internal clock select;
	Uart0Regs.UARTCTRL3.bit.SW_RESET = 1; //software reset released UART init done?

	Uart0Regs.UARTIOCTRLSCLK.bit.IO_FUNC = 0; //disable external clock for UART.

	Uart0Regs.UARTTXBUF.all = '\n'; //put out a byte to get things started.
}

void init_uart1(void)
{
	volatile Uint32 rx_byte1; //volatile to make warning go away about set but not read

	Uart1Regs.UARTCTRL3.bit.SW_RESET = 0; //software reset while initializing UART

	Uart1Regs.UARTCTRL0.bit.DATA_SIZE = 7; //8 bits
	Uart1Regs.UARTCTRL0.bit.STOP = 1; //2 stop bits
	Uart1Regs.UARTCTRL0.bit.SYNC_MODE = 1; //asynchronous mode

	Uart1Regs.UARTHBAUD.all = 0;
	Uart1Regs.UARTMBAUD.all = 0;
	Uart1Regs.UARTLBAUD.all = 50;  //for 38400 //47 for control board, 44 for open loop

	Uart1Regs.UARTRXST.bit.RX_ENA = 1 ;//enable RX

	Uart1Regs.UARTTXST.bit.TX_ENA = 1;//enable TX

	Uart1Regs.UARTINTST.all = 0xff;  //these two statements are supposed to clear the status bits
	Uart1Regs.UARTINTST.all = 0;

	rx_byte1 = Uart1Regs.UARTRXBUF.all; //clear RXRDY flag

	Uart1Regs.UARTIOCTRLTX.bit.IO_FUNC = 1; //enable transmit pin
	Uart1Regs.UARTIOCTRLRX.bit.IO_FUNC = 1; //enable receive pin

	Uart1Regs.UARTCTRL3.bit.CLOCK = 1; //internal clock select;
	Uart1Regs.UARTCTRL3.bit.SW_RESET = 1; //software reset released UART init done?

	Uart1Regs.UARTIOCTRLSCLK.bit.IO_FUNC = 0; //disable external clock for UART.

	Uart1Regs.UARTTXBUF.all = '\n'; //put out a byte to get things started.
}

char translate_nybble_out(char byte,char * pchar2 )
{
	char char1;
	char1 = (byte & 0xf0) >> 4;
	*pchar2 = (byte & 0x0f);
	if (char1 < 10)
	{
		char1 +='0';
	}else if ((char1 >= 0xa) && (char1 <= 0xf))
	{
		char1 = char1 + 'a' - 10;
	}
	if (*pchar2 < 10)
	{
		*pchar2 +='0';
	}else if ((*pchar2 >= 0xa) && (*pchar2 <= 0xf))
	{
		*pchar2 = *pchar2 + 'a' - 10;
	}
	return char1;
}





void char_out(char data)
{
	while(Uart0Regs.UARTTXST.bit.TX_RDY == 0)
	{
		//do nothing while waiting for data to transmit.
	}
	Uart0Regs.UARTTXBUF.all = data; //put out a byte
}

