

#ifndef VARIABLES_H
#define VARIABLES_H



#include "system_defines.h"
#include "stdint.h"

typedef void (*FUNC_PTR)(); 	//used for zeroing instruction word.

/*

IOUT_SNS   		     --	Output Current	--	AD01
DCDC_V_SNS_SCALED	 --	Output Voltage	--	AD02
Vout_Prot		     --	Output Voltage	--	AD03  -- Ignore for now
LV_BATT_MON		     --	Batt Current 	--	AD04
HV_BATT_I_SNS_DDC	 --	HV Batt Current --	AD06
HV_BATT_V_SNS_DDC	 --	HV Batt Voltage --	AD13  -- Possible Can be used as the Primary Side Voltage Sensing
*/

#ifdef HD_OBC_DCDC_CODE
typedef struct
{
	unsigned int address;		//Value from adc for device address
	unsigned int Iout; 		// IOUT_SNS   		 --	Output Current	--	AD01
	unsigned int Vout; 		// DCDC_V_SNS_SCALED --	Output Voltage	--	AD02
	unsigned int Vout_Prot; // LVDC_OV_MON		 --	Output Voltage	--	AD03
	unsigned int Ibatt; 	// LV_BATT_I_N		 --	Batt Current 	--	AD04
	unsigned int HV_battI;	// HV_BATT_I_MON_DDC --	HV Batt Current --	AD06
	unsigned int Vin; 		// HV_BATT_V_MON_DDC --	Input Voltage   --	AD13
	unsigned int Vin_fast;
	unsigned int srdet2;
	unsigned int current_temp;
	unsigned int isec;
	unsigned int temp_sense;// LV_DCDC_TEMP_SNS  --	MOSFET TEMP SES	--	AD00
	unsigned int Vout_fast;
	unsigned int Ibatt_fast;
	unsigned int Iout_fast;
} ADC_VALUES_STRUCT;

typedef struct
{
	 int address;		//Value from adc for device address
	 int Iout; 			//IOUT_SNS   		 --	Output Current	--	AD01
	 int Vout; 			//DCDC_V_SNS_SCALED	 --	Output Voltage	--	AD02
	 int Vout_Prot; 	//Vout_Prot		     --	Output Voltage	--	AD03  -- Ignore for now
	 int Ibatt; 		//LV_BATT_MON		 --	Batt Current 	--	AD04
	 int HV_battI;		//HV_BATT_I_SNS_DDC	 --	HV Batt Current --	AD06
	 int Vin; 			//HV_BATT_V_SNS_DDC	 --	HV Batt Voltage --	AD13  -- Possible Can be used as the Primary Side Voltage Sensing
	 int srdet2; 		//Value from adc for SR fb2
	 int current_temp;	//Value from adc for SR MOSFET temperature
	 int isec; 			//Value from adc for Iout
	 int temp_sense;			//Value from adc for internal device temperature
} ADC_VALUES_NORM;

#else
typedef struct  
{
	unsigned int address;	//Value from adc for device address
	unsigned int vin; 	//Value from adc for Vin 
	unsigned int ishare; 	//Value from adc for Ishare
	unsigned int Vout; 	//Value from adc for Vout
	unsigned int i_pri; 		//Value from adc for primary current sense
	unsigned int vo_ovp; 
	unsigned int srdet1; 	//Value from adc for SR fb1
	unsigned int srdet2; 	//Value from adc for SR fb2
	unsigned int current_temp;		//Value from adc for SR MOSFET temperature
	unsigned int isec; 	//Value from adc for Iout
	Uint32 temp_sense;		//Value from adc for internal device temperature
} ADC_VALUES_STRUCT;

#endif


typedef enum 
{
#ifdef CONTROL_STATE
#undef CONTROL_STATE
#endif
#define CONTROL_STATE(x,y) x,
#include "control_states.def"
#undef CONTROL_STATE
} SUPPLY_STATE;


extern SUPPLY_STATE supply_state;
extern int Enable_OpenLoop;  // comment for hyperknob [min=0, max=1, step=1]
extern int GateDriveFault;
extern int BlankFault;
extern int FaultReset;   // comment for hyperknob [min=0, max=1, step=1]
extern int FaultBlanking;
extern Uint16 BatteryLost; 				//Battery Disconnected While in Operation

extern Uint8 PSON; //Power Supply On
extern Uint8 PREVIOUS_PSON;

extern Uint16 hw_version;

extern int ramp_complete;				//Value stored in FeCtrl0Regs.RAMPSTAT.bit.RAMP_COMP_INT_STATUS
extern ADC_VALUES_STRUCT adc_values; 	//ADC Readings
extern ADC_VALUES_NORM adc_values_norm;
extern volatile ADC_VALUES_STRUCT adc_average;
extern int vin_eadc_sns;


extern Uint8 erase_segment_counter;	// Number of DFlash segment remaining to be erased
extern Uint8 erase_segment_number;		// DFlash segment number being erased
extern Uint8 flash_write_status;	// Global status while attempting to write to Data Flash.


extern signed int 	v_input_error;
extern signed int 	v_input_error_average;
extern signed int   v_input_delta;

extern Uint16 temp_value;
extern Uint8 temp_exp;
extern Uint16 temp_man;

extern Uint32 fault_status;

struct qnote
{
  int16 mantissa;
  int16 exponent;
};


extern struct qnote temp_qnote1;
extern struct qnote temp_qnote_scale1;
extern int16 temp_qnote_value1;
extern Uint32 rogue_errors;

//extern Uint32 cpstat;
//extern Uint32 cpstat1;
extern int32 current_share_int_state; 
extern int32 current_share_control_effort;
extern int16 current_share_kp;
extern int16 current_share_ki;
extern int32 error_zero;
extern int32 local_error;

extern Uint32 output_current_cal_ishare_ave;
extern Uint32 output_current_cal_ave;
extern Uint32 battery_current_cal_ave;
extern Uint32 output_current_cal;
extern Uint32 battery_current_cal;
extern int32 instant_resistance_positive;
extern int32 adc_count_factor_positive;
extern int32 instant_resistance_negative;
extern int32 adc_count_factor_negative;
extern int32 iout_comp_thresh;
extern int32 ipri_cbc_limit;

extern int32 ishare_threshold_master_enable;
extern int32 ishare_threshold_slave_enable;
extern int32 master_state;
extern int32 master_time_count;
extern int32 master_time_limit;
extern Uint32 current_x16;
extern int average_counter;
//extern Uint32 VoutCommand;
extern int timer_interrupt_temporary_1; // EADCDAC Set Point [min=0, max=16000, step=1]
extern int ram_eadcdac; // EADCDAC Set Point [min=0, max=16383, step=256]
extern Uint16 filtered_vin;

extern Uint32 pnom_value;
extern Uint32 dpwm_fault_status;
extern int power_supply_fault;
extern int vloop_filter;
extern int iloop_filter;
extern Uint16 cc_flag;
extern Uint32 cc_counter;
extern Uint32 restart_counter;
extern Uint32 vloop_filter_test1;
extern Uint32 vloop_filter_test2;
extern Uint32 vloop_filter_test3;

extern int return_value;


extern struct qnote constant_145_211;  
extern struct qnote constant_58_4902;  
extern struct qnote constant_511_188;  
extern struct qnote constant_7_90527; 
extern struct qnote constant_19_1631; 


extern Uint32 vari_watch;

extern Uint64 RTC_ms;


extern Uint32 pout;
extern int32 vout_mV;
extern int32 vout_mV_fast;
extern Uint32 vout_filtered;
extern Uint32 vout_raw_filtered;
extern  int32 iout_mA;
extern  int32 iout_mA_fast;
extern  int32 ibatt_mA;
extern  int32 ibatt_mA_fast;
extern	Uint32 imax_value;
extern	Uint32 vnom_value;
extern	Uint32 inom_value;
extern  const int32_t iout_max;
extern struct qnote pcmd;
extern Uint8 cpcc_on;

extern int VoutPreset;


extern Uint16 freq_linear11;
extern Uint32 peroid_new; 
extern Uint32 peroid_old;
extern Uint8 NoFault;
extern Uint8 adcCompleted;
extern uint16_t ISet_mA;
extern int32_t dac_ibat_offset_digits;
extern uint32_t batRes;
#endif


