<?xml version="1.0" encoding="utf-8" standalone="no" ?>
<!-- 
Cadence Design Systems (C) COPYRIGHT, Cadence Design Systems, Inc. 1999-2016 
All Rights Reserved
Licensed Materials - Property of Cadence Design Systems

No part of this file may be reproduced, stored in a retrieval system,
or transmitted in any form or by any means electronic, mechanical,
photocopying, recording, or otherwise without prior written permission 
of Cadence Design Systems, Inc.


WARRANTY:
Use all material in this file at your own risk.  Cadence Design Systems
makes no claims about any material contained in this file. 
-->
<cft:root xmlns:cft="http://www.cadence.com/xsd/cft" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.cadence.com/xsd/cft schemas/cfgFile.xsd">
  <cft:xml Name="dictionary">
    <root xmlns="http://www.cadence.com/xsd/dictionary" xsi:schemaLocation="http://www.cadence.com/xsd/dictionary schemas/dictionary.xsd"  Version="17.0">
      <attribute Name="PULSE_PARAM_FREQ" Description="Nets switch frequency">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uFrequency" Name="MHz"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_PERIOD" Description="Clock period">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <range Min="0"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_DUTY_CYCLE" Description="Clock duty cycle expressed as a percentage for the time High">
        <value Kind="Property" Type="Percentage">
          <data Type="Scalar" Storage="Integer"/>
          <units Type="uPercentage" Name="%"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_JITTER" Description="Amount of clock jitter expressed as an absolute value">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ps"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_MEASURE_CYCLE" Description="Clock cycle for measuring during simulation">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_COFF" Description="Amount of clock jitter expressed as an absolute value">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_AOFF" Description="Amount of clock jitter expressed as an absolute value">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="PULSE_PARAM_BPAT" Description="Bit Pattern">
        <value Kind="Property" Type="BitPattern">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS" Description="Minimum allowable first switch delay for a Path">
        <value Kind="MinConstraint" Type="Edge">
          <data Type="Array" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_FIRST_SWITCH_CNS_ACTUAL</r>
          <r>MIN_FIRST_SWITCH_CNS_MARGIN</r>
          <r>MIN_FIRST_SWITCH_CNS_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MAX_OVERSHOOT</r>
          <r>MIN_NOISE_MARGIN</r>
          <r>EDGE_SENS</r>
          <r>FIRST_INCIDENT</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_ACTUAL" Description="Actual first switch delay for the path">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <aliases>
          <a>MIN_FIRST_SWITCH_ACTUAL</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_MARGIN" Description="Actual switch delay minus Minimum switch delay">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_FIRST_SWITCH_CNS</r>
        </relatedProperties>
        <aliases>
          <a>MIN_FIRST_SWITCH_MARGIN</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_VSTATUS" Description="Min First Switch verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_FIRST_SWITCH_CNS</r>
        </relatedProperties>
        <aliases>
          <a>MIN_FIRST_SWITCH_VSTATUS</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_NODE" Description="Min First Switch measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MIN_FIRST_SWITCH_NODE</a>
        </aliases>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MIN_FIRST_SWITCH_WAVEID</a>
        </aliases>
      </attribute>
      <attribute Name="MIN_FIRST_SWITCH_CNS_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MIN_FIRST_SWITCH_WAVEFORMS</a>
        </aliases>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS" Description="Maximum allowable final settle delay for a Path">
        <value Kind="MaxConstraint" Type="Edge">
          <data Type="Array" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_FINAL_SETTLE_CNS_ACTUAL</r>
          <r>MAX_FINAL_SETTLE_CNS_MARGIN</r>
          <r>MAX_FINAL_SETTLE_CNS_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_OVERSHOOT</r>
          <r>MIN_NOISE_MARGIN</r>
          <r>EDGE_SENS</r>
          <r>FIRST_INCIDENT</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_ACTUAL" Description="Actual final settle delay for the path">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <aliases>
          <a>MAX_FINAL_SETTLE_ACTUAL</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_MARGIN" Description="Maximum settle constraint minus actual settle delay">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_FINAL_SETTLE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>MAX_FINAL_SETTLE_MARGIN</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_VSTATUS" Description="Max Final Settle verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_FINAL_SETTLE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>MAX_FINAL_SETTLE_VSTATUS</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_NODE" Description="Max Final Settle measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MAX_FINAL_SETTLE_NODE</a>
        </aliases>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MAX_FINAL_SETTLE_WAVEID</a>
        </aliases>
      </attribute>
      <attribute Name="MAX_FINAL_SETTLE_CNS_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <aliases>
          <a>MAX_FINAL_SETTLE_WAVEFORMS</a>
        </aliases>
      </attribute>
      <attribute Name="MAX_OVERSHOOT" Description="Absolute overshoot voltage allowed">
        <value Kind="MaxConstraint" Type="Threshold" Category="Bubble">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_OVERSHOOT_ACTUAL</r>
          <r>MAX_OVERSHOOT_MARGIN</r>
          <r>MAX_OVERSHOOT_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MIN_NOISE_MARGIN</r>
          <r>EDGE_SENS</r>
          <r>FIRST_INCIDENT</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_ACTUAL" Description="Actual overshoot voltage">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_OVERSHOOT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_MARGIN" Description="Maximum overshoot minus actual overshoot">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_OVERSHOOT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_VSTATUS" Description="Maximum overshoot verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_OVERSHOOT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_NODE" Description="Maximum Overshoot measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_OVERSHOOT_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN" Description="Minimum delta from the threshold after the net switches">
        <value Kind="MinConstraint" Type="Edge" Category="Bubble">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_NOISE_MARGIN_ACTUAL</r>
          <r>MIN_NOISE_MARGIN_MARGIN</r>
          <r>MIN_NOISE_MARGIN_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MAX_OVERSHOOT</r>
          <r>EDGE_SENS</r>
          <r>FIRST_INCIDENT</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_ACTUAL" Description="Actual delta from threshold after the net switches">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_NOISE_MARGIN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_MARGIN" Description="Actual delta from threshold after the net switches">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_NOISE_MARGIN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_VSTATUS" Description="Minimum noise margin verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_NOISE_MARGIN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_NODE" Description="Minimum Noise margin measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_NOISE_MARGIN_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_SSN" Description="Maximum simultaneous switching noise allowed">
        <value Kind="Constraint" Type="Edge" Category="Bubble">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_SSN_ACTUAL</r>
          <r>MAX_SSN_MARGIN</r>
          <r>MAX_SSN_VSTATUS</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_SSN_ACTUAL" Description="Actual simultaneous switching noise at steady state high:low">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_SSN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_SSN_MARGIN" Description="Worst case maximum minus actual simultaneous switching noise">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_SSN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_SSN_VSTATUS" Description="Maximum Simultaneous switching noise verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_SSN</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_SSN_POWER_BUS" Description="Power bus associated with driver pin">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="MAX_SSN_GROUND_BUS" Description="Ground bus associated with driver pin">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="MAX_SSN_NODE" Description="Maximum Simultaneous switching noise measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_SSN_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_SSN_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EDGE_SENS" Description="Nets sensitivity to non-monotonicity">
        <value Kind="Constraint" Type="Enum" Category="Bubble">
          <data Type="Scalar" Storage="Enum">
            <e>RISING</e>
            <e>FALLING</e>
            <e>BOTH</e>
            <e>NEITHER</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>EDGE_SENS_ACTUAL</r>
          <r>EDGE_SENS_MARGIN</r>
          <r>EDGE_SENS_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MAX_OVERSHOOT</r>
          <r>MIN_NOISE_MARGIN</r>
          <r>FIRST_INCIDENT</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="EDGE_SENS_ACTUAL" Description="Is edge non-monotonic?">
        <value Kind="Actual">
          <data Type="Array" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>EDGE_SENS</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="EDGE_SENS_MARGIN" Description="Is edge non-monotonic?">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>EDGE_SENS</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="EDGE_SENS_VSTATUS" Description="Edge sensitivity verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>EDGE_SENS</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="EDGE_SENS_NODE" Description="Edge sensitivity measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="EDGE_SENS_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EDGE_SENS_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="FIRST_INCIDENT" Description="Flags whether a receiver is required to switch on the first incident wave">
        <value Kind="Constraint" Type="Enum" Category="Bubble">
          <data Type="Scalar" Storage="Enum">
            <e>RISING</e>
            <e>FALLING</e>
            <e>BOTH</e>
            <e>NEITHER</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>FIRST_INCIDENT_ACTUAL</r>
          <r>FIRST_INCIDENT_MARGIN</r>
          <r>FIRST_INCIDENT_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MAX_OVERSHOOT</r>
          <r>MIN_NOISE_MARGIN</r>
          <r>EDGE_SENS</r>
        </relatedAnalyses>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="FIRST_INCIDENT_ACTUAL" Description="Did receiver switch on first incident wave?">
        <value Kind="Actual">
          <data Type="Array" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>FIRST_INCIDENT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="FIRST_INCIDENT_MARGIN" Description="Did receiver switch on first incident wave?">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>FIRST_INCIDENT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="FIRST_INCIDENT_VSTATUS" Description="First incident switch verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>FIRST_INCIDENT</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="FIRST_INCIDENT_NODE" Description="First Incident measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="FIRST_INCIDENT_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="FIRST_INCIDENT_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="XTALK_ACTIVE_TIME" Description="Clock cycle(s) when net is actively switching and creating noise">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="XTALK_SENSITIVE_TIME" Description="Clock cycle(s) when net is sensitive to noise">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>

            <o>Pin</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="XTALK_IGNORE_NETS" Description="List of nets to ignore when calculating crosstalk">
        <value Kind="Property" Type="Nets" Delimiter="," Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK" Description="Maximum allowable crosstalk from all aggressors" extDesc="MAX_XTALK.html">
        <value Kind="MaxConstraint" Type="Threshold" Category="Bubble">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_XTALK_ACTUAL</r>
          <r>MAX_XTALK_MARGIN</r>
          <r>MAX_XTALK_VSTATUS</r>
          <r>MAX_XTALK_EST_ACTUAL</r>
          <r>MAX_XTALK_EST_MARGIN</r>
          <r>MAX_XTALK_EST_VSTATUS</r>
        </relatedProperties>
        <aliases>
          <a>MAX_XTALK_EST</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_ACTUAL" Description="Actual crosstalk from all aggressors">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_MARGIN" Description="Maximum crosstalk minus actual crosstalk">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_VSTATUS" Description="Maximum Xtalk verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_EST_ACTUAL" Description="Actual crosstalk from all aggressors">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_EST_MARGIN" Description="Maximum crosstalk minus actual crosstalk">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_EST_VSTATUS" Description="Maximum Xtalk verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_EST_DRC" Description="Estimated Crosstalk DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK" Description="Maximum allowable crosstalk from a single aggressor" extDesc="MAX_PEAK_XTALK.html">
        <value Kind="MaxConstraint" Type="Threshold" Category="Bubble">
          <data Type="Array" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PEAK_XTALK_ACTUAL</r>
          <r>MAX_PEAK_XTALK_MARGIN</r>
          <r>MAX_PEAK_XTALK_VSTATUS</r>
          <r>MAX_PEAK_XTALK_EST_ACTUAL</r>
          <r>MAX_PEAK_XTALK_EST_MARGIN</r>
          <r>MAX_PEAK_XTALK_EST_VSTATUS</r>
        </relatedProperties>
        <aliases>
          <a>MAX_PEAK_XTALK_EST</a>
        </aliases>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_ACTUAL" Description="Actual peak crosstalk from the single aggressors">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_MARGIN" Description="Maximum peak crosstalk minus actual peak crosstalk">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_VSTATUS" Description="Maximum Peak Xtalk verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_EST_ACTUAL" Description="Actual peak crosstalk from the single aggressors">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_EST_MARGIN" Description="Maximum peak crosstalk minus actual peak crosstalk">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="mV"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_EST_VSTATUS" Description="Maximum Peak Xtalk verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_PEAK_XTALK</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_EST_DRC" Description="Estimated Peak Crosstalk DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_VMODE" Description="Maximum Xtalk verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_VMODE" Description="Maximum Peak Xtalk verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_XTALK_NODE" Description="Xtalk measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_XTALK_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_XTALK_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_NODE" Description="Peak Xtalk measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>XtalkVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_PEAK_XTALK_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
      </attribute>

      <!-- Power integrity discipline -->
      <attribute Name="MAX_SETBACK_DIST_SAME_LAYER" Description="Maximum DeCap setback distance when on the same layer." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PowerIntegrityCSet</o>
            <o>PowerRail</o>
            <o>PICSetPowerRail</o>
            <o>PartDefn</o>
            <o>Part</o>
          </valid>
          <readOnly>
            <o>PowerRail</o>
            <o>PartDefn</o>
            <o>Part</o>
          </readOnly>
          <noInherit>
            <pair Kind1="PICSetPowerRail" Kind2="PartDefn"/>
          </noInherit>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="MAX_SETBACK_DIST_OPP_LAYER" Description="Maximum DeCap setback distance when on the opposite  layer." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PowerIntegrityCSet</o>
            <o>PowerRail</o>
            <o>PICSetPowerRail</o>
            <o>PartDefn</o>
            <o>Part</o>
          </valid>
          <readOnly>
            <o>PowerRail</o>
            <o>PartDefn</o>
            <o>Part</o>
          </readOnly>
          <noInherit>
            <pair Kind1="PICSetPowerRail" Kind2="PartDefn"/>
          </noInherit>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="NUM_CAPS_SAME_LAYER" Description="Number of decaps that must be placed on the same layer." Version="16.600">
        <value Kind="Property" Category="PowerRailInst">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="NUM_CAPS_OPP_LAYER" Description="Number of decaps that must be placed on the opposite layer." Version="16.600">
        <value Kind="Property" Category="PowerRailInst">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="NUM_CAPS_UNDER_COMP" Description="Number of decaps that must be placed underneath the component." Version="16.600">
        <value Kind="Property" Category="PowerRailInst">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="MAX_POWER_PIN_DIST" Description="Maximum distance between power pin and decap." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="DECAP_PACKAGE" Description="Preferred package for decap." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="DECAP_PART_NUMBER" Description="Part number for decap." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="POWER_RAIL_GROUND" Description="Ground name for a Power Rail." Version="16.600">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMOnly</s>
            <s>UpperCaseValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PICSetPowerRail</o>
            <o>PowerRail</o>
          </valid>
        </objects>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="CLOCK_NET" Description="Clock net name">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CLK_2OUT_MIN" Description="Internal minimum delay when a component is triggered by a clock pulse">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>DrvrPin</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
        <allegro Id ="239" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CLK_2OUT_MAX" Description="Internal maximum delay when a component is triggered by a clock pulse">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>DrvrPin</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
        <allegro Id ="240" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="TIMING_DELAY_OVERRIDE" Description="Interconnect delay override used in setup/hold calculations">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CLK_SKEW_MIN" Description="Minimum skew between the clock arriving at the driver and receiver">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>RcvrPin</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
        <allegro Id ="244"  AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CLK_SKEW_MAX" Description="Maximum skew between the clock arriving at the driver and receiver">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>RcvrPin</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
        <allegro Id ="245" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="TESTER_GUARDBAND" Description="Tester guard band">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>RcvrPin</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MIN_SETUP</r>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="Base"/>
        <allegro Id ="251" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="MIN_SETUP" Description="SETUP requirements for a Receiver">
        <value Kind="MinConstraint" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>RcvrPin</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>CLOCK_NET</r>
          <r>PULSE_PARAM_FREQ</r>
          <r>PULSE_PARAM_JITTER</r>
          <r>CLK_2OUT_MIN</r>
          <r>CLK_2OUT_MAX</r>
          <r>CLK_SKEW_MIN</r>
          <r>CLK_SKEW_MAX</r>
          <r>MIN_FIRST_SWITCH_CNS_ACTUAL</r>
          <r>MAX_FINAL_SETTLE_CNS_ACTUAL</r>
          <r>TIMING_DELAY_OVERRIDE</r>
          <r>TESTER_GUARDBAND</r>
          <r>MIN_SETUP_ACTUAL</r>
          <r>MIN_SETUP_MARGIN</r>
          <r>MIN_SETUP_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MIN_HOLD</r>
        </relatedAnalyses>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="Base"/>
        <allegro Id ="241" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="MIN_SETUP_ACTUAL" Description="Actual SETUP for the Receiver">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_SETUP</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_SETUP_MARGIN" Description="SETUP margin for the Receiver">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_SETUP</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_SETUP_VSTATUS" Description="Minimum setup verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_SETUP</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_SETUP_NODE" Description="Minimum Setup measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MIN_SETUP_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_SETUP_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_HOLD" Description="HOLD requirements for a Receiver">
        <value Kind="MinConstraint" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>CMEditOnly</s>
            <s>RcvrPin</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>CLOCK_NET</r>
          <r>PULSE_PARAM_FREQ</r>
          <r>PULSE_PARAM_JITTER</r>
          <r>CLK_2OUT_MIN</r>
          <r>CLK_2OUT_MAX</r>
          <r>CLK_SKEW_MIN</r>
          <r>CLK_SKEW_MAX</r>
          <r>MIN_FIRST_SWITCH_CNS_ACTUAL</r>
          <r>MAX_FINAL_SETTLE_CNS_ACTUAL</r>
          <r>TIMING_DELAY_OVERRIDE</r>
          <r>TESTER_GUARDBAND</r>
          <r>MIN_HOLD_ACTUAL</r>
          <r>MIN_HOLD_MARGIN</r>
          <r>MIN_HOLD_VSTATUS</r>
        </relatedProperties>
        <relatedAnalyses>
          <r>MIN_FIRST_SWITCH_CNS</r>
          <r>MAX_FINAL_SETTLE_CNS</r>
          <r>MIN_SETUP</r>
        </relatedAnalyses>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="Base"/>
        <allegro Id ="242" AtrPropertyType="DB_DATA_TYPE_PROP_DELAY">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="MIN_HOLD_ACTUAL" Description="Actual HOLD for the Receiver">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_HOLD_MARGIN" Description="HOLD margin for the Receiver">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_HOLD_VSTATUS" Description="Minimum hold verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_HOLD</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MIN_HOLD_NODE" Description="Minimum hold measurement node location">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>SimVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MIN_HOLD_WAVEID" Description="Waveform Id for SigWave">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="MIN_HOLD_WAVEFORMS" Description="Waveform Matrix for SigWave">
        <value Kind="Property">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="TOPOLOGY_TEMPLATE_MAPPING_MODE" Description="Mapping mode when applying a template-defined schedule">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>PINUSE</e>
            <e>REFDES</e>
            <e>PINUSE_REFDES</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="NET_SCHEDULE" Description="Should the routing be verified against the schedule?">
        <value Kind="Property" Type="Enum" Category="Bubble">
          <data Type="Scalar" Storage="Enum">
            <e>VERIFY</e>
            <e>DO_NOT_VERIFY</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RATSNEST_SCHEDULE</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE" Description="Net schedule control">
        <value Kind="Constraint" Type="Enum" Category="Bubble">
          <!-- Serge 26.03.2014: these values can be offered in UI, but there are also several signifying user-defined schedule -->
          <data Type="Scalar" Storage="EnumOrString">
            <e>MIN_TREE</e>
            <e>MIN_DAISY_CHAIN</e>
            <e>SOURCE_LOAD_DAISY_CHAIN</e>
            <e>STAR</e>
            <e>FAR_END_CLUSTER</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>CanBeLocked</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>VerifyOnChange</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>NET_SCHEDULE</r>
          <r>RATSNEST_SCHEDULE_ACTUAL</r>
          <r>RATSNEST_SCHEDULE_MARGIN</r>
          <r>RATSNEST_SCHEDULE_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE_ACTUAL" Description="Is the Net routed according to the schedule?">
        <value Kind="Actual" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RATSNEST_SCHEDULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE_MARGIN" Description="Is the Net routed according to the schedule?">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RATSNEST_SCHEDULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE_VSTATUS" Description="Scheduling verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RATSNEST_SCHEDULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE_LSTATUS" Description="Scheduling lock reason">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RATSNEST_SCHEDULE_DRC" Description="Schedule DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS" Description="Defines the impedance requirements of a net" extDesc="IMPEDANCE_RULE_CNS.html">
        <value Kind="TargetOneTolerance">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
            <s>DRCVerify</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>IMPEDANCE_RULE_CNS_TOL</r>
          <r>IMPEDANCE_RULE_CNS_ACTUAL</r>
          <r>IMPEDANCE_RULE_CNS_MARGIN</r>
          <r>IMPEDANCE_RULE_CNS_VSTATUS</r>
        </relatedProperties>
        <aliases>
          <a>IMPEDANCE_RULE_VAL</a>
        </aliases>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_TOL" Description="Defines the impedance tolerance (absolute or percentage) of a net">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uResistanceTolerance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>Tolerance</s>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>IMPEDANCE_RULE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>IMPEDANCE_RULE_TOL</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_ACTUAL" Description="Actual impedance of a net">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>IMPEDANCE_RULE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>IMPEDANCE_RULE_ACTUAL</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_MARGIN" Description="Actual impedance minus the target impedance +/- the tolerance">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>IMPEDANCE_RULE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>IMPEDANCE_RULE_MARGIN</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_VSTATUS" Description="Impedance verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>IMPEDANCE_RULE_CNS</r>
        </relatedProperties>
        <aliases>
          <a>IMPEDANCE_RULE_VSTATUS</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_DRC" Description="Impedance DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <aliases>
          <a>IMPEDANCE_RULE_DRC</a>
        </aliases>
      </attribute>
      <attribute Name="IMPEDANCE_RULE_CNS_VMODE" Description="Impedance verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>IMPEDANCE_RULE_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="STUB_LENGTH" Description="Maximum stub length for daisy-chain type routing" extDesc="STUB_LENGTH.html">
        <value Kind="MaxConstraint" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>STUB_LENGTH_ACTUAL</r>
          <r>STUB_LENGTH_MARGIN</r>
          <r>STUB_LENGTH_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="STUB_LENGTH_ACTUAL" Description="Actual stub length for daisy-chain type routing">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>STUB_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="STUB_LENGTH_MARGIN" Description="Maximum stub length minus the actual stub length">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>STUB_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="STUB_LENGTH_VSTATUS" Description="Maximum stub-length verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>STUB_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="STUB_LENGTH_DRC" Description="Stub-length DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="STUB_LENGTH_VMODE" Description="Maximum stub length verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>RATSNEST_SCHEDULE_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="MAX_VIA_COUNT" Description="Maximum number of vias in a Net" extDesc="MAX_VIA_COUNT.html">
        <value Kind="MaxConstraint">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_VIA_COUNT_ACTUAL</r>
          <r>MAX_VIA_COUNT_MARGIN</r>
          <r>MAX_VIA_COUNT_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_VIA_COUNT_ACTUAL" Description="Number of vias in a Net">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_VIA_COUNT_MARGIN" Description="Maximum total vias minus the actual number of vias">
        <value Kind="Result">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_VIA_COUNT_VSTATUS" Description="Maximum via count verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_VIA_COUNT_DRC" Description="Max via count DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_VIA_COUNT_VMODE" Description="Maximum total vias verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="Net"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT" Description="Match vias in a group of Nets" Version="16.300" extDesc="MATCH_VIA_COUNT.html">
        <value Kind="PassFailConstraint">
          <data Type="Scalar" Storage="Enum">
            <!-- update IsMoreRestrictive in Value.cpp if reordering -->
            <e>ON</e>
            <e>OFF</e>
          </data>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>EditGroupOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
            <s>DRCVerify</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MATCH_VIA_COUNT_ACTUAL</r>
          <r>MATCH_VIA_COUNT_MARGIN</r>
          <r>MATCH_VIA_COUNT_VSTATUS</r>
          <r>MATCH_VIA_OBJECT_COUNT</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="L"/>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT_ACTUAL" Description="Vias in a group of Nets are matched" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MATCH_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="L"/>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT_MARGIN" Description="Difference in actual matched vias among a group of Nets" Version="16.300">
        <value Kind="Result">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MATCH_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="L"/>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT_VSTATUS" Description="Match vias verification status" Version="16.300">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MATCH_VIA_COUNT</r>
        </relatedProperties>
        <tiering tier="L"/>
      </attribute>
      <attribute Name="MATCH_VIA_OBJECT_COUNT" Description="Number of vias on an object" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
        </objects>
        <analysis MeasureName="ViaCount"/>
        <relatedProperties>
          <r>MATCH_VIA_COUNT</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT_DRC" Description="Match vias DRC object" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MATCH_VIA_COUNT_VMODE" Description="Match vias verification mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH" Description="Maximum length of copper on the outside of the board" extDesc="MAX_EXPOSED_LENGTH.html">
        <value Kind="MaxConstraint" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_EXPOSED_LENGTH_ACTUAL</r>
          <r>MAX_EXPOSED_LENGTH_MARGIN</r>
          <r>MAX_EXPOSED_LENGTH_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH_ACTUAL" Description="Actual length of copper on the outside of the board">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_EXPOSED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH_MARGIN" Description="Maximum exposed length minus the actual exposed length of copper">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_EXPOSED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH_VSTATUS" Description="Maximum exposed copper verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_EXPOSED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH_DRC" Description="Max exposed length DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_EXPOSED_LENGTH_VMODE" Description="Maximum exposed length verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_PARALLEL" Description="Maximum parallelism for wires" extDesc="MAX_PARALLEL_CNS.html">
        <value Kind="Constraint" Type="Matrix">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>VerifyOnChange</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PARALLEL_ACTUAL</r>
          <r>MAX_PARALLEL_MARGIN</r>
          <r>MAX_PARALLEL_VSTATUS</r>
        </relatedProperties>
        <aliases>
          <a>MAX_PARALLEL_CNS</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_PARALLEL_ACTUAL" Description="Actual same-layer parallelism results for the routing">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PARALLEL</r>
        </relatedProperties>
        <aliases>
          <a>MAX_PARALLEL_ACTUAL</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_PARALLEL_MARGIN" Description="Maximum parallelism minus the actual parallelism">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PARALLEL</r>
        </relatedProperties>
        <aliases>
          <a>MAX_PARALLEL_MARGIN</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_PARALLEL_VSTATUS" Description="Maximum parrallism verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_PARALLEL</r>
        </relatedProperties>
        <aliases>
          <a>MAX_PARALLEL_VSTATUS</a>
        </aliases>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="MAX_PARALLEL_DRC" Description="Max parallel DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_PARALLEL_VMODE" Description="Maximum parallelism verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>MAX_PARALLEL_CNS_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="LAYERSET_GROUP" Description="Routing layer sets" Version="15.500" extDesc="LAYERSET_GROUP.html">
        <value Kind="Constraint" Type="LayerSets" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>VerifyOnChange</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>LAYERSET_GROUP_ACTUAL</r>
          <r>LAYERSET_GROUP_MARGIN</r>
          <r>LAYERSET_IGNORED_LENGTH</r>
          <r>LAYERSET_GROUP_VMODE</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="LAYERSET_GROUP_ACTUAL" Description="Actual routing layers" Version="15.500">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Enum">
            <e>PASS</e>
            <e>FAIL</e>
          </data>
          <flags>
            <s>NoInherit</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>LAYERSET_GROUP</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="LAYERSET_GROUP_MARGIN" Description="Actual routing layers margin" Version="15.500">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>NoInherit</s>
            <s>NoUnitStr</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>LAYERSET_GROUP</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="LAYERSET_IGNORED_LENGTH" Description="Ignored length for an object" Version="15.500">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>LAYERSET_GROUP</r>
        </relatedProperties>
      </attribute>
      <attribute Name="LAYERSET_GROUP_VMODE" Description="Layer Sets verification mode" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>LAYERSET_GROUP</r>
        </relatedProperties>
      </attribute>
      <attribute Name="LAYERSET_GROUP_VSTATUS" Description="Layer Sets verification status" Version="15.500">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="LAYERSET_GROUP_DRC" Description="Layer Sets DRC object" Version="15.500">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>ProcessAllObjects</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_PATH_TYPE" Description="Apply delay/length constraints to various Path types">
        <value Kind="Property" Type="Enum" Delimiter=";">
          <!--delimiter added so that ':' inside the value would not be confused for one-->
          <data Type="Scalar" Storage="Enum">
            <e>L:S</e>
            <e>D:R</e>
            <e>AD:AR</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MIN_ACTUAL</r>
          <r>PROPAGATION_DELAY_MIN_MARGIN</r>
          <r>PROPAGATION_DELAY_MIN_VSTATUS</r>
          <r>PROPAGATION_DELAY_MAX_ACTUAL</r>
          <r>PROPAGATION_DELAY_MAX_MARGIN</r>
          <r>PROPAGATION_DELAY_MAX_VSTATUS</r>
          <r>PROPAGATION_DELAY_MIN</r>
          <r>PROPAGATION_DELAY_MAX</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN" Description="Minimum allowable propagation delay/length for an object" extDesc="PROPAGATION_DELAY_MIN.html">
        <value Kind="MinConstraint" Type="DelayWithUnits">
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDelay" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>CnsForAnalysis</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_PATH_TYPE</r>
          <r>PROPAGATION_DELAY_MIN_ACTUAL</r>
          <r>PROPAGATION_DELAY_MIN_MARGIN</r>
          <r>PROPAGATION_DELAY_MIN_VSTATUS</r>
        </relatedProperties>
        <restriction Type="MaxConstraint">
          <r>PROPAGATION_DELAY_MAX</r>
        </restriction>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN_ACTUAL" Description="Actual propagation delay/length for an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MIN</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN_MARGIN" Description="Actual propagation delay/length minus minimum propagation delay/length">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MIN</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN_VSTATUS" Description="Minimum propagation delay verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MIN</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN_DRC" Description="Min prop delay DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MIN_VMODE" Description="Minimum propagation delay/length verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>PROPAGATION_DELAY_MAX_VMODE</a>
          <a>PROPAGATION_DELAY_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MAX" Description="Maximum allowable propagation delay/length for an object">
        <value Kind="MaxConstraint" Type="DelayWithUnits">
          <data Type="Scalar" Storage="Double"/>
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <units Type="uDelay" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_PATH_TYPE</r>
          <r>PROPAGATION_DELAY_MAX_ACTUAL</r>
          <r>PROPAGATION_DELAY_MAX_MARGIN</r>
          <r>PROPAGATION_DELAY_MAX_VSTATUS</r>
        </relatedProperties>
        <restriction Type="MinConstraint">
          <r>PROPAGATION_DELAY_MIN</r>
        </restriction>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MAX_ACTUAL" Description="Actual propagation delay/length for an object">
        <value Kind="Actual">
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MAX</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MAX_MARGIN" Description="Maximum propagation delay/length minus actual propagation delay/length">
        <value Kind="Result">
          <!--// Serge 22.01.2015: Storage is set to Double deliberately - units are displayed only to highlight the type (lenght vs. time vs. %)-->
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MAX</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MAX_VSTATUS" Description="Maximum propagation delay verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>PROPAGATION_DELAY_MAX</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PROPAGATION_DELAY_MAX_DRC" Description="Max prop delay DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>ScheduleVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN" Description="Minimum allowable total etch length for an object" extDesc="TOTAL_ETCH_LENGTH_MIN.html">
        <value Kind="MinConstraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MIN_ACTUAL</r>
          <r>TOTAL_ETCH_LENGTH_MIN_MARGIN</r>
          <r>TOTAL_ETCH_LENGTH_MIN_VSTATUS</r>
        </relatedProperties>
        <restriction Type="MaxConstraint">
          <r>TOTAL_ETCH_LENGTH_MAX</r>
        </restriction>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN_ACTUAL" Description="Actual total etch for an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis MeasureName="EtchLength">
          <flags>
            <s>DRCVerify</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MIN</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN_MARGIN" Description="Actual total etch length minus minimum total etch length">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MIN</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN_VSTATUS" Description="Minimum total etch length verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MIN</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN_DRC" Description="Min total etch DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MIN_VMODE" Description="Minimum total etch length verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>TOTAL_ETCH_LENGTH_MAX_VMODE</a>
          <a>TOTAL_ETCH_LENGTH_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MAX" Description="Maximum total etch length for an object">
        <value Kind="MaxConstraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MAX_ACTUAL</r>
          <r>TOTAL_ETCH_LENGTH_MAX_MARGIN</r>
          <r>TOTAL_ETCH_LENGTH_MAX_VSTATUS</r>
        </relatedProperties>
        <restriction Type="MinConstraint">
          <r>TOTAL_ETCH_LENGTH_MIN</r>
        </restriction>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MAX_ACTUAL" Description="Actual total etch length for an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis MeasureName="EtchLength">
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MAX</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MAX_MARGIN" Description="Maximum total etch length minus actual total etch length">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MAX</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MAX_VSTATUS" Description="Maximum total etch length verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>TOTAL_ETCH_LENGTH_MAX</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="TOTAL_ETCH_LENGTH_MAX_DRC" Description="Max total etch DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="UNROUTED_LENGTH_ACTUAL" Description="Estimated Length of an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis MeasureName="ManhattanLength"/>
      </attribute>
      <attribute Name="UNROUTED_LENGTH_ACTUAL_VSTATUS" Description="Estimated Length verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="PERCENT_MANHATTAN_ACTUAL" Description="Actual percent manhattan for an object">
        <value Kind="Actual" Type="Percentage">
          <data Type="Scalar" Storage="Integer"/>
          <units Type="uPercentage" Name="%"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis MeasureName="PercentManhattan">
          <flags>
            <s>FullyRouted</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="PERCENT_MANHATTAN_ACTUAL_VSTATUS" Description="Percent manhattan verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE" Description="Defines the differential impedance requirements of an object">
        <value Kind="TargetOneTolerance">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFF_IMPEDANCE_RULE_TOL</r>
          <r>DIFF_IMPEDANCE_RULE_ACTUAL</r>
          <r>DIFF_IMPEDANCE_RULE_MARGIN</r>
          <r>DIFF_IMPEDANCE_RULE_VSTATUS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE_TOL" Description="Defines the differential impedance tolerance (absolute or percentage) of an object">
        <value Kind="Property" Type="PercentOptional">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uResistanceTolerance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>Tolerance</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFF_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE_ACTUAL" Description="Actual differential impedance of an object">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis MeasureName="DifferentialImpedance">
          <flags>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFF_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE_MARGIN" Description="Actual differential impedance minus the target impedance +/- the tolerance">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>DIFF_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE_VSTATUS" Description="Differential impedance verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>DIFF_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFF_IMPEDANCE_RULE_DRC" Description="Differential impedance DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE" Description="Defines the differential impedance requirements of an object"  Version="17.400">
        <value Kind="TargetOneTolerance">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>ClineSegment</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_RULE_TOL</r>
          <r>DIFFP_IMPEDANCE_RULE_ACTUAL</r>
          <r>DIFFP_IMPEDANCE_RULE_MARGIN</r>
          <r>DIFFP_IMPEDANCE_RULE_VSTATUS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE_TOL" Description="Defines the differential impedance tolerance (absolute or percentage) of an object"  Version="17.400">
        <value Kind="Property" Type="PercentOptional">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uResistanceTolerance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>ClineSegment</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>Tolerance</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE_ACTUAL" Description="Actual differential impedance of an object"  Version="17.400">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>ClineSegment</o>
          </valid>
        </objects>
        <analysis MeasureName="DifferentialImpedance">
          <flags>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE_MARGIN" Description="Actual differential impedance minus the target impedance +/- the tolerance"  Version="17.400">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>ClineSegment</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE_VSTATUS" Description="Differential impedance verification status"  Version="17.400">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_RULE</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_RULE_DRC" Description="Differential impedance DRC object"  Version="17.400">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>ClineSegment</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT" DisplayName="Target" Description="Defines the impedance target for breakouts" Version="17.400">
        <value Kind="TargetOneTolerance">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NotDerivedFromPin</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>ClineSegment</o>
            <o>Part</o>
            <o>Pin</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <readOnly>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Pin</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </readOnly>
          <inheritOnly>
            <o>ClineSegment</o>
          </inheritOnly>
          <noInherit>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPinPair"/>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPin"/>
            <pair Kind1="ElecCSetPinPair" Kind2="ElecCSetPin"/>
            <pair Kind1="PinPair" Kind2="Pin"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
            <s>DRCVerify</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT_TOL</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT_LEN</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT_ACTUAL</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT_MARGIN</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_TOL" DisplayName="Tolerance" Description="Defines the impedance tolerance (absolute or percentage) of a breakout" Version="17.400">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uResistanceTolerance" Name="Ohm"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NotDerivedFromPin</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Part</o>
            <o>Pin</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <readOnly>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Pin</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </readOnly>
          <inheritOnly>
            <o>ClineSegment</o>
          </inheritOnly>
          <noInherit>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPinPair"/>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPin"/>
            <pair Kind1="ElecCSetPinPair" Kind2="ElecCSetPin"/>
            <pair Kind1="PinPair" Kind2="Pin"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>Tolerance</s>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_LEN" DisplayName="Max Length" Description="Defines the maximum length of a breakout for impedance check" Version="17.400">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NotDerivedFromPin</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Part</o>
            <o>Pin</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <readOnly>
            <o>ElectricalCSet</o>
            <o>ElecCSetPinPair</o>
            <o>ElecCSetPin</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Pin</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </readOnly>
          <inheritOnly>
            <o>ClineSegment</o>
          </inheritOnly>
          <noInherit>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPinPair"/>
            <pair Kind1="ElectricalCSet" Kind2="ElecCSetPin"/>
            <pair Kind1="ElecCSetPinPair" Kind2="ElecCSetPin"/>
            <pair Kind1="PinPair" Kind2="Pin"/>
          </noInherit>
        </objects>
        <analysis>
          <flags>
            <s>Tolerance</s>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_ACTUAL" Description="Actual impedance of a breakout" Version="17.400">
        <value Kind="Actual">
          <data Type="Array" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_MARGIN" Description="Actual reajout bimpedance minus the target impedance +/- the tolerance" Version="17.400">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_VSTATUS" Description="Breakout Impedance verification status" Version="17.400">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_IMPEDANCE_BREAKOUT_DRC" Description="Breakout impedance DRC object" Version="17.400">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ClineSegment</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="MAX_BRANCHES" Description="Defines the maximum number of branches allowed in a Net">
        <value Kind="MaxConstraint">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>CnsForAnalysis</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MAX_BRANCHES_ACTUAL</r>
          <r>MAX_BRANCHES_MARGIN</r>
          <r>MAX_BRANCHES_VSTATUS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_BRANCHES_ACTUAL" Description="Number of branches in a Net">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis MeasureName="BranchCount"/>
        <relatedProperties>
          <r>MAX_BRANCHES</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_BRANCHES_MARGIN" Description="Maximum number of branches minus the actual number of branches">
        <value Kind="Result">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_BRANCHES</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MAX_BRANCHES_VSTATUS" Description="Maximum branches verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMDefined</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>MAX_BRANCHES</r>
        </relatedProperties>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_TARGET" Description="Target Pin Pair when defining relative constraint requirements">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_PATH_TYPE" Description="Auto-generate Pin Pairs for the Xnet/Nets in the Group">
        <!--delimiter added so that ':' inside the value would not be confused for one-->
        <value Kind="Property" Type="Enum" Delimiter=";">
          <data Type="Scalar" Storage="Enum">
            <e>L:S</e>
            <e>D:R</e>
            <e>AD:AR</e>
          </data>
          <flags>
            <s>Instances</s>
            <s>CMEditOnly</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_ACTUAL</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_MARGIN</r>
          <r>RELATIVE_PROPAGATION_DELAY_PLUS_MINUS</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_VSTATUS</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_CNS_PATH_TYPE</a>
        </aliases>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_SCOPE" Description="Scope when applying an Electrical CSet Relative/Match Group">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="Enum">
            <e>L</e>
            <e>G</e>
            <e>B</e>
            <e>C</e>
            <e>N</e>
          </data>
          <flags>
            <s>Instances</s>
            <s>CMEditOnly</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_ACTUAL</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_MARGIN</r>
          <r>RELATIVE_PROPAGATION_DELAY_PLUS_MINUS</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_VSTATUS</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_CNS_SCOPE</a>
        </aliases>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_CNS" Description="Propagation delay/length skew constraint for a group of objects">
        <value Kind="TargetOneTolerance" Type="DeltaTol">
          <data Type="Special" Storage="DblWUnitsOrEnum">
            <e>TARGET</e>
          </data>
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Instances</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>ElecCSetPinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
            <s>CnsForAnalysis</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_PATH_TYPE</r>
          <r>RELATIVE_PROPAGATION_DELAY_SCOPE</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_ACTUAL</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_MARGIN</r>
          <r>RELATIVE_PROPAGATION_DELAY_PLUS_MINUS</r>
          <r>RELATIVE_PROPAGATION_DELAY_CNS_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_CNS_ACTUAL" Description="Actual propagation delay/length skew for a group of objects">
        <value Kind="Actual">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>TARGET</e>
          </data>
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>Instances</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>DelayRelated</s>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_ACTUAL</a>
        </aliases>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_CNS_MARGIN" Description="Maximum minus actual propagation delay/length skew">
        <value Kind="Result">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>TARGET</e>
          </data>
          <units Type="uDelay" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>Instances</s>
            <s>CMEditOnly</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>MatchGroup</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>DelayRelated</s>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_MARGIN</a>
        </aliases>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_PLUS_MINUS" Description="Object is longer (+) or shorter (-) than target plus delta. Not populated when tolerance-only constraint is set">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Instances</s>
            <s>CMEditOnly</s>
            <s>MultiGroupAltQuery</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>RelPropDelayVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_CNS_VSTATUS" Description="Propagation delay/length skew verification status">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>Instances</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>RELATIVE_PROPAGATION_DELAY_CNS</r>
        </relatedProperties>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_VSTATUS</a>
        </aliases>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_OBJECT_LENGTH" Description="Length of an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
        </objects>
        <analysis MeasureName="EtchLength">
          <flags>
            <s>RelPropDelayVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_OBJECT_DELAY" Description="Delay of an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
        </objects>
        <analysis MeasureName="PropDelay">
          <flags>
            <s>RelPropDelayVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_DRC" Description="Relative prop delay DRC object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>Instances</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
          <parent>
            <o>MatchGroup</o>
            <o>ElecCSetMatchGroup</o>
          </parent>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>RelPropDelayVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="RELATIVE_PROPAGATION_DELAY_VMODE" Description="Propagation delay/length skew verification mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
          <noInherit>
            <pair Kind1="Xnet" Kind2="PinPair"/>
          </noInherit>
        </objects>
        <aliases>
          <a>RELATIVE_PROPAGATION_DELAY_CNS_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="BUS_SCOPE_BUS_NAME" Description="Store the Bus name used for creating Bus scope group">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ECSET_SCOPE_GROUP_NAME" Description="Store the ECSet Group name used for creating Bus/NetClass/NG groups">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CLASS_SCOPE_CLASS_NAME" Description="Store the Class name used for creating Class scope group">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NG_SCOPE_NG_NAME" Description="Store the Net Group name used for creating NG scope groups">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>MatchGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFP_GATHER_CONTROL" Description="Ignore length between Pins and gather point when calculating uncoupled length" Version="15.000">
        <value Kind="Property" Type="Enum" Category="Bubble">
          <data Type="Scalar" Storage="Enum">
            <e>IGNORE</e>
            <e>INCLUDE</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH_ACTUAL</r>
          <r>DIFFP_UNCOUPLED_LENGTH_MARGIN</r>
          <r>GATHER_LENGTH_IGNORED</r>
          <r>DIFFP_UNCOUPLED_LENGTH_VSTATUS</r>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="GATHER_LENGTH_IGNORED" Description="Ignored length for an object" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_UNCOUPLED_LENGTH" Description="Maximum uncoupled length" Version="15.000">
        <value Kind="MaxConstraint" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
            <s>FullyRouted</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_GATHER_CONTROL</r>
          <r>DIFFP_PRIMARY_GAP</r>
          <r>DIFFP_COUPLED_PLUS</r>
          <r>DIFFP_COUPLED_MINUS</r>
          <r>DIFFP_UNCOUPLED_LENGTH_ACTUAL</r>
          <r>DIFFP_UNCOUPLED_LENGTH_MARGIN</r>
          <r>GATHER_LENGTH_IGNORED</r>
          <r>DIFFP_UNCOUPLED_LENGTH_VSTATUS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_PRIMARY_GAP" Description="DiffPair primary separation gap" Version="15.000" extDesc="DIFFP_PRIMARY_GAP.html">
        <value Kind="Property" Type="DiffPairLayer" Category="Bubble">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Region</o>
            <o>RegionClass</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
        <restriction Type="DiffPairPlusVerify">
          <r>DIFFP_MIN_SPACE</r>
          <r>DIFFP_COUPLED_MINUS</r>
          <r>DIFFP_NECK_GAP</r>
        </restriction>
      </attribute>
      <attribute Name="DIFFP_COUPLED_PLUS" Description="DiffPair primary separation positive tolerance" Version="15.000">
        <value Kind="Property" Type="DiffPairLayer" Category="Bubble">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Region</o>
            <o>RegionClass</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_COUPLED_MINUS" Description="DiffPair primary separation negative tolerance" Version="15.000">
        <value Kind="Property" Type="DiffPairLayer" Category="Bubble">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Region</o>
            <o>RegionClass</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
        <restriction Type="DiffPairMinusVerify">
          <r>DIFFP_PRIMARY_GAP</r>
          <r>DIFFP_NECK_GAP</r>
          <r>DIFFP_MIN_SPACE</r>
        </restriction>
      </attribute>
      <attribute Name="DIFFP_UNCOUPLED_LENGTH_ACTUAL" Description="DiffPair maximum uncoupled length" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_UNCOUPLED_LENGTH_MARGIN" Description="DiffPair maximum uncoupled length margin" Version="15.000">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_UNCOUPLED_LENGTH_VSTATUS" Description="DiffPair maximum uncoupled length verification status" Version="15.000">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_UNCOUPLED_LENGTH</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_UNCOUPLED_LENGTH_DRC" Description="DiffPair maximum uncoupled length DRC object" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFFP_PHASE_CONTROL" Description="Used to control the type of phase tolerance check" Version="16.300">
        <!-- Phase control is now obsolete. Seperate constraints for static and dynamic checks -->
        <value Kind="Property" Type="Enum" Category="Bubble">
          <data Type="Scalar" Storage="Enum">
            <e>Static</e>
            <e>Dynamic</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>Obsolete</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
            <o>Bus</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_ACTUAL</r>
          <r>DIFFP_PHASE_TOL_MARGIN</r>
          <r>DIFFP_PHASE_TOL_VSTATUS</r>
        </relatedProperties>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL" Description="Maximum static time/distance for DiffPair to be out-of-phase" Version="15.000">
        <value Kind="MaxConstraint" Category="Bubble">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uPhaseTol" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
            <s>FullyRouted</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_ACTUAL</r>
          <r>DIFFP_PHASE_TOL_MARGIN</r>
          <r>DIFFP_PHASE_TOL_VSTATUS</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_ACTUAL" Description="DiffPair static length/time tolerance" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uPhaseTol" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_MARGIN" Description="DiffPair static length/time tolerance margin" Version="15.000">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uPhaseTol" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_VSTATUS" Description="DiffPair static length/time tolerance verification status" Version="15.000">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL</r>
        </relatedProperties>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DRC" Description="DiffPair static length/time tolerance DRC object" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFFP_PHASE_MAX_LENGTH" Description="The maximum distance allowed once a Differential Pair exceeds the phase tolerance constraint." Version="16.300">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>DiffPairVerify</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_DYNAMIC_ACTUAL</r>
          <r>DIFFP_PHASE_TOL_DYNAMIC_MARGIN</r>
          <r>DIFFP_PHASE_TOL_DYNAMIC_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DYNAMIC" Description="Maximum dynamic time/distance for DiffPair to be out-of-phase" Version="16.300">
        <value Kind="MaxConstraint" Category="Bubble">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uPhaseTol" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
          <inheritOnly>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>CnsForAnalysis</s>
            <s>FullyRouted</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_DYNAMIC_ACTUAL</r>
          <r>DIFFP_PHASE_TOL_DYNAMIC_MARGIN</r>
          <r>DIFFP_PHASE_TOL_DYNAMIC_VSTATUS</r>
        </relatedProperties>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DYNAMIC_ACTUAL" Description="DiffPair length tolerance" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uPhaseTol" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>MayUseViaZ</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
            <s>FullyRouted</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_DYNAMIC</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DYNAMIC_MARGIN" Description="DiffPair length tolerance margin" Version="16.300">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uPhaseTol" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_DYNAMIC</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DYNAMIC_VSTATUS" Description="DiffPair length tolerance verification status" Version="16.300">
        <value Kind="VStatus">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>DIFFP_PHASE_TOL_DYNAMIC</r>
        </relatedProperties>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_PHASE_TOL_DYNAMIC_DRC" Description="DiffPair length tolerance DRC object" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFFP_MIN_SPACE" Description="Minimum line spacing for DiffPair" Version="15.000">
        <value Kind="Property" Type="DiffPairLayer" Category="Bubble">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Region</o>
            <o>RegionClass</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <restriction Type="DiffPairMinusVerify">
          <r>DIFFP_PRIMARY_GAP</r>
          <r>DIFFP_NECK_GAP</r>
          <r>DIFFP_COUPLED_MINUS</r>
        </restriction>
      </attribute>
      <attribute Name="DIFFP_MIN_SPACE_ACTUAL" Description="DiffPair minimum line to line spacing" Version="15.000">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis Reason="PASS (Actual not calculated)">
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFFP_MIN_SPACE_DRC" Description="DiffPair minimum line to line spacing DRC object" Version="16.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>DRCVerify</s>
            <s>DiffPairVerify</s>
            <s>DelayRelated</s>
          </flags>
        </analysis>
      </attribute>
      <attribute Name="DIFFP_PRIMARY_GAP_VMODE" Description="Differential Pair verification mode" Version="15.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>DIFFP_UNCOUPLED_LENGTH_VMODE</a>
          <a>DIFFP_PHASE_TOL_VMODE</a>
          <a>DIFFP_MIN_SPACE_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="MIN_LINE_WIDTH" Description="Minimum line width" Version="15.000" extDesc="MIN_LINE_WIDTH.html">
        <value Kind="Property" Type="DiffPairLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <restriction Type="MaxConstraintOrZero">
          <r>MAX_LINE_WIDTH</r>
        </restriction>
      </attribute>
      <attribute Name="MIN_LINE_WIDTH_VMODE" Description="Minimum line width verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_LINE_WIDTH" Description="Maximum line width" Version="16.000" extDesc="MAX_LINE_WIDTH.html">
        <value Kind="Property" Type="DiffPairLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <restriction Type="MinConstraintOrZero">
          <r>MIN_LINE_WIDTH</r>
        </restriction>
      </attribute>
      <attribute Name="MAX_LINE_WIDTH_VMODE" Description="Maximum line width verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFP_NECK_GAP" Description="Neck gap if DiffPair segments reduce to the Neck width" Version="15.000">
        <value Kind="Property" Type="DiffPairLayer" Category="Bubble">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>Region</o>
            <o>RegionClass</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>DiffPairVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>MIN_NECK_WIDTH</r>
          <r>DIFFP_COUPLED_PLUS</r>
          <r>DIFFP_COUPLED_MINUS</r>
          <r>DIFFP_PRIMARY_GAP</r>
          <r>MIN_LINE_WIDTH</r>
        </relatedProperties>
        <restriction Type="DiffPairPlusVerify">
          <r>DIFFP_MIN_SPACE</r>
          <r>DIFFP_COUPLED_MINUS</r>
          <r>DIFFP_PRIMARY_GAP</r>
        </restriction>
      </attribute>
      <attribute Name="MIN_NECK_WIDTH" Description="Width which can be used to neck-through tight areas" Version="15.000">
        <value Kind="Property" Type="DiffPairLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>ElectricalCSet</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="MAXIMUM_NECK_LENGTH" Description="Length which can be used to neck-through tight areas" Version="16.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="CM_OBJECT_LENGTH" Description="Length of an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis MeasureName="Length"/>
      </attribute>
      <attribute Name="CM_OBJECT_PROPDELAY" Description="Delay of an object">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uTime" Name="ns"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinPair</o>
            <o>Result</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis MeasureName="PropDelay"/>
      </attribute>
      <attribute Name="DRAWING_EXTENTS" Description="Extents of the drawing" Version="16.000">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>Drawing</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRAWING_LOWER_LEFT" Description="Lower-left location of the drawing" Version="16.000">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>Drawing</s>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TOPOLOGY_TEMPLATE_REVISION" Description="Applied template or electrical CSet revision number">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="TOPOLOGY_TEMPLATE" Description="Topology template name">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="ASSIGN_TOPOLOGY" Description="Topology template name from schematic">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CDS_XNET_NAME" Description="Property to select or ignore Net for XNet name.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>SELECT</e>
            <e>IGNORE</e>
          </data>
          <flags>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="CDS_EXPORT_CONTENTS_MASK" Description="Data defining contents of last Export\Physical run.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_EDIT_PNS_STATUS" Description="Physical and Spacing Edit status in Front-end.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_NET_GROUP_SYNCED" Description="Net Groups in CM DB have been synced with the connectivity DB">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RIPUP_ETCH" Description="Enable ripup etch during electrical CSet apply">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="ECSET_MAPPING_ERROR" Description="Electrical CSet apply mapping error">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Control</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <inheritOnly>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>NetGroup</o>
          </inheritOnly>
        </objects>
        <analysis>
          <flags>
            <s>ECSetMappingVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>ELECTRICAL_CONSTRAINT_SET</r>
        </relatedProperties>
      </attribute>
      <attribute Name="ECSET_MAPPING_TAG" Description="Property used to resolve ambiguous mapping of Parts and/or Pins" Version="16.600">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>UpperCaseValue</s>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackage>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackage>
        </objects>
        <aliases>
          <a>CDS_MAPPING_PART_TAG</a>
        </aliases>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_XNET_PIN" Description="Xnet Pin which is mapped to the ECSet Pin" Version="16.600">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_XNET_MODE" Description="How XNet Pin was mapped/matched with the ECSet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_TAG" Description="Mapping tag to the ECSet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_GROUP" Description="ECSet Pin group category" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_BUFFER" Description="Buffer model assigned to the ECSet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_VALUE" Description="Value assigned to the ECSet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_ECSET_NETNUM" Description="Net number assigned to the ECSet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_XNET_GROUP" Description="Xnet Pin group category" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_XNET_BUFFER" Description="Buffer model assigned to the Xnet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_XNET_VALUE" Description="Value assigned to the XNet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_MAPPING_XNET_NETNUM" Description="Net number assigned to the Xnet Pin" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Hidden</s>
            <s>NoMerge</s>
            <s>NoFlow</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ECSET_MAPPING_ERROR_MARGIN" Description="Electrical CSet apply mapping margin">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>Control</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>ECSetMappingVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>ELECTRICAL_CONSTRAINT_SET</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PICSET_MAPPING_ERROR" Description="Power Integrity CSet apply mapping error">
        <value Kind="Actual">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Control</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>ComponentClass</o>
            <o>Part</o>
            <o>PartDefn</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>ECSetMappingVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>POWER_INTEGRITY_CONSTRAINT_SET</r>
        </relatedProperties>
      </attribute>
      <attribute Name="PICSET_MAPPING_ERROR_MARGIN" Description="Power Integrity CSet apply mapping margin">
        <value Kind="Result">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>Control</s>
            <s>NoInherit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>ComponentClass</o>
            <o>Part</o>
            <o>PartDefn</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>ECSetMappingVerify</s>
          </flags>
        </analysis>
        <relatedProperties>
          <r>POWER_INTEGRITY_CONSTRAINT_SET</r>
        </relatedProperties>
      </attribute>
      <attribute Name="CDS_OBJECT_KEY" Description="An object's key which is unique for ALL objects and never changes" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMDefined</s>
            <s>CMOnly</s>
            <s>NoEditor</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>ElecCSetPinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_UNROUTED_MINPROP" Description="Enable DRC for Min Prop Delay when PinPair is not fully routed">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
          </flags>
        </analysis>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="DRC_UNROUTED_RELPROP" Description="Enable DRC for Relative Delay when PinPair is not fully routed">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
          </flags>
        </analysis>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="AUTOMATIC_TOPOLOGY_UPDATE" Description="Update topology immediately on electrical CSet changes">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="OVERRIDE_LOCAL_CONSTRAINTS" Description="Replace local constraints during an ECSet apply">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="TOPOLOGY_TEMPLATE_EXTRACT_MODE" Description="Controls what is extracted from a Net to create a top file">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CDS_DI_MAX_PIN_MAPPINGS" Description="Controls the maximum number of Pin mappings">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DI_MAX_NET_MAPPINGS" Description="Controls the maximum number of Net mappings">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DI_MAX_NETS_IN_XNET" Description="Controls the maximum number of Nets in XNets">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DI_MAX_PINS_IN_NET" Description="Controls the maximum number of Pins in Net">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DI_MAX_GATE_PINS" Description="Controls the maximum number of Pins in Gate">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DI_CONTROL_MASK" Description="Controls DI boolean environment variables">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ONLINEFORMULAS_ENABLED" Description="Enable online formula calculations">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="RUN_ANALYSIS_ENABLED" Description="Enable analysis of empty cells during formula calculations">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="FTS_MODE" Description="Fast/Typical/Slow simulation mode">
        <value Kind="Property" Type="Enum">
          <data Type="Array" Storage="Enum">
            <e>Fast</e>
            <e>Typical</e>
            <e>Slow</e>
            <e>Fast/Slow</e>
            <e>Slow/Fast</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SIM_DATA" Description="Simulation data type">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Reflection</e>
            <e>ComprehensiveOdd</e>
            <e>ComprehensiveEven</e>
            <e>ComprehensiveStatic</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="SIM_MEASUREMENT" Description="Simulation measurement type">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Pulse</e>
            <e>Rise/Fall</e>
            <e>Custom</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="AGGRESSOR_SWITCH_MODE" Description="Xtalk aggressor switch mode">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Odd</e>
            <e>Even</e>
            <e>Odd/Even</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="AGGRESSOR_DRIVER_SELECTION" Description="Xtalk aggressor driver selection">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>FastestDriver</e>
            <e>AllDrivers</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="XTALK_TIMING_WINDOWS" Description="Xtalk timing windows">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CREATE_WAVEFORMS" Description="Save waveforms">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CREATE_CIRCUIT" Description="Save circuit file">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="USE_CUSTOM_STIMULUS" Description="Use custom stimulus for custom measurements">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="CREATE_PLANEMODELS" Description="Save plane modeling">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="ONLINE_DRC" Description="On-line DRC">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Y</e>
            <e>N</e>
            <e>R</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ONLINE_INTERLAYER_DRC" Description="On-line Interlayer DRC" extDesc="ONLINE_INTERLAYER_DRC.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_IS_UPTODATE" Description="DRC scope status">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PIN_DELAY" Description="Pin delay is the value (length or time) from the die of the component to the point on the board" Version="15.200">
        <value Kind="PinDelay">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <!-- uPhaseTol is time or length (no %) -->
          <units Type="uPhaseTol" Name="mil"/>
          <flags>
            <s>AskAppForDataOnce</s>
            <s>ForceOverrideAudit</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Result</o>
            <o>PinPair</o>
            <o>ResultPinPair</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
            <s>CheckVMode</s>
          </flags>
        </analysis>
        <domains>
          <d>Electrical</d>
        </domains>
        <allegro Id="337" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PinPair</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="PIN_DELAY_PVF" Description="PinDelay Propagation Velocity Factor">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uVelocity" Name="m/s"/>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
            <s>CheckVMode</s>
          </flags>
        </analysis>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="PIN_DELAY_ENABLED" Description="Include PinDelay in all Propagation Delays and Differential Pair Phase checks">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
          </flags>
        </analysis>
        <aliases>
          <a>PIN_DELAY_VMODE</a>
          <a>PIN_DELAY_PVF_VMODE</a>
        </aliases>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="VIA_Z_PVF" Description="Z Axis Delay Propagation Velocity Factor">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uVelocity" Name="m/s"/>
          <flags>
            <s>Control</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
          </flags>
        </analysis>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="VIA_Z_ENABLED" Description="Include Z Axis Delay in all Propagation Delays and Differential Pair Phase checks">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
            <s>UpdateDelay</s>
          </flags>
        </analysis>
        <aliases>
          <a>VIA_Z_PVF_VMODE</a>
        </aliases>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="SAME_NET_XTALK_ENABLED" Description="Include same net etch in Xtalk and parallelism checks">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_USES_PROPERTIES" Description="Diff pair overrides take precedence over region constraints" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="DIFFP_VIA_STATIC_PHASE" Description="Enable static phase checks at vias." Version="17.240">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <analysis>
          <flags>
            <s>VerifyOnChange</s>
          </flags>
        </analysis>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="FULLY_ROUTED" Description="If defined, the object is fully routed.">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ECSET_PINUSAGE" Description="Pin usage">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElecCSetPin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ELECTRICAL_CONSTRAINT_SET" Description="Electrical Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>NetGroup</o>
            <o>NetClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
          <readOnly>
            <o>Design</o>
          </readOnly>
        </objects>
        <relatedProperties>
          <r>ECSET_MAPPING_ERROR</r>
          <r>ECSET_MAPPING_ERROR_MARGIN</r>
        </relatedProperties>
        <domains>
          <d>Electrical</d>
        </domains>
        <allegro Id="119" AtrPropertyType="DB_DATA_TYPE_NAME">
        </allegro>
      </attribute>
      <attribute Name="PHYSICAL_CONSTRAINT_SET" Description="Physical Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>Region</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>RegionClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <domains>
          <d>Physical</d>
        </domains>
      </attribute>
      <attribute Name="SPACING_CONSTRAINT_SET" Description="Spacing Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>Region</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="DIFFP_SPACING_CONSTRAINT_SET" Description="Intra-Differential Pair Spacing Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>Region</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SAME_NET_SPACING_CONSTRAINT_SET" Description="Same Net Spacing Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>Region</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>RegionClass</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
        </objects>
        <domains>
          <d>SameNetSpacing</d>
        </domains>
      </attribute>
      <attribute Name="POWER_INTEGRITY_CONSTRAINT_SET" Description="Power Integrity Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>ComponentClass</o>
            <o>Part</o>
            <o>PartDefn</o>
          </valid>
          <readOnly>
            <o>Design</o>
          </readOnly>
        </objects>
        <relatedProperties>
          <r>PICSET_MAPPING_ERROR</r>
          <r>PICSET_MAPPING_ERROR_MARGIN</r>
        </relatedProperties>
        <domains>
          <d>PowerIntegrity</d>
        </domains>
      </attribute>
      <attribute Name="ASSEMBLY_CONSTRAINT_SET" Description="Assembly Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoMerge</s>
            <s>WriteCMDBSaveOnly</s>
            <s>ObjectReference</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
            <o>WireProfile</o>
            <o>ComponentClass</o>
            <o>ClassClass</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="CANONICAL_NAME" Description="Canonical name of an object">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Hidden</s>
            <s>CMEditOnly</s>
            <s>NoReport</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>DesignInstance</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>PinPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NET_PHYSICAL_TYPE" Description="Name of physical constraint set to apply (NET_PHYSICAL_TYPE)" Version="15.200">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>UpperCaseValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NET_SPACING_TYPE" Description="Name of spacing constraint set to apply (NET_SPACING_TYPE)" Version="15.200">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>UpperCaseValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VOLTAGE" Description="Voltage of a DC net or operating voltage of a gate" Version="15.200">
        <value Kind="Property" Category="Bubble">
          <data Type="Scalar" Storage="String"/>
          <units Type="uVoltage" Name="V"/>
          <!-- CCMPR01304616: it is used by FE as key => the string itself cannot change, if it's '1v' it must not become '1 V' -->
          <flags>
            <s>Package</s>
            <s>OnlyREDSValidation</s>
            <s>IgnoreConversion</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>Net</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>PowerIntegrityCSet</o>
            <o>PowerRail</o>
            <o>PICSetPowerRail</o>
          </valid>
          <noPackage>
            <o>Bus</o>
            <o>Net</o>
          </noPackage>
        </objects>
        <domains>
          <d>Electrical</d>
          <d>PowerIntegrity</d>
        </domains>
        <allegro Id ="39"  AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Bus</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="VOLTAGE_TO_VALIDATE" Description="Internal!!! Used to validate VOLTAGE string" Version="17.220" DisplayName="Voltage">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uVoltage" Name="V"/>
          <flags>
            <s>Hidden</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>Net</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>PowerIntegrityCSet</o>
            <o>PowerRail</o>
            <o>PICSetPowerRail</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="WEIGHT" Description="Auto-placement value (0 to 100) indicating importance of keeping this net as short as possible (WEIGHT)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_RAT" Description="Whether to display ratsnesting for this net (NO_RAT)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ROUTE_PRIORITY" Description="Net routing priority (ROUTE_PRIORITY)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ROUTE_TO_SHAPE" Description="Whether net can be routed to a shape (ROUTE_TO_SHAPE)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="FIXED" Description="Whether an object can be moved, deleted, ripped up, glossed (FIXED)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Part</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Shape</o>
          </valid>
          <noPackage>
            <o>Net</o>
          </noPackage>
        </objects>
      </attribute>
      <attribute Name="NO_ROUTE" Description="Whether missing connections on this net should be routed (NO_ROUTE)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_RIPUP" Description="Whether router can rip up etch on this net (NO_RIPUP)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_PIN_ESCAPE" Description="Whether router can place pin escapes on this net (NO_PIN_ESCAPE)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Part</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_TEST" Description="Whether test points may be generated for this net (NO_TEST)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPOINT_QUANTITY" Description="The desired number of testpoints on this net (TESTPOINT_QUANTITY)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PROBE_NUMBER" Description="The test probe to be used for this net (PROBE_NUMBER)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BACKDRILL_MAX_PTH_STUB" Description="Maximum plated thru hole stub length allowed on this net with backdrilling (BACKDRILL_MAX_PTH_STUB)" Version="15.700">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Pin</o>

          </valid>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="NO_GLOSS" Description="Whether net should be glossed (NO_GLOSS)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHIELD_NET" Description="Net to use as a shield for this one (SHIELD_NET)" Version="15.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHIELD_TYPE" Description="Type (parallel, tandem, coax) of the shield net (SHIELD_TYPE)" Version="15.200">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="EnumOrString">
            <e>PARALLEL</e>
            <e>TANDEM</e>
            <e>COAX</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="UNUSED_PADS_IGNORE" Description="Pads on this net are to be ignored by dynamic unused pads suppression (UNUSED_PADS_IGNORE)" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>

            <o>Pin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_DIFF_PAIR" Description="Exclude Xnet/Net when automatically creating model-defined DiffPairs" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>CreateSync</s>
            <s>DeleteSync</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFF_PAIR_PINS_POS" Description="Identifies a pin on the positive leg of a Differential Pair." Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinDefn</o>
            <o>Pin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFF_PAIR_PINS_NEG" Description="Identifies a pin on the negative leg of a Differential Pair." Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PinDefn</o>
            <o>Pin</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="JUMPER_LIST" Description="Colon delimited list of jumpers" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RETAIN_NET_ON_VIAS" Description="Vias will retain original Net if the Net is renamed." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
        <aliases>
          <a>STICKY_VIAS</a>
        </aliases>
      </attribute>
      <attribute Name="TERMINATION" Description="Generates when a termination is applied" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TERM_IDENT" Description="Generated when a termination is applied" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PARENT_PPT_PART" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PARENT_PPT" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PARENT_PART_TYPE" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NAME_OF_PART" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LONG_PART_NAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PARENT_CHIPS_PHYS_PART" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PART_NAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_ERR_LOCATION" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Prefix</s>
            <s>Suffix</s>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_ERR_PHYS_NET_NAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFERENTIAL_PAIR" Description="Property used for Concept-CM synchronization" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DIFFPAIR_NAME" Description="Temporary property for new name of Diff Pair in case there is a Diff Pair rename triggered by CM.">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DiffPair</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PDV_INT_SYM_GNAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LIB" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LOCATION" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PN" Description=" " Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noInherit>
            <pair Kind1="Gate" Kind2="Pin"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="CDS_PHYS_PART_NAME" Description=" " Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SEC" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_SEC" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SCHEMATIC_GROUP" Description=" ">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PHYS_NET_NAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoAliasMerge</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Bus</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PNN" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PRIM_FILE" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CHIPS_PART_NAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DS_MAP_VALUE" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DS_MAP_PROPNAME" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DLY" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SUBDESIGN_PREFIX" Description="Generated by PXL on blocks added with block prefix option" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
          </valid>
        </objects>
        <aliases>
          <a>BLOCK_PREFIX</a>
        </aliases>
      </attribute>
      <attribute Name="SUBDESIGN_SUFFIX" Description="Generated by PXL on blocks added with block suffix option" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
          </valid>
        </objects>
        <aliases>
          <a>BLOCK_SUFFIX</a>
        </aliases>
      </attribute>
      <attribute Name="RANGE_START" Description="Generated by PXL on blocks added with block added with range option &amp; specifies starting range" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RANGE_END" Description="Generated by PXL on blocks added with block added with range option &amp; specifies ending range" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_FUNC_IDENT" Description=" " Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PARENT_FUNC_IDENT" Description=" " Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DEFINE_BODY_PAGE" Description="Page where Define body is processed from" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_VHDL_DECS_BODY_PAGE" Description="Page where VHDL_DECS body is processed from" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_DRAWING_BODY_PAGE" Description="Page where DRAWING body is processed from" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SYM_NAME" Description="Functional name of the symbol" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ALT_SYMBOLS" Description="Used to specify a list of alternate package symbol names" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EMC_COMP_TYPE" Description="Specifies the component type" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="EMC_CRITICAL_IC" Description="" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="GROUP" Description="Identifies schematic instances that are to be packaged together" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HEIGHT" Description="Specifies the package height" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="JEDEC_TYPE" Description="Specifies the footprint to be used in the Allegro for component in logical netlist" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ROOM" Description="Instances with same room value are to be packaged and placed together" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="SIGNAL_MODEL" Description="Defines electrical, I/O models and package parasitics model" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageSameValue</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DEFAULT_SIGNAL_MODEL" Description="Defines electrical, I/O models and package parasitics model" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageSameValue</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VOLT_TEMP_SIGNAL_MODEL" Description="Defines electrical, I/O models and package parasitics model" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageSameValue</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ASI_MODEL" Description="Defines electrical, I/O models and package parasitics model" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageSameValue</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TOL" Description="Percent tolerance used by Allegro/APD GenRad interface to prepare .ckt file" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VIA_LIST" Description="A list of via names that can be used for connections in this net" Version="15.500">
        <value Kind="Property" Type="ViaList" MaxLength="-1">
          <data Type="Special" Storage="String"/>
          <!--has special validation-->
          <flags>
            <s>OnlyREDSValidation</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="ALLOW_CONNECT" Description="Allows different types of outputs to be connected without producing errors" Version="15.500">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Bus</o>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackage>
            <o>Bus</o>
            <o>Net</o>
          </noPackage>
        </objects>
      </attribute>
      <attribute Name="BOM_IGNORE" Description="Component instances having this property will not be displayed in the Bill of Materials report" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="BLOCK" Description="Attached to the origin of a block" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_NOT_ON_SYM" Description="Added on pins that belong to split parts that are not initiated on the schematic" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="COMP_NAME" Description="Name of the alternate physical part" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="COMP_NAME_SUFFIX" Description="Appended to the physical part name" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HAS_FIXED_SIZE" Description="Identifies symbols with a fixed size" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SIZE" Description="It identifies those symbols that have a size" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LAST_MODIFIED" Description="Date and time of the last save" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LOCATION" Description="Controls packaging by assigning a particular physical part to a logical component" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Prefix</s>
            <s>Suffix</s>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MERGE_NC_PINS" Description="Merges the NC_PINS in the schematic instance or in the chips.prt or ptf files" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MERGE_POWER_PINS" Description="Add pins to an existing POWER_PINS or NC_PINS property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NC_PINS" Description="Specify pins which are present on a physical package but do not have any logical connections" Version="15.500">
        <value Kind="Property" Delimiter=",">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NEEDS_NO_SIZE" Description="Identify those symbols that do not need SIZE property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_BACKANNOTATE" Description="Used when user does not want properties updated in the schematic" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PATH" Description="Concept add this property on gates" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PART_NUMBER" Description="" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PART_NAME" Description="Specifies the part name" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACK_TYPE" Description="Specifies the type of package used for a part" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACK_IGNORE" Description="Specifies the type of package used for a part" Version="15.500">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="EnumOrString">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACK_SHORT" Description="Specifies the shorting of pins of a part" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PHYS_DES_PREFIX" Description="Specifies the ref des prefix for the default PXL naming pattern" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="POWER_GROUP" Description="Modifies the POWER_PINS property at any given level" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="POWER_PINS" Description="Specifies power and ground pins that exist on the physical part but are not shown on the schematic symbol" Version="15.500">
        <value Kind="Property" Delimiter=";">
          <data Type="Array" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PINCOUNT" Description="Specifies pin count" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>PackageCreatePart</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SPLIT_INST" Description="Added on all split parts of a device" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SPLIT_INST_NAME" Description="Add on all split parts that have to be merged into a single instance in simulation netlist" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SUBDESIGN_MASTER" Description="Identifies which instance in top level design will be used by GEN_SUBDESIGN directive to generate subdesign state files" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VALUE" Description="Used by the Allegro/APD interface to prepare the .ckt file" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VER" Description="Concept (tool) generated property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ROT" Description="Concept (tool) generated property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="XY" Description="Concept (tool) generated property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REUSE_INSTANCE" Description="Package property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>PackageSameValueOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <allegro Id="261" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <allegroOnly>
              <o>Net</o>
            </allegroOnly>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="REUSE_ID" Description="Package property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>PackageSameValue</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REUSE_NAME" Description="Package property" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>DesignInstance</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VOLT_TEMP_MODEL" Description="The voltage temperature model for the pin" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="REF_DES_FOR_ASSIGN" Description="The preferred reference designator when assigning gate (REF_DES_FOR_ASSIGN)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REF_DES_PATTERN" Description="Used for specifying reference designator pattern on instances of block" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SLOTNAME" Description="The preferred slot name when assigning gate (SLOTNAME)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SWAP_GROUP" Description="A group for swapping (SWAP_GROUP)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SCHEMATIC_PLACE_ORDER" Description="Recommended placement order in a generated schematic for instances belonging to the same group" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IGNORE_IN_DOCSCHGEN" Description="Ignore instances while generating schematic so that they don't appear" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ALLOW_CONN_SWAP" Description="Allows connection to be swapped if component Pin are swapped" Version="16.200">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PHYS_PAGE" Description="Concept (tool) generated property" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="USE1" Description="Concept (tool) generated property" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="USE2" Description="Concept (tool) generated property" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LIBRARY1" Description="Concept (tool) generated property" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PSPICE_LOCATION" Description="Designates an identifier to instances for simulation flow" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_POWER_DISS" Description="The power dissipation for the part (MAX_POWER_DISS)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>AskAppForDataOnce</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="MAX_POWER_DISSIPATION" Description="The power dissipation for the part (MAX_POWER_DISSIPATION)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uPower" Name="W"/>
          <flags>
            <s>AskAppForDataOnce</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="PLACE_TAG" Description="The placement tag for the part (PLACE_TAG)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="COMPONENT_WEIGHT" Description="The component weighting for placement (COMPONENT_WEIGHT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="FIX_ALL" Description="Disable all swapping for gates/component (FIX_ALL)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_SWAP_COMP" Description="Disable swapping for component (NO_SWAP_COMP)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>ReadOnly</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_SWAP_GATE" Description="Disable swapping of gates (NO_SWAP_GATE)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_SWAP_GATE_EXT" Description="Extension property to disable swapping of gates (NO_SWAP_GATE_EXT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_SWAP_PIN" Description="Disable swapping of pins (NO_SWAP_PIN)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="J_TEMPERATURE" Description="Component junction temperature (J_TEMPERATURE)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>highSpeed</option>
        </tiering>
      </attribute>
      <attribute Name="HARD_LOCATION" Description="Lock component/gate location (HARD_LOCATION)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DesignInstance</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="AUTO_RENAME" Description="Enable automatic renaming for components (AUTO_RENAME)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PIN_ESCAPE" Description="Enable pin escapes on component/pins (PIN_ESCAPE)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DENSE_COMPONENT" Description="Flag dense components (DENSE_COMPONENT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="AUTO_GENERATED_TERM" Description="Automatically generated termination for components (AUTO_GENERATED_TERM)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="THETA_JB" Description="Theta value JB (THETA_JB)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uThermalResistance" Name="degC/W"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
            <o>Part</o>
          </valid>
          <readOnly>
            <o>PartDefn</o>
          </readOnly>
        </objects>
      </attribute>
      <attribute Name="THETA_JC" Description="Theta value JC (THETA_JC)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uThermalResistance" Name="degC/W"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
            <o>Part</o>
          </valid>
          <readOnly>
            <o>PartDefn</o>
          </readOnly>
        </objects>
      </attribute>
      <attribute Name="COMMENT" Description="The comment attached to the DRC." Version="15.700">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>PartDefn</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
            <o>DRC</o>
            <o>SubClassSubClass</o>
            <o>Shape</o>

            <o>Line</o>
            <o>CLine</o>

            <o>Design</o>
            <o>ClassClass</o>
            <o>Layer</o>
            <o>Group</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>MatchGroup</o>
            <o>Die</o>
            <o>NetClass</o>
            <o>Region</o>
            <o>RatBundle</o>
            <o>NetInterface</o>
            <o>NetGroup</o>
            <o>VoltageDefinition</o>
            <o>WireProfile</o>
          </valid>
          <readOnly>
            <o>PartDefn</o>
          </readOnly>
        </objects>
        <allegro Id="387" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <allegroOnly>
              <o>PhysicalCSet</o>
              <o>SpacingCSet</o>
            </allegroOnly>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="ISRFELEMENT" Description="Is RF Element" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>

            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RFELEMENTTYPE" Description="RF Element Type" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>

            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="RF_TLINE" Description="RF TLine" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REUSE_ALT_MODULE" Description="Reuse ALT Module" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REUSE_MODULE" Description="Reuse Module" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REUSE_PID" Description="Reuse PID" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>Package</s>
            <s>ReadOnly</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>DesignInstance</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_PART_COUNT" Description="Parts Count" Version="16.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_X" Description="The object's origin's x-coordinate." Version="16.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_Y" Description="The object's origin's y-coordinate." Version="16.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_ROTATION" Description="The object's rotation angle." Version="16.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_MIRROR" Description="The object's mirrored flag." Version="16.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_EMBEDDED_LAYER" Description="The object's embedded layer name." Version="16.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_EMBEDDED_STATUS" Description="The object's embedded status." Version="16.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_D_SYMBOL_EMBEDDED_ATTACH" Description="The object's embedded attach." Version="16.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EMB_VIA_CONNECT_PADSTACK" Description="If a symbol is placed and does not contain a property EMB_VIA_CONNECT_PADSTACK, this will be used by default to replace PIN's padstack." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CAVITY2LAYER_CLEARANCE" Description="Defines a clearance or buffer that will be factored in when calculating a component height violation if embedded." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_CAVITY_GAP" Description="Defines the minimum XY spacing between cavities before they will merge." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PLACEBOUND2VIAKEEPOUT_EXPANSION" Description="This will be used to create a cavity outline from PLACEBOUND if library symbol does not contain one. Changing this value will not impact already placed symbols." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VIA_CONNECT_HEIGHT" Description="Defines a constant for the gap between the ETCH layer and the component mounted in the dielectric." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CAVITY2RTKEEPOUT_EXPANSION" Description="This will be used to create a route keepout outline from cavity outline when the symbol protrudes through a layer." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EMBEDDED_PLACEMENT" Description="A component's embedded placement requirement." Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>REQUIRED</e>
            <e>OPTIONAL</e>
            <e>EXTERNAL_ONLY</e>
          </data>
          <flags>
            <s>Package</s>
            <s>PackageSameValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>PartDefn</o>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <readOnly>
            <o>PartDefn</o>
          </readOnly>
          <noPackageNoFlow>
            <o>Part</o>
          </noPackageNoFlow>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="PIN_SIGNAL_MODEL" Description="Pin level override for a buffer model used in signal integrity simulations" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="NO_DRC" Description="Disable DRC checking for this pin or via" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PINUSE" Description="Indicates the type of pin" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="EnumOrString">
            <e>UNSPEC</e>
            <e>POWER</e>
            <e>GROUND</e>
            <e>NC</e>
            <e>IN</e>
            <e>OUT</e>
            <e>BI</e>
            <e>TRI</e>
            <e>OCA</e>
            <e>OCL</e>
          </data>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="PN" Description="Assigns a physical pin number to a logical pin in the schematic" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PIN_TYPE" Description="Attach to a pin to indicate its pin type" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_PIN_TEXT" Description="Property added for Import FPGA" Version="15.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>NoFlow</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_THERMAL_CON_TYPE" Description="Thermal connection type for dynamic shapes (DYN_THERMAL_CON_TYPE)" Version="16.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Enum">
            <e>DIAGONAL</e>
            <e>ORTHOGONAL</e>
            <e>FULL_CONTACT</e>
            <e>8_WAY</e>
            <e>NONE</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_THERMAL_BEST_FIT" Description="Thermal connection best fit for dynamic shapes (DYN_THERMAL_BEST_FIT)" Version="16.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_MIN_THERMAL_CONNS" Description="Minimum thermal connections to dynamic shapes (DYN_MIN_THERMAL_CONNS)" Version="16.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Integer"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_MAX_THERMAL_CONNS" Description="Maximum thermal connections to dynamic shapes (DYN_MAX_THERMAL_CONNS)" Version="16.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Integer"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_OVERSIZE_THERM_WIDTH" Description="Oversized thermal trace width for dynamic shapes (DYN_OVERSIZE_THERM_WIDTH)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
        <allegro Id ="134" AtrPropertyType="DB_DATA_TYPE_DESIGN_UNITS">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Pin</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="DYN_OVERSIZE_THERM_WIDTH_ARRAY" Description="Oversized thermal trace width for dynamic shapes (DYN_OVERSIZE_THERM_WIDTH_ARRAY)" Version="17.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_CLEARANCE_TYPE" Description="Clearance type for dynamic shapes (DYN_CLEARANCE_TYPE)" Version="16.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Enum">
            <e>DRC_VALUE</e>
            <e>ANTI_THERMAL</e>
            <e>NO_VOID</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_CLEARANCE_OVERSIZE" Description="Clearance oversize for dynamic shapes (DYN_CLEARANCE_OVERSIZE)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
        <allegro Id ="140" AtrPropertyType="DB_DATA_TYPE_DESIGN_UNITS">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Pin</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="DYN_CLEARANCE_OVERSIZE_ARRAY" Description="Clearance oversize for dynamic shapes (DYN_CLEARANCE_OVERSIZE_ARRAY)" Version="17.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DYN_FIXED_THERM_WIDTH" Description="Fixed thermal trace width for dynamic shapes (DYN_FIXED_THERM_WIDTH)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>

            <o>Design</o>
          </valid>
        </objects>
        <allegro Id ="360" AtrPropertyType="DB_DATA_TYPE_DESIGN_UNITS">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Pin</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="DYN_FIXED_THERM_WIDTH_ARRAY" Description="Fixed thermal trace width for dynamic shapes (DYN_FIXED_THERM_WIDTH_ARRAY" Version="17.000">
        <value Kind="Property" Type="SparseLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>


          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_SHAPE_CONNECT" Description="Do not connect to shapes (NO_SHAPE_CONNECT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SUBNET_NAME" Description="Subnet of Pin (SUBNET_NAME)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
        <tiering tier="XL"/>
      </attribute>
      <attribute Name="SHORTING_SCHEME" Description="Name of shorting scheme (SHORTING_SCHEME)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>

            <o>Net</o>
          </valid>
        </objects>
        <tiering tier="XL"/>
      </attribute>
      <attribute Name="VOLTAGE_SOURCE_PIN" Description="Voltage supply Pin (VOLTAGE_SOURCE_PIN)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_VIA_CONNECT" Description="Do not connect pin/via (NO_VIA_CONNECT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NET_SHORT" Description="Shorting Net for Pin\Via (NET_SHORT)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="ASSIGN_ROUTE_LAYER" Description="Routing layer for Pin/Net (ASSIGN_ROUTE_LAYER)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DEGAS_NO_VOID" Description="Degassing void required (DEGAS_NO_VOID)" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackage>
            <o>Net</o>
          </noPackage>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="BACKDRILL_EXCLUDE" Description="Backdrill Exclude" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>EXCLUDE_TOP</e>
            <e>EXCLUDE_BOTTOM</e>
            <e>EXCLUDE_BOTH</e>
          </data>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="BACKDRILL_MIN_PIN_PTH" Description="Backdrill Min Pin Plated Thru Hole" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
        <tiering tier="Base"/>
      </attribute>
      <attribute Name="CDS_PARENT_PIN_SPACING" Description="Parent Pin Spacing" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IDF_OWNER" Description="IDF Owner" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ECAD</e>
            <e>MCAD</e>
            <e>UNOWNED</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>

            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LEAD_DIAMETER" Description="Lead Diameter" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_WIREBOND" Description="No Wirebond" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Net</o>
          </valid>
          <noPackage>
            <o>Net</o>
          </noPackage>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="VIA_AT_SMD_FIT" Description="Via at SMD Fit" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
          <noPackageNoFlow>
            <o>Pin</o>
            <o>PinDefn</o>
          </noPackageNoFlow>
        </objects>
      </attribute>
      <attribute Name="PIN_GROUP" Description="Pin level property for defining pin groups" Version="15.700">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ECL" Description="Identifies a high speed net" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="EMC_CRITICAL_NET" Description=" " Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAKE_BASE" Description="Used to declare the name of the signal as the base signal name for all its aliases or synonyms" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PHYS_NET_NAME" Description="Generated by PXL for those logical nets that have their physical nets names different from their logical nets" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
            <s>Prefix</s>
            <s>Suffix</s>
            <s>Package</s>
            <s>NoAliasMerge</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Bus</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BUS_NAME" Description="Generated by PXL for those logical buses that have their physical bus names different from their logical buses" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Prefix</s>
            <s>Suffix</s>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>

            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SIG_NAME" Description="Specifies a net name" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="REMOVE" Description="Used either on bodies in the library or on instances of bodies in the schematic design" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SIM_MAP_VIEW" Description="Overrides the default map file viewlist specified in the simulation configuration" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VERILOG_MODEL" Description="Used to change the name of Verilog module generated or to select a specific MODEL entry in a Verilog map file" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VHDL_INIT" Description="Initial value of the signal for VHDL" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VHDL_MODEL" Description="Used to change the name of the VHDL module generated or to select a specific MODEL entry in a VHDL map file" Version="15.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_TYPE" Description="The type of object (Die, Tile, Driver...)" Version="15.300">
        <value Kind="Actual" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>Die</e>
            <e>Tile</e>
            <e>Driver</e>
          </data>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LEFDEF_ORIG_CASE_MACRO_INS_NAME" Description="The object's original instance name, which may be mixed-case or too long to match the Object name." Version="15.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_NAME" Description="The object's 'cell name' or 'part name'." Version="15.300">
        <!-- For IO_NAME, the Enum list of names will be replaced at runtime with the list of available driver definition names -->
        <value Kind="DerivedData" Type="EnumSpecial">
          <data Type="Scalar" Storage="EnumOrString">
            <e>nil</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_ORDER" Description="The object's order in the buffer sequence (clockwise around ring).." Version="15.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Integer"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_DIE_EDGE" Description="The side of the die (North, South, East, West) the object is aligned with." Version="15.300">
        <value Kind="DerivedData" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>N</e>
            <e>S</e>
            <e>E</e>
            <e>W</e>
            <e>NE</e>
            <e>NW</e>
            <e>SE</e>
            <e>SW</e>
            <e>U</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_OFFSET" Description="The object's distance from the edge it is nearest." Version="15.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_NET_NAME" Description="The names of the nets attached to the object's pins [blank or (pinName) is a 'dummy net']." Version="15.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_ORIENTATION" Description="The mirroring/rotation of the object." Version="15.300">
        <value Kind="DerivedData" Type="EnumSpecial">
          <data Type="Scalar" Storage="Enum">
            <e>N</e>
            <e>FN</e>
            <e>E</e>
            <e>FE</e>
            <e>S</e>
            <e>FS</e>
            <e>W</e>
            <e>FW</e>
            <e>ODD</e>
            <e>FODD</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_X" Description="The object's origin's x-coordinate." Version="15.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_Y" Description="The object's origin's y-coordinate." Version="15.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_WIDTH" Description="The object's definition's width (X-direction)." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_LENGTH" Description="The object's definition's length (Y-direction)." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_MIN_X" Description="The object's extents' minimum x-coordinate." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_MIN_Y" Description="The object's extents' minimum y-coordinate." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_MAX_X" Description="The object's extents' maximum x-coordinate." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="IO_MAX_Y" Description="The object's extents' maximum y-coordinate." Version="15.300">
        <value Kind="Actual">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>IODriver</o>
            <o>IOTile</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_CONSTRAINT_SET" Description="The constraint set containing the violated rule." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_SUBCLASS" Description="The subclass information from the DRC." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_VALUES_REQUIRED" Description="The required values information from the DRC." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_VALUES_ACTUAL" Description="The actual values information from the DRC." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_OBJECT1" Description="The object1 information from the DRC." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_OBJECT2" Description="The object2 information from the DRC." Version="15.500">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DRC</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ALLOW_ON_ETCH_SUBCLASS" Description="Allow this object's etch on this layer" Version="16.000" extDesc="ALLOW_ON_ETCH_SUBCLASS.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="ALLOW_ON_ETCH_SUBCLASS_VMODE" Description="Allow this object's etch on this layer verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TS_ALLOWED" Description="Allow this object's T-points on this layer" Version="16.000" extDesc="TS_ALLOWED.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Enum">
            <e>ANYWHERE</e>
            <e>NOT_ALLOWED</e>
            <e>PINS_ONLY</e>
            <e>PINS_VIAS_ONLY</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TS_ALLOWED_VMODE" Description="Allow this object's T-points on this layer verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_BVIA_STAGGER" Description="Minimum blind/buried via stagger" Version="16.000" extDesc="MIN_BVIA_STAGGER.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <restriction Type="MaxConstraintOrZero">
          <r>MAX_BVIA_STAGGER</r>
        </restriction>
      </attribute>
      <attribute Name="MIN_BVIA_STAGGER_VMODE" Description="Minimum blind/buried via stagger verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_BVIA_STAGGER" Description="Minimum blind/buried via stagger" Version="16.000" extDesc="MAX_BVIA_STAGGER.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <restriction Type="MinConstraintOrZero">
          <r>MIN_BVIA_STAGGER</r>
        </restriction>
      </attribute>
      <attribute Name="MAX_BVIA_STAGGER_VMODE" Description="Maximum blind/buried via stagger verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PAD_PAD_DIRECT_CONNECT" Description="Pad to pad direct connect allowed" Version="16.000" extDesc="PAD_PAD_DIRECT_CONNECT.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Enum">
            <e>ALL_ALLOWED</e>
            <e>VIAS_PINS_ONLY</e>
            <e>VIAS_VIAS_ONLY</e>
            <e>MICROVIAS_MICROVIAS_ONLY</e>
            <e>MICROVIAS_MICROVIAS_COINCIDENT_ONLY</e>
            <e>NOT_ALLOWED</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>PhysicalCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="PAD_PAD_DIRECT_CONNECT_VMODE" Description="Pad to pad direct connect allowed verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_THRUPIN_SPACING" Description="Minimum thru pin to thru pin spacing" Version="16.000" extDesc="THRUPIN_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_THRUPIN_SPACING_VMODE" Description="Minimum thru pin to thru pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_SMDPIN_SPACING" Description="Minimum thru pin to SMD pin spacing" Version="16.000" extDesc="THRUPIN_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_SMDPIN_SPACING_VMODE" Description="Minimum thru pin to SMD pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_THRUPIN_SPACING" Description="Minimum thru pin to test pin spacing" Version="16.000" extDesc="TESTPIN_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_THRUPIN_SPACING_VMODE" Description="Minimum thru pin to test pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_THRUVIA_SPACING" Description="Minimum thru pin to thru via spacing" Version="16.000" extDesc="THRUPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru pin to thru via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_THRUPIN_SPACING" Description="Minimum thru pin to test via spacing" Version="16.000" extDesc="TESTVIA_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_THRUPIN_SPACING_VMODE" Description="Minimum thru pin to test via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_THRUPIN_SPACING" Description="Minimum thru pin to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_THRUPIN_SPACING_VMODE" Description="Minimum thru pin to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_BONDPAD_SPACING" Description="Minimum thru pin to bond finger spacing" Version="16.000" extDesc="THRUPIN_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_BONDPAD_SPACING_VMODE" Description="Minimum thru pin to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_THRUPIN_SPACING" Description="Minimum thru pin to line spacing" Version="16.000" extDesc="LINE_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_THRUPIN_SPACING_VMODE" Description="Minimum thru pin to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_SHAPE_SPACING" Description="Minimum thru pin to shape spacing" Version="16.000" extDesc="THRUPIN_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_TO_SHAPE_SPACING_VMODE" Description="Minimum thru pin to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUPIN_SPACING" Description="Minimum Thru Pin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_THRUPIN_SPACING</r>
          <r>THRUPIN_TO_THRUPIN_SPACING</r>
          <r>THRUPIN_TO_SMDPIN_SPACING</r>
          <r>TESTPIN_TO_THRUPIN_SPACING</r>
          <r>THRUPIN_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_THRUPIN_SPACING</r>
          <r>TESTVIA_TO_THRUPIN_SPACING</r>
          <r>MVIA_TO_THRUPIN_SPACING</r>
          <r>THRUPIN_TO_SHAPE_SPACING</r>
          <r>THRUPIN_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SMDPIN_TO_SMDPIN_SPACING" Description="Minimum SMD pin to SMD pin spacing" Version="16.000" extDesc="SMDPIN_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_SMDPIN_SPACING_VMODE" Description="Minimum SMD pin to SMD pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_TESTPIN_SPACING" Description="Minimum SMD pin to test pin spacing" Version="16.000" extDesc="SMDPIN_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_TESTPIN_SPACING_VMODE" Description="Minimum SMD pin to test pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_THRUVIA_SPACING" Description="Minimum SMD pin to thru via spacing" Version="16.000" extDesc="SMDPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum SMD pin to thru via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_TESTVIA_SPACING" Description="Minimum SMD pin to test via spacing" Version="16.000" extDesc="SMDPIN_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_TESTVIA_SPACING_VMODE" Description="Minimum SMD pin to test via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_SMDPIN_SPACING" Description="Minimum SMD pin to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_SMDPIN_SPACING_VMODE" Description="Minimum SMD pin to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_BONDPAD_SPACING" Description="Minimum SMD pin to bond finger spacing" Version="16.000" extDesc="SMDPIN_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_TO_BONDPAD_SPACING_VMODE" Description="Minimum SMD pin to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_SMDPIN_SPACING" Description="Minimum SMD pin to line spacing" Version="16.000" extDesc="LINE_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_SMDPIN_SPACING_VMODE" Description="Minimum SMD pin to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_SMDPIN_SPACING" Description="Minimum SMD pin to shape spacing" Version="16.000" extDesc="SHAPE_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_SMDPIN_SPACING_VMODE" Description="Minimum SMD pin to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_TESTPIN_SPACING" Description="Minimum test pin to test pin spacing" Version="16.000" extDesc="TESTPIN_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_TESTPIN_SPACING_VMODE" Description="Minimum test pin to test pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_THRUVIA_SPACING" Description="Minimum test pin to thru via spacing" Version="16.000" extDesc="TESTPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum test pin to thru via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_TESTVIA_SPACING" Description="Minimum test pin to test via spacing" Version="16.000" extDesc="TESTPIN_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_TO_TESTVIA_SPACING_VMODE" Description="Minimum test pin to test via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_TESTPIN_SPACING" Description="Minimum test pin to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_TESTPIN_SPACING_VMODE" Description="Minimum test pin to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_TESTPIN_SPACING" Description="Minimum test pin to bond finger spacing" Version="16.000" extDesc="BONDPAD_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_TESTPIN_SPACING_VMODE" Description="Minimum test pin to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_TESTPIN_SPACING" Description="Minimum test pin to line spacing" Version="16.000" extDesc="LINE_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_TESTPIN_SPACING_VMODE" Description="Minimum test pin to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_TESTPIN_SPACING" Description="Minimum test pin to shape spacing" Version="16.000" extDesc="SHAPE_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_TESTPIN_SPACING_VMODE" Description="Minimum test pin to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="THRUVIA_TO_THRUVIA_SPACING" Description="Minimum thru via to thru via spacing" Version="16.000" extDesc="THRUVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="THRUVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to thru via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_THRUVIA_SPACING" Description="Minimum thru via to test via spacing" Version="16.000" extDesc="TESTVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to test via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_THRUVIA_SPACING" Description="Minimum thru via to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_THRUVIA_SPACING" Description="Minimum thru via to bond finger spacing" Version="16.000" extDesc="BONDPAD_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_THRUVIA_SPACING" Description="Minimum thru via to line spacing" Version="16.000" extDesc="LINE_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_THRUVIA_SPACING" Description="Minimum thru via to shape spacing" Version="16.000" extDesc="SHAPE_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_THRUVIA_SPACING_VMODE" Description="Minimum thru via to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_TESTVIA_SPACING" Description="Minimum test via to test via spacing" Version="16.000" extDesc="TESTVIA_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="TESTVIA_TO_TESTVIA_SPACING_VMODE" Description="Minimum test via to test via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_TESTVIA_SPACING" Description="Minimum test via to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_TESTVIA_SPACING_VMODE" Description="Minimum test via to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_TESTVIA_SPACING" Description="Minimum test via to bond finger spacing" Version="16.000" extDesc="BONDPAD_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_TESTVIA_SPACING_VMODE" Description="Minimum test via to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_TESTVIA_SPACING" Description="Minimum test via to line spacing" Version="16.000" extDesc="LINE_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_TESTVIA_SPACING_VMODE" Description="Minimum test via to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_TESTVIA_SPACING" Description="Minimum test via to shape spacing" Version="16.000" extDesc="SHAPE_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_TESTVIA_SPACING_VMODE" Description="Minimum test via to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_BBV_SPACING" Description="Minimum blind/buried via to blind/buried via spacing" Version="16.000" extDesc="BBV_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_BBV_SPACING_VMODE" Description="Minimum blind/buried via to blind/buried via spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_BBV_SPACING" Description="Minimum blind/buried via to bond finger spacing" Version="16.000" extDesc="BONDPAD_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_BBV_SPACING_VMODE" Description="Minimum blind/buried via to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_LINE_SPACING" Description="Minimum blind/buried via to line spacing" Version="16.000" extDesc="BBV_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_LINE_SPACING_VMODE" Description="Minimum blind/buried via to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_SHAPE_SPACING" Description="Minimum blind/buried via to shape spacing" Version="16.000" extDesc="BBV_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BBV_TO_SHAPE_SPACING_VMODE" Description="Minimum blind/buried via to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_BONDPAD_SPACING" Description="Minimum bond finger to bond finger spacing" Version="16.000" extDesc="BONDPAD_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_BONDPAD_SPACING_VMODE" Description="Minimum bond finger to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_LINE_SPACING" Description="Minimum bond finger to line spacing" Version="16.000" extDesc="BONDPAD_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_LINE_SPACING_VMODE" Description="Minimum bond finger to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_SHAPE_SPACING" Description="Minimum bond finger to shape spacing" Version="16.000" extDesc="BONDPAD_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_SHAPE_SPACING_VMODE" Description="Minimum bond finger to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_LINE_SPACING" Description="Minimum line to line spacing" Version="16.000" extDesc="LINE_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_LINE_SPACING_VMODE" Description="Minimum line to line spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_SHAPE_SPACING" Description="Minimum line to shape spacing" Version="16.000" extDesc="LINE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="LINE_TO_SHAPE_SPACING_VMODE" Description="Minimum line to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="LINE_SPACING" Description="Minimum line spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_LINE_SPACING</r>
          <r>LINE_TO_THRUPIN_SPACING</r>
          <r>LINE_TO_SMDPIN_SPACING</r>
          <r>LINE_TO_TESTPIN_SPACING</r>
          <r>LINE_TO_THRUVIA_SPACING</r>
          <r>LINE_TO_TESTVIA_SPACING</r>
          <r>BBV_TO_LINE_SPACING</r>
          <r>MVIA_TO_LINE_SPACING</r>
          <r>LINE_TO_SHAPE_SPACING</r>
          <r>BONDPAD_TO_LINE_SPACING</r>
          <r>HOLE_TO_LINE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SHAPE_TO_SHAPE_SPACING" Description="Minimum shape to shape spacing" Version="16.000" extDesc="SHAPE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SHAPE_TO_SHAPE_SPACING_VMODE" Description="Minimum shape to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_PIN_SPACING" Description="Minimum hole to pin spacing" Version="16.200" extDesc="HOLE_TO_PIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_PIN_SPACING_VMODE" Description="Minimum hole to pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_VIA_SPACING" Description="Minimum hole to via spacing" Version="16.200" extDesc="HOLE_TO_VIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_VIA_SPACING_VMODE" Description="Minimum hole to via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_LINE_SPACING" Description="Minimum hole to line spacing" Version="16.200" extDesc="HOLE_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_LINE_SPACING_VMODE" Description="Minimum hole to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_SHAPE_SPACING" Description="Minimum hole to shape spacing" Version="16.200" extDesc="HOLE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_SHAPE_SPACING_VMODE" Description="Minimum hole to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_HOLE_SPACING" Description="Minimum hole to hole spacing" Version="16.200" extDesc="HOLE_TO_HOLE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="HOLE_TO_HOLE_SPACING_VMODE" Description="Minimum hole to hole spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_MVIA_SPACING" Description="Minimum microvia to microvia spacing" Version="16.200">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_MVIA_SPACING_VMODE" Description="Minimum microvia to microvia spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_THRUPIN_SPACING" Description="Minimum microvia to thru pin spacing" Version="16.200" extDesc="MVIA_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_THRUPIN_SPACING_VMODE" Description="Minimum microvia to thru pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_SMDPIN_SPACING" Description="Minimum microvia to SMD pin spacing" Version="16.200" extDesc="MVIA_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_SMDPIN_SPACING_VMODE" Description="Minimum microvia to SMD pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SMDPIN_SPACING" Description="Minimum SMD Pin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_SMDPIN_SPACING</r>
          <r>THRUPIN_TO_SMDPIN_SPACING</r>
          <r>SMDPIN_TO_SMDPIN_SPACING</r>
          <r>SMDPIN_TO_TESTPIN_SPACING</r>
          <r>SMDPIN_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_SMDPIN_SPACING</r>
          <r>SMDPIN_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_SMDPIN_SPACING</r>
          <r>SHAPE_TO_SMDPIN_SPACING</r>
          <r>SMDPIN_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MVIA_TO_THRUVIA_SPACING" Description="Minimum microvia to thru via spacing" Version="16.200" extDesc="MVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum microvia to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_BBV_SPACING" Description="Minimum microvia to blind/buried via spacing" Version="16.200" extDesc="MVIA_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_BBV_SPACING_VMODE" Description="Minimum microvia to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_LINE_SPACING" Description="Minimum microvia to line spacing" Version="16.200" extDesc="MVIA_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_LINE_SPACING_VMODE" Description="Minimum microvia to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_SHAPE_SPACING" Description="Minimum microvia to shape spacing" Version="16.200" extDesc="MVIA_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_SHAPE_SPACING_VMODE" Description="Minimum microvia to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_TO_TESTPIN_SPACING" Description="Minimum microvia to test pin spacing" Version="16.200" extDesc="MVIA_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_TESTPIN_SPACING_VMODE" Description="Minimum microvia to test pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPIN_SPACING" Description="Minimum Test Pin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_TESTPIN_SPACING</r>
          <r>TESTPIN_TO_THRUPIN_SPACING</r>
          <r>SMDPIN_TO_TESTPIN_SPACING</r>
          <r>TESTPIN_TO_TESTPIN_SPACING</r>
          <r>TESTPIN_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_TESTPIN_SPACING</r>
          <r>TESTPIN_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_TESTPIN_SPACING</r>
          <r>SHAPE_TO_TESTPIN_SPACING</r>
          <r>BONDPAD_TO_TESTPIN_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="MVIA_TO_TESTVIA_SPACING" Description="Minimum microvia to test via spacing" Version="16.200" extDesc="MVIA_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MVIA_TO_TESTVIA_SPACING_VMODE" Description="Minimum microvia to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_TO_MVIA_SPACING" Description="Minimum bond finger to microvia spacing" Version="16.200" extDesc="BONDPAD_TO_MVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="BONDPAD_TO_MVIA_SPACING_VMODE" Description="Minimum bond finger to microvia spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MVIA_SPACING" Description="Minimum Micro Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>MVIA_TO_LINE_SPACING</r>
          <r>MVIA_TO_THRUPIN_SPACING</r>
          <r>MVIA_TO_SMDPIN_SPACING</r>
          <r>MVIA_TO_TESTPIN_SPACING</r>
          <r>MVIA_TO_THRUVIA_SPACING</r>
          <r>MVIA_TO_BBV_SPACING</r>
          <r>MVIA_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_MVIA_SPACING</r>
          <r>MVIA_TO_SHAPE_SPACING</r>
          <r>BONDPAD_TO_MVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="TESTVIA_SPACING" Description="Minimum Test Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_TESTVIA_SPACING</r>
          <r>TESTVIA_TO_THRUPIN_SPACING</r>
          <r>SMDPIN_TO_TESTVIA_SPACING</r>
          <r>TESTPIN_TO_TESTVIA_SPACING</r>
          <r>TESTVIA_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_TESTVIA_SPACING</r>
          <r>TESTVIA_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_TESTVIA_SPACING</r>
          <r>SHAPE_TO_TESTVIA_SPACING</r>
          <r>BONDPAD_TO_TESTVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SHAPE_SPACING" Description="Minimum Shape spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_SHAPE_SPACING</r>
          <r>THRUPIN_TO_SHAPE_SPACING</r>
          <r>SHAPE_TO_SMDPIN_SPACING</r>
          <r>SHAPE_TO_TESTPIN_SPACING</r>
          <r>SHAPE_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_SHAPE_SPACING</r>
          <r>SHAPE_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_SHAPE_SPACING</r>
          <r>SHAPE_TO_SHAPE_SPACING</r>
          <r>BONDPAD_TO_SHAPE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="BONDPAD_SPACING" Description="Minimum Bondpad spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>BONDPAD_TO_LINE_SPACING</r>
          <r>THRUPIN_TO_BONDPAD_SPACING</r>
          <r>SMDPIN_TO_BONDPAD_SPACING</r>
          <r>BONDPAD_TO_TESTPIN_SPACING</r>
          <r>BONDPAD_TO_THRUVIA_SPACING</r>
          <r>BONDPAD_TO_BBV_SPACING</r>
          <r>BONDPAD_TO_TESTVIA_SPACING</r>
          <r>BONDPAD_TO_MVIA_SPACING</r>
          <r>BONDPAD_TO_SHAPE_SPACING</r>
          <r>BONDPAD_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="HOLE_SPACING" Description="Minimum Hole spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>HOLE_TO_LINE_SPACING</r>
          <r>HOLE_TO_PIN_SPACING</r>
          <r>HOLE_TO_VIA_SPACING</r>
          <r>HOLE_TO_SHAPE_SPACING</r>
          <r>HOLE_TO_HOLE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="BBV_SPACING" Description="Minimum Blind/Buried Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>BBV_TO_LINE_SPACING</r>
          <r>BBV_TO_THRUPIN_SPACING</r>
          <r>BBV_TO_SMDPIN_SPACING</r>
          <r>BBV_TO_TESTPIN_SPACING</r>
          <r>BBV_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_BBV_SPACING</r>
          <r>BBV_TO_TESTVIA_SPACING</r>
          <r>MVIA_TO_BBV_SPACING</r>
          <r>BBV_TO_SHAPE_SPACING</r>
          <r>BONDPAD_TO_BBV_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="THRUVIA_SPACING" Description="Minimum Thru Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>LINE_TO_THRUVIA_SPACING</r>
          <r>THRUPIN_TO_THRUVIA_SPACING</r>
          <r>SMDPIN_TO_THRUVIA_SPACING</r>
          <r>TESTPIN_TO_THRUVIA_SPACING</r>
          <r>THRUVIA_TO_THRUVIA_SPACING</r>
          <r>BBV_TO_THRUVIA_SPACING</r>
          <r>TESTVIA_TO_THRUVIA_SPACING</r>
          <r>MVIA_TO_THRUVIA_SPACING</r>
          <r>SHAPE_TO_THRUVIA_SPACING</r>
          <r>BONDPAD_TO_THRUVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SAME_NET" Description="Same net DRC allowed" Version="16.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="MIN_BVIA_GAP" Description="Minimum blind/buried via gap" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="MIN_BVIA_GAP_VMODE" Description="Minimum blind/buried via gap verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_THRUPIN_SPACING" Description="Minimum same net thru pin to thru pin spacing" Version="16.200" extDesc="SN_THRUPIN_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net thru pin to thru pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_SMDPIN_SPACING" Description="Minimum same net thru pin to SMD pin spacing" Version="16.200" extDesc="SN_THRUPIN_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net thru pin to SMD pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_THRUPIN_SPACING" Description="Minimum same net thru pin to test pin spacing" Version="16.200" extDesc="SN_TESTPIN_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net thru pin to test pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_THRUVIA_SPACING" Description="Minimum same net thru pin to thru via spacing" Version="16.200" extDesc="SN_THRUPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru pin to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_THRUPIN_SPACING" Description="Minimum same net thru pin to test via spacing" Version="16.200" extDesc="SN_TESTVIA_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net thru pin to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_THRUPIN_SPACING" Description="Minimum same net thru pin to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net thru pin to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_BONDPAD_SPACING" Description="Minimum same net thru pin to bond finger spacing" Version="16.200" extDesc="SN_THRUPIN_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_BONDPAD_SPACING_VMODE" Description="Minimum same net thru pin to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_THRUPIN_SPACING" Description="Minimum same net thru pin to line spacing" Version="16.200" extDesc="SN_LINE_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net thru pin to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_SHAPE_SPACING" Description="Minimum same net thru pin to shape spacing" Version="16.200" extDesc="SN_THRUPIN_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUPIN_TO_SHAPE_SPACING_VMODE" Description="Minimum same net thru pin to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_SMDPIN_SPACING" Description="Minimum same net SMD pin to SMD pin spacing" Version="16.200" extDesc="SN_SMDPIN_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net SMD pin to SMD pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_TESTPIN_SPACING" Description="Minimum same net SMD pin to test pin spacing" Version="16.200" extDesc="SN_SMDPIN_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net SMD pin to test pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_THRUVIA_SPACING" Description="Minimum same net SMD pin to thru via spacing" Version="16.200" extDesc="SN_SMDPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net SMD pin to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_TESTVIA_SPACING" Description="Minimum same net SMD pin to test via spacing" Version="16.200" extDesc="SN_SMDPIN_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net SMD pin to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_SMDPIN_SPACING" Description="Minimum same net SMD pin to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net SMD pin to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_BONDPAD_SPACING" Description="Minimum same net SMD pin to bond finger spacing" Version="16.200" extDesc="SN_SMDPIN_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SMDPIN_TO_BONDPAD_SPACING_VMODE" Description="Minimum same net SMD pin to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_SMDPIN_SPACING" Description="Minimum same net SMD pin to line spacing" Version="16.200" extDesc="SN_LINE_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net SMD pin to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_SMDPIN_SPACING" Description="Minimum same net SMD pin to shape spacing" Version="16.200" extDesc="SN_SHAPE_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net SMD pin to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_TESTPIN_SPACING" Description="Minimum same net test pin to test pin spacing" Version="16.200" extDesc="SN_TESTPIN_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net test pin to test pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_THRUVIA_SPACING" Description="Minimum same net test pin to thru via spacing" Version="16.200" extDesc="SN_TESTPIN_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net test pin to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_TESTVIA_SPACING" Description="Minimum same net test pin to test via spacing" Version="16.200" extDesc="SN_TESTPIN_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTPIN_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test pin to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_TESTPIN_SPACING" Description="Minimum same net test pin to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net test pin to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_TESTPIN_SPACING" Description="Minimum same net test pin to bond finger spacing" Version="16.200" extDesc="SN_BONDPAD_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net test pin to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_TESTPIN_SPACING" Description="Minimum same net test pin to line spacing" Version="16.200" extDesc="SN_LINE_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net test pin to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_TESTPIN_SPACING" Description="Minimum same net test pin to shape spacing" Version="16.200" extDesc="SN_SHAPE_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net test pin to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_THRUVIA_TO_THRUVIA_SPACING" Description="Minimum same net thru via to thru via spacing" Version="16.200" extDesc="SN_THRUVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_THRUVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_THRUVIA_SPACING" Description="Minimum same net thru via to test via spacing" Version="16.200" extDesc="SN_TESTVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_THRUVIA_SPACING" Description="Minimum same net thru via to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_THRUVIA_SPACING" Description="Minimum same net thru via to bond finger spacing" Version="16.200" extDesc="SN_BONDPAD_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_THRUVIA_SPACING" Description="Minimum same net thru via to line spacing" Version="16.200" extDesc="SN_LINE_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_THRUVIA_SPACING" Description="Minimum same net thru via to shape spacing" Version="16.200" extDesc="SN_SHAPE_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net thru via to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_TESTVIA_SPACING" Description="Minimum same net test via to test via spacing" Version="16.200" extDesc="SN_TESTVIA_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_TESTVIA_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test via to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_TESTVIA_SPACING" Description="Minimum same net test via to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test via to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_TESTVIA_SPACING" Description="Minimum same net test via to bond finger spacing" Version="16.200" extDesc="SN_BONDPAD_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test via to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_TESTVIA_SPACING" Description="Minimum same net test via to line spacing" Version="16.200" extDesc="SN_LINE_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test via to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_TESTVIA_SPACING" Description="Minimum same net test via to shape spacing" Version="16.200" extDesc="SN_SHAPE_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net test via to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_BBV_SPACING" Description="Minimum same net blind/buried via to blind/buried via spacing" Version="16.200" extDesc="SN_BBV_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_BBV_SPACING_VMODE" Description="Minimum same net blind/buried via to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_BBV_SPACING" Description="Minimum same net blind/buried via to bond finger spacing" Version="16.200" extDesc="SN_BONDPAD_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_BBV_SPACING_VMODE" Description="Minimum same net blind/buried via to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_LINE_SPACING" Description="Minimum same net blind/buried via to line spacing" Version="16.200" extDesc="SN_BBV_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_LINE_SPACING_VMODE" Description="Minimum same net blind/buried via to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_SHAPE_SPACING" Description="Minimum same net blind/buried via to shape spacing" Version="16.200" extDesc="SN_BBV_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BBV_TO_SHAPE_SPACING_VMODE" Description="Minimum same net blind/buried via to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_BONDPAD_SPACING" Description="Minimum same net bond finger to bond finger spacing" Version="16.200" extDesc="SN_BONDPAD_TO_BONDPAD_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_BONDPAD_SPACING_VMODE" Description="Minimum same net bond finger to bond finger spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_LINE_SPACING" Description="Minimum same net bond finger to line spacing" Version="16.200" extDesc="SN_BONDPAD_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_LINE_SPACING_VMODE" Description="Minimum same net bond finger to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_SHAPE_SPACING" Description="Minimum same net bond finger to shape spacing" Version="16.200" extDesc="SN_BONDPAD_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_SHAPE_SPACING_VMODE" Description="Minimum same net bond finger to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_LINE_SPACING" Description="Minimum same net line to line spacing" Version="16.200" extDesc="SN_LINE_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_LINE_SPACING_VMODE" Description="Minimum same net line to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_SHAPE_SPACING" Description="Minimum same net line to shape spacing" Version="16.200" extDesc="SN_LINE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_TO_SHAPE_SPACING_VMODE" Description="Minimum same net line to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_SHAPE_SPACING" Description="Minimum same net shape to shape spacing" Version="16.200" extDesc="SN_SHAPE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_SHAPE_TO_SHAPE_SPACING_VMODE" Description="Minimum same net shape to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_PIN_SPACING" Description="Minimum same net hole to pin spacing" Version="16.200" extDesc="SN_HOLE_TO_PIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_PIN_SPACING_VMODE" Description="Minimum same net hole to pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_VIA_SPACING" Description="Minimum same net hole to via spacing" Version="16.200" extDesc="SN_HOLE_TO_VIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_VIA_SPACING_VMODE" Description="Minimum same net hole to via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_LINE_SPACING" Description="Minimum same net hole to line spacing" Version="16.200" extDesc="SN_HOLE_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_LINE_SPACING_VMODE" Description="Minimum same net hole to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_SHAPE_SPACING" Description="Minimum same net hole to shape spacing" Version="16.200" extDesc="SN_HOLE_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_SHAPE_SPACING_VMODE" Description="Minimum same net hole to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_HOLE_SPACING" Description="Minimum same net hole to hole spacing" Version="16.200" extDesc="SN_HOLE_TO_HOLE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="SN_HOLE_TO_HOLE_SPACING_VMODE" Description="Minimum same net hole to hole spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_MVIA_SPACING" Description="Minimum same net microvia to microvia spacing" Version="16.200">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_MVIA_SPACING_VMODE" Description="Minimum same net microvia to microvia spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_THRUPIN_SPACING" Description="Minimum same net microvia to thru pin spacing" Version="16.200" extDesc="SN_MVIA_TO_THRUPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_THRUPIN_SPACING_VMODE" Description="Minimum same net microvia to thru pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_SMDPIN_SPACING" Description="Minimum same net microvia to SMD pin spacing" Version="16.200" extDesc="SN_MVIA_TO_SMDPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_SMDPIN_SPACING_VMODE" Description="Minimum same net microvia to SMD pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_THRUVIA_SPACING" Description="Minimum same net microvia to thru via spacing" Version="16.200" extDesc="SN_MVIA_TO_THRUVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_THRUVIA_SPACING_VMODE" Description="Minimum same net microvia to thru via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_BBV_SPACING" Description="Minimum same net microvia to blind/buried via spacing" Version="16.200" extDesc="SN_MVIA_TO_BBV_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_BBV_SPACING_VMODE" Description="Minimum same net microvia to blind/buried via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_LINE_SPACING" Description="Minimum same net microvia to line spacing" Version="16.200" extDesc="SN_MVIA_TO_LINE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_LINE_SPACING_VMODE" Description="Minimum same net microvia to line spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_SHAPE_SPACING" Description="Minimum same net microvia to shape spacing" Version="16.200" extDesc="SN_MVIA_TO_SHAPE_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_SHAPE_SPACING_VMODE" Description="Minimum same net microvia to shape spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_TESTPIN_SPACING" Description="Minimum same net microvia to test pin spacing" Version="16.200" extDesc="SN_MVIA_TO_TESTPIN_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_TESTPIN_SPACING_VMODE" Description="Minimum same net microvia to test pin spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_MVIA_TO_TESTVIA_SPACING" Description="Minimum same net microvia to test via spacing" Version="16.200" extDesc="SN_MVIA_TO_TESTVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_MVIA_TO_TESTVIA_SPACING_VMODE" Description="Minimum same net microvia to test via spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_MVIA_SPACING" Description="Minimum same net bond finger to microvia spacing" Version="16.200" extDesc="SN_BONDPAD_TO_MVIA_SPACING.html">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="SN_BONDPAD_TO_MVIA_SPACING_VMODE" Description="Minimum same net bond finger to microvia spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SN_LINE_SPACING" Description="Minimum line spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_LINE_SPACING</r>
          <r>SN_LINE_TO_THRUPIN_SPACING</r>
          <r>SN_LINE_TO_SMDPIN_SPACING</r>
          <r>SN_LINE_TO_TESTPIN_SPACING</r>
          <r>SN_LINE_TO_THRUVIA_SPACING</r>
          <r>SN_LINE_TO_TESTVIA_SPACING</r>
          <r>SN_BBV_TO_LINE_SPACING</r>
          <r>SN_MVIA_TO_LINE_SPACING</r>
          <r>SN_LINE_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_LINE_SPACING</r>
          <r>SN_HOLE_TO_LINE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_THRUPIN_SPACING" Description="Minimum Thrupin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_THRUPIN_SPACING</r>
          <r>SN_THRUPIN_TO_THRUPIN_SPACING</r>
          <r>SN_THRUPIN_TO_SMDPIN_SPACING</r>
          <r>SN_TESTPIN_TO_THRUPIN_SPACING</r>
          <r>SN_THRUPIN_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_THRUPIN_SPACING</r>
          <r>SN_TESTVIA_TO_THRUPIN_SPACING</r>
          <r>SN_MVIA_TO_THRUPIN_SPACING</r>
          <r>SN_THRUPIN_TO_SHAPE_SPACING</r>
          <r>SN_THRUPIN_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_SMD_SPACING" Description="Minimum SMD Pin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_SMDPIN_SPACING</r>
          <r>SN_THRUPIN_TO_SMDPIN_SPACING</r>
          <r>SN_SMDPIN_TO_SMDPIN_SPACING</r>
          <r>SN_SMDPIN_TO_TESTPIN_SPACING</r>
          <r>SN_SMDPIN_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_SMDPIN_SPACING</r>
          <r>SN_SMDPIN_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_SMDPIN_SPACING</r>
          <r>SN_SHAPE_TO_SMDPIN_SPACING</r>
          <r>SN_SMDPIN_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_TESTPIN_SPACING" Description="Minimum Test Pin spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_TESTPIN_SPACING</r>
          <r>SN_TESTPIN_TO_THRUPIN_SPACING</r>
          <r>SN_SMDPIN_TO_TESTPIN_SPACING</r>
          <r>SN_TESTPIN_TO_TESTPIN_SPACING</r>
          <r>SN_TESTPIN_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_TESTPIN_SPACING</r>
          <r>SN_TESTPIN_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_TESTPIN_SPACING</r>
          <r>SN_SHAPE_TO_TESTPIN_SPACING</r>
          <r>SN_BONDPAD_TO_TESTPIN_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_THRUVIA_SPACING" Description="Minimum Thru Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_THRUVIA_SPACING</r>
          <r>SN_THRUPIN_TO_THRUVIA_SPACING</r>
          <r>SN_SMDPIN_TO_THRUVIA_SPACING</r>
          <r>SN_TESTPIN_TO_THRUVIA_SPACING</r>
          <r>SN_THRUVIA_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_THRUVIA_SPACING</r>
          <r>SN_TESTVIA_TO_THRUVIA_SPACING</r>
          <r>SN_MVIA_TO_THRUVIA_SPACING</r>
          <r>SN_SHAPE_TO_THRUVIA_SPACING</r>
          <r>SN_BONDPAD_TO_THRUVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_BBV_SPACING" Description="Minimum Blind/Buried Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_BBV_TO_LINE_SPACING</r>
          <r>SN_BBV_TO_THRUPIN_SPACING</r>
          <r>SN_BBV_TO_SMDPIN_SPACING</r>
          <r>SN_BBV_TO_TESTPIN_SPACING</r>
          <r>SN_BBV_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_BBV_SPACING</r>
          <r>SN_BBV_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_BBV_SPACING</r>
          <r>SN_BBV_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_BBV_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_MVIA_SPACING" Description="Minimum Micro Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_MVIA_TO_LINE_SPACING</r>
          <r>SN_MVIA_TO_THRUPIN_SPACING</r>
          <r>SN_MVIA_TO_SMDPIN_SPACING</r>
          <r>SN_MVIA_TO_TESTPIN_SPACING</r>
          <r>SN_MVIA_TO_THRUVIA_SPACING</r>
          <r>SN_MVIA_TO_BBV_SPACING</r>
          <r>SN_MVIA_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_MVIA_SPACING</r>
          <r>SN_MVIA_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_MVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_TESTVIA_SPACING" Description="Minimum Test Via spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_TESTVIA_SPACING</r>
          <r>SN_TESTVIA_TO_THRUPIN_SPACING</r>
          <r>SN_SMDPIN_TO_TESTVIA_SPACING</r>
          <r>SN_TESTPIN_TO_TESTVIA_SPACING</r>
          <r>SN_TESTVIA_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_TESTVIA_SPACING</r>
          <r>SN_TESTVIA_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_TESTVIA_SPACING</r>
          <r>SN_SHAPE_TO_TESTVIA_SPACING</r>
          <r>SN_BONDPAD_TO_TESTVIA_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_SHAPE_SPACING" Description="Minimum Shape spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_LINE_TO_SHAPE_SPACING</r>
          <r>SN_THRUPIN_TO_SHAPE_SPACING</r>
          <r>SN_SHAPE_TO_SMDPIN_SPACING</r>
          <r>SN_SHAPE_TO_TESTPIN_SPACING</r>
          <r>SN_SHAPE_TO_THRUVIA_SPACING</r>
          <r>SN_BBV_TO_SHAPE_SPACING</r>
          <r>SN_SHAPE_TO_TESTVIA_SPACING</r>
          <r>SN_MVIA_TO_SHAPE_SPACING</r>
          <r>SN_SHAPE_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_SHAPE_SPACING</r>
          <r>SN_HOLE_TO_SHAPE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_BONDPAD_SPACING" Description="Minimum Bond Finger spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_BONDPAD_TO_LINE_SPACING</r>
          <r>SN_THRUPIN_TO_BONDPAD_SPACING</r>
          <r>SN_SMDPIN_TO_BONDPAD_SPACING</r>
          <r>SN_BONDPAD_TO_TESTPIN_SPACING</r>
          <r>SN_BONDPAD_TO_THRUVIA_SPACING</r>
          <r>SN_BONDPAD_TO_BBV_SPACING</r>
          <r>SN_BONDPAD_TO_TESTVIA_SPACING</r>
          <r>SN_BONDPAD_TO_MVIA_SPACING</r>
          <r>SN_BONDPAD_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_SHAPE_SPACING</r>
          <r>SN_BONDPAD_TO_BONDPAD_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="SN_HOLE_SPACING" Description="Minimum Hole spacings" Version="17.000">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Super</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>RegionClass</o>
            <o>SameNetSpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>PinPair</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <relatedProperties>
          <r>SN_HOLE_TO_LINE_SPACING</r>
          <r>SN_HOLE_TO_PIN_SPACING</r>
          <r>SN_HOLE_TO_VIA_SPACING</r>
          <r>SN_HOLE_TO_SHAPE_SPACING</r>
          <r>SN_HOLE_TO_HOLE_SPACING</r>
        </relatedProperties>
      </attribute>
      <attribute Name="BONDPAD_TO_BONDPAD_DIFFP_SPC" Description="Minimum same profile bond wire to bond wire spacing for differential pairs" Version="16.200">
        <value Kind="Property" Type="DiffPairLayer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Region</o>
            <o>ClassClass</o>
            <o>RegionClass</o>
            <o>RegionClassClass</o>
            <o>SpacingCSet</o>
            <o>Design</o>
            <o>NetClass</o>
            <o>NetGroup</o>
            <o>DiffPair</o>

            <o>Net</o>
            <o>Xnet</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>PinPair</o>
            <o>NetClass</o>
            <o>NetGroup</o>
          </valid>
          <inheritOnly>
            <o>Design</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="BONDPAD_TO_BONDPAD_DIFFP_SPC_VMODE" Description="Minimum same profile bond wire to bond wire spacing for differential pairs verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_BONDWIRE_SPC" Description="Minimum bond wire to bond wire spacing" Version="16.000" extDesc="BONDWIRE_BONDWIRE_SPC.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
            <o>ClassClass</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_BONDWIRE_SPC_VMODE" Description="Minimum same profile bond wire to bond wire spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_DIFF_PROFILE_SPC" Description="Minimum different profile bond wire to bond wire spacing" Version="16.000" extDesc="BONDWIRE_DIFF_PROFILE_SPC.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>Obsolete</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="BOND_WIRE_CROSSING_LENGTH" Description="Maximum different profile bond wire to bond wire crossing length captured as a percentage" Version="16.000" extDesc="BOND_WIRE_CROSSING_LENGTH.html">
        <value Kind="Property" Type="Percentage">
          <data Type="Array" Storage="Integer"/>
          <units Type="uPercentage" Name="%"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
            <o>ClassClass</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
        <aliases>
          <a>BONDWIRE_CROSSING_LENGTH</a>
        </aliases>
      </attribute>
      <attribute Name="BOND_WIRE_CROSSING_LENGTH_VMODE" Description="Maximum different profile bond wire to bond wire crossing length verification mode" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_DIFF_PROFILE_SPC_VMODE" Description="Minimum different profile bond wire to bond wire spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
            <s>Obsolete</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_BONDWIRE_CONNECT_SPC" Description="Minimum bond wire end to bond wire end spacing" Version="16.000" extDesc="BONDWIRE_BONDWIRE_CONNECT_SPC.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
            <o>ClassClass</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
        <aliases>
          <a>BONDWIRE_BONDWIRE_CONNECTION_SP</a>
        </aliases>
      </attribute>
      <attribute Name="BONDWIRE_BONDWIRE_CONNECT_SPC_VMODE" Description="Minimum bond wire end to bond wire end spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>BONDWIRE_BONDWIRE_CONNECTION_SP_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="BONDWIRE_PIN_SPC" Description="Minimum bond wire to pin spacing" Version="16.000" extDesc="BONDWIRE_PIN_SPC.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_PIN_SPC_VMODE" Description="Minimum bond wire to pin spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_BONDPAD_SPC" Description="Minimum bond wire to bond finger spacing" Version="16.000" extDesc="BONDWIRE_BONDPAD_SPC.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_BONDPAD_SPC_VMODE" Description="Minimum bond wire to bond finger spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_BOND_LENGTH" Description="Minimum bond wire length" Version="16.000" extDesc="MIN_BOND_LENGTH.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="MIN_BOND_LENGTH_VMODE" Description="Minimum bond wire length verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_BOND_LENGTH" Description="Maximum bond wire length" Version="16.000" extDesc="MAX_BOND_LENGTH.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="MAX_BOND_LENGTH_VMODE" Description="Maximum bond wire length verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAX_LINE_EXIT_ANGLE" Description="Maximum bond wire to die edge angle" Version="16.000" extDesc="MAX_LINE_EXIT_ANGLE.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="180"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="MAX_LINE_EXIT_ANGLE_VMODE" Description="Maximum bond wire to die edge angle verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_DIAMETER" Description="Minimum bond wire diameter" Version="16.000" extDesc="BONDWIRE_DIAMETER.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="BONDWIRE_DIAMETER_VMODE" Description="Minimum bond wire diameter verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_COMP_EDGE" Description="Minimum bond finger to component edge spacing" Version="16.000" extDesc="BONDPAD_COMP_EDGE.html">
        <value Kind="Property">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
          <noInherit>
            <pair Kind1="System" Kind2="Design"/>
          </noInherit>
        </objects>
      </attribute>
      <attribute Name="BONDPAD_COMP_EDGE_VMODE" Description="Minimum bond finger to component edge spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACKAGE_PACKAGE_VMODE" Description="Package to package spacing verification mode" Version="16.000" extDesc="PACKAGE_PACKAGE_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACKAGE_KEEPIN_VMODE" Description="Package to keepin spacing verification mode" Version="16.000" extDesc="PACKAGE_KEEPIN_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACKAGE_KEEPOUT_VMODE" Description="Package to keepout spacing verification mode" Version="16.000" extDesc="PACKAGE_KEEPOUT_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ROOM_TYPE_VMODE" Description="Package to room spacing verification mode" Version="16.000" extDesc="ROOM_TYPE_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACKAGE_TO_CAVITY_SPACING" Description="Package to Cavity spacing" Version="16.500" extDesc="PACKAGE_TO_CAVITY_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="PACKAGE_TO_CAVITY_SPACING_VMODE" Description="Package to Cavity verification mode" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PACKAGE_TO_LAYER_SPACING_VMODE" Description="Package Height to Layer verification mode" Version="16.500" extDesc="PACKAGE_TO_LAYER_SPACING_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SHAPE_ISLAND_OVERSIZE" Description="Negative plane islands oversize" Version="16.000" extDesc="SHAPE_ISLAND_OVERSIZE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Physical</d>
        </domains>
      </attribute>
      <attribute Name="SHAPE_ISLAND_OVERSIZE_VMODE" Description="Negative plane islands oversize verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SOLDERMASK_ALIGNMENT" Description="Soldermask alignment tolerance" Version="16.000" extDesc="SOLDERMASK_ALIGNMENT.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SOLDERMASK_ALIGNMENT_VMODE" Description="Soldermask alignment tolerance verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SOLDERMASK_SPACING" Description="Soldermask to soldermask spacing" Version="16.000" extDesc="SOLDERMASK_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SOLDERMASK_SPACING_VMODE" Description="Soldermask to soldermask spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SOLDERMASK_CLINE_SPACING" Description="Soldermask to pad or cline spacing" Version="16.000" extDesc="SOLDERMASK_CLINE_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SOLDERMASK_CLINE_SPACING_VMODE" Description="Soldermask to pad or cline spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SOLDERMASK_SHAPE_SPACING" Description="Soldermask to shape spacing" Version="16.000" extDesc="SOLDERMASK_SHAPE_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SOLDERMASK_SHAPE_SPACING_VMODE" Description="Soldermask to shape spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TPPAD_CMP_SPACING" Description="Testpoint pad to component spacing" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="TPPAD_CMP_SPACING_VMODE" Description="Testpoint pad to component spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TPLOC_CMP_SPACING" Description="Testpoint location to component spacing" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="TPLOC_CMP_SPACING_VMODE" Description="Testpoint location to component spacing verification mode" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="TESTPOINT_ALLOW_UNDER_VMODE" Description="Testpoint allowed under component verification mode" Version="16.000" extDesc="TESTPOINT_ALLOW_UNDER_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_MHOLE_AS_HOLE" Description="Mechanical Drill Hole Checks Use Hole Spacing">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MECH_PIN_TO_MECH_PIN_SPACING" Description="Mechanical pin to mechanical pin spacing" Version="16.200" extDesc="MECH_PIN_TO_MECH_PIN_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>

            <o>Pin</o>
          </valid>
        </objects>
        <aliases>
          <a>MECH_HOLE_TO_MECH_HOLE_SPACING</a>
        </aliases>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MECH_PIN_TO_MECH_PIN_SPACING_VMODE" Description="Mechanical pin to mechanical pin verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>MECH_HOLE_TO_MECH_HOLE_SPACING_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="MECH_PIN_TO_CONDUCTOR_SPACING" Description="Mechanical pin to conductor spacing" Version="16.200" extDesc="MECH_PIN_TO_CONDUCTOR_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>

            <o>Pin</o>
          </valid>
        </objects>
        <aliases>
          <a>MECH_HOLE_TO_CONDUCTOR_SPACING</a>
        </aliases>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MECH_PIN_TO_CONDUCTOR_SPACING_VMODE" Description="Mechanical pin to conductor spacing verification mode" Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>MECH_HOLE_TO_CONDUCTOR_SPACING_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="VIA_AT_SMD_VMODE" Description="Allow vias in SMD pins verification mode" Version="16.200" extDesc="VIA_AT_SMD_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VIA_AT_SMD_FIT_VMODE" Description="Vias in SMD pins must fit entirely inside verification mode" Version="16.200" extDesc="VIA_AT_SMD_FIT_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VIA_AT_SMD_THRU_VMODE" Description="Allow thru vias in SMD pins verification mode" Version="16.200" extDesc="VIA_AT_SMD_THRU_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ETCH_TURN_UNDER_PAD_VMODE" Description="Allow etch turns in SMD pins verification mode" Version="16.200" extDesc="ETCH_TURN_UNDER_PAD_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PASTEMASK_SPACING" Description="Pastemask to pastemask spacing" Version="16.300" extDesc="PASTEMASK_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="PASTEMASK_SPACING_VMODE" Description="Pad pastemask to pad pastemask spacing verification mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NEGATIVE_PLANE_SLIVER_SPACING" Description="Negative plane sliver spacing" Version="16.300" extDesc="NEGATIVE_PLANE_SLIVER_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="NEGATIVE_PLANE_SLIVER_SPACING_VMODE" Description="Negative plane sliver verification mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="VIA_LIST_VMODE" Description="Via List verification mode" Version="16.300" extDesc="VIA_LIST_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PIN_TO_ROUTE_KEEPOUT_VMODE" Description="Pin to route keepout verification mode" Version="16.300" extDesc="PIN_TO_ROUTE_KEEPOUT_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="BBVIA_SEPARATION" Description="BB Via layer separation" Version="16.300" extDesc="BBVIA_SEPARATION.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="SAME_NET_MIN_METAL_SPACING" Description="Minimum same net metal to metal spacing" Version="16.400">
        <!-- Not in use in 16.4. See CCMPR00803396, CCMPR00836312, CCMPR00873280; Keep in dictionary to prevent auto-creation in flow. -->
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>Control</s>
            <s>CMEditOnly</s>
            <s>Hidden</s>
            <s>NoMerge</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>

        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="SAME_NET_MIN_METAL_SPACING_VMODE" Description="Minimum same net metal to metal spacing verification mode" Version="16.400">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
            <s>Hidden</s>
            <s>NoMerge</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MIN_METAL_SPACING" Description="Minimum metal to metal spacing" Version="16.500" extDesc="MIN_METAL_SPACING.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MIN_METAL_SPACING_VMODE" Description="Minimum metal to metal spacing verification mode" Version="16.500">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DUP_DRILL_HOLE_VMODE" Description="Duplicate Drill Hole verification mode" Version="16.500" extDesc="DUP_DRILL_HOLE_VMODE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAXIMUM_CAVITY_SIZE" Description="Maximum cavity area" Version="16.600" extDesc="MAXIMUM_CAVITY_SIZE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil" Dimension="2"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MAXIMUM_CAVITY_SIZE_VMODE" Description="Maximum cavity area verification mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MAXIMUM_CAVITY_COMPONENT_COUNT" Description="Maximum cavity component count" Version="16.600" extDesc="MAXIMUM_CAVITY_COMPONENT_COUNT.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
        <tiering tier="XL">
          <option>miniaturization</option>
        </tiering>
      </attribute>
      <attribute Name="MAXIMUM_CAVITY_COMPONENT_COUNT_VMODE" Description="Maximum cavity component count verification mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CONS_SUB_TYPE_ID" Description="Layer sub-type (used for layer-specific constraint editing) corresponding to this layer (CONS_SUB_TYPE_ID). Available sub-types are defined in $ALLEGRO_SITE/consmgr/LayerSubTypes.xml" Version="17.000">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
        <aliases>
          <a>CDS_LAYER_SUB_TYPE</a>
        </aliases>
      </attribute>
      <attribute Name="CDS_IPC2581_SUB_TYPE" Description="Layer manufacture sub-type corresponding to this layer. Available sub-types are defined in $ALLEGRO_SITE/consmgr/ManufactureLayerSubTypes.xml" Version="17.000">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_MATERIAL" Description="The material of the layer (Air, Copper, FR-4, etc.)." Version="16.000">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_THICKNESS" Description="The layer thickness, in design units." Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uLayerThickness" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_THICKNESS_PLUS" Description="The layer thickness tolerance, in design units" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uLayerThickness" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_THICKNESS_MINUS" Description="The layer thickness tolerance, in design units" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uLayerThickness" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_ELECTRICAL_CONDUCTIVITY" Description="The layer's electrical conductivity." Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uElectricalConductivity" Name="mho/cm"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_DIELECTRIC_CONSTANT" Description="The layer's dielectric constant." Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_LOSS_TANGENT" Description="The layer's loss tangent." Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <range Min="0.0" Max= "0.99"/>
          <flags>
            <s>MustHaveValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_NEGATIVE_ARTWORK" Description="Is the layer's artwork negative?" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_UPS_PINS" Description="Unused Pads Suppression: pins" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_FILLET" Description="Does Layer have 'No_Fillet' property?" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_UPS_VIAS" Description="Unused Pads Suppression: vias" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_DIFF_COUPLING" Description="Diff pair coupling" Version="17.000">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="Enum">
            <e>None</e>
            <e>Edge</e>
            <e>Broadside</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_DIFF_SPACING" Description="Diff pair spacing" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_IS_SHIELD" Description="Is the layer a shield layer?" Version="16.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_PRIMARY_REFERENCE" Description="Is the layer a primary reference layer?" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_XSECT_PVIA_CUT_LAYER" Description="Is the layer a poly via layer?" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_XSECT_DIE_SECTION" Description="Is the layer in die section?" Version="17.40">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_FREQ_DEP_FILE" Description="The frequency-dependent material properties file of the layer." Version="16.200">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_ETCH_FACTOR" Description="The etch factor of the layer, in degrees of arc." Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_EMBEDDED_STATUS" Description="The embedded status of the layer (NON_EMBEDDED, BODY_UP, BODY_DOWN." Version="16.500">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="Enum">
            <e>Not embedded</e>
            <e>Body up</e>
            <e>Body down</e>
            <e>Protruding allowed</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_EMBEDDED_ATTCH" Description="The embedded attach method of the layer (DIRCTECT_ATTACH, INDIRECT_ATTACH)." Version="16.500">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>Direct attach</e>
            <e>Indirect attach</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_LINE_WIDTH" Description="Line width" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_SINGLE_IMPEDANCE" Description="CDS_LAYER_SINGLE_IMPEDANCE" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_DIFFZ0" Description="CDS_LAYER_DIFFZ0" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uResistance" Name="Ohm"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_SI_IGNORE" Description="Ignore layer in Signal Integrity" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_BIAS_INFO" Description="Variant Biasing Info. Set in Define Variants command." Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ILC_TYPE" Description="Check type" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Undefined</e>
            <e>Gap</e>
            <e>Overlap</e>
            <e>1 inside 2</e>
            <e>2 inside 1</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>SubClassSubClass</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="ILC_ENABLED" Description="Specifies whether the rule should be checked" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>SubClassSubClass</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="ILC_SPACING" Description="The spacing value for the rule" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Name="mil" Type="uDesign"/>
          <range Min="0"/>
        </value>
        <objects>
          <valid>
            <o>SubClassSubClass</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="ILC_DRC_LABEL" Description="The label to be shown at the drc marker" Version="17.200">
        <value Kind="Property" MaxLength="1" Format="[a-zA-Z0-9]">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>SubClassSubClass</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="ILC_DRC_SUBCLASS" Description="The subclass DRC errors will be displayed on" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="EnumOrString">
            <e>ALL</e>
            <e>PACKAGE_TOP</e>
            <e>PACKAGE_BOTTOM</e>
            <e>SOLDERMASK_TOP</e>
            <e>SOLDERMASK_BOTTOM</e>
            <e>PASTEMASK_TOP</e>
            <e>PASTEMASK_BOTTOM</e>
            <e>INTER_LAYER</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>SubClassSubClass</o>
          </valid>
        </objects>
        <tiering tier="Base">
          <option>totalEtch</option>
        </tiering>
      </attribute>
      <attribute Name="DYNAMIC_UNUSED_PADS_SUPPRESSION" Description="Dynamic unused pads suppression" Version="17.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DISPLAY_PADLESS_HOLES" Description="Display padless holes" Version="17.000">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <!-- testing the merge -->
      <attribute Name="PLAN_LAYER_MATCH" Description="Consider layer matching during planning." Version="16.100">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_MAX_TRANSITION_COUNT" Description="Maximum number of transitions allowed during planning." Version="16.100">
        <value Kind="Property" Type="EnumOrInteger">
          <data Type="Scalar" Storage="String">
            <e>NL</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_ELONGATION_PATTERN" Description="Pattern type for elongation added in planning." Version="16.100">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>TROMBONE</e>
            <e>ACCORDION</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PLAN_MIN_WRAP_GAP" Description="Accordion pattern: minimum gap in elongation added in planning." Version="16.100">
        <value Kind="Property">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_MIN_AMPLITUDE" Description="Accordion pattern: minimum amplitude of elongation added in planning." Version="16.100">
        <value Kind="Property" Type="EnumOrString">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <restriction Type="MaxConstraint">
          <r>PLAN_MAX_AMPLITUDE</r>
        </restriction>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_MAX_AMPLITUDE" Description="Accordion pattern: maximum amplitude of elongation added in planning." Version="16.100">
        <value Kind="Property" Type="EnumOrString">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <restriction Type="MinConstraint">
          <r>PLAN_MIN_AMPLITUDE</r>
        </restriction>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_CORNER_TYPE" Description="Accordion pattern: corner type for elongation added in planning." Version="16.100">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>90</e>
            <e>45</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_CORNER_LEN" Description="Accordion pattern: corner length in elongation added in planning." Version="16.100">
        <value Kind="Property">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_BUNDLE_SPACING" Description="Spacing between ratsnest bundle members for planning." Version="16.100">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>Default</e>
            <e>MinDRC</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="NO_XNET_CONNECTION" Description="Prevent XNet connection." Version="16.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
            <s>CreateSync</s>
            <s>DeleteSync</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>PartDefn</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
          <readOnly>
            <o>PartDefn</o>
          </readOnly>
        </objects>
        <allegro Id ="537" AtrPropertyType="DB_DATA_TYPE_BOOLEAN">
          <allegro_objects>
            <excludeFromAllegro>
              <o>PartDefn</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="XNET_PINS" Description="Identify Pins used to create XNets." Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>AskAppForDataOnce</s>
            <s>NoReport</s>
            <s>CreateSync</s>
            <s>DeleteSync</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="XNET_DELAY" Description="Propagation delay across an XNet connection." Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <!-- uPhaseTol is time or length (no %) -->
          <units Type="uPhaseTol" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>Package</s>
            <s>AskAppForDataOnce</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
            <o>PinDefn</o>
            <o>Gate</o>
            <o>GateDefn</o>
            <o>Part</o>
            <o>PartDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PLAN_TR_MIN_WRAP_GAP" Description="Trombone pattern: minimum gap in elongation added in planning." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_TR_MIN_AMPLITUDE" Description="Trombone pattern: minimum amplitude of elongation added in planning." Version="16.600">
        <value Kind="Property" Type="EnumOrString">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_TR_MAX_LEVELS" Description="Trombone pattern: maximum levels of elongation added in planning." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_TR_CORNER_TYPE" Description="Trombone pattern: corner type for elongation added in planning." Version="16.600">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>90</e>
            <e>45</e>
          </data>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="PLAN_TR_CORNER_LEN" Description="Trombone pattern: corner length in elongation added in planning." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="DblWUnitsOrEnum">
            <e>NL</e>
          </data>
          <units Type="uDesignOrXWidth" Name="mil"/>
          <flags>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>RatBundle</o>
          </valid>
        </objects>
        <tiering tier="MustHaveOption">
          <option>GreBundlePlan</option>
        </tiering>
      </attribute>
      <attribute Name="NO_PCB_BUNDLE" Description="Prevent automatic bundling of net group." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_OVERHANG_XOVERLAP" Description="Maximum Allowed X-overlap." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_OVERHANG_YOVERLAP" Description="Maximum Allowed Y-overlap." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_OVERHANG_XOVERLAP_VMODE" Description="Die Overhang Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_DIE_OVERHANG_YOVERLAP_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_LWR_DIE_MAX_LAP" Description="Maximum Allowed Die Pad to Lower Die Overlap." Version="16.300">
        <value Kind="MinConstraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>NoUnitStr</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_LWR_DIE_MAX_LAP_VMODE" Description="Die Pad to Lower Die Overhang Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_TO_UPPER_DIE_SPC" Description="Minimum Required Die Pad to Upper Die Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_TO_UPPER_DIE_SPC_VMODE" Description="Die Pad to Upper Die Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_BOND_FNGR_SPC" Description="Minimum Required Die to Bond Finger Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_BOND_FNGR_SPC_VMODE" Description="Die to Bond Finger Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_CNCTD_BOND_FNGR_SPC" Description="Minimum Required Die to Connected Bond Finger Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_CNCTD_BOND_FNGR_SPC_VMODE" Description="Die to Connected Bond Finger Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_DIE_SPC_CNCTD_DIES" Description="Minimum Required Die to Die Spacing, Connected Dies ." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
            <o>ClassClass</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_DIE_SPC_CNCTD_DIES_VMODE" Description="Die to Die Spacing, Connected Dies Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_DIE_SPC_UNCNCTD" Description="Minimum Required Die to Die Spacing, Unconnected Dies ." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
            <o>ComponentClass</o>
            <o>ClassClass</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_DIE_SPC_UNCNCTD_VMODE" Description="Die to Die Spacing, Unconnected Dies Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_PACKAGE_EDGE_SPC" Description="Minimum Required Die to Package Edge Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_TO_PACKAGE_EDGE_SPC_VMODE" Description="Die to Package Edge Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_PITCH_SPC" Description="Minimum Required Die Pad Pitch." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>ComponentClass</o>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_PAD_PITCH_SPC_VMODE" Description="Die Pad Pitch Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_STACK_TO_DIE_STACK_SPC" Description="Minimum Required Die Stack to Die Stack Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_STACK_TO_DIE_STACK_SPC_VMODE" Description="Die Stack to Die Stack Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TOTAL_STACKING_HEIGHT_TOP" Description="Maximum Allowed Die Stack Height on Top Substrate ." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TOTAL_STACKING_HEIGHT_BOT" Description="Maximum Allowed Die Stack Height on Bottom Substrate ." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TOTAL_STACKING_HEIGHT_TOP_VMODE" Description="Total Die Stack Height Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_TOTAL_STACKING_HEIGHT_BOT_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_CNTR_TO_CNTR_DELTA_EXTS" Description="Maximum Allowed Center to Center Delta ( extents based)." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CNTR_TO_CNTR_DELTA_EXTS_VMODE" Description="Center to Center Delta  - extents based- Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CNTR_TO_CNTR_DELTA_PINS" Description="Maximum Allowed Center to Center Delta ( pins based)." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CNTR_TO_CNTR_DELTA_PINS_VMODE" Description="Center to Center Delta  - pins based- Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_LEN_OVER_DIE_MAX" Description="Maximum Bond Wire Length Over Lower Die Stack Member." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_LEN_OVER_DIE_MAX_VMODE" Description="Maximum Bond Wire Length Over Lower Die Stack Member Verification Mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_LEN_OVER_PARENT_DIE" Description="Maximum Bond Wire Length Over Parent Die." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_LEN_OVER_PARENT_DIE_VMODE" Description="Maximum Bond Wire Length Over Parent Die Verification Mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_MAX_ANGL_TO_BOND_FNGR" Description="Maximum Wire to Bond Finger Angle" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="360"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_MAX_ANGL_TO_BOND_FNGR_VMODE" Description="Maximum Wire to Bond Finger Angle Verification Mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_COMPONENT_SPC" Description="Minimum bond wire to component edge spacing" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_COMPONENT_SPC_VMODE" Description="Minimum bond wire to component edge spacing verification mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WR_END_TO_S_MASK_SPC_SHAPE" Description="Minimum Bond Wire Substrate End on Shape to Merged Soldermask Shape Gap" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WR_END_TO_S_MASK_SPC_SHAPE_VMODE" Description="Minimum Bond Wire Substrate End on Shape to Merged Soldermask Gap Verification Mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WR_END_TO_S_MASK_SPC_FNGR" Description="Minimum Bond Wire Substrate End on Bondfinger to Merged Soldermask Shape Gap" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WR_END_TO_S_MASK_SPC_FNGR_VMODE" Description="Minimum Bond Wire Substrate End on Bondfinger to Merged Soldermask Shape Gap Verification Mode" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_ALONG_S_MASK_GAP" Description="Minimum Bond Wire Substrate End on Any Metal To Merged Solder Mask Gap Along the Vector of Wire" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_ALONG_S_MASK_GAP_VMODE" Description="Minimum Bond Wire Substrate End on Any Metal To Merged Solder Mask Gap Along the Vector of Wire Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_FINGER_EDGE_GAP" Description="Minimum Bond Wire Tack Point to Bond Finger Edge Gap" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_FINGER_EDGE_GAP_VMODE" Description="Minimum Bond Wire Tack Point to Bond Finger Edge Gap Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_DIEPIN_EDGE_GAP" Description="Minimum Bond Wire Tack Point to Die Pin Edge Gap" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_DIEPIN_EDGE_GAP_VMODE" Description="Minimum Bond Wire Tack Point to Die Pin Edge Gap Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_SHAPE_GAP" Description="Minimum Bond Wire Tack Point to Connected Metal Edge Gap" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_SHAPE_GAP_VMODE" Description="Minimum Bond Wire Tack Point to Connected Metal Edge Gap Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_ALONG_METAL_GAP" Description="Minimum Bond Wire Tack Point To Merged Connected Metal Gap Along the Vector of Wire" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_ALONG_METAL_GAP_VMODE" Description="Minimum Bond Wire Tack Point To Merged Connected Metal Gap Along the Vector of Wire Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_CAVITY_SPC" Description="Minimum Bond Wire To Cavity Spacing" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_CAVITY_SPC_VMODE" Description="Minimum Bond Wire To Cavity Spacing Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_CAVITY_SPC" Description="Minimum Bond Wire Tack Point To Cavity Spacing" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TACK_PT_TO_CAVITY_SPC_VMODE" Description="Minimum Bond Wire Tack Point To Cavity Spacing Verification Mode" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_SBSTR_MIN" Description="Minimum Value of the Length of the Longer Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MaxConstraint">
          <r>ADRC_OPT_SHRT_DIE_TO_SBSTR_MAX</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_SBSTR_MAX" Description="Maximum Value of the Length of the Longer Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MinConstraint">
          <r>ADRC_OPT_SHRT_DIE_TO_SBSTR_MIN</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_SBSTR_MIN_VMODE" Description="Die to Substrate Optical Short Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_OPT_SHRT_DIE_TO_SBSTR_MAX_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_DIE_MIN" Description="Minimum Value of the Length of the Longer Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MaxConstraint">
          <r>ADRC_OPT_SHRT_DIE_TO_DIE_MAX</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_DIE_MAX" Description="Maximum Value of the Length of the Longer Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MinConstraint">
          <r>ADRC_OPT_SHRT_DIE_TO_DIE_MIN</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_OPT_SHRT_DIE_TO_DIE_MIN_VMODE" Description="Die to Die Optical Short Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_OPT_SHRT_DIE_TO_DIE_MAX_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_PIN_OPT_SHRT_MIN" Description="Minimum Value of the Length of the Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MaxConstraint">
          <r>ADRC_WIRE_TO_PIN_OPT_SHRT_MAX</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_PIN_OPT_SHRT_MAX" Description="Maximum Value of the Length of the Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MinConstraint">
          <r>ADRC_WIRE_TO_PIN_OPT_SHRT_MIN</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_PIN_OPT_SHRT_MIN_VMODE" Description="Die to Die Pad Optical Short Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_WIRE_TO_PIN_OPT_SHRT_MAX_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_FNGR_OPT_SHRT_MIN" Description="Minimum Value of the Length of the Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MaxConstraint">
          <r>ADRC_WIRE_TO_FNGR_OPT_SHRT_MAX</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_FNGR_OPT_SHRT_MAX" Description="Maximum Value of the Length of the Wire" Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="DoubleWUnits"/>
          <units Type="uLengthPercent" Name="um"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
        <restriction Type="MinConstraint">
          <r>ADRC_WIRE_TO_FNGR_OPT_SHRT_MIN</r>
        </restriction>
      </attribute>
      <attribute Name="ADRC_WIRE_TO_FNGR_OPT_SHRT_MIN_VMODE" Description="Die to Bond Finger Optical Short Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_WIRE_TO_FNGR_OPT_SHRT_MAX_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_DIE_FL_TO_DSCR_CMP_PAD_SPC" Description="Minimum Required Die Flag to Discrete Component Pad Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FL_TO_DSCR_CMP_PAD_SPC_VMODE" Description="Die Flag to Discrete Component Pad Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_DIE_FLAG_SPC" Description="Minimum Required Die Flag to Die Flag Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_DIE_FLAG_SPC_VMODE" Description="Die Flag to Die Flag Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_BOND_FNGR_SPC" Description="Minimum Required Die Flag to Bond Finger Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_BOND_FNGR_SPC_VMODE" Description="Die Flag to Bond Finger Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_PACK_EDGE_SPC" Description="Minimum Required Die Flag to Package Edge Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DIE_FLAG_TO_PACK_EDGE_SPC_VMODE" Description="Die Flag to Package Edge Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MINIMUM_SHAPE_CHECK_SPC" Description="Minimum Required Size." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MINIMUM_SHAPE_CHECK_SPC_VMODE" Description="Minimum Shape Check Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MINIMUM_VOID_CHECK_SPC" Description="Minimum Required Size." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MINIMUM_VOID_CHECK_SPC_VMODE" Description="Minimum Void Check Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_SHAPE_BOUNDARY" Description="Minimum Legal Angle." Version="16.600">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_SHAPE_BOUNDARY_VMODE" Description="Acute Angle  Shape Boundary Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="ADRC_COND_SHAPE_VOID_OVERLAP_VMODE" Description="Conductor Shape Void Overlap Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_METAL_CHECK" Description="Minimum Legal Angle." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_METAL_CHECK_VMODE" Description="Acute Angle  Merged Metal Check Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_ROUTING" Description="Minimum Legal Angle." Version="16.600">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ACUTE_ANGLE_ROUTING_VMODE" Description="Acute Angle  Routing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANG_TO_PAD" Description="Minimum Legal Angle." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRC_MIN_ANG_TO_PAD_NO_FNGR" Description="Check Bond Fingers." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANG_TO_PAD_VMODE" Description="Trace Minimum Angle To Pad Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANGLE_TO_SHAPE" Description="Minimum Legal Angle." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANGLE_TO_SHAPE_VMODE" Description="Trace Minimum Angle To Shape Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANGLE_TO_TRACE" Description="Minimum Legal Angle." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TRACE_MIN_ANGLE_TO_TRACE_VMODE" Description="Trace Minimum Angle To Trace Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CONTINUES_S_MASK_COVERAGE_VMODE" Description="Continues Solder Mask Coverage Check Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_DIE_EDGE_SPC" Description="Minimum Required Solder Mask To Die Edge Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_DIE_IGNRE_UNDER" Description="Check Solder Mask Under the Die." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_DIE_EDGE_SPC_VMODE" Description="Solder Mask to Die Edge Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_PACK_EDGE_SPC" Description="Minimum Required Solder Mask To Package Edge Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_PACK_EDGE_SPC_VMODE" Description="Solder Mask to Package Edge Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_S_MASK_SPC" Description="Minimum Required Solder Mask To Solder Mask Spacing." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_S_MASK_TO_S_MASK_SPC_VMODE" Description="Solder Mask to Solder Mask Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SM_SHAPE" Description="Minimum Required Solder Mask Shape Size." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SM_SHAPE_VMODE" Description="Minimum Required Solder Mask Shape Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SM_VOID" Description="Minimum Required Solder Mask Void Size." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SM_VOID_VMODE" Description="Minimum Required Solder Mask Void Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_SM_TO_UNFILLED_DRILL_SPC" Description="Minimum Required Solder Mask To Unfilled Via Drill Spacing." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_SM_TO_UNFILLED_DRILL_SPC_VMODE" Description="Minimum Required Solder Mask To Unfilled Via Drill Spacing Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_SM_TO_FILLED_DRILL_SPC" Description="Minimum Required Solder Mask To Filled Via Drill Spacing." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_SM_TO_FILLED_DRILL_SPC_VMODE" Description="Minimum Required Solder Mask To Filled Via Drill Spacing Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_METAL_TO_METAL_SPC" Description="Minimum Required Any Metal to Any Metal Spacing The Same Net." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MET_TO_MET_SPC_DIFF_NET" Description="Minimum Required Any Metal to Any Metal Spacing Different Net." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_METAL_TO_METAL_ON_OFF" Description="Run / Do Not Run check for the specified layer" Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Enum">
            <e>TRUE</e>
            <e>FALSE</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>

          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_METAL_TO_METAL_SPC_VMODE" Description="Any Metal to Any Metal Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_MET_TO_MET_SPC_DIFF_NET_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_BOND_FNGR_TO_PACK_EDGE_SPC" Description="Minimum Required Bond Finger to Package Substrate Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_BOND_FNGR_TO_PACK_EDGE_SPC_VMODE" Description="Bond Finger to Package Substrate Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_COND_TO_PACKAGE_EDGE_SPC" Description="Minimum Required Conductor to Package Substrate Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_COND_TO_PACKAGE_EDGE_SPC_VMODE" Description="Conductor to Package Substrate Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_EXP_METAL_TO_EXP_METAL_SPC" Description="Minimum Required Exposed Metal To Exposed Metal Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_EXP_METAL_TO_EXP_METAL_SPC_VMODE" Description="Exposed Metal To Exposed Metal Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_VIA_TO_PACKAGE_EDGE_SPC" Description="Minimum Required Via to Package Substrate Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_VIA_TO_PACKAGE_EDGE_SPC_VMODE" Description="Via to Package Substrate Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CLINE_TO_VIA_OVERLAP_VMODE" Description="Cline to Via Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="ADRC_DEGAS_VOID_OVERLAP_SPC" Description="Minimum Required Degassing Void Overlap Spacing. Use 0 for overlap only." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DEGAS_VOID_OVERLAP_SPC_VMODE" Description="Degassing Void Overlap Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DCR_COMP_PAD_BOND_FNGR_SPC" Description="Minimum Required Discrete Component Pad to Bond Finger Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DCR_COMP_PAD_BOND_FNGR_SPC_VMODE" Description="Discrete Component Pad to Bond Finger Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DCR_COMP_PAD_PACK_EDGE_SPC" Description="Minimum Required Discrete Component Pad to Package Edge Spacing." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_DCR_COMP_PAD_PACK_EDGE_SPC_VMODE" Description="Discrete Component Pad to Package Edge Spacing Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_CLINE_SEG_MIN_LEN" Description="Minimum Required Cline Segment Length." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_CLINE_SEG_MIN_LEN_VMODE" Description="Minimum Cline Segment Length Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TOMBSTONE_CHECK_TOLERANCE" Description="Maximum Tolerance." Version="16.300">
        <value Kind="Property" Type="Percentage">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uPercentage" Name="%"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_TOMBSTONE_CHECK_TOLERANCE_VMODE" Description="Tombstone Check Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CLINE_EXT_MIN_LEN" Description="Minimum Required Trace Extension Length." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CLINE_EXT_ANGLE" Description="Maximum Trace Angle To Bond Finger." Version="16.300">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="360"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_CLINE_EXT_MIN_LEN_VMODE" Description="Trace Extension from Bond Finger Verification Mode." Version="16.300">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>ADRC_CLINE_EXT_ANGLE_VMODE</a>
        </aliases>
      </attribute>
      <attribute Name="ADRC_FINGER_TO_CAVITY_SPC" Description="Minimum Required Bond Finger To Cavity Spacing." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_FINGER_TO_CAVITY_SPC_VMODE" Description="Bond Finger To Cavity Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_COMPONENT_TO_CAVITY_SPC" Description="Minimum Required Component To Cavity Spacing." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_COMPONENT_TO_CAVITY_SPC_VMODE" Description="Component To Cavity Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ADRC_ACUTE_ANGLE_CAVITY" Description="Acute Angle Cavity Check." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ADRC_ACUTE_ANGLE_CAVITY_VMODE" Description="Acute Angle Cavity Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SIZE_CAVITY" Description="Minimum Required Cavity Size." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_MIN_SIZE_CAVITY_VMODE" Description="Minimum Cavity Size Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_OBJECT_EXPOSURE_CAVITY_VMODE" Description="Object Exposure to Cavity Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ROUTING_ANGLE" Description="Legal Routing Angle." Version="16.600">
        <value Kind="Property" Type="Layer">
          <data Type="Layer" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="180"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
            <o>AssemblyCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ADRC_ROUTING_ANGLE_VMODE" Description="Routing Angle Verification Mode." Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>ON</e>
            <e>OFF</e>
          </data>
          <flags>
            <s>VMode</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Assembly</d>
        </domains>
      </attribute>
      <attribute Name="WIRE_PROF_DIAMETER" Description="Wire Diameter" Version="16.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="WIRE_PROF_MATERIAL" Description="Wire Material" Version="16.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>WireProfile</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIE_THICKNESS" Description="Die Thickness" Version="16.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIE_ATTACHMENT_TYPE" Description="Attachment Type" Version="16.300">
        <value Kind="DerivedData">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Die</o>
            <o>Interposer</o>
            <o>Spacer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MEMBERSHIP_LOCKED" Description="Lock the membership of an object" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>MODEL_DEFINED</e>
            <e>SCHEMATIC_DEFINED</e>
            <e>CODESIGN_DEFINED</e>
            <e>FSP_DEFINED</e>
            <e>LIBRARY_DEFINED</e>
            <e>SCHEMATIC_LIBRARAY_DEFINED</e>
            <e>NETGROUP_DEFINED</e>
            <e>ACC_DEFINED</e>
          </data>
          <flags>
            <s>NoEditor</s>
            <s>NoReport</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
            <o>NetGroup</o>
            <o>RatBundle</o>
            <o>Bus</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="OBJECT_INSTANCE" Description="Mapped object name">
        <value Kind="Property" Type="IBDMapping">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>ObjectInstance</s>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="INTERFACE_DEFINITION" Description="Interface Definition Name">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
            <o>NetGroup</o>

            <o>VoltageDefinition</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_PRESENCE" Description="If defined, the existance of the port is controlled by the specified value.">
        <value Kind="Property" Type="EnumSpecial">
          <data Type="Scalar" Storage="Enum">
            <e>illegal</e>
            <e>required</e>
            <e>optional</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>CanBeLocked</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_ALLOWABLE_SIZES" Description="List of allowable sizes for replication of a port.  Absence indicates no restriction.">
        <value Kind="Property">
          <data Type="Array" Storage="Integer"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>CanBeLocked</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SIZE" Description="Defines the replication count of a port. The logical numbering of the port starts at 0 to size-1.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="1"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>CanBeLocked</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <restriction Type="MatchOneOf">
          <r>CDS_IBD_ALLOWABLE_SIZES</r>
        </restriction>
      </attribute>
      <attribute Name="CDS_IBD_DIRECTION" Description="If defined, the direction of a port is restricted to the specified value. ">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>in</e>
            <e>out</e>
            <e>inout</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_CONFIGURED" Description="Flag an interface definition as expanded to meet a specific configuration.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>expanded</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_INST_CONFIGURATION" Description="Configuration information for an Interface instance.">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>CMDefined</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_VENDOR" Description="Vendor which supports the Interface">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_LIBRARY" Description="Library name from which the Interface originates">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetInterface</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_VERSION" Description="Version of Interface">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_DISPLAY_NAME" Description="Display name for Interface object">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_DESC" Description="Description of Interface object">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_QUALIFIER" Description="Indicates the type of information a port will carry">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>Address</e>
            <e>Data</e>
            <e>Address_and_Data</e>
            <e>Clock</e>
            <e>Reset</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SYS_GROUP_NAME" Description="Used to group common/shared ports into different groups at the system-level">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>CMEditOnly</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SYS_PRESENCE" Description="Requirements of a common/shared port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>illegal</e>
            <e>required</e>
            <e>optional</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SYS_ALLOWABLE_SIZES" Description="List of allowable sizes of a common/shared port.  Absence indicates no restriction.">
        <value Kind="Property">
          <data Type="Array" Storage="Integer"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SYS_SIZE" Description="Indicates the size of a common/shared port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="1"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <restriction Type="MatchOneOf">
          <r>CDS_IBD_SYS_ALLOWABLE_SIZES</r>
        </restriction>
      </attribute>
      <attribute Name="CDS_IBD_SYS_DIRECTION" Description="Indicates the direction of a common/shared port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>in</e>
            <e>out</e>
            <e>inout</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_MASTER_PRESENCE" Description="If defined, the existance of the port is controlled by the specified value.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>illegal</e>
            <e>required</e>
            <e>optional</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_MASTER_ALLOWABLE_SIZES" Description="List of allowable sizes for replication of a master port. Absence indicates no restriction.">
        <value Kind="Property">
          <data Type="Array" Storage="Integer"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_MASTER_SIZE" Description="Defines the replication count of a master port. Absence indicates size will be specified when interface is instantiated. The logical numbering of the port starts at 0 to size-1.">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="1"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <restriction Type="MatchOneOf">
          <r>CDS_IBD_MASTER_ALLOWABLE_SIZES</r>
        </restriction>
      </attribute>
      <attribute Name="CDS_IBD_MASTER_DIRECTION" Description="If defined, the direction of a master port is restricted to the specified value. ">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>in</e>
            <e>out</e>
            <e>inout</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SLAVE_PRESENCE" Description="Requirements of a slave port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>illegal</e>
            <e>required</e>
            <e>optional</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SLAVE_ALLOWABLE_SIZES" Description="List of allowable sizes of a slave port.  Absence indicates no restriction.">
        <value Kind="Property">
          <data Type="Array" Storage="Integer"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_IBD_SLAVE_SIZE" Description="Indicates the size of a slave port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Integer"/>
          <range Min="1"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoInherit</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
        <restriction Type="MatchOneOf">
          <r>CDS_IBD_SLAVE_ALLOWABLE_SIZES</r>
        </restriction>
      </attribute>
      <attribute Name="CDS_IBD_SLAVE_DIRECTION" Description="Indicates the direction of a slave port">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>in</e>
            <e>out</e>
            <e>inout</e>
          </data>
          <flags>
            <s>CMEditOnly</s>
            <s>ReadOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>NetGroup</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Xnet</o>
            <o>Net</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="PARENT_CLASS" Description="Object's Net Class" Version="16.500">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Control</s>
            <s>ObjectParent</s>
            <s>CMEditOnly</s>
            <s>UpperCaseValue</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Net</o>
            <o>Xnet</o>
            <o>NetGroup</o>
          </valid>
          <parent>
            <o>NetClass</o>
          </parent>
        </objects>
      </attribute>
      <attribute Name="SE_BREAKOUT_IMPEDANCE_EDITOR" Description="Single-ended breakout requirements" Version="16.500">
        <value Kind="Property" Type="DerivedComponents">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Control</s>
            <s>NoEditor</s>
            <s>MustSetAll</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>ElecCSetPin</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Net</o>
            <o>Xnet</o>
            <o>NetGroup</o>
            <o>PinPair</o>
            <o>Pin</o>
          </valid>
        </objects>
        <restriction Type="BreakoutImpedance">
          <r>IMPEDANCE_BREAKOUT_LEN</r>
          <r>IMPEDANCE_BREAKOUT</r>
          <r>IMPEDANCE_BREAKOUT_TOL</r>
        </restriction>
      </attribute>
      <attribute Name="ECSET_IMPEDANCE_BO_RULE" Description="Single-ended breakout bundle for ECSets" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="ECSET_DIFF_IMPEDANCE_BO_RULE" Description="Differential breakout bundle for ECSets" Version="17.200">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DIFFP_BREAKOUT_IMPEDANCE_EDITOR" Description="Differential breakout requirements" Version="16.500">
        <value Kind="Property" Type="DerivedComponents">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Control</s>
            <s>NoEditor</s>
            <s>MustSetAll</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>ElecCSetPin</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>Net</o>
            <o>Xnet</o>
            <o>NetGroup</o>
            <o>PinPair</o>
            <o>Pin</o>
          </valid>
        </objects>
        <restriction Type="BreakoutImpedance">
          <r>DIFFP_IMPEDANCE_BREAKOUT_LEN</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT</r>
          <r>DIFFP_IMPEDANCE_BREAKOUT_TOL</r>
        </restriction>
      </attribute>
      <attribute Name="CDS_FSP_NET" Description="FSP Logical net name" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Pin</o>
            <o>PinDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_FSP_INSTANCE_ID" Description="FSP instance object ID" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_FSP_IS_FPGA" Description="FSP FPGA instance" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_FSP_UID" Description="FSP unique net ID" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_FSP_TERM_TYPE" Description="FSP termination type" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
        <allegro Id ="800" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Part</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CDS_FSP_TERM_NAME" Description="FSP termination name" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
        <allegro Id ="802" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Part</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CDS_FSP_MAPPED_CELL" Description="FSP referenced front-end library and cell" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
        <allegro Id ="801" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Part</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CDS_FSP_TERM_INDEX" Description="FSP termination ID" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
        <allegro Id ="803" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Part</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CDS_FSP_FPGA_SYMBOL" Description="Schematic symbol was generated by FSP" Version="16.600">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Package</s>
            <s>NoEditor</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Part</o>
            <o>Gate</o>
            <o>GateDefn</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
        <allegro Id ="807" AtrPropertyType="DB_DATA_TYPE_STRING">
          <allegro_objects>
            <excludeFromAllegro>
              <o>Part</o>
            </excludeFromAllegro>
          </allegro_objects>
        </allegro>
      </attribute>
      <attribute Name="CDS_SD_BIND_TYPE" Description="SLD source association type" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_SRC_ID" Description="SLD source name" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_SRC_CHECKSUM_PROP" Description="SLD source checksum" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_PCB_PARTITION_NAME" Description="SLD sub-system partition name" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_PCB_PARTITION_COLOR" Description="SLD sub-system partition color" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Gate</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_NET_SRC_ID" Description="SLD source pin spath" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_SD_UNRESOLVED" Description="SLD sub-system pin status" Version="17.250">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>NoEditor</s>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Pin</o>
          </valid>
        </objects>
        <domains>
          <d>NoDomain</d>
        </domains>
      </attribute>
      <attribute Name="CDS_LAYER_NAME" Description="Name of the Layer." Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_ID" Description="Layer's ID." Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DRC_HOLE_IN_PAD" Description="Attribute enables drill to conductor element checking independently of the conductor pad definition status" extDesc="DRC_HOLE_IN_PAD.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="NODRC_SYM_EXPLODED_PINS" Description="This attribute enables suppression of Spacing DRCs on exploded symbol pins" extDesc="NODRC_SYM_EXPLODED_PINS.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>VMode</s>

          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="BACKDRILL_MIN_SPACE" Description="Attribute backdrill minimum space" Version="17.240" extDesc="BACKDRILL_MIN_SPACE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MINIMUM_SHAPE_EDGE_ANGLE" Description="Minimum Shape edge to edge " Version="17.000" extDesc="MINIMUM_SHAPE_EDGE_ANGLE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MINIMUM_SHAPE_EDGE_ANGLE_VMODE" Description="Minimum Shape edge to edge verification mode" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_PAD_ANGLE" Description="Minimum Line to Pad angle " Version="17.000" extDesc="MINIMUM_LINE_TO_PAD_ANGLE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_PAD_ANGLE_VMODE" Description="Trace Minimum Angle to Pad verification mode" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_SHAPE_ANGLE" Description="Minimum Line to Shape angle" Version="17.000" extDesc="MINIMUM_LINE_TO_SHAPE_ANGLE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_SHAPE_ANGLE_VMODE" Description="Minimum Line to Shape angle verification mode" Version="17.000">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_LINE_ANGLE" Description="Minimum Line to Line angle" Version="17.000" extDesc="MINIMUM_LINE_TO_LINE_ANGLE.html">
        <value Kind="Property">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0" Max="90"/>
          <flags>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Spacing</d>
        </domains>
      </attribute>
      <attribute Name="MINIMUM_LINE_TO_LINE_ANGLE_VMODE" Description="Minimum Line to Line angle verification mode" Version="17.0">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="OK_NET_ONE_PIN" Description="Flag single Pin Net as OK" Version="17.0" >
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool"/>
          <flags>
            <s>Package</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Net</o>
            <o>PinDefn</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CONS_MASK_TYPE_ID" Description="Layer mask sub-type" Version="17.200">
        <value Kind="Property" Type="EditOrPickFromList">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_LAYER_FUNCTION" Description="Layer Function" Version="17.200">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="String"/>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="CDS_STACKUP_TYPE" Description="Stackup type" Version="17.200">
        <value Kind="Property" Type="Enum">
          <data Type="Scalar" Storage="Enum">
            <e>Rigid</e>
            <e>Flex</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>Stackup</o>
          </valid>
        </objects>
      </attribute>

      <attribute Name="VIA_STRUCT_LIST" Description="Via stuctures list." Version="17.210">
        <value Kind="Property" >
          <data Type="Array" Storage="String" />
          <flags>
            <s>CMEditOnly</s>
            <s>NoFlow</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>ElectricalCSet</o>
            <o>Xnet</o>
            <o>Net</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>NetInterface</o>
            <o>NetGroup</o>
            <o>NetClass</o>
          </valid>
          <inheritOnly>
            <o>Xnet</o>
            <o>Net</o>
            <o>DiffPair</o>
            <o>Bus</o>
            <o>NetInterface</o>
            <o>NetGroup</o>
            <o>NetClass</o>
          </inheritOnly>
        </objects>
      </attribute>
      <attribute Name="CM_DERATING_RADIUS" Description="Radius column in derating table" Version="17.210">
        <value Kind="Property" Type="TableCol">
          <data Type="Array" Storage="Double"/>
          <units Type="uDesign"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="CM_DERATING_M" Description="M column in derating table" Version="17.210">
        <value Kind="Property" Type="TableCol">
          <data Type="Array" Storage="Double"/>
          <units Type="uLayerThickness"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="CM_DERATING_B" Description="B column in derating table" Version="17.210">
        <value Kind="Property" Type="TableCol">
          <data Type="Array" Storage="Double"/>
          <units Type="uLayerThickness"/>
        </value>
        <objects>
          <valid>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>Electrical</d>
        </domains>
      </attribute>
      <attribute Name="USE_ARC_DERATING" Description ="Use arc derating algorith for the object." Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Bool" />
        </value>
        <objects>
          <valid>
            <o>Xnet</o>
            <o>Net</o>
            <o>Bus</o>
            <o>DiffPair</o>
            <o>NetGroup</o>
          </valid>
        </objects>
      </attribute>
      <attribute Name="DFF_OUTLINE_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFOutlineSCGroup</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFMaskSCGroup</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_ANNULARRING_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_HOLE_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_COPPERFEATURE_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_COPPERSPACING_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_SILKSCREEN_CSET" Description="Design For Fabrication Constraint Set reference">
        <value Kind="ConstraintSetRef" Type="EnumSpecial">
          <data Type="Scalar" Storage="String"/>
          <flags>
            <s>Instances</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFSilkscreenSCGroup</o>
            <o>Stackup</o>
          </valid>
          <parent>
            <o>Stackup</o>
          </parent>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_CSET_INTENT">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>Etch</e>
            <e>Non-Etch</e>
            <e>Stackup</e>
          </data>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
            <o>DFFAnnularRingCSet</o>
            <o>DFFSilkscreenCSet</o>
            <o>DFFCopperFeatureCSet</o>
            <o>DFFCopperSpacingCSet</o>
            <o>DffHoleCSet</o>
            <o>DFFMaskCSet</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_TRACE" Description="Minimum outline to trace spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_TRACE_VMODE" Description="Minimum outline to trace verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <aliases>
          <a>DFF_OUTLINE_TO_TRACE_VMODE</a>
        </aliases>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_SHP" Description="Minimum outline to shape spacing" Version="17.210">
       <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_SHP_VMODE" Description="Minimum outline to shape verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PP" Description="Minimum outline to pin pad spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PP_VMODE" Description="Minimum outline to pin pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPH" Description="Minimum outline to Non plated hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPH_VMODE" Description="Minimum outline to non plated hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_THPNPD" Description="Minimum outline to thrupin pad spacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_THPNPD_VMODE" Description="Minimum outline to plated thrupin verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
            <o>SubClass</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_SMDPN" Description="Minimum outline to smd pin spacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_SMDPN_VMODE" Description="Minimum outline to smd pin verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_VIAPD" Description="Minimum outline to via pad spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_VIAPD_VMODE" Description="Minimum outline to via pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_BBVIAPD" Description="Minimum outline to bb via pad spacing" Version="17.210" Master="DFF_OLN_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_BBVIAPD_VMODE" Description="Minimum outline to bb via pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_UVIAPD" Description="Minimum outline to microvia pad spacing" Version="17.210" Master="DFF_OLN_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_UVIAPD_VMODE" Description="Minimum outline to microvia pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_SLTPD" Description="Minimum outline to slot pad spacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_SLTPD_VMODE" Description="Minimum outline to slot pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_FDCL" Description="Minimum outline to fiducial spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_FDCL_VMODE" Description="Minimum outline to fiducial verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_TOOLHLPD" Description="Minimum outline to toolhole pad spacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_TOOLHLPD_VMODE" Description="Minimum outline to toolhole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPTOOLHL" Description="Minimum outline to Non Plated Tooling hole spacing" Version="17.210" Master="DFF_OLN_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPTOOLHL_VMODE" Description="Minimum outline to Non Plated Tooling hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_MNTHLPD" Description="Minimum outline to mounting hole pad spacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_MNTHLPD_VMODE" Description="Minimum outline to mounting hole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPSLTHL" Description="Minimum outline to Non Plated Slot Hole spacing" Version="17.210" Master="DFF_OLN_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPSLTHL_VMODE" Description="Minimum outline to Non Plated Slot Hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPMNTHL" Description="Minimum outline to non plated mounting hole spacing" Version="17.210" Master="DFF_OLN_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPMNTHL_VMODE" Description="Minimum outline to non plated mounting hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_MECHLPD" Description="Minimum outline to mechanical hole padspacing" Version="17.210" Master="DFF_OLN_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_MECHLPD_VMODE" Description="Minimum outline to mechanical hole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPMECHHL" Description="Minimum outline to non plated mechanical hole spacing" Version="17.210" Master="DFF_OLN_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_NPMECHHL_VMODE" Description="Minimum outline to non plated mechanical hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NSG" Description="Minimum outline to non sig geometry spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NSG_VMODE" Description="Minimum outline to non sig geometry verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_LINE" Description="Minimum outline to Lines spacing" Version="17.210" Master="DFF_OLN_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_LINE_VMODE" Description="Minimum outline to Lines verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_TEXT" Description="Minimum outline to text spacing" Version="17.210" Master="DFF_OLN_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_TEXT_VMODE" Description="Minimum outline to text verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_NSS" Description="Minimum outline to non sig shape spacing" Version="17.210" Master="DFF_OLN_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_NSS_VMODE" Description="Minimum outline to non sig shape verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRUVIA_PAD" Description="Minimum outline to Thru Via Pad spacing" Version="17.210" Master="DFF_OLN_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRUVIA_PAD_VMODE" Description="Minimum outline to Thru Via Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PH" Description="Minimum outline to plated hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PH_VMODE" Description="Minimum outline to plated hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRPIN_HOLE" Description="Minimum outline to Thru pin hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRPIN_HOLE_VMODE" Description="Minimum outline to Thru pin hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRVIA_HOLE" Description="Minimum outline to Via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_THRVIA_HOLE_VMODE" Description="Minimum outline to Via verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_BBVIA_HOLE" Description="Minimum outline to BB via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_BBVIA_HOLE_VMODE" Description="Minimum outline to BB via hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_MICROVIA_HOLE" Description="Minimum outline to Micro via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_MICROVIA_HOLE_VMODE" Description="Minimum outline to Micro via hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PSLTHL" Description="Minimum outline to plated slot hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_PSLTHL_VMODE" Description="Minimum outline to plated slot hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PTOOLHL" Description="Minimum outline to plated mechanical hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_PTOOLHL_VMODE" Description="Minimum outline to plated mechanical hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PMECHHL" Description="Minimum outline to plated mechanical hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_PMECHHL_VMODE" Description="Minimum outline to plated mechanical hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_PL_MOUNTHL" Description="Minimum outline to plated mounting hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_PL_MOUNTHL_VMODE" Description="Minimum outline to plated mounting hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO" Description="Minimum outline to cutout spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Stackup</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_VMODE" Description="Minimum outline to cutout verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_CO" Description="Minimum cutout to cutout spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Stackup</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_CO_VMODE" Description="Minimum cutout to cutout verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TRACE" Description="Minimum cutout to trace spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TRACE_VMODE" Description="Minimum cutout to trace verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SHP" Description="Minimum cutout to shape spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SHP_VMODE" Description="Minimum cutout to shape verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_PP" Description="Minimum cutout to pin pad spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_PP_VMODE" Description="Minimum cutout to pin pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPH" Description="Minimum cutout to non plated hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPH_VMODE" Description="Minimum cutout to non plated hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NSG" Description="Minimum cutout to non sig geometry spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NSG_VMODE" Description="Minimum cutout to non sig geometry verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_LINE" Description="Minimum cutout to Lines spacing" Version="17.210" Master="DFF_OLN_CO_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_LINE_VMODE" Description="Minimum cutout to Lines verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TEXT" Description="Minimum cutout to text spacing" Version="17.210" Master="DFF_OLN_CO_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TEXT_VMODE" Description="Minimum cutout to text verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NSS" Description="Minimum cutout to non sig shape spacing" Version="17.210" Master="DFF_OLN_CO_TO_NSG">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NSS_VMODE" Description="Minimum cutout to non sig shape verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TPINPD" Description="Minimum cutout to thrupin pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TPINPD_VMODE" Description="Minimum cutout to thrupin pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_UVIAPD" Description="Minimum cutout to microvia pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_UVIAPD_VMODE" Description="Minimum cutout to microvia pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SMDPN" Description="Minimum cutout to smd pin spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SMDPN_VMODE" Description="Minimum cutout to smd pin verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_FDCL" Description="Minimum cutout to fiducial spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_FDCL_VMODE" Description="Minimum cutout to fiducial verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_VIAPD" Description="Minimum cutout to via pad spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_VIAPD_VMODE" Description="Minimum cutout to via pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SLTPD" Description="Minimum cutout to slot pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_SLTPD_VMODE" Description="Minimum cutout to slot pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_BBVIA" Description="Minimum cutout to bb via spacing" Version="17.210" Master="DFF_OLN_CO_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_BBVIA_VMODE" Description="Minimum cutout to bb via verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TOOLHLPD" Description="Minimum cutout to tooling hole pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_TOOLHLPD_VMODE" Description="Minimum cutout to tooling hole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPTOOLHL" Description="Minimum cutout to Non Plated Tooling hole spacing" Version="17.210" Master="DFF_OLN_CO_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPTOOLHL_VMODE" Description="Minimum cutout to Non Plated Tooling hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_MNTHLPD" Description="Minimum cutout to mounting hole pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_MNTHLPD_VMODE" Description="Minimum cutout to mounting hole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPSLTHL" Description="Minimum cutout to Non Plated Slot Hole spacing" Version="17.210" Master="DFF_OLN_CO_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPSLTHL_VMODE" Description="Minimum cutout to Non Plated Slot Hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPMNTHL" Description="Minimum cutout to non plated mounting hole spacing" Version="17.210" Master="DFF_OLN_CO_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPMNTHL_VMODE" Description="Minimum cutout to non plated mounting hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_MECHLPD" Description="Minimum cutout to mechanical hole pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_PP">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_MECHLPD_VMODE" Description="Minimum cutout to mechanical hole pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPMECHHL" Description="Minimum cutout to non plated mechanical hole spacing" Version="17.210" Master="DFF_OLN_CO_TO_NPH">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_NPMECHHL_VMODE" Description="Minimum cutout to non plated mechanical hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THVIAPAD" Description="Minimum cutout to Thru Via pad spacing" Version="17.210" Master="DFF_OLN_CO_TO_VIAPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THVIAPAD_VMODE" Description="Minimum cutout to Thru Via Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PH" Description="Minimum cutout to plated hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PH_VMODE" Description="Minimum cutout to plated hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THRPIN_HOLE" Description="Minimum cutout to Thru pin hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THRPIN_HOLE_VMODE" Description="Minimum cutout to Thru pin hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THRVIA_HOLE" Description="Minimum cutout to Via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_CO_TO_THRVIA_HOLE_VMODE" Description="Minimum cutout to Via hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_BBVIA_HOLE" Description="Minimum cutout to BB via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_BBVIA_HOLE_VMODE" Description="Minimum cutout to BB via hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_MICROVIA_HOLE" Description="Minimum cutout to Micro via hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_MICROVIA_HOLE_VMODE" Description="Minimum cutout to Micro via hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PSLTHL" Description="Minimum cutout to plated slot hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PSLTHL_VMODE" Description="Minimum cutout to plated slot hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PMECHHL" Description="Minimum cutout to plated mechanical hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PMECHHL_VMODE" Description="Minimum cutout to plated mechanical hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PTOOLHL" Description="Minimum cutout to plated tooling hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PTOOLHL_VMODE" Description="Minimum cutout to plated tooling hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PMNTHL" Description="Minimum cutout to plated mounting hole spacing" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFOutlineCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>SubClass</o>
            <o>DFFOutlineSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_OLN_TO_CO_PMNTHL_VMODE" Description="Minimum cutout to plated mounting hole verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_SLIVERS" Description="Mask Slivers(Min Spacing width)" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_SLIVERS_VMODE" Description="Mask Slivers(Min Spacing width) verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_SLIVERS_ANGLE" Description="Mask Slivers(Min Angle)" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uAngle" Name="deg"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_SLIVERS_ANGLE_VMODE" Description="Mask Slivers(Min Angle) verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_ISLANDS" Description="Mask Islands" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil" Dimension="2"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_ISLANDS_VMODE" Description="Mask Islands verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_SHPS" Description="Mask opening on Shapes" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil" Dimension="2"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_MSK_SHPS_VMODE" Description="Mask opening on Shapes verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_EXPOSED_ETCH" Description="Exposed Etch" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_MSK_EXPOSED_ETCH_VMODE" Description="Exposed Etch verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MSK_EXPOSED_ETCH_AREA" Description="Exposed Etch Area" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign" Name="mil" Dimension="2"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_MSK_EXPOSED_ETCH_AREA_VMODE" Description="Exposed Etch Area verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_TRACE" Description="Trace to Mask Opening" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_TRACE_VMODE" Description="Trace to Mask Opening verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_SHAPE" Description="Shape to Mask Opening" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_SHAPE_VMODE" Description="Shape to Mask Opening verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_PARTCOV_VIA" Description="Via Partially Covered With Mask Opening" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_PARTCOV_VIA_VMODE" Description="Via Partially Covered With Mask Opening verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_PINPD" Description="Pin Pad to Mask Opening" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_PINPD_VMODE" Description="Pin Pad to Mask Opening verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_VIAPD" Description="Via Pad to Mask Opening" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFMaskCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFMaskSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_MASK_TO_VIAPD_VMODE" Description="Via Pad to Mask Opening verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_TH_MISSNG_MSK" Description="Annular Ring: Thru Pin Missing Mask" Version="17.210" Master="DFF_AR_PN_MISSNG_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_TH_MISSNG_MSK_VMODE" Description="Annular Ring: Thru Pin Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THPD_TO_MSK" Description="Annular Ring: Thru Pin Pad to Mask" Version="17.210" Master="DFF_AR_PNPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THPD_TO_MSK_VMODE" Description="Annular Ring: Thru Pin Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THPD_TO_THRML" Description="Annular Ring: Thru Pin Pad to Thermal" Version="17.210" Master="DFF_AR_PNPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THPD_TO_THRML_VMODE" Description="Annular Ring: Thru Pin Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_MSK" Description="Annular Ring: Plated Pin Hole to Mask" Version="17.210" Master="DFF_AR_PNHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_MSK_VMODE" Description="Annular Ring: Plated Pin Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THHL_TOPD" Description="Annular Ring: Thru Pin Hole to Pad" Version="17.210" Master="DFF_AR_PNHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THHL_TOPD_VMODE" Description="Annular Ring: Thru Pin Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_ANTIPD" Description="Annular Ring: Thru Pin Hole to Antipad" Version="17.210" Master="DFF_AR_PNHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_ANTIPD_VMODE" Description="Annular Ring: Thru Pin Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_THRML" Description="Annular Ring: Thru Pin Hole to Thermal" Version="17.210" Master="DFF_AR_PNHL_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THHL_TO_THRML_VMODE" Description="Annular Ring: Thru Pin Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_TH_BACKDRILL_TOPD" Description="Annular Ring: Thru Pin Backdrill to Pad" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_TH_BACKDRILL_TOPD_VMODE" Description="Annular Ring: Thru Pin Backdrill to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PN_MISSNG_MSK" Description="Annular Ring: Pin Missing Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PN_MISSNG_MSK_VMODE" Description="Annular Ring: Pin Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNPD_TO_MSK" Description="Annular Ring: Pin Pad to Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNPD_TO_MSK_VMODE" Description="Annular Ring: Pin Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNPD_TO_THRML" Description="Annular Ring: Pin Pad to Thermal" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PNPD_TO_THRML_VMODE" Description="Annular Ring: Pin Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_MSK" Description="Annular Ring: Plated Pin Hole to Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_MSK_VMODE" Description="Annular Ring: Plated Pin Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TOPD" Description="Annular Ring: Pin Hole to Pad" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TOPD_VMODE" Description="Annular Ring: Pin Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>
            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_ANTIPD" Description="Annular Ring: Pin Hole to Antipad" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_ANTIPD_VMODE" Description="Annular Ring: Pin Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_THRML" Description="Annular Ring: Pin Hole to Thermal" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PNHL_TO_THRML_VMODE" Description="Annular Ring: Pin Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_MSNGMSK" Description="Annular Ring: Plated Mechanical Pad to Missing Mask" Version="17.210" Master="DFF_AR_PN_MISSNG_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_MSNGMSK_VMODE" Description="Annular Ring: Plated Mechanical Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_TO_MSK" Description="Annular Ring: Plated Mechanical Pad to Mask" Version="17.210" Master="DFF_AR_PNPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_TO_MSK_VMODE" Description="Annular Ring: Plated Mechanical Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_TO_THRML" Description="Annular Ring: Plated Mechanical Pad to Thermal" Version="17.210" Master="DFF_AR_PNPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHPD_TO_THRML_VMODE" Description="Annular Ring: Plated Mechanical Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_MSK" Description="Annular Ring: Plated Mechanical Hole to Mask" Version="17.210" Master="DFF_AR_PNHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_MSK_VMODE" Description="Annular Ring: Plated Mechanical Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TOPD" Description="Annular Ring: Plated Mechanical Hole to Pad" Version="17.210" Master="DFF_AR_PNHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TOPD_VMODE" Description="Annular Ring: Plated Mechanical Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_ANTIPD" Description="Annular Ring: Plated Mechanical Hole to Antipad" Version="17.210" Master="DFF_AR_PNHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_ANTIPD_VMODE" Description="Annular Ring: Plated Mechanical Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_THRML" Description="Annular Ring: Plated Mechanical Hole to Thermal" Version="17.210" Master="DFF_AR_PNHL_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_PMECHHL_TO_THRML_VMODE" Description="Annular Ring: Plated Mechanical Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHPD_MSNGMSK" Description="Annular Ring: Non Plated Mechanical Pad to Missing Mask" Version="17.210" Master="DFF_AR_NP_MISSING_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHPD_MSNGMSK_VMODE" Description="Annular Ring: Non Plated Mechanical Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHPD_TO_MSK" Description="Annular Ring: Non Plated Mechanical Pad to Mask" Version="17.210" Master="DFF_AR_NPPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHPD_TO_MSK_VMODE" Description="Annular Ring: Non Plated Mechanical Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_MSK" Description="Annular Ring: Non Plated Mechanical Hole to Mask" Version="17.210" Master="DFF_AR_NPHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_MSK_VMODE" Description="Annular Ring: Non Plated Mechanical Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TOPD" Description="Annular Ring: Non Plated Mechanical Hole to Pad" Version="17.210" Master="DFF_AR_NPHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TOPD_VMODE" Description="Annular Ring: Non Plated Mechanical Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_ANTIPD" Description="Annular Ring: Non Plated Mechanical Hole to Antipad" Version="17.210" Master="DFF_AR_NPHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_ANTIPD_VMODE" Description="Annular Ring: Non Plated Mechanical Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_THRML" Description="Annular Ring: NonPlated Mechanical Hole to Thermal" Version="17.210" Master="DFF_AR_NPHL_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_NPMECHHL_TO_THRML_VMODE" Description="Annular Ring: NonPlated Mechanical Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_SMDPN_MSNGMSK" Description="Annular Ring: SMD Pin to Missing Mask" Version="17.210" Master="DFF_AR_PN_MISSNG_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_SMDPN_MSNGMSK_VMODE" Description="Annular Ring: SMD Pin to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_SMDPN_TO_MSK" Description="Annular Ring: SMD Pin to Mask" Version="17.210" Master="DFF_AR_PNPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_SMDPN_TO_MSK_VMODE" Description="Annular Ring: SMD Pin to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_SMDPNPD_TO_ANTIPD" Description="Annular Ring: SMD Pin to Antipad" Version="17.210" Master="DFF_AR_PNHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_SMDPNPD_TO_ANTIPD_VMODE" Description="Annular Ring: SMD Pin to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_SMDPNPD_TO_THRML" Description="Annular Ring: SMD Pin to Thermal" Version="17.210" Master="DFF_AR_PNPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_SMDPNPD_TO_THRML_VMODE" Description="Annular Ring: SMD Pin to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_MSNGMSK" Description="Annular Ring: Via Pad to Missing Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_MSNGMSK_VMODE" Description="Annular Ring: Via Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_TO_MSK" Description="Annular Ring: Via Pad to Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_TO_MSK_VMODE" Description="Annular Ring: Via Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_TO_THRML" Description="Annular Ring: Via Pad to Thermal" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAPD_TO_THRML_VMODE" Description="Annular Ring: Via Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_MSK" Description="Annular Ring: Via Hole to Mask" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_MSK_VMODE" Description="Annular Ring: Via Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TOPD" Description="Annular Ring: Via Hole to Pad" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TOPD_VMODE" Description="Annular Ring: Via Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_ANTIPD" Description="Annular Ring: Via Hole to Antipad" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_ANTIPD_VMODE" Description="Annular Ring: Via Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_THRML" Description="Annular Ring: Via Hole to Thermal" Version="17.210">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_VIAHL_TO_THRML_VMODE" Description="Annular Ring: Via Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_MSNGMSK" Description="Annular Ring: Thru Via Pad to Missing Mask" Version="17.210" Master="DFF_AR_VIAPD_MSNGMSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_MSNGMSK_VMODE" Description="Annular Ring: Thru Via Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_TO_MSK" Description="Annular Ring: Thru Via Pad to Mask" Version="17.210" Master="DFF_AR_VIAPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_TO_MSK_VMODE" Description="Annular Ring: Thru Via Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_TO_THRML" Description="Annular Ring: Thru Via Pad to Thermal" Version="17.210" Master="DFF_AR_VIAPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAPD_TO_THRML_VMODE" Description="Annular Ring: Thru Via Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_MSK" Description="Annular Ring: Thru Via Hole to Mask" Version="17.210" Master="DFF_AR_VIAHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_MSK_VMODE" Description="Annular Ring: Thru Via Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TOPD" Description="Annular Ring: Thru Via Hole to Pad" Version="17.210" Master="DFF_AR_VIAHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TOPD_VMODE" Description="Annular Ring: Thru Via Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_ANTIPD" Description="Annular Ring: Thru Via Hole to Antipad" Version="17.210" Master="DFF_AR_VIAHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_ANTIPD_VMODE" Description="Annular Ring: Thru Via Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_THRML" Description="Annular Ring: Thru Via Hole to Thermal" Version="17.210" Master="DFF_AR_VIAHL_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THVIAHL_TO_THRML_VMODE" Description="Annular Ring: Thru Via Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_TH_BACKDRILL_TOVIA" Description="Annular Ring: Thru Pin Backdrill to Via" Version="17.25">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_TH_BACKDRILL_TOVIA_VMODE" Description="Annular Ring: Thru Pin Backdrill to Via verification Mode" Version="17.25">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THRPN_BDRL_ANTPD" Description="Annular Ring: Thru Pin Backdrill to Antipad" Version="17.25">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THRPN_BDRL_ANTPD_VMODE" Description="Annular Ring: Thru Pin Backdrill to Antipad verification Mode" Version="17.25">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THRVIA_BDRL_ANTPD" Description="Annular Ring: Thru Via Backdrill to Antipad" Version="17.25">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THRVIA_BDRL_ANTPD_VMODE" Description="Annular Ring: Thru Via Backdrill to Antipad verification Mode" Version="17.25">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THRPN_BDRL_MSK" Description="Annular Ring: Thru Pin Backdrill to Mask" Version="17.25">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THRPN_BDRL_MSK_VMODE" Description="Annular Ring: Thru Pin Backdrill to Mask verification Mode" Version="17.25">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_THRVIA_BDRL_MSK" Description="Annular Ring: Thru Via Backdrill to Mask" Version="17.25">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_THRVIA_BDRL_MSK_VMODE" Description="Annular Ring: Thru Via Backdrill to Mask verification Mode" Version="17.25">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_MSNGMSK" Description="Annular Ring: BBVia Pad to Missing Mask" Version="17.210" Master="DFF_AR_VIAPD_MSNGMSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_MSNGMSK_VMODE" Description="Annular Ring: BBVia Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_TO_MSK" Description="Annular Ring: BBVia Pad to Mask" Version="17.210" Master="DFF_AR_VIAPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_TO_MSK_VMODE" Description="Annular Ring: BBVia Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_TO_THRML" Description="Annular Ring: BBVia Pad to Thermal" Version="17.210" Master="DFF_AR_VIAPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAPD_TO_THRML_VMODE" Description="Annular Ring: BBVia Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_MSK" Description="Annular Ring: BBVia Hole to Mask" Version="17.210" Master="DFF_AR_VIAHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_MSK_VMODE" Description="Annular Ring: BBVia Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TOPD" Description="Annular Ring: BBVia Hole to Pad" Version="17.210" Master="DFF_AR_VIAHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TOPD_VMODE" Description="Annular Ring: BBVia Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_ANTIPD" Description="Annular Ring: BBVia Hole to Antipad" Version="17.210" Master="DFF_AR_VIAHL_TO_ANTIPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_ANTIPD_VMODE" Description="Annular Ring: BBVia Hole to Antipad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_THRML" Description="Annular Ring: BBVia Hole to Thermal" Version="17.210" Master="DFF_AR_VIAHL_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_BBVIAHL_TO_THRML_VMODE" Description="Annular Ring: BBVia Hole to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_MSNGMSK" Description="Annular Ring: MicroVia Pad to Missing Mask" Version="17.210" Master="DFF_AR_VIAPD_MSNGMSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Enum">
            <e>On</e>
            <e>Off</e>
          </data>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_MSNGMSK_VMODE" Description="Annular Ring: MicroVia Pad to Missing Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_TO_MSK" Description="Annular Ring: MicroVia Pad to Mask" Version="17.210" Master="DFF_AR_VIAPD_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_TO_MSK_VMODE" Description="Annular Ring: MicroVia Pad to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_TO_THRML" Description="Annular Ring: MicroVia Pad to Thermal" Version="17.210" Master="DFF_AR_VIAPD_TO_THRML">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_UVIAPD_TO_THRML_VMODE" Description="Annular Ring: MicroVia Pad to Thermal verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_UVIAHL_TO_MSK" Description="Annular Ring: MicroVia Hole to Mask" Version="17.210" Master="DFF_AR_VIAHL_TO_MSK">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>SubClass</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_UVIAHL_TO_MSK_VMODE" Description="Annular Ring: MicroVia Hole to Mask verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
            <s>VMode</s>

            <s>CMEditOnly</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>System</o>
            <o>Design</o>
          </valid>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
      </attribute>
      <attribute Name="DFF_AR_UVIAHL_TOPD" Description="Annular Ring: MicroVia Hole to Pad" Version="17.210" Master="DFF_AR_VIAHL_TOPD">
        <value Kind="Constraint">
          <data Type="Scalar" Storage="Double"/>
          <units Type="uDesign"/>
          <range Min="0"/>
          <flags>
            <s>CMEditOnly</s>
            <s>NoUnitStr</s>
          </flags>
        </value>
        <objects>
          <valid>
            <o>DFFAnnularRingCSet</o>
          </valid>
          <inheritOnly>
            <o>Layer</o>
            <o>GenericLayer</o>
            <o>DFFAnnularRingSCGroup</o>
          </inheritOnly>
        </objects>
        <domains>
          <d>DFF</d>
        </domains>
        <tiering tier="MustHaveOption">
          <option>dfmAdvanced</option>
        </tiering>
      </attribute>
      <attribute Name="DFF_AR_UVIAHL_TOPD_VMODE" Description="Annular Ring: MicroVia Hole to Pad verification Mode" Version="17.210">
        <value Kind="Property">
          <data Type="Scalar" Storage="Enum">
            <e>OFF</e>
            <e>ON</e>
            <e>BATCH</e>
          </data>
          <flags>
    