<?xml version="1.0" encoding="UTF-8"?>
<!--Cadence Design Systems

 (C) COPYRIGHT, Cadence Design Systems, Inc. 1998-2002
 All Rights Reserved
 Licensed Materials - Property of Cadence Design Systems

 No part of this file may be reproduced, stored in a retrieval system,
 or transmitted in any form or by any means electronic, mechanical,
 photocopying, recording, or otherwise without prior written permission
 of Cadence Design Systems, Inc.

 WARRANTY:
 Use all material in this file at your own risk.  Cadence Design Systems
 makes no claims about any material contained in this file.
 -->
<!--This is used to transform XML file into HTML which is generated during Export->HTML File...-->
<xsl:stylesheet version="2.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <html>
      <head>
        <style type="text/css">
          .report-header{
          font-family:Arial;
          font-size:15pt;
          font-weight:bold;
		  text-align:left;
		  background-color:white;
          }

          <!--This is used for ILC Matrix header columns(vertical/tilted headers)-->
          .ILCVerticalHeader
          {
          font-weight:lighter;
          border-color:black;
          text-align: left;
          -webkit-transform: rotate(-45deg);
          -moz-transform: rotate(-45eg);
          -o-transform: rotate(-45deg);
          font-size: 5pt;
          }

          <!--This is used for ILC Matrix cell columns(check boxes)-->
          .ILCCellData {
          width: auto;
          position: relative;
          font-weight: lighter;
          border-color: black;
          white-space: nowrap;
          }

          <!--This is used for injecting blank rows-->
          .BlankRow {
          height: 20px !important; /* overwrites any other rules */
          background-color: white;
          border-style: none;
          empty-cells: hide;
          }

          .triangle-expanded:after{
          content:'\25B6';
          margin-left:10px;
          }
          .triangle-collapsed:after{
          content:'\25BB';
          margin-left:10px;
          }
          .triangle-transposed-expanded:before{
          content:'\25C4';
          margin-right:5px;
          font-size: 1.3em;
          }
          .triangle-transposed-collapsed:before{
          content:'\25B7';
          margin-right:5px;
          font-size: 1.3em;
          }

          <!--Alternate row's color-->
          tr:nth-child(even){
          background-color: #E9FFE9;
          }

          .Crosshatch {
          background:
          repeating-linear-gradient(135deg, rgba(128, 128, 128, 0.2), rgba(128, 128, 128, 0.2) 2px, rgba(0, 255, 0, 0.1) 4px, rgba(0, 255, 0, 0.1) 5px), repeating-linear-gradient(45deg, rgba(128, 128, 128, 0.2), rgba(128, 128, 128, 0.2) 4px, rgba(0, 255, 0, 0.1) 4px, rgba(0, 255, 0, 0.1) 5px);
          }

          .hiddenPrefix{
          color:white;
          }

        </style>
      </head>
      <body>
        <table border="2" bordercolor="black">
          <xsl:apply-templates/>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="REPORTINFO">
    <xsl:for-each select="node()">
      <xsl:if test="@Val!=''">
        <p class="report-header">
          <xsl:value-of select="@Val"/>
        </p>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="BLANKROWS">
    <xsl:call-template name="loopForBlankRowsHeaders">
      <xsl:with-param name="var" select="@HeaderRowCount"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="loopForBlankRowsHeaders">
    <xsl:param name="var"/>
    <xsl:if test="$var &gt; 0">
      <tr class="BlankRow">
        <th></th>
      </tr>
      <xsl:call-template name="loopForBlankRowsHeaders">
        <xsl:with-param name="var" select="number($var)-1" />
      </xsl:call-template>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="WORKSHEETNAME">
  <tr class="BlankRow">
        <th></th>
      </tr>
	  <tr class="BlankRow">
        <th></th>
      </tr>
    <th class="report-header" colspan="10">
        <xsl:value-of select="@Val"/>
    </th>
  </xsl:template>

  <xsl:template match="HEADERSPARENT">
    <xsl:call-template name="loopForHeaders">
      <xsl:with-param name="var" select="@HeaderRowCount"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="loopForHeaders">
    <xsl:param name="var"/>
    <xsl:if test="$var &gt; 0">
      <tr>
        <xsl:for-each select="node()">
          <xsl:if test="../@HeaderRowCount - $var = @Level">
            <th class="{@status}" bgcolor="{@bgcolor}" nowrap="nowrap" rowspan="{@ColHeight}" colspan="{@ColWidth}" style="text-align:center; font-family:Arial ;font-size:10pt; font-weight:normal;">
              <xsl:value-of select="@Val"/>
            </th>
          </xsl:if>
        </xsl:for-each>
      </tr>
      <xsl:call-template name="loopForHeaders">
        <xsl:with-param name="var" select="number($var)-1" />
      </xsl:call-template>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="FILTERS">
    <tr >
      <xsl:for-each select="node()">
        <xsl:if test="name()!=''">
          <td bgcolor="white">
            <xsl:value-of select="@Val"/>
          </td>
        </xsl:if>
      </xsl:for-each>
      <xsl:apply-templates select="BLANKROWS"/>
    </tr>
  </xsl:template>

  <xsl:template match="OBJECTS">
    <tr >
      <xsl:for-each select="node()">
        <xsl:if test="name()='FIRSTCOLVALUE'">
          <xsl:for-each select="node()">
            <xsl:if test="name()='DISPINFO'">
              <td bgcolor="{@bgcolor}" style="{@style}" nowrap="nowrap" align="{@align}" class="{@CellType}">
                <!--Add a dummy invisible character so that there lies a whitespace between arrow and text-->
                <b class="hiddenPrefix">
				-
                  <xsl:call-template name="loopForObjects">
                    <xsl:with-param name="var" select="../../@Level"/>
                  </xsl:call-template>
                </b>
                <span class="{@status}">
                  &#032;
                  <xsl:value-of select="../@Val"/>
                </span>
              </td>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
        <xsl:if test="name()='COLVALUE'">
          <xsl:for-each select="node()">
            <xsl:if test="name()='DISPINFO'">
              <xsl:choose>
                <xsl:when test="../@IsChecked!=''">
                  <td bgcolor="{@bgcolor}" style="{@style}" nowrap="nowrap" align="{@align}" class="{@CellType}">
                    <xsl:choose>
                      <xsl:when test="../@IsChecked='2'">
                        <input type="checkbox" checked="checked" disabled="disabled"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="checkbox" disabled="disabled"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </xsl:when>
                <xsl:when test="@CellType!=''">
                  <td nowrap="nowrap" align="{@align}" class="{@CellType}">
                    <xsl:value-of select="../@Val"/>
                  </td>
                </xsl:when>
                <xsl:otherwise>
                  <td bgcolor="{@bgcolor}" style="{@style}" nowrap="nowrap" class="{@ILCCellData}">
                    <xsl:value-of select="../@Val"/>
                    <xsl:if test="@ImagePath!=''">
                      <img  src="{@ImagePath}"/>
                    </xsl:if>
                  </td>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:for-each>
        </xsl:if>
      </xsl:for-each>
    </tr>
    <xsl:apply-templates select="OBJECTS"/>
  </xsl:template>

  <!--add indentation for first column if there is parent child relationship-->
  <xsl:template name="loopForObjects">
    <xsl:param name="var"/>
    <xsl:if test="$var &gt; 0">
      <xsl:text>-----</xsl:text>
      <xsl:call-template name="loopForObjects">
        <xsl:with-param name="var" select="number($var)-1" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
