var msgBox = 
{
    Initialize : function ()
    {
	    let cmdLine = window.arguments[0];
	    cmdLine = cmdLine.QueryInterface(Components.interfaces.nsICommandLine);
	    this.rcFile = cmdLine.handleFlagWithParam("file", false);
	    this.options = document.getElementById("options-radio-grp");
        this.options.selectedIndex = -1;
    },
    
    OK : function(rc)
    {
        var file = new File(this.rcFile);
        file.create();
        if(!file.isWritable())
        {
            alert("Cannot write to " + file.path);
            throw("Cannot write to " + file.path);
        }

        file.open("w");
        file.write(this.options.selectedIndex.toString());
        file.close();
        window.close();
    },
    
    findExe : function(baseName)
    {
        var env = Components.classes["@mozilla.org/process/environment;1"].getService(Components.interfaces.nsIEnvironment);
          
        
        var pathInOneString = env.get("PATH");
    
        var sep = ":";                              // unix
        if(pathInOneString.search(";") != -1)       // windows - shouldn't search for ':' in windows - (C:\...)
            sep = ";";
        
        var paths = pathInOneString.split(sep);
        
        var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        var execs = [baseName, baseName + ".exe"];
        for(var i = 0; i < paths.length; i++)
        {
            for(var j = 0; j < execs.length; j++)
            {
                var p;
                if(navigator.platform.search("Win") != -1)
                { p = paths[i] + "\\" + execs[j]; }
                else
                { p = paths[i] + "/" + execs[j]; }
                
                
                try { file.initWithPath(p); }
                catch(e) 
                { continue; }
                
                if(file.exists() && file.isExecutable())
                     return file;
            }
        }
        return null;
    },
    
    Help : function()
    {
        try 
        {              
            var file = this.findExe("cdnshelp");
            if(file == null)
            {
                alert("Failed to find cdnshelp, please make sure it is in your path.");
                return;
            }
            
                              
            var process = Components.classes["@mozilla.org/process/util;1"].createInstance(Components.interfaces.nsIProcess);
            
            if (process != null)
            {
                process.init(file);
                        
                var args = ["-openpage", "consmgr:base_version_check"];
                var pid = process.run(false, args, args.length);
            }
        } catch(e) {
            alert(e);
        }
    },
};





