<?xml version="1.0" encoding="utf-8" standalone="no" ?>
<!--
Cadence Design Systems 

(C) COPYRIGHT, Cadence Design Systems, Inc. 2013
All Rights Reserved
Licensed Materials - Property of Cadence Design Systems
asdf
No part of this file masdfasdfdsady be reproduced, stored in a retrieval system,
or transmitted in any form adsfasdfaor by any means electronic, mechanical,
photocopying, recording, or otherwise without prior written permission
of Cadence Design Systems, Inc. sdafa

WARRANTY:
Use all material in this file at your own risk.  Cadence Design Systems
makes no claims about any material contained in this file.
-->
<cft:root xmlns:cft="http://www.cadence.com/xsd/cft" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.cadence.com/xsd/cft schemas/cfgFile.xsd">
    <cft:xml Name="dictionary">
        <root xmlns="http://www.cadence.com/xsd/dictionary" xsi:schemaLocation="http://www.cadence.com/xsd/dictionary schemas/dictionary.xsd" Version="17.0">
            <attribute Name="CDS_IBD_VENDOR" Description="Vendor which supports the Interface">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetInterface</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_LIBRARY" Description="Library name from which the Interface originates">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetInterface</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_VERSION" Description="Version of Interface">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>Design</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_DISPLAY_NAME" Description="Display name for Interface object">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>DiffPair</o>
                        <o>Bus</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_DESC" Description="Description of Interface object">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                        <s>NoInherit</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>DiffPair</o>
                        <o>Bus</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_QUALIFIER" Description="Indicates the type of information a port will carry">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>Address</e>
                        <e>Data</e>
                        <e>Address_and_Data</e>
                        <e>Clock</e>
                        <e>Reset</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>DiffPair</o>
                        <o>Bus</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SYS_GROUP_NAME" Description="Used to group common/shared ports into different groups at the system-level">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>DiffPair</o>
                        <o>Bus</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SYS_PRESENCE" Description="Requirements of a common/shared port">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>illegal</e>
                        <e>required</e>
                        <e>optional</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SYS_ALLOWABLE_SIZES" Description="List of allowable sizes of a common/shared port.  Absence indicates no restriction.">
                <value Kind="Property">
                    <data Type="dListLong"/>
                    <flags>
                        <s>CMEditOnly</s>
                        <s>NoInherit</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SYS_DIRECTION" Description="Indicates the direction of a common/shared port">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>in</e>
                        <e>out</e>
                        <e>inout</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_MASTER_PRESENCE" Description="If defined, the existance of the port is controlled by the specified value.">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>illegal</e>
                        <e>required</e>
                        <e>optional</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_MASTER_ALLOWABLE_SIZES" Description="List of allowable sizes for replication of a master port. Absence indicates no restriction.">
                <value Kind="Property">
                    <data Type="dListLong"/>
                    <flags>
                        <s>CMEditOnly</s>
                        <s>NoInherit</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_MASTER_DIRECTION" Description="If defined, the direction of a master port is restricted to the specified value. ">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>in</e>
                        <e>out</e>
                        <e>inout</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SLAVE_PRESENCE" Description="Requirements of a slave port">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>illegal</e>
                        <e>required</e>
                        <e>optional</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SLAVE_ALLOWABLE_SIZES" Description="List of allowable sizes of a slave port.  Absence indicates no restriction.">
                <value Kind="Property">
                    <data Type="dListLong"/>
                    <flags>
                        <s>CMEditOnly</s>
                        <s>NoInherit</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CDS_IBD_SLAVE_DIRECTION" Description="Indicates the direction of a slave port">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>in</e>
                        <e>out</e>
                        <e>inout</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="VOLTAGE" Description="Voltage level supported by interface">
                <value Kind="Property">
                    <data Type="dString"/>
                    <units Type="uVoltage" Name="V"/>
                    <flags>
                        <s>IgnoreConversion</s>
                        <s>NoUnitStr</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>VoltageDefinition</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="COMMENT" Description="Comment">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>NoInherit</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetInterface</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                        <o>VoltageDefinition</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="CLOCK_NET" Description="Clock net name">
                <value Kind="Property">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="ELECTRICAL_CONSTRAINT_SET" Description="Electrical Constraint Set reference">
                <value Kind="Constraint" Type="EnumSpecial">
                    <data Type="dEnum">
                        <e>nil</e>
                    </data>
                    <flags>
                        <s>CMEditOnly</s>
                        <s>Hidden</s>
                        <s>ObjectReference</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <relatedProperties>
                    <r>ECSET_MAPPING_ERROR</r>
                    <r>ECSET_MAPPING_ERROR_MARGIN</r>
                </relatedProperties>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="ECSET_MAPPING_ERROR" Description="Electrical CSet apply mapping error">
                <value Kind="Actual">
                    <data Type="dString"/>
                    <flags>
                        <s>Control</s>
                        <s>NoInherit</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>System</o>
                        <o>Design</o>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <analysis>
                    <flags>
                        <s>ECSetMappingVerify</s>
                    </flags>
                </analysis>
                <relatedProperties>
                    <r>ELECTRICAL_CONSTRAINT_SET</r>
                </relatedProperties>
            </attribute>
            <attribute Name="ECSET_MAPPING_ERROR_MARGIN" Description="Electrical CSet apply mapping margin">
                <value Kind="Result">
                    <data Type="dDouble"/>
                    <flags>
                        <s>Control</s>
                        <s>NoInherit</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>System</o>
                        <o>Design</o>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <analysis>
                    <flags>
                        <s>ECSetMappingVerify</s>
                    </flags>
                </analysis>
                <relatedProperties>
                    <r>ELECTRICAL_CONSTRAINT_SET</r>
                </relatedProperties>
            </attribute>
            <attribute Name="NET_ELECTRICAL_TYPE" Description="Name of Electrical Net Class (NET_ELECTRICAL_TYPE)" Version="15.200">
                <value Kind="Property" Type="EditOrPickFromList">
                    <data Type="dString"/>
                    <flags>
                        <s>UpperCaseValue</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="NET_PHYSICAL_TYPE" Description="Name of Physical Net Class (NET_PHYSICAL_TYPE)" Version="15.200">
                <value Kind="Property" Type="EditOrPickFromList">
                    <data Type="dString"/>
                    <flags>
                        <s>UpperCaseValue</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="NET_SPACING_TYPE" Description="Name of Spacing Net Class (NET_SPACING_TYPE)" Version="15.200">
                <value Kind="Property" Type="EditOrPickFromList">
                    <data Type="dString"/>
                    <flags>
                        <s>UpperCaseValue</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="PARENT_CLASS" Description="Object's Net Class" Version="16.500">
                <value Kind="Property" Type="EditOrPickFromList">
                    <data Type="dString"/>
                    <flags>
                        <s>Control</s>
                        <s>ObjectParent</s>
                        <s>CMEditOnly</s>
                        <s>UpperCaseValue</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Net</o>
                        <o>Xnet</o>
                        <o>NetGroup</o>
                    </valid>
                    <parent>
                        <o>NetClass</o>
                    </parent>
                </objects>
            </attribute>
            <attribute Name="PULSE_PARAM_FREQ" Description="Nets switch frequency">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <units Type="uFrequency" Name="MHz"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_PERIOD" Description="Clock period">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <units Type="uTime" Name="ns"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>Hidden</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_DUTY_CYCLE" Description="Clock duty cycle expressed as a percentage for the time High">
                <value Kind="Property" Type="Percentage">
                    <data Type="dLong"/>
                    <units Type="uPercentage" Name="%"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_JITTER" Description="Amount of clock jitter expressed as an absolute value">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <units Type="uJitterTime" Name="ps"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_MEASURE_CYCLE" Description="Clock cycle for measuring during simulation">
                <value Kind="Property">
                    <data Type="dLong"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_COFF" Description="Amount of clock jitter expressed as an absolute value">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <units Type="uTime" Name="ns"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_AOFF" Description="Amount of clock jitter expressed as an absolute value">
                <value Kind="Property">
                    <data Type="dDouble"/>
                    <units Type="uTime" Name="ns"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="PULSE_PARAM_BPAT" Description="Bit Pattern">
                <value Kind="Property" Type="BitPattern">
                    <data Type="dString"/>
                    <flags>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetClass</o>
                        <o>NetGroup</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Xnet</o>
                        <o>Net</o>
                    </valid>
                </objects>
                <domains>
                    <d>Electrical</d>
                </domains>
            </attribute>
            <attribute Name="DESIGN_UNITS" Description="Defines the current units of measurement for coordinate and distance data">
                <value Kind="Property">
                    <data Type="dListInteger"/>
                    <units Type="uPrecision" Name="mil"/>
                    <flags>
                        <s>Drawing</s>
                        <s>NoUnitStr</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>System</o>
                        <o>Design</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="DRAWING_EXTENTS" Description="Extents of the drawing" Version="16.000">
                <value Kind="Property">
                    <data Type="dListDouble"/>
                    <units Type="uDesign" Name="mil"/>
                    <range Min="0.000000"/>
                    <flags>
                        <s>Drawing</s>
                        <s>NoUnitStr</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>Design</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="DRAWING_LOWER_LEFT" Description="Lower-left location of the drawing" Version="16.000">
                <value Kind="Property">
                    <data Type="dListDouble"/>
                    <units Type="uDesign" Name="mil"/>
                    <flags>
                        <s>Drawing</s>
                        <s>NoUnitStr</s>
                        <s>CMEditOnly</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>Design</o>
                    </valid>
                </objects>
            </attribute>
            <attribute Name="MEMBERSHIP_LOCKED" Description="Lock the membership of an object" Version="16.600">
                <value Kind="Property">
                    <data Type="dEnum">
                        <e>MODEL_DEFINED</e>
                        <e>SCHEMATIC_DEFINED</e>
                        <e>CODESIGN_DEFINED</e>
                        <e>FSP_DEFINED</e>
                        <e>LIBRARY_DEFINED</e>
                        <e>SCHEMATIC_LIBRARAY_DEFINED</e>
                        <e>NETGROUP_DEFINED</e>
                    </data>
                    <flags>
                        <s>NoEditor</s>
                    </flags>
                </value>
                <objects>
                    <valid>
                        <o>NetInterface</o>
                        <o>NetGroup</o>
                        <o>RatBundle</o>
                        <o>FromTo</o>
                        <o>Bus</o>
                        <o>DiffPair</o>
                        <o>Net</o>
                        <o>Xnet</o>
                    </valid>
                </objects>
            </attribute>
            <bundle Name="PULSE_PARAM">
                <value Type="PulseParam" Category="Bubble"/>
                <relatedProperties>
                    <r>PULSE_PARAM_FREQ</r>
                    <r>PULSE_PARAM_DUTY_CYCLE</r>
                    <r>PULSE_PARAM_JITTER</r>
                    <r>PULSE_PARAM_MEASURE_CYCLE</r>
                    <r>PULSE_PARAM_BPAT</r>
                    <r>PULSE_PARAM_COFF</r>
                    <r>PULSE_PARAM_AOFF</r>
                </relatedProperties>
            </bundle>
        </root>
    </cft:xml>
</cft:root>


