/*
 * config.c
 *
 *  Created on: Jun 24, 2013
 *      Author: x0202894
 */

//#define GUI
#ifdef GUI
#include "msp430f5132.h"
#include<string.h>
#define TRUE 1
#define FALSE 0
#define TX 1
#define RX 2
#define DATA_LENGTH 10
#define FRAME_LENGTH 15
#define LOAD_DISABLE 		P3OUT |= BIT2
#define LOAD_ENABLE			P3OUT &= ~BIT2

extern unsigned int CC_LIMIT;
extern unsigned int CC_TO_CV_LIMIT;
extern unsigned int FLOAT_VOLTAGE;
extern unsigned int BATTERY_CUTOFF;

extern unsigned int Panel_Voltage,
					Battery_Voltage,
					Panel_Current,
					Battery_Current;

extern unsigned int Is_Load_On,
			        GUI_Battery_Charge_Current_State,
			        GUI_Battery_Charge_Previous_State,
			        Is_Cal_Load_Management,
			        Load_I_Limit;

extern unsigned char 	Hysterisis_ON ,
						OC_Triggered,
						Start_Delay,
						Battery_Current_Counter;


void Init_UART (void);
void Interrupt_enable(int IE);
void Create_Frame(void);
void Send_Frame(void);
void Init_GUI_Parameters();

void Calculate_CRC(void);
void UnpackReceivedFrame(void);
void RespndToGUI();

char CRC_Generator[]={0x80,0x21};
char copy[13];
unsigned int testVar=258;
int size;
char FrameToSend[15];
char ReceivedFrame[15];
char CRC_buffer[13];

unsigned int Stat_U,Stat_L;
unsigned int Bat_Const_I,Bat_Const_V,Float_V,System_Voltage,GUI_Commands;
int isFrameReceived =FALSE ;
unsigned int prev_Load_Limit = 0x02; // default 9A

/*Here all the initialization required to establish link with GUI are done.
 * When GUI is not used all the system data variables are initialized in this function.  */
void Init_GUI_Parameters()
{
	Init_UART();
	Interrupt_enable(RX);

}


void Init_UART(void)
{
	// select secondary fun
		P2SEL |= (BIT4|BIT5); // 4-RX, 5-TX
	    P2DIR |= (BIT5); //TX output
        P2REN |= (BIT4); // RX pull up reg

	    PMAPKEYID = 0x02D52;
	    PMAPCTL = PMAPRECFG;
	    P2MAP4= PM_UCA0RXD;
	    P2MAP5 = PM_UCA0TXD;

    	UCA0CTL1=0X0C1; // SETTING UCSWRST source clock = SMCLK = 25Mhz
    	UCA0CTL0=0X00;
    	UCA0BR0=44; // BAUD RATE for 9600
    	UCA0BR1=10;
    	UCA0MCTL=UCBRS_1+UCBRF_0; // MODULATION not needed
    	UCA0CTL1 &= ~0X01;// RESETTING UCSWRST;

}

void Create_Frame(void)
{
	int j;
	FrameToSend[0]='*'; // header
	FrameToSend[1]=0x01; // msg ID
	FrameToSend[2] = (Panel_Voltage>>8) & 0xFF;
	FrameToSend[3]= Panel_Voltage & 0xFF;
	FrameToSend[4]= (Panel_Current >> 8) & 0xFF;
	FrameToSend[5]= (Panel_Current) & 0xFF;
	FrameToSend[6] = (Battery_Voltage >> 8) & 0xFF;
	FrameToSend[7] = (Battery_Voltage) & 0xFF;
	FrameToSend[8] = (Battery_Current >> 8) & 0xFF;
	FrameToSend[9]= (Battery_Current) & 0xFF;
	FrameToSend[10] = (Stat_U ) & 0xFF;
	FrameToSend[11]= (Stat_L) & 0xFF;
	FrameToSend[12] = 0; // initially CRC bits are 0
	FrameToSend[13]= 0; // initially CRC bits are 0
	FrameToSend[14]='#'; // footer

	for(j=1;j<14;j++)
				CRC_buffer[j-1]= ReceivedFrame[j];
	Calculate_CRC();

	FrameToSend[12] = CRC_buffer[0];
	FrameToSend[13]= CRC_buffer[1];
}

void Send_Frame(void)
{
	int i;
	for(i=0;i<=14;i++)
	     {
	           UCA0TXBUF=FrameToSend[i];
	           while(!(UCA0IFG & BIT1));
	     }
}
void Interrupt_enable(int IE)
{
	if(IE==1)
		UCA0IE |= BIT1;
	else
		UCA0IE |= BIT0;
}

void RespndToGUI()
{
	int j;
	int Is_Valid_Frame = 1;
	if(isFrameReceived == TRUE)
	{
		isFrameReceived =FALSE;
		// put values in CRC buffer
		for(j=1;j<14;j++)
			CRC_buffer[j-1]= ReceivedFrame[j];
		Calculate_CRC();

		// check if CRC is correct
		if(!((CRC_buffer[0] ==0)&& (CRC_buffer[1]==0)))
			Is_Valid_Frame = 0;
		// check header , footer and msg ID
		if((ReceivedFrame[0] != 0x42 )||(ReceivedFrame[14] != 0x35)|| (ReceivedFrame[1] != 0x0A))
			Is_Valid_Frame = 0;
		if(Is_Valid_Frame)
		{

			UnpackReceivedFrame();

			CC_LIMIT = Bat_Const_I;
			CC_TO_CV_LIMIT = Bat_Const_V;
			FLOAT_VOLTAGE =Float_V;

			if(prev_Load_Limit != Load_I_Limit)
			{
				prev_Load_Limit = Load_I_Limit;
				CBCTL1 &= ~CBON; // first turn off
				switch(Load_I_Limit & 0x03)
					{
						case 0x00: // 3 Amps
							CBCTL2 = CBRS_1 + CBRSEL + CBREF1_0 + CBREF0_0;     // VCC applied to R-ladder;
									break;
						case 0x01: // 6 Amps
							CBCTL2 = CBRS_1 + CBRSEL+ CBREF1_1 + CBREF0_1;     // VCC applied to R-ladder;
									break;
						case 0x02: // 9 Amps
							CBCTL2 = CBRS_1 + CBRSEL + CBREF1_2 + CBREF0_2;     // VCC applied to R-ladder;
									break;
						case 0x03: // 12 Amps
							CBCTL2 = CBRS_1 + CBRSEL +CBREF1_3 + CBREF0_3;     // VCC applied to R-ladder;
									break;
						default:
							break;
					}
				CBCTL1 |= CBON; //  turn on
			}

			if(((Is_Load_On==1) && Hysterisis_ON)||((Is_Load_On==0) && Battery_Voltage < BATTERY_CUTOFF ))
				Stat_L |= 0xFF;
			else
				Stat_L &=0x00;

			if(OC_Triggered)
				Stat_U |= 0xFF;
			else
				Stat_U &=0x00;

			Create_Frame();
			Send_Frame();



			if(Is_Load_On)
			{
					if((Hysterisis_ON == 0) && (OC_Triggered == 0))
					LOAD_ENABLE;
					Is_Cal_Load_Management = 1;
			}
			else
			{
				Is_Cal_Load_Management = 0;
					LOAD_DISABLE;
			}
			if((GUI_Battery_Charge_Current_State != GUI_Battery_Charge_Previous_State) && (GUI_Battery_Charge_Current_State))
			{
				Start_Delay =0; // no delay needed
				Battery_Current_Counter=0;
			}
			}
	}
}
void UnpackReceivedFrame()
{
	Bat_Const_I=(ReceivedFrame[2]<<8)|ReceivedFrame[3];
	Bat_Const_V=(ReceivedFrame[4]<<8)|ReceivedFrame[5];
	Float_V=(ReceivedFrame[6]<<8)|ReceivedFrame[7];
	Load_I_Limit=(ReceivedFrame[8]<<8)|ReceivedFrame[9];
	System_Voltage=ReceivedFrame[10];
	GUI_Commands=ReceivedFrame[11];

	if(GUI_Commands & 0x0F)
		Is_Load_On =1;
	 else
		 Is_Load_On =0;

	 if(GUI_Commands & 0xF0)
		 GUI_Battery_Charge_Current_State =1;
	 else
		 GUI_Battery_Charge_Current_State=0;
}
#pragma vector=USCI_A0_VECTOR
__interrupt void TX_RX_interrupt(void)
{
	static int index=0;
	if(UCA0IFG & BIT0) // if due to RX
	{

		ReceivedFrame[index++]=UCA0RXBUF;
		UCA0IFG &= ~BIT0; // clear flag
	}

	if(index==15)
	{
		isFrameReceived = TRUE;
		index=0;
	}
}
void Calculate_CRC(void)
{

	int i,k;

		for(i=0;i<(11*8);i++)
	    {
	    	if(CRC_buffer[0] & 0x80)
	         {
   	        	// xor
	    		CRC_buffer[0] = CRC_buffer[0]  ^ CRC_Generator[0];

	    		CRC_buffer[1] = CRC_buffer[1]  ^ CRC_Generator[1];
	         }
	   	        // shifting
	         for(k=0;k<13;k++)
	       	{
	       		CRC_buffer[k] = CRC_buffer[k] << 1;
	       		if(k!=12)
	   			if(CRC_buffer[k+1] & 0x80)
	    	    CRC_buffer[k] |= 0x01;
	    	 }
	    }
}
#endif


