"""
Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/ 
ALL RIGHTS RESERVED 
"""

from System.Windows.Media import SolidColorBrush, Color, Colors

from System.Windows.Controls import(ComboBox,ComboBoxItem)
from System.Windows import TextAlignment,FontWeights

import sys
import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon

import math
brush_warning = SolidColorBrush(Color.FromArgb(255,204,0,0))
brush_white = SolidColorBrush(Color.FromArgb(255,255,255,255))
brush_alert = SolidColorBrush(Color.FromArgb(255,253,205,52))

# Note: In some places elements are accessed using UIC_Control (UI Control Element) because of the clash with controls in User Controls Page

def System_Update_Loaded_Mode():
    UpdateFpdFrequency()
    #UpdateVCOFrequency() 
    UpdateDistribution()
    UpdateVCOGain()
    UpdateCPGain()
    ValidateFrequencies()

def System_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    UpdateDistribution()
    UpdateCPGain()
    ValidateFrequencies()

def System_Update_Run_Once():
    UIC_Fosc_FREQ.TextAlignment = TextAlignment.Left
    UIC_Fpd_FREQ.TextAlignment = TextAlignment.Right
    UIC_CalculatedCPG.TextAlignment = TextAlignment.Left
    UIC_Fvco_FREQ.TextAlignment = TextAlignment.Left    
    UIC_VCO_MULTIPLIED_FREQ.TextAlignment = TextAlignment.Left
    UIC_CalculatedTotalDivide.TextAlignment = TextAlignment.Left
    UIC_CalculatedKvco.TextAlignment = TextAlignment.Left
    UIC_FoutA_FREQ.TextAlignment = TextAlignment.Left
    UIC_FoutB_FREQ.TextAlignment = TextAlignment.Left



    UIC_OSC_2X.Background = brush_white
    UIC_PLL_R_PRE.Background = brush_white
    UIC_MULT.Background = brush_white
    UIC_PLL_R.Background = brush_white
    UIC_CP_IUP.Background = brush_white
    UIC_CP_ICOARSE.Background = brush_white
    UIC_CP_EN.Background = brush_white
    UIC_OUTA_PWR.Background = brush_white
    UIC_OUTB_PWR.Background = brush_white
    UIC_VCO_2X.Background = brush_white
    UIC_OUTA_MUX.Background = brush_white
    UIC_OUTB_MUX.Background = brush_white   
    UIC_PLL_N_PRE.Background = brush_white  
    UIC_CHDIV_SEG_SEL.Background = brush_white

    
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    UpdateDistribution()
    UpdateCPGain()
    ValidateFrequencies()
     
def CP_ICOARSE_Update():
    UpdateCPGain()
    
def CP_EN_Update():
    UpdateCPGain()

def CP_IUP_Update():
    CP_IDN.iValue=CP_IUP.iValue     #for the PLL tab, which only has IUP, to set both up and down equal
    UpdateCPGain()

def UpdateCPGain():
    CP1=0
    if (CP_IUP.iValue<8):
        CP1=CP_IUP.iValue
    elif (CP_IUP.iValue<16):
        CP1=CP_IUP.iValue+8
    elif (CP_IUP.iValue<24):
        CP1=CP_IUP.iValue-8
    else:
        CP1=CP_IUP.iValue
 
    CP2=0
    if (CP_IDN.iValue<8):
        CP2=CP_IDN.iValue
    elif (CP_IDN.iValue<16):
        CP2=CP_IDN.iValue+8
    elif (CP_IDN.iValue<24):
        CP2=CP_IDN.iValue-8
    else:
        CP2=CP_IDN.iValue

    if (CP2<CP1):    #if CP up and down are not equal make them equal
        CP1=CP2
        
    if (CP_EN.iValue==0):
        CP1=0
 
    if (CP_ICOARSE.iValue==0):
        CPG=0.3125*CP1
    elif(CP_ICOARSE.iValue==1):
        CPG=0.3125*2*CP1
    elif (CP_ICOARSE.iValue==2):
        CPG=0.3125*1.5*CP1
    else:
        CPG=0.3125*2.5*CP1
    
    CalculatedCPG.dValue=CPG
    
def UpdateFpdFrequency():
    R = PLL_R_PRE.iValue*PLL_R.iValue
    if (R<1):
        R=1
    Fpd = (MULT.iValue)*Fosc_FREQ.dValue/R*(1+OSC_2X.iValue)
    Fpd_FREQ.dValue=Fpd


def UpdateNDivider():  
    Fin = Fvco_FREQ.dValue*(VCO_2X.iValue+1)
    PreN = 2*(PLL_N_PRE.iValue+1)  
    Fden = PLL_DEN.iValue
    if (Fden<1):
        Fden=1
        PLL_DEN.iValue=1
    Fpd = Fpd_FREQ.dValue
    if (Fpd<0.0000001):
        Fpd=1
        Fpd_FREQ.dValue=1
   
    FracN = Fin/Fpd/PreN
    N = math.floor(FracN)
    PLL_N.iValue = N
    PLL_NUM.iValue = round(Fden*(FracN-N))
    
    btn_LoadRegisters.Background=brush_alert
    UIC_FCAL_EN.Background=brush_alert
    btn_LoadRegisters.ToolTip="Whenever the VCO Frequency is changed from a previusly unlocked condition, the registers should be loaded."
    UIC_FCAL_EN.ToolTip="Toggling the FCAL_EN bit activates the VCO calibration.  This should be done whenever the  VCO changes to a new frequency from a previously locked frequency."
    pass
 
def UpdateVCOFrequency():
    Fpd = Fpd_FREQ.dValue
    Fnum = PLL_NUM.iValue
    Fden = PLL_DEN.iValue    
    PreN = 2*(PLL_N_PRE.iValue+1)
    N = PLL_N.iValue
    if (Fden<1):
        Fden=1
        PLL_DEN.iValue=1
        
    FracN=1.0*N+Fnum*1.0/Fden
    Fvco = FracN*PreN*Fpd/(VCO_2X.iValue+1)
    Fvco_FREQ.dValue=round(Fvco,10)  
    VCO_MULTIPLIED_FREQ.dValue = Fvco*(VCO_2X.iValue+1) 
    UpdateVCOGain() 
    
    btn_LoadRegisters.Background=brush_alert
    UIC_FCAL_EN.Background=brush_alert
    btn_LoadRegisters.ToolTip="Do this or FCAL_EN for each frequency change."
    UIC_FCAL_EN.ToolTip="Do this or LoadRegisters for each frequency change."
    
    pass 
    
def Fosc_FREQ_Update():
    UpdateFpdFrequency()
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()

def Fosc_FREQ_Update_UI():
    ValidateFrequencies()

    
def OSC_2X_Update():
    UpdateFpdFrequency()
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()

def OSC_2X_Update_UI():
    ValidateFrequencies()
   
   
def PLL_R_PRE_Update():
    UpdateFpdFrequency()
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()
    
def PLL_R_PRE_Update_UI():
    ValidateFrequencies()
  
  
def MULT_Update():
    UpdateFpdFrequency()
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()
    
def MULT_Update_UI():
    ValidateFrequencies()
 
 
def PLL_R_Update():
    UpdateFpdFrequency()
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()

def PLL_R_Update_UI():
    ValidateFrequencies()    

    
def Fpd_FREQ_Update():
    Fin = (OSC_2X.iValue+1)*MULT.iValue*Fosc_FREQ.dValue/PLL_R_PRE.iValue
 
    Fpd = Fpd_FREQ.dValue
    if (Fpd<0.0001):
        Fpd = Fin/PLL_R.iValue
    
    Rdiv=int(Fin/Fpd+0.5)
    if (Rdiv<1):
        Rdiv=1
    if (Rdiv>128):
        Rdiv=128    
        
    PLL_R.iValue=Rdiv
    Fpd_FREQ.dValue=Fin/PLL_R.iValue
    
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()  

    
def Fpd_FREQ_Update_UI():
    ValidateFrequencies()
    
    
def PLL_NUM_Update():
    UpdateVCOFrequency()
    UpdateDistribution()

def PLL_NUM_Update_UI():
    ValidateFrequencies()

    
def PLL_DEN_Update():
    UpdateVCOFrequency()
    UpdateDistribution()
    
def PLL_DEN_Update_UI():
    ValidateFrequencies()

def PLL_N_Update():
    UpdateVCOFrequency()
    UpdateDistribution()
    
def PLL_N_Update_UI():
    ValidateFrequencies()
    
    
def PLL_N_PRE_Update():
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()

def PLL_N_PRE_Update_UI():
    ValidateFrequencies()


def Fvco_FREQ_Update():
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()
    
def Fvco_FREQ_Update_UI():
    ValidateFrequencies()
 
 
def VCO_2X_Update():
    if (VCO_2X.iValue==1):    
        PLL_N_PRE.iValue=1
    else:
        PLL_N_PRE.iValue=0
    UpdateNDivider()
    UpdateVCOFrequency()
    UpdateDistribution()
    
    
def VCO_2X_Update_UI():
    ValidateFrequencies()

    
def FoutA_FREQ_Update():
    FoutA=FoutA_FREQ.dValue
    if (FoutA>5500):
        Fvco_FREQ.dValue=5500
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=1
        CHDIV_DISTA_EN.iValue=0
        VCO_DISTA_PD.iValue=0
        UpdateDistribution()
    elif (FoutA>3549.9):
        Fvco_FREQ.dValue=FoutA
        VCO_2X.iValue=0
        VCO_2X_Update()
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=1
        CHDIV_DISTA_EN.iValue=0
        VCO_DISTA_PD.iValue=0
        UpdateDistribution()
    elif (FoutA_FREQ.dValue<18.5):
        Fvco_FREQ.dValue=3550
        VCO_2X.iValue=0
        VCO_2X_Update()
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=0
        CHDIV_DISTA_EN.iValue=1
        VCO_DISTA_PD.iValue=1
        CHDIV_SEG1.iValue=1
        CHDIV_SEG2.iValue=8
        CHDIV_SEG3.iValue=8
        CHDIV_SEG_SEL.iValue=4
        CHDIV_SEG_SEL_Update()
        UpdateDistribution()
    else:
        OUTA_MUX.iValue=0
        CHDIV_DISTA_EN.iValue=1
        VCO_DISTA_PD.iValue=1
        VCO_2X.iValue=0
        DivMin=3550/FoutA_FREQ.dValue
        DivMax=7100/FoutA_FREQ.dValue
        
        CHDIV=CalculatedTotalDivide.dValue
        
        if (CHDIV<DivMin) or (CHDIV>DivMax):
            #   Only Consider Changing Divide Values to values of 2,3,4,6,8,16, 24, 32,64,128, and 192, start with prefered sequence
            
            CHDIV=2
            if (2>=DivMin) and (2<=DivMax):
                CHDIV=2
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1
            elif (3>=DivMin) and (3<=DivMax):
                CHDIV=3
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1
            elif (4>=DivMin) and (4<=DivMax):
                CHDIV=4 
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1                
            elif (6>=DivMin) and (6<=DivMax):
                CHDIV=6    
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1                
            elif (8>=DivMin) and (8<=DivMax):
                CHDIV=8
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=2
                CHDIV_SEG3.iValue=1
            elif (16>=DivMin) and (16<=DivMax):
                CHDIV=16    
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1  
            elif (24>=DivMin) and (24<=DivMax):
                CHDIV=24    
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1                 
            elif (32>=DivMin) and (32<=DivMax):
                CHDIV=32 
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1                  
            elif (64>=DivMin) and (64<=DivMax):
                CHDIV=64
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=2  
            elif (128>=DivMin) and (128<=DivMax):
                CHDIV=128
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=8                 
            elif (192>=DivMin) and (192<=DivMax):
                CHDIV=192               
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=8  
                
            if (CHDIV<4):
                CHDIV_SEG_SEL.iValue=1
            elif (CHDIV<25):
                CHDIV_SEG_SEL.iValue=2
            else:
                CHDIV_SEG_SEL.iValue=4
        
        Fvco_FREQ.dValue=CHDIV*FoutA_FREQ.dValue
        UpdateNDivider()
        UpdateVCOFrequency()
        CHDIV_SEG_SEL_Update()

def FoutA_FREQ_Update_UI():
    ValidateFrequencies()    
    
def FoutB_FREQ_Update():
    FoutB=FoutB_FREQ.dValue
    if (FoutB>5500):
        Fvco_FREQ.dValue=5500
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=1
        CHDIV_DISTA_EN.iValue=0
        VCO_DISTA_PD.iValue=0
        UpdateDistribution()

    elif (FoutB>3549.9):
        Fvco_FREQ.dValue=FoutA
        VCO_2X.iValue=0
        VCO_2X_Update()
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=1
        CHDIV_DISTA_EN.iValue=0
        VCO_DISTA_PD.iValue=0
        UpdateDistribution()
        ValidateFrequencies()
    elif (FoutB_FREQ.dValue<18.5):
        Fvco_FREQ.dValue=3550
        VCO_2X.iValue=0
        VCO_2X_Update()
        UpdateNDivider()
        UpdateVCOFrequency()
        OUTA_MUX.iValue=0
        CHDIV_DISTA_EN.iValue=1
        VCO_DISTA_PD.iValue=1

        CHDIV_SEG1.iValue=1
        CHDIV_SEG2.iValue=8
        CHDIV_SEG3.iValue=8
        CHDIV_SEG_SEL.iValue=4
        UpdateDistribution()
        ValidateFrequencies()
    else:
        OUTA_MUX.iValue=0
        CHDIV_DISTA_EN.iValue=1
        VCO_DISTA_PD.iValue=1
        VCO_2X.iValue=0
        DivMin=3550/FoutB_FREQ.dValue
        DivMax=7100/FoutB_FREQ.dValue
        
        CHDIV=CalculatedTotalDivide.dValue
        
        if (CHDIV<DivMin) or (CHDIV>DivMax):
            #   Only Consider Changing Divide Values to values of 2,3,4,6,8,16, 24, 32,64,128, and 192, start with prefered sequence
            
            CHDIV=2
            if (2>=DivMin) and (2<=DivMax):
                CHDIV=2
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1
            elif (3>=DivMin) and (3<=DivMax):
                CHDIV=3
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1
            elif (4>=DivMin) and (4<=DivMax):
                CHDIV=4 
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1                
            elif (6>=DivMin) and (6<=DivMax):
                CHDIV=6    
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=1
                CHDIV_SEG3.iValue=1                
            elif (8>=DivMin) and (8<=DivMax):
                CHDIV=8
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=2
                CHDIV_SEG3.iValue=1
            elif (16>=DivMin) and (16<=DivMax):
                CHDIV=16    
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1  
            elif (24>=DivMin) and (24<=DivMax):
                CHDIV=24    
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1                 
            elif (32>=DivMin) and (32<=DivMax):
                CHDIV=32 
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=1                  
            elif (64>=DivMin) and (64<=DivMax):
                CHDIV=64
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=2  
            elif (128>=DivMin) and (128<=DivMax):
                CHDIV=128
                CHDIV_SEG1.iValue=0
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=8                 
            elif (192>=DivMin) and (192<=DivMax):
                CHDIV=192               
                CHDIV_SEG1.iValue=1
                CHDIV_SEG2.iValue=8
                CHDIV_SEG3.iValue=8  
                
            if (CHDIV<4):
                CHDIV_SEG_SEL.iValue=1
            elif (CHDIV<25):
                CHDIV_SEG_SEL.iValue=2
            else:
                CHDIV_SEG_SEL.iValue=4

        Fvco_FREQ.dValue=CHDIV*FoutB_FREQ.dValue
        UpdateNDivider()
        UpdateVCOFrequency()
        CHDIV_SEG_SEL_Update()

def FoutB_FREQ_Update_UI():
    ValidateFrequencies()   
    
def UpdateVCOGain():
    Fvco=Fvco_FREQ.dValue
    
    if (Fvco<3550):
        Kvco = 27.4
    elif (Fvco<4200):
        Kvco = 28+(30-28)*(Fvco-3700)/(4200-3700)
    elif (Fvco<4700):
        Kvco = 30+(33-30)*(Fvco-4200)/(4700-4200)        
    elif (Fvco<5200):
        Kvco = 33+(36-33)*(Fvco-4700)/(5200-4700)
    elif (Fvco<5700):
        Kvco = 36+(41-36)*(Fvco-5200)/(5700-5200)
    elif (Fvco<6200):
        Kvco = 41+(47-41)*(Fvco-5700)/(6200-5700)
    elif (Fvco<7100):
        Kvco = 47+(51-47)*(Fvco-6200)/(6800-6200)
    else:
        Kvco = 53
    CalculatedKvco.dValue=Kvco   
 
def CHDIV_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_DIST_PD_Update():
    UpdateDistribution()
    ValidateFrequencies()
    
def CHDIV_SEG1_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_SEG2_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_SEG3_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_SEG1_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_SEG2_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_SEG3_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()
    
def CHDIV_SEG_SEL_Update():       
    if (CHDIV_SEG_SEL.iValue==1):
        CHDIV_SEG1_EN.iValue=1
        CHDIV_SEG2_EN.iValue=0
        CHDIV_SEG3_EN.iValue=0        
    if (CHDIV_SEG_SEL.iValue==2):
        CHDIV_SEG1_EN.iValue=1
        CHDIV_SEG2_EN.iValue=1
        CHDIV_SEG3_EN.iValue=0
    if (CHDIV_SEG_SEL.iValue==4):
        CHDIV_SEG1_EN.iValue=1
        CHDIV_SEG2_EN.iValue=1
        CHDIV_SEG3_EN.iValue=1
    UpdateDistribution()
    ValidateFrequencies()


def CHDIV_DISTA_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()

def CHDIV_DISTB_EN_Update():
    UpdateDistribution()
    ValidateFrequencies()

def VCO_DISTA_PD_Update():
    UpdateDistribution()
    ValidateFrequencies()

def VCO_DISTB_PD_Update():
    UpdateDistribution()
    ValidateFrequencies()
    
def OUTA_MUX_Update():
    if (OUTA_MUX.iValue==0):
        VCO_DISTA_PD.iValue=1
        CHDIV_DISTA_EN.iValue=1
        CHDIV_DIST_PD.iValue=0
    else:
        VCO_DISTA_PD.iValue=0
        CHDIV_DISTA_EN.iValue=0
    UpdateDistribution()
    
def OUTA_MUX_Update_UI():
    ValidateFrequencies()
    
def OUTB_MUX_Update():
    if (OUTB_MUX.iValue==0):
        VCO_DISTB_PD.iValue=1
        CHDIV_DISTB_EN.iValue=1
        CHDIV_DIST_PD.iValue=0
    else:
        VCO_DISTB_PD.iValue=0
        CHDIV_DISTB_EN.iValue=0
    UpdateDistribution()

def OUTB_MUX_Update_UI():
    ValidateFrequencies()

def OUTA_PD_Update():
    if (OUTA_PD.iValue==1):
        VCO_DISTA_PD.iValue=1
        CHDIV_DISTA_EN.iValue=0
    elif (OUTA_MUX.iValue==0):
        VCO_DISTA_PD.iValue=1
        CHDIV_DISTA_EN.iValue=1 
    else:
        VCO_DISTA_PD.iValue=0
        CHDIV_DISTA_EN.iValue=0    
    UpdateDistribution()
    ValidateFrequencies()
           
def OUTB_PD_Update():
    if (OUTB_PD.iValue==1):
        VCO_DISTB_PD.iValue=1
        CHDIV_DISTB_EN.iValue=0
    elif (OUTB_MUX.iValue==0):
        VCO_DISTB_PD.iValue=1
        CHDIV_DISTB_EN.iValue=1 
    else:
        VCO_DISTB_PD.iValue=0
        CHDIV_DISTB_EN.iValue=0  
    UpdateDistribution()
    ValidateFrequencies()

def OUTA_PWR_Update():
    ValidateFrequencies()

def OUTB_PWR_Update():
    ValidateFrequencies()
    
    

def UpdateDistribution():      
    UpdateChDiv()
    UpdateOutMux()
    UpdatePowerSettings()
    pass
      
    
    
def UpdateChDiv():
    SEG1=1
    SEG2=1
    SEG3=1
    CHDIV=1
    

    if (CHDIV_SEG1.iValue==0):
        SEG1=2      
    elif (CHDIV_SEG1.iValue==1):
        SEG1=3
    else:
        SEG1=1


    if (CHDIV_SEG2.iValue==8):
        SEG2=8
    elif (CHDIV_SEG2.iValue==4):
        SEG2=6
    elif (CHDIV_SEG2.iValue==2):
        SEG2=4
    elif (CHDIV_SEG2.iValue==1):
        SEG2=2
    else:
        SEG2=1


    if (CHDIV_SEG3.iValue==8):
        SEG3=8
    elif (CHDIV_SEG3.iValue==4):
        SEG3=6
    elif (CHDIV_SEG3.iValue==2):
        SEG3=4
    elif (CHDIV_SEG3.iValue==1):
        SEG3=2
    else:
        SEG3=1 


    if (CHDIV_SEG_SEL.iValue==4):         
        CHDIV=SEG1*SEG2*SEG3        
    elif (CHDIV_SEG_SEL.iValue==2):
        CHDIV=SEG1*SEG2
    else:         
        CHDIV=SEG1

       
    CalculatedTotalDivide.dValue=CHDIV

	
	
def UpdateOutMux():
    Fin = Fvco_FREQ.dValue*(1+VCO_2X.iValue)
    Fchdiv = Fin/CalculatedTotalDivide.dValue
    if (OUTA_MUX.iValue==0):
        FoutA_FREQ.dValue=Fchdiv
    else:
        FoutA_FREQ.dValue=Fin
    if (OUTB_MUX.iValue==0):
        FoutB_FREQ.dValue=Fchdiv
    else:
        FoutB_FREQ.dValue=Fin
    pass
    
    
def UpdatePowerSettings():  
    #   This routine Dims and UnDims Sections of the Powerdown Selection
    FoutA_PD=False
    FoutB_PD=False
    
   
    #   Do Outputs and output Mux and powerdown box
    if (OUTA_PD.iValue==1) :
        FoutA_PD=True
    if (OUTA_MUX.iValue==0) and (CHDIV_DISTA_EN.iValue==0):
        FoutA_PD=True
    if (OUTA_MUX.iValue==1) and (VCO_DISTA_PD.iValue==1):
        FoutA_PD=True
    if (FoutA_PD==True):
        Dim(FoutA_FREQ)
        Dim(OUTA_MUX)
        Dim(OUTA_PWR)
    else:
        UnDim(FoutA_FREQ)
        UIC_OUTA_MUX.Background=brush_white
        UnDim(OUTA_PWR)    
        
    if (OUTB_PD.iValue==1) :
        FoutB_PD=True
    if (OUTB_MUX.iValue==0) and (CHDIV_DISTB_EN.iValue==0):
        FoutB_PD=True
    if (OUTB_MUX.iValue==1) and (VCO_DISTB_PD.iValue==1):
        FoutB_PD=True
    if (FoutB_PD==True):
        Dim(FoutB_FREQ)
        Dim(OUTB_MUX)
        Dim(OUTB_PWR)
    else:
        UnDim(FoutB_FREQ)
        UIC_OUTB_MUX.Background = brush_white
        UnDim(OUTB_PWR)

		
 
    #   Channel Divider & Channel Mux
    if (CHDIV_EN.iValue==0) or (CHDIV_DIST_PD.iValue==1):
        Dim(CHDIV_SEG_SEL)
        if (OUTA_MUX.iValue==0) or (OUTB_MUX.iValue==0):
            UIC_CHDIV_SEG_SEL.Background=brush_warning
            UIC_CHDIV_SEG1.ToolTip="channel divider is used"           
    else:
        UIC_CHDIV_SEG_SEL.Background = brush_white

    if (CHDIV_SEG1_EN.iValue==0):
        Dim(CHDIV_SEG1)
        if (CHDIV_SEG_SEL.iValue==1) or (CHDIV_SEG_SEL.iValue==2) or (CHDIV_SEG_SEL.iValue==4):
            UIC_CHDIV_SEG1.Background=brush_warning
            UIC_CHDIV_SEG1.ToolTip="channel divider segment 1 is used"
    else:
        UIC_CHDIV_SEG1.Background = brush_white
 
    if (CHDIV_SEG2_EN.iValue==0):
        Dim(CHDIV_SEG2)
        if (CHDIV_SEG_SEL.iValue==2) or (CHDIV_SEG_SEL.iValue==4):
            UIC_CHDIV_SEG2.Background=brush_warning
            UIC_CHDIV_SEG2.ToolTip="channel divider segment 2 is used"
    else:
        UIC_CHDIV_SEG2.Background = brush_white                

    if (CHDIV_SEG3_EN.iValue==0):
        Dim(CHDIV_SEG3)
        if (CHDIV_SEG_SEL.iValue==4):
            UIC_CHDIV_SEG3.Background=brush_warning
            UIC_CHDIV_SEG3.ToolTip="channel divider segment 3 is used"
    else:
        UIC_CHDIV_SEG3.Background = brush_white  
    pass
 
def ValidateFrequencies():
    Fosc=Fosc_FREQ.dValue
	
    #   Check OSCin
    if (Fosc<5):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Minimum Fosc is 5 MHz"
    elif (Fosc>1400):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Maximum Fosc is 1400 MHz"
    else:
        UIC_Fosc_FREQ.Background = brush_white
        UIC_Fosc_FREQ.ToolTip=None
        
    Fosc=Fosc_FREQ.dValue
   
    if (Fosc<200.01):
        NewIndex=0
    elif (Fosc<400.01):
        NewIndex=1
    elif (Fosc<800.01):
        NewIndex=2
    else:
        NewIndex=3
        
    if (CAL_CLK_DIV.iValue==NewIndex):
        UIC_CAL_CLK_DIV.Background = brush_white
        UIC_CAL_CLK_DIV.ToolTip = None
    else:
        UIC_CAL_CLK_DIV.Background = brush_alert
        UIC_CAL_CLK_DIV.ToolTip = "CAL_CLK_DIV Should be adjusted to state "+str(NewIndex)         

    #   Check OSCin Doubler
    if  (OSC_2X.iValue+1)*Fosc>1400:
        UIC_OSC_2X.Background = brush_warning
        UIC_OSC_2X.ToolTip = "Maximum Input Frequency for the OSCin doubler is 700 MHz."
    else:
        UIC_OSC_2X.Background = brush_white
        
    #   Check Multiplier  
    PreR=PLL_R_PRE.iValue
    if (0==PreR):
        PreR=1
    MultIn = (OSC_2X.iValue+1)*Fosc/PreR
    MultOut = MultIn*MULT.iValue  
         
    if  (MULT.iValue==1):
        UIC_MULT.Background = brush_white
        UIC_MULT.ToolTip=None
    elif (MULT.iValue==2):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="A Multiply value of 2 is not supported.  However this can be done with the OSCin doubler."
    elif (MULT.iValue>6):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Multiply Values of greater than 6 are not supported." 
    elif (MultIn<40):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Minimum input frequency to the Multiplier is 40 MHz"
    elif (MultIn>70):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Maximum input frequency to the Multiplier is 70 MHz"
    elif (MultOut<180):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="When the multiplier is engaged, the output frequency has to be at least 180 MHz."
    elif (MultOut>240):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="When the multiplier is engaged, the output frequency can not be greater than 240 MHz."  
    else:
        UIC_MULT.Background = brush_white
        UIC_MULT.ToolTip=None
    
    #   Check Phase Detector Frequency 
    if (Fpd_FREQ.dValue<0.25):
        UIC_Fpd_FREQ.Background = brush_warning
        UIC_Fpd_FREQ.ToolTip="Minimum Phase Detector Frequency is 250 kHz."
    elif (Fpd_FREQ.dValue>400):
        UIC_Fpd_FREQ.Background = brush_warning
        UIC_Fpd_FREQ.ToolTip="Maximum Phase Detector Frequency is 400 MHz."
    else:
        UIC_Fpd_FREQ.Background = brush_white
        UIC_Fpd_FREQ.ToolTip=None
        
    #   Set FCAL_LPFD_ADJ and FCAL_LPFD_ADJ
    Fpd=Fpd_FREQ.dValue

    if (Fpd<2.5):
        NewIndex=3
        NewIndex2=0
    elif (Fpd<5):
        NewIndex=2
        NewIndex2=0
    elif (Fpd<10):
        NewIndex=1
        NewIndex2=0
    elif (Fpd<100.1):
        NewIndex=0
        NewIndex2=0
    elif (Fpd<150.1):
        NewIndex=0
        NewIndex2=1
    elif (Fpd<200.1):
        NewIndex=0
        NewIndex2=2
    else:
        NewIndex=0
        NewIndex2=3     
 
    if (FCAL_LPFD_ADJ.iValue==NewIndex):
        UIC_FCAL_LPFD_ADJ.Background = brush_white
        UIC_FCAL_LPFD_ADJ.ToolTip=None
    else:
        UIC_FCAL_LPFD_ADJ.Background = brush_alert
        UIC_FCAL_LPFD_ADJ.ToolTip="FCAL_LPFD_ADJ should be adjusted from state " +str(FCAL_LPFD_ADJ.iValue)+ " to state "+str(NewIndex) 
        
    if (FCAL_HPFD_ADJ.iValue==NewIndex2):
        UIC_FCAL_HPFD_ADJ.Background = brush_white
        UIC_FCAL_HPFD_ADJ.ToolTip=None
    else:
        UIC_FCAL_HPFD_ADJ.Background = brush_alert
        UIC_FCAL_HPFD_ADJ.ToolTip="FCAL_LPFD_ADJ should be adjusted from state " +str(FCAL_HPFD_ADJ.iValue)+ " to state "+str(NewIndex2)   

      
    #   Validate PRE_N
    if (PLL_N_PRE.iValue==0):
        if (VCO_2X.iValue==1):
            UIC_PLL_N_PRE.ToolTip="The Pre-N divider needs to be 4 whenver the VCO doubler is used."
            UIC_PLL_N_PRE.Background=brush_warning 
        elif (Fpd_FREQ.dValue<5.0001):
            UIC_PLL_N_PRE.ToolTip="The Pre-N divider needs to be 4 whenever the phase detector frequency is <=5 MHz."
            UIC_PLL_N_PRE.Background=brush_warning
        else:
            UIC_PLL_N_PRE.ToolTip=None
            UIC_PLL_N_PRE.Background=brush_white
    else:
        UIC_PLL_N_PRE.ToolTip=None
        UIC_PLL_N_PRE.Background=brush_white

    #   Check N Divider, Order, and PFD_DLY
    N=PLL_N.iValue
    Order = MASH_ORDER.iValue
    Nmin=1
    PFD_DLYnew=0
    
    if (Order==0):
        Nmin=9
        PFD_DLYnew=1
    elif (Order==1):
        Nmin=11
        PFD_DLYnew=1
    elif (Order==2):
        Nmin=16
        PFD_DLYnew=2
    elif (Order==3):
        Nmin=18
        PFD_DLYnew=2
    elif (Order==4):
        Nmin=30
        PFD_DLYnew=8
     
    if (N<9):
        UIC_PLL_N.ToolTip="PLL_N values below 9 are not supported"
        UIC_PLL_N.GetTextBox().Background = brush_warning
        UIC_MASH_ORDER.ToolTip=None
        UIC_MASH_ORDER.Background=brush_white
    elif (N<Nmin):
        UIC_PLL_N.ToolTip="This PLL_N value is too low for this MASH_ORDER, but could be supported if the MASH_ORDER is reduced."
        UIC_PLL_N.GetTextBox().Background = brush_alert
        UIC_MASH_ORDER.Background=brush_alert   
        if (N<16):
            UIC_MASH_ORDER.ToolTip="Try using the 1st Order Modulator."
        elif (N<18):
            UIC_MASH_ORDER.ToolTip="Try using the 2nd Order Modulator."
        elif (N<30):
            UIC_MASH_ORDER.ToolTip="Try using the 3rd Order Modulator."
    else:
        UIC_PLL_N.ToolTip= None
        UIC_PLL_N.GetTextBox().Background = brush_white      
        UIC_MASH_ORDER.ToolTip=None
        UIC_MASH_ORDER.Background=brush_white
        
    if (PFD_DLY.iValue==PFD_DLYnew):
        UIC_PFD_DLY.ToolTip= None
        UIC_PFD_DLY.Background=brush_white
    else:
        UIC_PFD_DLY.ToolTip="State "+str(PFD_DLY.iValue)+" should be changed to state " + str(PFD_DLYnew) + ".  If already at this state, toggle this to another state and back to clear this warning."
        UIC_PFD_DLY.Background = brush_alert

    #   Check MASH_DITHER
    UIC_MASH_DITHER.Background=brush_white
    UIC_MASH_DITHER.ToolTip=None
    
    if (MASH_DITHER.iValue==1):
        Fnum=PLL_NUM.iValue
        Fden=PLL_DEN.iValue
        if (Fnum==0):
            Fden=1
        while ( (0 == (Fnum%2)) and (0==(Fden%2))):
            Fnum=Fnum/2
            Fden=Fden/2
        while ( (0 == (Fnum%3)) and (0==(Fden%3))):
            Fnum=Fum/3
            Fden=Fden/3
        while ( (0 == (Fnum%3)) and (0==(Fden%3))):
            Fnum=Fum/3
            Fden=Fden/3
            
        NoDither=0
        if (Fnum==0):
            NoDither=1
        if (MASH_ORDER.iValue<2):
            NoDither=1
        if (0 < (Fden % 2)) and (MASH_ORDER.iValue==2):
            NoDither=1
        if (0 <(Fden % 2)) and (0 <(Fden % 3)) and(MASH_ORDER.iValue>2):
            NoDither=1

        if (NoDither==1):
            UIC_MASH_DITHER.Background=brush_alert
            UIC_MASH_DITHER.ToolTip="Dithering will likely not improve performance in this situation as there should be no sub-fractional spurs."
        
    #   Check VCO Frequency
    if (Fvco_FREQ.dValue<3550):
        UIC_Fvco_FREQ.ToolTip="Minimum VCO Frequency is 3550 MHz."
        UIC_Fvco_FREQ.Background = brush_warning
    elif (Fvco_FREQ.dValue>7100):
        UIC_Fvco_FREQ.Background = brush_warning
        UIC_Fvco_FREQ.ToolTip="Maximum VCO Frequency is 7100 MHz."
    else:
        UIC_Fvco_FREQ.Background = brush_white
        UIC_Fvco_FREQ.ToolTip=None
        
    #   Check VCO Doubler
    UIC_VCO_2X.Background = brush_white
    UIC_VCO_2X.ToolTip = None
    UIC_OUTA_MUX.Background = brush_white
    UIC_OUTA_MUX.ToolTip = None
    UIC_OUTB_MUX.Background = brush_white
    UIC_OUTB_MUX.ToolTip = None
    
    if (1==VCO_2X.iValue):
        if (Fvco_FREQ.dValue>4900):
            UIC_VCO_2X.Background = brush_warning
            UIC_VCO_2X.ToolTip="The VCO doubler can not be used if the VCO frequency is greater than 4900 MHz."
  
    #   Validate Output Frequencies
    if (FoutA_FREQ.dValue<18.5):
        UIC_FoutA_FREQ.ToolTip="Minimum output frequency is 18.5 MHz."
        UIC_FoutA_FREQ.Background = brush_warning
    elif (FoutA_FREQ.dValue>5500):
        UIC_FoutA_FREQ.Background = brush_warning
        UIC_FoutA_FREQ.ToolTip="Maximum output frequency is 5500 MHz."
    elif (OUTA_MUX.iValue==0) and (VCO_2X.iValue==1):
        UIC_FoutA_FREQ.Background = brush_warning
        UIC_FoutA_FREQ.ToolTip="The Output Divider can not be used at the same time as the VCO doubler."
    else:
        UIC_FoutA_FREQ.Background = brush_white
        UIC_FoutA_FREQ.ToolTip=None
        
    if (FoutB_FREQ.dValue<18.5):
        UIC_FoutB_FREQ.ToolTip="Minimum output frequency is 18.5 MHz."
        UIC_FoutB_FREQ.Background = brush_warning
    elif (FoutB_FREQ.dValue>5500):
        UIC_FoutB_FREQ.Background = brush_warning
        UIC_FoutB_FREQ.ToolTip="Maximum output frequency is 5500 MHz."
    elif (OUTB_MUX.iValue==0) and (VCO_2X.iValue==1):
        UIC_FoutB_FREQ.Background = brush_warning
        UIC_FoutB_FREQ.ToolTip="The Output Divider can not be used at the same time as the VCO doubler."
    else:
        UIC_FoutB_FREQ.Background = brush_white
        UIC_FoutB_FREQ.ToolTip=None   
        
    UpdatePowerSettings()
    
def btn_LoadRegisters_Update():
    btn_LoadRegisters.Background=brush_white
    btn_LoadRegisters.ToolTip=None
    UIC_FCAL_EN.Background=brush_white
    UIC_FCAL_EN.ToolTip=None
    WriteAllRegisters()
    
def FCAL_EN_Update():
    btn_LoadRegisters.Background=brush_white
    btn_LoadRegisters.ToolTip=None
    UIC_FCAL_EN.Background=brush_white
    UIC_FCAL_EN.ToolTip=None
    
def btn_SimplifyFraction_Update():
    Fnum=PLL_NUM.iValue
    Fden=PLL_DEN.iValue


    if  ((Fnum==0) or (Fden==0)):
        Fden=1
        Fnum=0
    else:
        Divisor = 2      
        while ( Divisor<Fnum+1):
            if (0 == (Fnum % Divisor)) and (0 == (Fden % Divisor)):
                Fnum=Fnum/Divisor
                Fden=Fden/Divisor
            else:
                Divisor=Divisor+1
                
        if (Fden%Fnum==0):
            Fden=Fden/Fnum
            Fnum=1
    
    UpdateStatusBar("Fraction Simplified to "+str(Fnum)+"/"+str(Fden))     
    PLL_DEN.iValue=Fden
    PLL_NUM.iValue=Fnum
    
def CAL_CLK_DIV_Update_UI():
    ValidateFrequencies()

def FCAL_HPFD_ADJ_Update_UI():
    ValidateFrequencies()
    
def FCAL_LPFD_ADJ_Update_UI():
    ValidateFrequencies()
    
def MASH_ORDER_Update_UI():
    ValidateFrequencies()
    
def PFD_DLY_Update_UI():
    ValidateFrequencies()
