"""
Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/ 
ALL RIGHTS RESERVED 
"""

#from System.Windows.Media import SolidColorBrush, Color, Colors

#from System.Windows.Controls import(ComboBox,ComboBoxItem)
#from System.Windows import TextAlignment,FontWeights

#import sys
#import clr
#clr.AddReference("System.Windows.Forms")
##from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon

#import math
from System.Windows.Media import SolidColorBrush, Color, Colors
from System.Windows.Controls import(ComboBox,ComboBoxItem)
from System.Windows import TextAlignment,FontWeights
import math
   
text_grey = SolidColorBrush(Color.FromArgb(153,153,153,0))
text_black = SolidColorBrush(Colors.Black)
brush_violation = SolidColorBrush(Color.FromArgb(255,204,0,0))
brush_white = SolidColorBrush(Color.FromArgb(255,255,255,255))
brush_alert = SolidColorBrush(Color.FromArgb(255,253,205,52))

# Note: In some places elements are accessed using UIC_Control (UI Control Element) because of the clash with controls in User Controls Page


def System_Update_Loaded_Mode():
    UpdateGUItoOperatingMode()
    Fvco_FREQ_Update
    ValidateDiagram()
    UpdateCurrent()
    flexOUTBUF_TX_EN_Update()
    flexOUTBUF_RX_EN_Update()

def System_Update():
    UpdateGUItoOperatingMode()
    Fvco_FREQ_Update
    ValidateDiagram()
    UpdateCurrent()
    flexOUTBUF_TX_EN_Update()
    flexOUTBUF_RX_EN_Update()

def System_Update_Run_Once():
    UpdateGUItoOperatingMode()
    Fvco_FREQ_Update
    ValidateDiagram()
    UpdateCurrent()
    flexOUTBUF_TX_EN_Update()
    flexOUTBUF_RX_EN_Update()
       
def Fosc_FREQ_Update_UI():
    ValidateDiagram()       

def flexPLL_R_PRE_Update_UI():
    ValidateDiagram()      
    
def flexMULT_Update_UI():
    ValidateDiagram()   

def flexPFD_DELAY_Update_UI():
    ValidateDiagram()        
    
def flexPLL_R_Update():
    ValidateDiagram()      
    
def flexFpd_FREQ_Update_UI():
    ValidateDiagram() 

def flexFRAC_ORDER_Update_UI():
    ValidateDiagram()     

def Fvco_FREQ_Update_UI():
    ValidateDiagram()      
    
def Fout_FREQ_Update_UI():
    ValidateDiagram()     
    
def flexPLL_N_PRE_Update_UI():
    ValidateDiagram()   
    
def CP_IUP_Update_UI():
    ValidateDiagram()

def CP_IDN_Update_UI():
    ValidateDiagram()
    
def EXTVCO_CP_IUP_Update_UI():
    ValidateDiagram()

def EXTVCO_CP_IDN_Update_UI():
    ValidateDiagram()    
    
    
    
def FCAL_EN_Update():
    UIC_FCAL_EN.Background=brush_white
    UIC_FCAL_EN.ToolTip=None
    
    
def CP_IUP_Update():
    UpdateKpd()
    
def EXTVCO_CP_IUP_Update():
    UpdateKpd()
    
def CP_GAIN_Update():
    UpdateKpd()
    
def EXTVCO_CP_GAIN_Update():
    UpdateKpd()    
    
def flexOUTBUF_TX_EN_Update():
    if (GetActivePLL()==1):
        OUTBUF_TX_EN_F1.iValue=flexOUTBUF_TX_EN.iValue
    else:
        OUTBUF_TX_EN_F2.iValue=flexOUTBUF_TX_EN.iValue
       
    if (flexOUTBUF_TX_EN.iValue==0):
        Dim(flexOUTBUF_TX_PWR)
    else:
        UnDim(flexOUTBUF_TX_PWR)
    UpdateCurrent()
    
def flexOUTBUF_RX_EN_Update():
    if (GetActivePLL()==1):
        OUTBUF_RX_EN_F1.iValue=flexOUTBUF_RX_EN.iValue
    else:
        OUTBUF_RX_EN_F2.iValue=flexOUTBUF_RX_EN.iValue
       
    if (flexOUTBUF_RX_EN.iValue==0):
        Dim(flexOUTBUF_RX_PWR)
    else:
        UnDim(flexOUTBUF_RX_PWR)
    UpdateCurrent()  
   
def flexOUTBUF_TX_PWR_Update():
    if (GetActivePLL()==1):
        OUTBUF_TX_PWR_F1.iValue=flexOUTBUF_TX_PWR.iValue
    else:
        OUTBUF_TX_PWR_F2.iValue=flexOUTBUF_TX_PWR.iValue
        
    if (flexOUTBUF_TX_EN.iValue==0):
        Dim(flexOUTBUF_TX_PWR)
    else:
        UnDim(flexOUTBUF_TX_PWR)
    UpdateCurrent()
    
def flexOUTBUF_RX_PWR_Update():
    if (GetActivePLL()==1):
        OUTBUF_RX_PWR_F1.iValue=flexOUTBUF_RX_PWR.iValue
    else:
        OUTBUF_RX_PWR_F2.iValue=flexOUTBUF_RX_PWR.iValue
    UpdateCurrent()     
    
def EXTVCO_SEL_F1_Update():
    UpdateGUItoOperatingMode()
    UpdateCurrent()
    
def EXTVCO_SEL_F2_Update():
    UpdateGUItoOperatingMode()
    UpdateCurrent()  
 
    
def Fosc_FREQ_Update():
    if (Fosc_FREQ.dValue<0.0001):
        Fosc_FREQ.dValue=1
    UpdateFpd()
    if (GetActivePLL()==1):
        Fosc_F1_FREQ.dValue=Fosc_FREQ.dValue
    else:
        Fosc_F2_FREQ.dValue=Fosc_FREQ.dValue
        
def flexFRAC_ORDER_Update():
    if (GetActivePLL()==1):
        FRAC_ORDER_F1.iValue=flexFRAC_ORDER.iValue
    else:
        FRAC_ORDER_F2.iValue=flexFRAC_ORDER.iValue
    UpdateCurrent()
    
def flexPLL_R_PRE_Update():
    UpdateFpd()
    if (GetActivePLL()==1):
        PLL_R_PRE_F1.iValue=flexPLL_R_PRE.iValue
    else:
        PLL_R_PRE_F2.iValue=flexPLL_R_PRE.iValue  
        
def flexMULT_Update():
    UpdateFpd()
    if (GetActivePLL()==1):
        MULT_F1.iValue=flexMULT.iValue
    else:
        MULT_F2.iValue=flexMULT.iValue  
        
def flexPFD_DELAY_Update():
    if (GetActivePLL()==1):
        PFD_DELAY_F1.iValue=flexPFD_DELAY.iValue
    else:
        PFD_DELAY_F2.iValue=flexPFD_DELAY.iValue         
        

def flexPLL_R_Update():
    UpdateFpd()   
    if (GetActivePLL()==1):
        PLL_R_F1.iValue=flexPLL_R.iValue
    else:
        PLL_R_F2.iValue=flexPLL_R.iValue   
    
def UpdateFpd():
    PLL_R_PRE=flexPLL_R_PRE.iValue
    if (PLL_R_PRE==0):
        PLL_R_PRE = 1
    
    MULT = flexMULT.iValue
    if (MULT==0):
        MULT=1
    
    PLL_R = flexPLL_R.iValue
    if (PLL_R==0):
        PLL_R=1
    Fpd_FREQ.dValue = MULT*Fosc_FREQ.dValue/(PLL_R_PRE*PLL_R)
    
    if (GetActivePLL()==1):
        Fpd_F1_FREQ.dValue=Fpd_FREQ.dValue
    else:
        Fpd_F2_FREQ.dValue=Fpd_FREQ.dValue
     
    UpdateFvco()
    

def Fpd_FREQ_Update():
    PLL_R_PRE=flexPLL_R_PRE.iValue
    if (PLL_R_PRE<1):
        PLL_R_PRE=1
    
    MULT=flexMULT.iValue
    if (MULT==0):
        MULT=1
        
    MULTout = MULT*Fosc_FREQ.dValue/PLL_R_PRE
    Fpd=Fpd_FREQ.dValue
    if (Fpd<0.0001):
        Fpd =0.01
        
    PLL_R = int(round(MULTout/Fpd))
    if (PLL_R<1):
        PLL_R=1
        Fpd_FREQ.dValue=MULTout/PLL_R
    if (PLL_R>255):
        PLL_R=255
        Fpd_FREQ.dValue=MULTout/PLL_R
        
    flexPLL_R.iValue=PLL_R
    if (GetActivePLL()==1):
        PLL_R_F1.iValue=flexPLL_R.iValue
    else:
        PLL_R_F2.iValue=flexPLL_R.iValue  
    
    Fpd_FREQ.dValue=MULTout/PLL_R
    if (GetActivePLL()==1):
        Fosc_F1_FREQ.dValue=Fosc_FREQ.dValue
    else:
        Fosc_F2_FREQ.dValue=Fosc_FREQ.dValue  

    UpdateFvco()
    
def UpdateFvco():
    Fden = 1
    if (flexPLL_DEN.iValue>0):
        Fden=flexPLL_DEN.iValue
    else:
        Fden = pow(2,24)
        
    Fvco = round(Fpd_FREQ.dValue*(flexPLL_N.iValue) + flexPLL_NUM.iValue*Fpd_FREQ.dValue/Fden,10)
    
    if (GetVCOMode()==0):
        Fvco=Fvco*2*(flexPLL_N_PRE.iValue+1)
        flexIntVCO_FREQ.dValue=Fvco
        UpdateKvco()
    else:
        flexExtVCO_FREQ.dValue=Fvco
        
    Fvco_FREQ.dValue=Fvco
    UpdateFout()
    
    if (GetActivePLL()==1):
        Fvco_F1_FREQ.dValue=Fvco
    else:
        Fvco_F2_FREQ.dValue=Fvco  
    
    UIC_FCAL_EN.Background=brush_violation
    UIC_FCAL_EN.ToolTip="Whenver the VCO frequency is changed, the VCO needs to be recalibrated by toggling the FCAL_EN bit."

    
def Fvco_FREQ_Update():
    TotalN = Fvco_FREQ.dValue/Fpd_FREQ.dValue
    Fden=1
    if (flexPLL_DEN.iValue>0):
        Fden=flexPLL_DEN.iValue
    else:
        Fden=pow(2,24)
    
    PreN=1
    if (0==GetVCOMode()):
        PreN = 2*(flexPLL_N_PRE.iValue+1)

    TotalN = TotalN/PreN
    
    flexPLL_N.iValue=int(TotalN)
    if (GetActivePLL()==1):
        PLL_N_F1.iValue=flexPLL_N.iValue
    else:
        PLL_N_F2.iValue=flexPLL_N.iValue  
    
    flexPLL_NUM.iValue=round(Fden*(TotalN-1.0*int(TotalN)),0)
    if (GetActivePLL()==1):
        PLL_NUM_F1.iValue=flexPLL_NUM.iValue
    else:
        PLL_NUM_F2.iValue=flexPLL_NUM.iValue  
        
    UpdateFvco()
          
    
def UpdateFout():
    if (1==GetVCOMode() ):
        flexOutputDivide.iValue=flexEXTVCO_CHDIV.iValue
    else:
        flexOutputDivide.iValue=flexCHDIV1.iValue*pow(2,flexCHDIV2.iValue)
    CHDIV=flexOutputDivide.iValue
    
    
    if (CHDIV==0):
        CHDIV=1
    Fout_FREQ.dValue=round(Fvco_FREQ.dValue/CHDIV,10)
    
    if (GetActivePLL()==1):
        Fout_F1_FREQ.dValue=round(Fout_FREQ.dValue,10)
    else:
        Fout_F2_FREQ.dValue=round(Fout_FREQ.dValue,10)
    
    UpdateCurrent()
    
def Fout_FREQ_Update():
    if (GetVCOMode()==1):
        CHDIV=flexEXTVCO_CHDIV.iValue
    else:
        CHDIV=flexCHDIV1.iValue*pow(2,flexCHDIV2.iValue)
        
    if (CHDIV==0):
        CHDIV=1

    Fvco_FREQ.dValue=round(CHDIV*Fout_FREQ.dValue,10)
    Fvco_FREQ_Update()
    
    
def flexCHDIV1_Update():
    if (GetActivePLL()==1):
        CHDIV1_F1.iValue=flexCHDIV1.iValue-4
    else:
        CHDIV1_F2.iValue=flexCHDIV1.iValue-4 

    UpdateFout()
    
def flexCHDIV2_Update():
    if (GetActivePLL()==1):
        CHDIV2_F1.iValue=flexCHDIV2.iValue
    else:
        CHDIV2_F2.iValue=flexCHDIV2.iValue 
    UpdateFout() 

def flexEXTVCO_CHDIV_Update():   
    if (GetActivePLL()==1):
        EXTVCO_CHDIV_F1.iValue=flexEXTVCO_CHDIV.iValue
    else:
        EXTVCO_CHDIV_F2.iValue=flexEXTVCO_CHDIV.iValue  
    UpdateFout()
     
def flexPLL_NUM_Update():
    UpdateFvco()

    if (GetActivePLL()==1):
        PLL_NUM_F1.iValue=flexPLL_NUM.iValue
    else:
        PLL_NUM_F2.iValue=flexPLL_NUM.iValue      

def flexPLL_DEN_Update():
    UpdateFvco()

    if (GetActivePLL()==1):
        PLL_DEN_F1.iValue=flexPLL_DEN.iValue
    else:
        PLL_DEN_F2.iValue=flexPLL_DEN.iValue   
        

def flexPLL_N_Update():
    UpdateFvco()

    if (GetActivePLL()==1):
        PLL_N_F1.iValue=flexPLL_N.iValue
    else:
        PLL_N_F2.iValue=flexPLL_N.iValue   
        
        
def flexPLL_N_PRE_Update():
    UpdateFvco()

    if (GetActivePLL()==1):
        PLL_N_PRE_F1.iValue=flexPLL_N_PRE.iValue
    else:
        PLL_N_PRE_F2.iValue=flexPLL_N_PRE.iValue         
                
def F1F2_SEL_Update(): 
    UpdateGUItoOperatingMode()

def F1F2_CTRL_Update():
    UpdateGUItoOperatingMode()
    
def TrCtl_Pin_Update():
    SetPin("TrCtl",TrCtl_Pin.iValue)
    UpdateGUItoOperatingMode()
    
def UpdateGUItoOperatingMode():

    UIC_LF_R3_F1.Foreground=text_grey
    UIC_LF_R4_F1.Foreground=text_grey
    UIC_LF_R3_F2.Foreground=text_grey
    UIC_LF_R4_F2.Foreground=text_grey
        
    if (GetVCOMode()==0):
        if (GetActivePLL()==1):
            UIC_LF_R3_F1.Foreground=text_black
            UIC_LF_R4_F1.Foreground=text_black
            UIC_LF_R3_F2.Foreground=text_grey
            UIC_LF_R4_F2.Foreground=text_grey
        else:
            UIC_LF_R3_F1.Foreground=text_grey
            UIC_LF_R4_F1.Foreground=text_grey
            UIC_LF_R3_F2.Foreground=text_black
            UIC_LF_R4_F2.Foreground=text_black
    
        UIC_FCAL_EN.Foreground=text_black
        UIC_flexPLL_N_PRE.Foreground=text_black
        UnDim(flexCHDIV1)
        UIC_flexCHDIV2.Foreground=text_black
        UIC_FCAL_EN.Foreground=text_black
        UIC_flexKvco.Foreground=text_black
        UIC_flexIntVCO_FREQ.Foreground=text_black            
                                            
        UIC_EXTVCO_CP_IUP.Foreground=text_grey
        UIC_EXTVCO_CP_IDN.Foreground=text_grey
        UIC_EXTVCO_CP_GAIN.Foreground=text_grey
        UIC_flexEXTVCO_CHDIV.Foreground=text_grey
        UIC_flexExtVCO_FREQ.Foreground=text_grey
    else:
        UIC_LF_R3_F1.Foreground=text_grey
        UIC_LF_R4_F1.Foreground=text_grey
        UIC_LF_R3_F2.Foreground=text_grey
        UIC_LF_R4_F2.Foreground=text_grey
        UIC_FCAL_EN.Foreground=text_grey
        
        UIC_flexPLL_N_PRE.Foreground=text_grey
        Dim(flexCHDIV1)
        UIC_flexCHDIV2.Foreground=text_grey
        UIC_FCAL_EN.Foreground=text_grey
        UIC_flexKvco.Foreground=text_grey
        UIC_flexIntVCO_FREQ.Foreground=text_grey            
                                            
        UIC_EXTVCO_CP_IUP.Foreground=text_black
        UIC_EXTVCO_CP_IDN.Foreground=text_black
        UIC_EXTVCO_CP_GAIN.Foreground=text_black
        UIC_flexEXTVCO_CHDIV.Foreground=text_black
        UIC_flexExtVCO_FREQ.Foreground=text_black           
    
    
    if (GetActivePLL()==1):
        GetSettingsFromF1()
        
        UIC_Fosc_F1_FREQ.Foreground=text_black
        UIC_PLL_R_PRE_F1.Foreground=text_black
        UIC_MULT_F1.Foreground=text_black
        UIC_PLL_R_F1.Foreground=text_black
        UIC_Fpd_F1_FREQ.Foreground=text_black
        UIC_PLL_N_F1.Foreground=text_black
        UIC_PLL_NUM_F1.Foreground=text_black
        UIC_PLL_DEN_F1.Foreground=text_black
        UIC_PLL_N_PRE_F1.Foreground=text_black
        UIC_PFD_DELAY_F1.Foreground=text_black
        UIC_FRAC_ORDER_F1.Foreground=text_black
        UIC_Fvco_F1_FREQ.Foreground=text_black
        
        UIC_Fosc_F2_FREQ.Foreground=text_grey
        UIC_PLL_R_PRE_F2.Foreground=text_grey
        UIC_MULT_F2.Foreground=text_grey
        UIC_PLL_R_F2.Foreground=text_grey
        UIC_Fpd_F2_FREQ.Foreground=text_grey
        UIC_PLL_N_F2.Foreground=text_grey
        UIC_PLL_NUM_F2.Foreground=text_grey
        UIC_PLL_DEN_F2.Foreground=text_grey
        UIC_PLL_N_PRE_F2.Foreground=text_grey
        UIC_PFD_DELAY_F2.Foreground=text_grey
        UIC_FRAC_ORDER_F2.Foreground=text_grey
        UIC_Fvco_F2_FREQ.Foreground=text_grey        
        
        UIC_CHDIV1_F1.Foreground=text_black
        UIC_CHDIV2_F1.Foreground=text_black
        UIC_EXTVCO_CHDIV_F1.Foreground=text_black
        UIC_OUTBUF_TX_PWR_F1.Foreground=text_black
        UIC_OUTBUF_TX_EN_F1.Foreground=text_black
        UIC_OUTBUF_RX_PWR_F1.Foreground=text_black
        UIC_OUTBUF_RX_PWR_F1.Foreground=text_black
        UIC_Fout_F1_FREQ.Foreground=text_black
        
        UIC_CHDIV1_F2.Foreground=text_grey
        UIC_CHDIV2_F2.Foreground=text_grey
        UIC_EXTVCO_CHDIV_F2.Foreground=text_grey
        UIC_OUTBUF_TX_PWR_F2.Foreground=text_grey
        UIC_OUTBUF_TX_EN_F2.Foreground=text_grey
        UIC_OUTBUF_RX_PWR_F2.Foreground=text_grey
        UIC_OUTBUF_RX_EN_F2.Foreground=text_grey
        UIC_Fout_F2_FREQ.Foreground=text_grey        
        
        UIC_EXTVCO_SEL_F1.Foreground=text_black
        UIC_EXTVCO_SEL_F2.Foreground=text_grey

    if (GetActivePLL()==2):
        GetSettingsFromF2()  
        
        UIC_Fosc_F2_FREQ.Foreground=text_black
        UIC_PLL_R_PRE_F2.Foreground=text_black
        UIC_MULT_F2.Foreground=text_black
        UIC_PLL_R_F2.Foreground=text_black
        UIC_Fpd_F2_FREQ.Foreground=text_black
        UIC_PLL_N_F2.Foreground=text_black
        UIC_PLL_NUM_F2.Foreground=text_black
        UIC_PLL_DEN_F2.Foreground=text_black
        UIC_PLL_N_PRE_F2.Foreground=text_black
        UIC_PFD_DELAY_F2.Foreground=text_black
        UIC_FRAC_ORDER_F2.Foreground=text_black
        UIC_Fvco_F2_FREQ.Foreground=text_black
        
        UIC_Fosc_F1_FREQ.Foreground=text_grey
        UIC_PLL_R_PRE_F1.Foreground=text_grey
        UIC_MULT_F1.Foreground=text_grey
        UIC_PLL_R_F1.Foreground=text_grey
        UIC_Fpd_F1_FREQ.Foreground=text_grey
        UIC_PLL_N_F1.Foreground=text_grey
        UIC_PLL_NUM_F1.Foreground=text_grey
        UIC_PLL_DEN_F1.Foreground=text_grey
        UIC_PLL_N_PRE_F1.Foreground=text_grey
        UIC_PFD_DELAY_F1.Foreground=text_grey
        UIC_FRAC_ORDER_F1.Foreground=text_grey
        UIC_Fvco_F1_FREQ.Foreground=text_grey        
        
        UIC_CHDIV1_F2.Foreground=text_black
        UIC_CHDIV2_F2.Foreground=text_black
        UIC_EXTVCO_CHDIV_F2.Foreground=text_black
        UIC_OUTBUF_TX_PWR_F2.Foreground=text_black
        UIC_OUTBUF_TX_EN_F2.Foreground=text_black
        UIC_OUTBUF_RX_PWR_F2.Foreground=text_black
        UIC_OUTBUF_RX_PWR_F2.Foreground=text_black
        UIC_Fout_F2_FREQ.Foreground=text_black
        
        UIC_CHDIV1_F1.Foreground=text_grey
        UIC_CHDIV2_F1.Foreground=text_grey
        UIC_EXTVCO_CHDIV_F1.Foreground=text_grey
        UIC_OUTBUF_TX_PWR_F1.Foreground=text_grey
        UIC_OUTBUF_TX_EN_F1.Foreground=text_grey
        UIC_OUTBUF_RX_PWR_F1.Foreground=text_grey
        UIC_OUTBUF_RX_EN_F1.Foreground=text_grey
        UIC_Fout_F1_FREQ.Foreground=text_grey        
        
        
        UIC_EXTVCO_SEL_F1.Foreground=text_grey
        UIC_EXTVCO_SEL_F2.Foreground=text_black
      

def GetSettingsFromF1(): 
    Fosc_FREQ.dValue=Fosc_F1_FREQ.dValue
    flexPLL_R_PRE.iValue=PLL_R_PRE_F1.iValue
    flexMULT.iValue=MULT_F1.iValue
    flexPLL_R.iValue=PLL_R_F1.iValue
    flexPFD_DELAY.iValue=PFD_DELAY_F1.iValue
    UpdateFpd()    
    flexFRAC_ORDER.iValue=FRAC_ORDER_F1.iValue
    flexPLL_DEN.iValue=PLL_DEN_F1.iValue
    flexPLL_NUM.iValue=PLL_NUM_F1.iValue
    flexPLL_N.iValue=PLL_N_F1.iValue
    flexPLL_N_PRE.iValue=PLL_N_PRE_F1.iValue
    flexCHDIV1.iValue=CHDIV1_F1.iValue+4
    flexCHDIV2.iValue=CHDIV2_F1.iValue
    flexEXTVCO_CHDIV.iValue=EXTVCO_CHDIV_F1.iValue
    flexOUTBUF_TX_EN.iValue=OUTBUF_TX_EN_F1.iValue
    flexOUTBUF_RX_EN.iValue=OUTBUF_RX_EN_F1.iValue
    flexOUTBUF_TX_PWR.iValue=OUTBUF_TX_PWR_F1.iValue
    flexOUTBUF_RX_PWR.iValue=OUTBUF_RX_PWR_F1.iValue
    
    UpdateFvco()
    UpdateCurrent()       
    
def GetSettingsFromF2(): 
    Fosc_FREQ.dValue=Fosc_F2_FREQ.dValue
    flexPLL_R_PRE.iValue=PLL_R_PRE_F2.iValue
    flexMULT.iValue=MULT_F2.iValue
    flexPLL_R.iValue=PLL_R_F2.iValue
    flexPFD_DELAY.iValue=PFD_DELAY_F2.iValue
    UpdateFpd()    
    flexFRAC_ORDER.iValue=FRAC_ORDER_F2.iValue
    flexPLL_DEN.iValue=PLL_DEN_F2.iValue
    flexPLL_N_PRE.iValue=PLL_N_PRE_F2.iValue
    flexPLL_NUM.iValue=PLL_NUM_F2.iValue
    flexPLL_N.iValue=PLL_N_F2.iValue
    flexCHDIV1.iValue=CHDIV1_F2.iValue+4
    flexCHDIV2.iValue=CHDIV2_F2.iValue
    flexEXTVCO_CHDIV.iValue=EXTVCO_CHDIV_F2.iValue
    flexOUTBUF_TX_EN.iValue=OUTBUF_TX_EN_F2.iValue
    flexOUTBUF_RX_EN.iValue=OUTBUF_RX_EN_F2.iValue
    flexOUTBUF_TX_PWR.iValue=OUTBUF_TX_PWR_F2.iValue
    flexOUTBUF_RX_PWR.iValue=OUTBUF_RX_PWR_F2.iValue
    
    UpdateFvco()
    UpdateCurrent()
    

def btn_SimplifyFraction_Update():
    Fnum=flexPLL_NUM.iValue
    Fden=flexPLL_DEN.iValue

    if  ((Fnum==0) or (Fden==0)):
        Fden=1
        Fnum=0
    else:
        Divisor = 2      
        while ( Divisor<Fnum+1):
            if (0 == (Fnum % Divisor)) and (0 == (Fden % Divisor)):
                Fnum=Fnum/Divisor
                Fden=Fden/Divisor
            else:
                Divisor=Divisor+1
                
        if (Fden%Fnum==0):
            Fden=Fden/Fnum
            Fnum=1
    
    UpdateStatusBar("Fraction Simplified to "+str(Fnum)+"/"+str(Fden))     
    flexPLL_DEN.iValue=Fden
    flexPLL_NUM.iValue=Fnum    
    
    if (GetActivePLL()==1):
        PLL_DEN_F1.iValue=flexPLL_DEN.iValue
        PLL_NUM_F1.iValue=flexPLL_NUM.iValue
    else:
        PLL_DEN_F2.iValue=flexPLL_DEN.iValue 
        PLL_NUM_F2.iValue=flexPLL_NUM.iValue   

def btn_SpurBGone_Update():
    Fosc=Fosc_FREQ.dValue
    Fpd = Fpd_FREQ.dValue
    Fvco=Fvco_FREQ.dValue
    Fnum=flexPLL_NUM.iValue
    OldFden = flexPLL_DEN.iValue
    OldMult = flexMULT.iValue
    
    
    OldTotalR = int(Fosc * OldMult / Fpd)

    MultInMin = 10
    MultInMax = 30
    MultOutMin = 60
    MultOutMax = 130
    
    FpdMin = Fpd * 0.7
    FpdMax = Fpd * 1.4
    if (FpdMax > 140):
        FpdMax = 140

    BestIBSMetric = 0.00000000001   
   
    FpdMin = Fpd * 0.7
    FpdMax = Fpd * 1.4
    if (FpdMax > 140):
        FpdMax = 140

    BestIBSMetric = 0.00000000001
    FoundBest = False
    
    for Mult in range(1,16):
        if (FoundBest==True):
            break;
        if (Mult==1):
            PLL_R_PRE_min = 1
            PLL_R_PRE_max = 1   
        else:
            PLL_R_PRE_min = int(math.ceil(Fosc / MultInMax))
            if (Fosc > MultInMax*PLL_R_PRE_min):
                PLL_R_PRE_min = PLL_R_PRE_min + 1
            
            PLL_R_PRE_max = int(Fosc / MultInMin)
            if (Fosc / PLL_R_PRE_max < MultInMin):
                PLL_R_PRE_max = PLL_R_PRE_max - 1
        

        for PLL_R_PRE in range(PLL_R_PRE_min,PLL_R_PRE_max+1):
            MultOut = Fosc / PLL_R_PRE * Mult
            if  (Mult==1) or ((MultOut > MultOutMin - 0.0001) and (MultOut < MultOutMax - 0.0001) ):
                for PLL_R in range(1,10):
                    Fpd = Mult * Fosc / (PLL_R_PRE * PLL_R)
                
                    if (Fpd<FpdMin):
                        break;
                
                    if (Fpd<FpdMax):
                        PLL_N = 2 * int(0.5+ 1.0*math.floor(Fvco / Fpd / 2) )
                        
                        IBS = math.fabs(Fvco - PLL_N * Fpd)
                        if (IBS > math.fabs(Fpd - IBS) ):
                            IBS = math.fabs(Fpd - IBS)

                        IBS2 = math.fabs(Fpd / 2 - IBS)
                        
                        
                        if (IBS < IBS2): 
                            IBSMetric = IBS
                        else:
                            IBSMetric = IBS * (40 * IBS2) / (IBS + 40 * IBS2 + 0.000000000001)
                        
                        
                        if (IBS < 0.000001):
                            #   Best Case Scenario, integer Channel
                            BestIBS = 0
                            BestMult = Mult
                            BestPreR = PLL_R_PRE
                            BestPLL_R = PLL_R
                            BestFpd = Fpd
                            BestIBS2 = IBS2
                            BestIBSMetric = IBS2
                            FoundBest = True
                        elif (IBS2 > 0.000001) and (IBSMetric > BestIBSMetric):
                            #   Decide based on weighted metric
                            BestIBS = IBS
                            BestMult = Mult
                            BestPreR = PLL_R_PRE
                            BestPLL_R = PLL_R
                            BestFpd = Fpd
                            BestIBS2 = IBS2
                            BestIBSMetric = IBSMetric
                                
                                
    #   Decide if it is necessary to update the fractional Denominator
    Fden = OldFden

    if (OldMult % BestMult > 0):
    
        #   Find the Denominator of the original fraction in reduced form
        i=2
        while (i<math.sqrt(Fden*1.0) ):
            if (Fnum%i==0) and (Fden%i==0):
                Fden = Fden/i
                Fnum = Fnum/i
            else:   
                i=i+1

        #    X and Y are Mult*  x  TotalR       
        X = BestMult * OldTotalR
        Y = OldMult * BestPreR * BestPLL_R
        
        
        while (i<math.sqrt(X*1.0) ):
            if (X%i==0) and (X%i==0):
                X = X/i
                Y = Y/i
            else:   
                i=i+1
                
        #   Now find the smallest possible simplified denominator
        if (X*Fden > 16777215):
            Fden = OldFden
        else:
            Fden = Fden*X

        #   Now try to Scale Fden back to something close to the original  value
        GCD = int(0.5+OldFden*1.0 / Fden)
        if (GCD<1):
            GCD=1
        Fden=Fden*GCD

    flexPLL_R_PRE.iValue = BestPreR
    flexMULT.iValue=BestMult
    flexPLL_R.iValue=BestPLL_R
    Fpd_FREQ.dValue=BestFpd
    flexPLL_DEN.iValue=Fden
    flexPLL_NUM.iValue=Fnum
    Fvco_FREQ_Update()
    if (GetActivePLL()==1):
        PLL_R_PRE_F1.iValue=flexPLL_R_PRE.iValue
        MULT_F1.iValue=flexMULT.iValue
        PLL_R_F1.iValue=flexPLL_R.iValue
        Fpd_F1_FREQ.dValue=Fpd_FREQ.dValue
        PLL_N_F1.iValue=flexPLL_N.iValue
        PLL_NUM_F1.iValue=flexPLL_NUM.iValue
        PLL_DEN_F1.iValue=flexPLL_DEN.iValue
        Fvco_F1_FREQ.dValue=Fvco_FREQ.dValue
    else:
        PLL_R_PRE_F2.iValue=flexPLL_R_PRE.iValue
        MULT_F2.iValue=flexMULT.iValue
        PLL_R_F2.iValue=flexPLL_R.iValue
        Fpd_F2_FREQ.dValue=Fpd_FREQ.dValue
        PLL_N_F2.iValue=flexPLL_N.iValue
        PLL_NUM_F2.iValue=flexPLL_NUM.iValue
        PLL_DEN_F2.iValue=flexPLL_DEN.iValue
        Fvco_F2_FREQ.dValue=Fvco_FREQ.dValue 

def UpdateCurrent():
    if (POWERDOWN.iValue==1):
        Current=0.9
    else:
        #   Core
        if (1==GetVCOMode() ):
            Current = 9
        elif (flexPLL_N_PRE.iValue==0):
            Current=37
        else:
            Current = 32
            
        #   Multiplier
        if (flexMULT.iValue>1):
            Current=Current+2
            
        #   Phase Detector Frequency
        Current = Current + (5.0/(97.2-19.44) )*(Fpd_FREQ.dValue-19.44)
        
    #   Outputs
    if (flexOUTBUF_TX_EN.iValue==1):
        if (flexOUTBUF_TX_PWR.iValue<4):
            Current = Current + 3.3
        elif (flexOUTBUF_TX_PWR.iValue>24):
            Current=Current+9.6
        elif (flexOUTBUF_TX_PWR.iValue>8):
            Current=Current + 7.4
        else:
            Current=Current+5
    
     #   Outputs
    if (flexOUTBUF_RX_EN.iValue==1):
        if (flexOUTBUF_RX_PWR.iValue<4):
            Current = Current + 3.3
        elif (flexOUTBUF_RX_PWR.iValue>24):
            Current=Current+9.6
        elif (flexOUTBUF_RX_PWR.iValue>8):
            Current=Current + 7.4
        else:
            Current=Current+5   
    
    flexCurrent.dValue = round(Current,1)
    
    
def UpdateKvco():
    Fvco=Fvco_FREQ.dValue
    flexKvco.dValue= -1.0
    A=1.0
    B=1.0
    C=1.0
    if (Fvco<4200):
        flexKvco.dValue = 46.0
    elif (Fvco>5520):
        flexKvco.dValue = 73.0
    else:
        if (Fvco<4449):
            A= 52.0
            B = (52.0-46.0)/(4450-4200)
            C = 4450.0
        elif (Fvco<4630):
            A= 52.0
            B = (61.0-52.0)/(4700-4450) 
            C = 4450.0
        elif (Fvco<4800):
            A= 56.0
            B = (56.0-50.0)/(4800-4560) 
            C = 4800.0
        elif (Fvco<5010):
            A= 56.0
            B = (65.0-56.0)/(5100-4800)  
            C = 4800.0
        elif (Fvco<5220):
            A= 63.0
            B = (63.0-55.0)/(5520-4920)
            C = 5520.0
        elif (Fvco<5521):
            A= 63.0
            B = (73.0-63.0)/(5520-5220) 
            C = 5520.0
            
        flexKvco.dValue = A + B*(Fvco-C)    
        
def UpdateKpd():
    if (GetVCOMode==0):
        iCPU = CP_IUP.iValue
        iCPD = CP_IDN.iValue
        iCPG = CP_GAIN.iValue
    else:
        iCPU = EXTVCO_CP_IUP.iValue
        iCPD = EXTVCO_CP_IDN.iValue 
        iCPG = EXTVCO_CP_GAIN.iValue

    if (iCPU>15):
        iCPU=iCPU-8

    if (iCPD>15):
        iCPD=iCPD-8     

    if (iCPD<iCPU):    #if CP up and down are not equal make them equal
        iCPD=iCPU
        
    if (iCPG==0):
        CPG=0.15625*iCPU
    elif(iCPG==1):
        CPG=0.15625*2*CP1
    elif (iCPG==2):
        CPG=0.15625*1.5*CP1
    else:
        CPG=0.15625*2.5*CP1
    
    flexKpd.dValue=CPG*2
                   
def GetActivePLL():
    #   1 is F1 PLL, 2 is F2 PLL, Assiging ActivePLL=1 prevents warning that ActivePLL is referenced before assignment
    ActivePLL=1
    if (F1F2_CTRL.iValue==0):
        if (F1F2_SEL.iValue==0):
            ActivePLL = 1
        else:
            ActivePLL = 2
    else:
        if (GetPin("TrCtl")==0):
            ActivePLL = 1
        else:
            ActivePLL=2

    #   Fix the flex checkbox if it is wrong
    if (GetPin("TrCtl")<>TrCtl_Pin.iValue):
        TrCtl_Pin.iValue=GetPin("TrCtl")
            
            
    return ActivePLL


def GetVCOMode():
    #   0 is internal VCO, 1 is External VCO
    ActivePLL = GetActivePLL()
    VCOMode=1
    
    if (ActivePLL==1) and (EXTVCO_SEL_F1.iValue==0):
        VCOMode = 0
    elif (ActivePLL==2) and (EXTVCO_SEL_F2.iValue==0):
        VCOMode=0

    return VCOMode
    
    
def ValidateDiagram():

    #   Validate OSCin
    if (Fosc_FREQ.dValue<10) or (Fosc_FREQ.dValue>150):
        UIC_Fosc_FREQ.Background=brush_violation
        UIC_Fosc_FREQ.ToolTip = "Valid Fosc Frequency range is 10 to 130 MHz."
    else:
        UIC_Fosc_FREQ.Background=brush_white
        UIC_Fosc_FREQ.ToolTip = None

    #    Validate MULTin
    if (flexPLL_R_PRE.iValue==0):
        MULTin  = Fosc_FREQ.dValue
    else:
        MULTin= Fosc_FREQ.dValue/flexPLL_R_PRE.iValue
        
    if (flexMULT.iValue<2):
        UIC_flexMULT.GetTextBox().Background=brush_white
        UIC_flexMULT.ToolTip = None   
    elif (MULTin<10) or (MULTin>30):
        UIC_flexMULT.GetTextBox().Background=brush_violation
        UIC_flexMULT.ToolTip = "Valid Multiplier input frequency is 10 to 30 MHz."
    elif (MULTin*flexMULT.iValue<60) or (MULTin*flexMULT.iValue>130):
        UIC_flexMULT.GetTextBox().Background=brush_violation
        UIC_flexMULT.ToolTip = "Valid Multiplier output frequency is 60 to 130 MHz."
    else:
        UIC_flexMULT.GetTextBox().Background=brush_white
        UIC_flexMULT.ToolTip = None     
   

    #   Validate Fpd
    if (Fpd_FREQ.dValue>130):
        UIC_Fpd_FREQ.Background=brush_alert
        UIC_Fpd_FREQ.ToolTip = "Maximum phase detector frequency is 130 MHz."
    else:
        UIC_Fpd_FREQ.Background=brush_white
        UIC_Fpd_FREQ.ToolTip = None   
        
    #   Validate Charge Pump Down
    if (CP_IDN.iValue==CP_IUP.iValue):
        UIC_CP_IDN.ToolTip=None
        UIC_CP_IDN.Background=brush_white
    else:
        UIC_CP_IDN.ToolTip="CP_IDN and CP_IUP should be equal"
        UIC_CP_IDN.Background=brush_alert  

    if (EXTVCO_CP_IDN.iValue==EXTVCO_CP_IUP.iValue):
        UIC_EXTVCO_CP_IDN.ToolTip=None
        UIC_EXTVCO_CP_IDN.Background=brush_white
    else:
        UIC_EXTVCO_CP_IDN.ToolTip="EXTVCO_CP_DN and EXTVCO_CP_UP should be equal"
        UIC_EXTVCO_CP_IDN.Background=brush_alert         
   
    #   Validate PLL N divider
    MinN = -1
    if (flexFRAC_ORDER.iValue==0):
        MinN=6
    elif (flexFRAC_ORDER.iValue==1):
        MinN=6
    elif (flexFRAC_ORDER.iValue==2):
        MinN=11
    elif (flexFRAC_ORDER.iValue==3):
        MinN=22
    else:
        MinN=22
    
    if (flexPLL_N.iValue<MinN):
        UIC_flexPLL_N.GetTextBox().Background=brush_violation
        UIC_flexPLL_N.GetTextBox().ToolTip = "Minimum N Divider Value for FRAC_ORDER="+str(flexFRAC_ORDER.iValue)+ " is " + str(MinN)
    else:
        UIC_flexPLL_N.GetTextBox().Background=brush_white
        UIC_flexPLL_N.GetTextBox().ToolTip = None    
   
   
    #   Validate VCO and External VCO Channel Divider
    if (GetVCOMode()==0):
        if (Fvco_FREQ.dValue<4300) or (Fvco_FREQ.dValue>5376):
            UIC_Fvco_FREQ.Background=brush_violation
            UIC_Fvco_FREQ.ToolTip = "Internal VCO frequency range is 4300 - 5376 MHz."
        else:
            UIC_Fvco_FREQ.Background=brush_white
            UIC_Fvco_FREQ.ToolTip = None
    else:
        if (Fvco_FREQ.dValue<100) or (Fvco_FREQ.dValue>2000):
            UIC_Fvco_FREQ.Background=brush_violation
            UIC_Fvco_FREQ.ToolTip = "External VCO frequency range is 100 - 2000 MHz with some restrictions on the output divider at higher frequencies."
        else:
            UIC_Fvco_FREQ.Background=brush_white
            UIC_Fvco_FREQ.ToolTip = None
            
        if (Fvco_FREQ.dValue>1900) and (flexEXTVCO_CHDIV.iValue>0):
            UIC_flexEXTVCO_CHDIV.Background=brush_violation
            UIC_flexEXTVCO_CHDIV.ToolTip="External VCO divide must be set to 1 for VCO frequencies above 1900 MHz."
        elif (Fvco_FREQ.dValue>1400) and (flexEXTVCO_CHDIV.iValue<>0) and (flexEXTVCO_CHDIV.iValue<>8) and (flexEXTVCO_CHDIV.iValue<>10):
            UIC_flexEXTVCO_CHDIV.Background=brush_violation
            UIC_flexEXTVCO_CHDIV.ToolTip="External VCO divide must be set to 1,8, or 10 for VCO frequencies above 1400 MHz."
        else:
            UIC_flexEXTVCO_CHDIV.Background=brush_white
            UIC_flexEXTVCO_CHDIV.ToolTip=None     
        