﻿"""
 * Copyright (C) 2017 Texas Instruments Incorporated - http://www.ti.com/ 
 * ALL RIGHTS RESERVED 
"""
"""
File CDCE6214_extra.py
Version 1.03
"""
###############################################################################
#   20160616, KP: initial work
#   20160715, KP: +cFraction,gcdeuclid from LMK61E2extra
#   20161021, KP: moved FODCALC
#   20170202, KP: just updated the date in here
#   20170516, KP: crc from shankar, eedirect updated, rest commented out
#   20170522, KP: limitcheck, global vars modified (limits)
#   20170523, KP: bugfixes
#   20170628, KP: rework for CDCI6214
#   20170703, KP: backported to engineering version (full only)
#   20170919, KP: worked on wiz and freq planner, still ongoing before port to cust version
#   20171106, KP: lots of edits everywhere
#   20171115, KP: as there will be major TP update, include the exe version in the tcs using TICS_VERSION
#   20180227, KP: freqinc/dec reg mode, added ivalue+writeparam scheme
#                 bootosc enable for freq_inc/dec
#                 hide all 1p8v bitfields, force through trimforce
#                 diff buf trim set to 1 (550uA) as it turned out this moves VCM on LVDS
#                 btn_reset & btn_evm_pwr, i2c scan followed by rev_reg read
#                 powerdowns, pdn fodclk -> trimforce
#   20180228, KP: indec readback, added fod linkedbits and exposed boot osc disable
#
###############################################################################
import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Media import SolidColorBrush,Colors,Color,LinearGradientBrush,ColorConverter
from System.Windows import TextAlignment,VerticalAlignment,FontWeights
from time import sleep,ctime,clock
from System.IO import Directory, Path, File
import re
from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon,OpenFileDialog,SaveFileDialog
from INIParser import ConfigFileParser
from System import Array,Byte
import datetime
from math import floor, pow, ceil
from System.Threading import Thread

######### MATH FUNCTIONS

def gcd_euclid(a, b):
    ### RE-USE from LMK61E2_extra.py
    # Figure out which of a or b is larger.
    small = min([a, b])
    big = max([a, b])

    # Apply Euclidean algorithm.
    newsmall = big % small

    # Recusive logic.
    if (newsmall == 0):
        return small
    else:
        return gcd_euclid(small, newsmall)
def gcd_float(a, b):
    mult = 1.0

    while ( (a-int(a)) > 0 or (b-int(b)) > 0 ):
        a *= 10.0
        b *= 10.0
        mult *= 10.0

    answer = gcd_euclid(a,b)
    return(answer / mult)

class cFraction:
    ### RE-USE from LMK61E2_extra.py
    def __init__(self, value=None):
        self.num = 0
        self.den = 1
        
        if value:
            self.fset2(value)
    
    def fset2(self, value):
        if float == type(value):
            f = cFraction(str(value))
            self.num = f.num
            self.den = f.den
        else:
            # Match 1 + 2/3 or 1 2/3
            #res = re.search("[0-9]+ *[ +\+] *[0-9]+ */ *[0-9]+", str(value))
            res = re.search("([0-9]*\.?[0-9]+)+ *[ +\+] *([0-9]*\.?[0-9]+)+ */ *([0-9]*\.?[0-9]+)+", str(value))
            if res:
                whole, num, den = [x for x in re.split("[ \+/]", str(res.group())) if x!=""]
                #print ("Before", whole, num, den)

                anum_dec_str = re.search("[0-9]*", num)
                if anum_dec_str:
                    anum_dec_str = anum_dec_str.group()
                else:
                    anum_dec_str = ""
                    
                aden_dec_str = re.search("[0-9]*", den)
                if aden_dec_str:
                    aden_dec_str = aden_dec_str.group()
                else:
                    aden_dec_str = ""

                bnum_dec_str = re.search("(?<=\.)[0-9]+", num)
                if bnum_dec_str:
                    bnum_dec_str = bnum_dec_str.group()
                else:
                    bnum_dec_str = ""
                    
                bden_dec_str = re.search("(?<=\.)[0-9]+", den)
                if bden_dec_str:
                    bden_dec_str = bden_dec_str.group()
                else:
                    bden_dec_str = ""

                num = anum_dec_str + bnum_dec_str + "0"*(max(len(bnum_dec_str), len(bden_dec_str)) - len(bnum_dec_str) )
                den = aden_dec_str + bden_dec_str + "0"*(max(len(bnum_dec_str), len(bden_dec_str)) - len(bden_dec_str) )
                
                    
                #print ("Middle", whole, num, den)

                self.den = int(den)
                self.num = int(num)
                
                if 0 == self.den:
                    self.den = 1

                
                ans = self + cFraction(whole)
                self.num = ans.num
                self.den = ans.den
                
            else:
                # Match 2/3
                #res = re.search("[0-9]+ */ *[0-9]+", str(value))
                res = re.search("([0-9]*\.?[0-9]+)+ */ *([0-9]*\.?[0-9]+)+", str(value))
                if res:
                    num, den = re.split("[ \+/]", str(res.group()))
                    thefract = cFraction(num) / cFraction(den)
                    self.num = thefract.num
                    self.den = thefract.den

                    if 0 == self.den:
                        self.den = 1

                else:
                    # Match 2
                    #res = re.search("[0-9]+", str(value))
                    res = re.search("[0-9]*\.?[0-9]+", str(value))

                    if res:
                        vals = res.group().split(".")
                        if 1 == len(vals) or (2 == len(vals) and ""==vals[1]):
                            self.num = int(vals[0])
                            self.den = 1
                        elif 2 == len(vals):
                            self.den = int("1" + "0" * len(vals[1]))
                            if 0 == self.den:
                                self.den = 1
                            self.num = int(vals[1])
                            if "" != vals[0]:
                                self.num += self.den * int(vals[0])
                        else:
                            raise TypeError("Can't handle input >%s< as fractional input", value)
        
        self.reduce()
        
    def reduce(self):
        if self.num > 0:
            thegcd = gcd_euclid(self.num, self.den)
            self.num = int(self.num / thegcd)
            self.den = int(self.den / thegcd)
        else:
            self.den = 1
        
    def __add__(self, right):
        ans = cFraction()
        
        if isinstance(right, cFraction):
            ans.num = (self.num * right.den) + (right.num * self.den)
            ans.den = self.den * right.den
            ans.reduce()
        elif int == type(right) or long == type(right):
            ans.num = self.num + (self.den * right)
            ans.den = self.den
        else:
            raise TypeError("unsupported operand type(s) for +:" + str(cFraction) + " and " + str(type(right)))
            
        ans.reduce()
        return ans

    def __radd__(self, left):
        return (self.__add__(left))
    
    def __mul__(self, right):
        ans = cFraction()
        
        if isinstance(right, cFraction):
            ans.num = self.num * right.num
            ans.den = self.den * right.den
        elif int == type(right) or long == type(right):
            ans.num = self.num * right
            ans.den = self.den
        else:
            raise TypeError("unsupported operand type(s) for *:" + str(cFraction) + " and " + str(type(right)))
            
        ans.reduce()
        return ans

    def __rmul__(self, left):
        return self.__mul__(left)
    
    def __truediv__(self, right):
        ans = cFraction()

        if isinstance(right, cFraction):
            ans.num = right.den
            ans.den = right.num
            ans = self.__mul__(ans)
        elif int == type(right) or long == type(right):
            ans.num = self.num
            ans.den = self.den * right
        else:
            raise TypeError("unsupported operand type(s) for /:" + str(cFraction) + " and " + str(type(right)))
        
        ans.reduce()
        return ans
    
    def __idiv__(self, right):
        return self.__truediv__(right)
    
    def __div__(self, right):
        return self.__truediv__(right)

    def __eq__(self, right):
        if isinstance(right, cFraction):
            self.reduce()
            right.reduce()
            
            if (self.num == 0 and right.num == 0):
                return True
            elif (self.den == right.den and self.num == right.num):
                return True
            else:
                return False
        elif int == type(right) or long == type(right):
            self.reduce()
            if ((self.den == 1 and self.num == right) or (self.num == 0 and 0 == right)):
                return True
            else:
                return False
        elif float == type(right):
            self.reduce()
            return self == cFraction(right)
        else:
            raise TypeError("unsupported operand type(s) for ==:" + str(cFraction) + " and " + str(type(right)))
        
    def __ne__(self, right):
        return not self.__eq__(right)

    def __gt__(self, right):
        if float(self) > float(right):
            return True
        else:
            return False

    def __ge__(self, right):
        if float(self) >= float(right):
            return True
        else:
            return False

    def __lt__(self, right):
        if float(self) < float(right):
            return True
        else:
            return False

    def __le__(self, right):
        if float(self) <= float(right):
            return True
        else:
            return False

    def __str__(self):
        thestr = "%s" % str(float(self.num) / self.den)
        if not re.search("\.[0-9][0-9][0-9][0-9][0-9]", thestr):
            # Decimal can be represented in 4 or less decimal places
            return thestr
        else:
            if self.num < self.den:
                return ("%d/%d" % (self.num, self.den))
            else:
                return ("%d + %d/%d" % (int(self.num/self.den), self.num%self.den, self.den))
    
    def __float__(self):
        return float(self.num)/self.den

    def __int__(self):
        return int(self.num/self.den)
    
    def __mod__(self, right):
        ans = cFraction()
        
        if isinstance(right, cFraction):
            ans.num = (self.num * right.den) % (right.num * self.den)
            ans.den = self.den * right.den
        elif int == type(right) or long == type(right):
            ans.num = self.num % (right * self.den)
            ans.den = self.den
        else:
            raise TypeError("unsupported operand type(s) for %:" + str(cFraction) + " and " + str(type(right)))
            
        ans.reduce()
        return ans
class targetfreq(object):
    def __init__(self,finit=cFraction('0'),iCnt=0):
        #UpdateStatusBar(str(finit))
        self.fractargetfreq = cFraction(finit)
        self.ftargetfreq    = float(finit)
        self.iCnt           = iCnt
        self.bInt           = False          
        self.lvco           = []
        self.ivco           = 0 
        self.fvcomin        = 2400.0
        self.fvcomax        = 2800.0
        self.fpsmin         = self.fvcomin/6.0
        self.fpsmax         = self.fvcomax/4.0
        self.lps            = [4.0,5.0,6.0]
        self.prio           = -1
        self.accu           = 1e-12
    def calcvco(self,cfref):
        retval = False
        fref = float(cfref)
        llocalvco = []
        ok = lambda x: True if x-int(x)<self.accu else False
        imin = int(ceil(self.fvcomin/self.ftargetfreq))
        imax = int(self.fvcomax/self.ftargetfreq)+1
        for i in range(imin,imax):
            lps = []
            liod = []
            lref = []
            for ps in self.lps:
                itmp = i/ps
                if ok(itmp):
                    fvco = self.ftargetfreq*i
                    lps.append(ps)
                    liod.append(itmp)
                    #pllndiv >=6 while clkdist does not have that limitation
                    #should only be effective for ref/pfd=100MHz
                    ir =0.5
                    bKeepGoing = True
                    while (ir < 256) and bKeepGoing:
                        fgcd = gcd_float(fref/ir,fvco/ps)
                        if ((fvco/ps)/(fref/ir) >=6.0):
                            if fgcd <= 100.0 and fgcd > fref and ir == 0.5:
                                bKeepGoing = False
                            elif fgcd <= fref and ir >= 1 and ir < 256:
                                bKeepGoing = False
                        if ir==0.5:
                            ir = 1.0
                        else:
                            ir = ir + 1.0
                        if len(lref)>10:
                            bKeepGoing = False
                    lref.append(fgcd)
                    if not [fvco,lps,liod,lref] in self.lvco:
                        self.lvco.append([fvco,lps,liod,lref])
                    # [vco, valid ps, valid iod, pfd]
        self.ivco = len(self.lvco)
        if self.ivco>0:
            # this qualifies an output as integer when it has a reasonable gcd with the input reference... we do not know about other outputs yet.
            for k in range(0,self.ivco):
                itst = 0
                for pfd in self.lvco[k][3]:
                    if pfd >= 0.999 and pfd <=100.001:
                        itst +=1
            if itst:
                retval = True
        self.bInt = retval
        return retval
    def settargetfreq(self,freq,cnt):
        retval = False
        if (self.ftargetfreq >0) and (self.ftargetfreq >= self.fpsmin) and (self.ftargetfreq <= self.fpsmax) and (cnt in range(0,5)):
            retval = True
            self.ftargetfreq = float(freq)
            self.fractargetfreq = freq
            self.count = cnt
        else:
            self.ftargetfreq = 0.0
        return retval
    def calc(self,cfref):
        retval = True
        retval = retval & self.calcvco(cfref)
        return retval
class freqplan(object):
    def __init__(self,cfref,lf):
        self.ref = cfref
        self.lfreq = []
        self.ifreq = len(lf)
        self.lvcoshared = []
        self.ivcoshared = -1
        self.tfRef = targetfreq(cfref,1)
        if self.ifreq>0:
            for ele in lf:
                self.lfreq.append(targetfreq(ele[0],ele[1]))

    def findvcos(self):
        lcommonvco = []
        retval  = 0
        for i in range(0,self.ifreq):
            self.lfreq[i].calc(self.ref)
            retval  = retval + self.lfreq[i].ivco
        if retval==0:
            UpdateStatusBar("Frequency Planner - no integer relation between reference and potential VCO frequencies found.\nPlease consider another reference frequency when possible.")
            # all fractional
        else:
            # merge integer solutions to common VCO
            if self.ifreq>=2:
                #find targetfreq with least solutions
                ileast = 5
                itmp = 40000
                ltfindices = []
                for i in range(0,self.ifreq):
                    for j in range(0,self.lfreq[i].ivco):
                        for fpfd in self.lfreq[i].lvco[j][3]:
                            if fpfd >= 0.999 and fpfd <=100.001:
                                itmp2 = self.lfreq[i].ivco
                                if itmp2 < itmp:
                                    ileast = i
                                    itmp = itmp2
                                # 1st hit is the 2x, let's use it and stop
                                break
                if ileast in range(0,self.ifreq):
                    #integer releation to reference possible, continue common vco search
                    #create list without reference
                    for i in range(0,self.ifreq):
                        if i != ileast:
                            ltfindices.append(i)
                    #generate reference list
                    lvcoref = []
                    lvcorefind = []
                    for i in range(0,self.lfreq[ileast].ivco):
                        lvcoref.append(self.lfreq[ileast].lvco[i][0])
                        lvcorefind.append((ileast,i))
                    #loop targetfreqs
                    lvcohits = []
                    lvcohitsind = []
                    # [vco, valid ps, valid iod, pfd]
                    for l in range(0,len(lvcoref)):
                        vcoref = lvcoref[l]
                        for i in ltfindices:
                            for j in range(0,self.lfreq[i].ivco):
                                if vcoref == self.lfreq[i].lvco[j][0]:
                                    if not vcoref in lvcohits:
                                        lvcohits.append(vcoref)
                                    lvcohitsind.append((i,j)) #which targetfreq, which vco
                        lvcohitsind.append(lvcorefind[l])
                    #get vco list for each target freq
                    #then compare n-1 target freqs with the other vco lists and save the indices
                    for i in range(0,len(lvcohits)):
                        lcommonvco.append((lvcohits[i],lvcohitsind))
                    if len(lvcohits)==0 and len(lvcoref):
                        lcommonvco.append((lvcoref[0],[(ileast,0)]))
                else:
                    #only fractional relation to reference possible, abort vco search
                    UpdateStatusBar("Frequency Planner - no integer relation between reference and potential VCO frequencies found.\nPlease consider another reference frequency when possible.")
            elif self.ifreq==1 and self.lfreq[0].bInt:
                lcommonvco.append((self.lfreq[0].lvco[0][0],[(0,0)]))
        self.lvcoshared = lcommonvco
        self.ivcoshared = len(self.lvcoshared)
    def ShowFreqPlan(self):
        gv = globals()
        strtmp = "Frequency Planner\n" + "Entry\tCount\tTarget MHz\tType\tPS\tIOD\tFOD_MSB\tFOD\tFODCLK\tFODout\n"
        ltfnr = []
        ltf = []
        ltfcnt = []
        ltftyp = []
        ltfsetps = []
        ltfsetiod = []
        ltffodmsb = []
        ltffod = []
        ltffodclk = []
        ltffodout = []
        #g.setdbg(1)
        if self.ivcoshared>=1:
            # integer w.r.t. ref found
            il = len(self.lvcoshared[0][1])
            #fill tf &  setting listlist
            for i in range(0,il):
                ltfnr.append(self.lvcoshared[0][1][i][0])                                                          #entry
                ltfcnt.append(self.lfreq[self.lvcoshared[0][1][i][0]].iCnt)                                        #amount
                ltf.append(self.lfreq[self.lvcoshared[0][1][i][0]].fractargetfreq)                                 #freq
                ltftyp.append(self.lfreq[self.lvcoshared[0][1][i][0]].bInt)                                        #integer
                ltfsetps.append(self.lfreq[self.lvcoshared[0][1][i][0]].lvco[self.lvcoshared[0][1][i][1]][1][0])   #PS
                ltfsetiod.append(self.lfreq[self.lvcoshared[0][1][i][0]].lvco[self.lvcoshared[0][1][i][1]][2][0])  #IOD
                ltffodmsb.append(32768)
                ltffod.append(0)
                ltffodclk.append(0)
                ltffodout.append(0)
            #now all vco frequencies in the list, search missing ones and add them
            #dbg2txt("list length " + str(len(ltfnr)))
            for i in range(0,self.ifreq):
                if not i in ltfnr:
                    ltfnr.append(i)                                                                                #entry
                    ltfcnt.append(self.lfreq[i].iCnt)                                                              #amount
                    ltf.append(self.lfreq[i].fractargetfreq)                                                       #freq
                    self.lfreq[i].bInt = False                                                                     #mark the possible int vco freq as frac
                    ltftyp.append(self.lfreq[i].bInt)                                                              #fractional
                    ltfsetps.append(8)                                                                             #PS
                    #fod code snippet start
                    imax=int(float(cFraction(self.lvcoshared[0][0] / 6.0) / self.lfreq[i].fractargetfreq))
                    bInnerBreak = False
                    fodmsb = 32768
                    fod =0
                    iod = 1
                    fodclk = 0
                    for k in [0,1]:
                        for l in range(1,imax+1):
                            if (k==0 and l%2==0) or k==1: #FODCLK=0 IOD=2N requirement
                                retval = FOD_FREQ2REG(cFraction(self.lvcoshared[0][0]),self.lfreq[i].fractargetfreq,l,k)
                                if retval[0]:
                                    lfod = FOD_REG2FREQ(cFraction(self.lvcoshared[0][0]),retval[1],retval[2],l,k)
                                    fodoutfreq = cFraction(l) * lfod[1]
                                    fodmsb = retval[1]
                                    fod = retval[2]
                                    iod = l
                                    fodclk = k
                                    bInnerBreak = True
                                    break
                        if bInnerBreak:
                            break
                    #snippet end
                    ltfsetiod.append(iod)  #IOD
                    ltffodmsb.append(fodmsb)
                    ltffod.append(fod)
                    ltffodclk.append(fodclk)
                    ltffodout.append(fodoutfreq)
            dbg2txt("list length " + str(len(ltfnr)))
            for j in range(0,len(ltfnr)):
                strtmp = strtmp + str(ltfnr[j]) +"\t"+ str(ltfcnt[j])+"\t"+ str(ltf[j])+"\t"+ str(ltftyp[j])+"\t"+ str(ltfsetps[j])+"\t"+ str(ltfsetiod[j])+"\t"+ str(ltffodmsb[j])+"\t"+ str(ltffod[j])+"\t"+ str(ltffodclk[j])+"\t"+ str(ltffodout[j])+"\n"
        else:
            print "fractional case"
            #all fractional w.r.t. ref
            self.tfRef.calc(self.ref)
            if self.tfRef.ivco>=1:
                # select the "best" VCO frequency
                ibestvco = self.tfRef.ivco-1
                ibestpfd = -1.0
                bCont = True
                for i in range(self.tfRef.ivco-1,-1,-1):
                    if bCont:
                        for pfd in self.tfRef.lvco[i][3]:
                            if pfd>=self.tfRef.ftargetfreq:
                                ibestvco = i
                                ibestpfd = pfd
                                bCont = False
                                break
                for i in range(0,self.ifreq):
                    if not i in ltfnr:
                        ltfnr.append(i)                                                                                #entry
                        ltfcnt.append(self.lfreq[i].iCnt)                                                              #amount
                        ltf.append(self.lfreq[i].fractargetfreq)                                                       #freq
                        ltftyp.append(self.lfreq[i].bInt)                                                              #fractional
                        ltfsetps.append(8)                                                                             #PS
                        #fod code snippet start
                        imax=int(float(cFraction(self.tfRef.lvco[ibestvco][0] / 6.0) / self.lfreq[i].fractargetfreq))
                        bInnerBreak = False
                        fodmsb = 32768
                        fod =0
                        iod = 1
                        fodclk = 0
                        for k in [0,1]:
                            for l in range(1,imax+1):
                                if (k==0 and l%2==0) or k==1:   #FODCLK=0 IOD=2N requirement
                                    retval = FOD_FREQ2REG(cFraction(self.tfRef.lvco[ibestvco][0]),self.lfreq[i].fractargetfreq,l,k)
                                    if retval[0]:
                                        lfod = FOD_REG2FREQ(cFraction(self.tfRef.lvco[ibestvco][0]),retval[1],retval[2],l,k)
                                        fodoutfreq = cFraction(l) * lfod[1]
                                        fodmsb = retval[1]
                                        fod = retval[2]
                                        iod = l
                                        fodclk = k
                                        bInnerBreak = True
                                        break
                            if bInnerBreak:
                                break
                        #snippet end
                        ltfsetiod.append(iod)  #IOD
                        ltffodmsb.append(fodmsb)
                        ltffod.append(fod)
                        ltffodclk.append(fodclk)
                        ltffodout.append(fodoutfreq)
                dbg2txt("list length " + str(len(ltfnr)))
                for j in range(0,len(ltfnr)):
                    strtmp = strtmp + str(ltfnr[j]) +"\t"+ str(ltfcnt[j])+"\t"+ str(ltf[j])+"\t"+ str(ltftyp[j])+"\t"+ str(ltfsetps[j])+"\t"+ str(ltfsetiod[j])+"\t"+ str(ltffodmsb[j])+"\t"+ str(ltffod[j])+"\t"+ str(ltffodclk[j])+"\t"+ str(ltffodout[j])+"\n"
            else:
                UpdateStatusBar("Frequency Planner: Please change input frequency. No results found.")
            #similar to snippet above
            #need to define VCO frequency first; choose highest w.r.t. refx2
        dbg2txt(strtmp)
        #g.setdbg(0)
        # time to push to device
        imax = len(ltfnr)
        if imax>=1:
            if freqplanconfirm():
                #user confirmed
                #transfer reference
                XIN_FREQ.sValue = str(self.ref)
                REF_FREQ.sValue = str(self.ref)
                Y1_FREQ.sValue = ""
                Y2_FREQ.sValue = ""
                Y3_FREQ.sValue = ""
                Y4_FREQ.sValue = ""
                if self.ivcoshared>=1:                           
                    bBreak = True
                    for i in range(0,len(ltftyp)):
                        if ltftyp[i]==True and bBreak:
                            index0 = self.lvcoshared[0][1][i][0]
                            index1 = self.lvcoshared[0][1][i][1]
                            tmppfd = self.lfreq[index0].lvco[index1][3][0]
                            ftmprdiv = float(self.ref/cFraction(tmppfd)) #PFD frequency, float
                            itmprdiv = int(ftmprdiv)
                            if ftmprdiv - itmprdiv < 1e-12:
                                ip_rdiv.iValue = int(self.ref/cFraction(tmppfd)) #PFD frequency
                                bBreak = False
                                break
                            elif ftmprdiv == 0.5 and tmppfd <=100.0:
                                ip_rdiv.iValue = 0
                                bBreak = False
                                break
                elif self.tfRef.ivco>=1:
                    ftmprdiv = float(self.ref/cFraction(ibestpfd)) #PFD frequency
                    itmprdiv = int(ftmprdiv) #PFD frequency
                    if ftmprdiv - itmprdiv < 1e-12:
                        bBreak = False
                        ip_rdiv.iValue = itmprdiv #PFD frequency
                    elif ftmprdiv == 0.5:
                        ip_rdiv.iValue = 0 # doubler case
                    else:
                        UpdateStatusBar("Frequency Planner: Full Fractional Case: Error Reference Frequency.")
                else:
                    UpdateStatusBar("Frequency Planner: Assignment Error Reference Frequency.")
                #transfer PLL
                if self.ivcoshared>=1:
                    bBreak = True
                    for i in range(0,len(ltftyp)):
                        if ltftyp[i]==True and bBreak:
                            bBreak = False
                            tmpvco = self.lvcoshared[self.ivcoshared-1][0] #VCO
                            tmppfd = self.lfreq[self.lvcoshared[0][1][i][0]].lvco[self.lvcoshared[0][1][i][1]][3][0] #PFD
                            tpmps = self.lfreq[self.lvcoshared[0][1][i][0]].lvco[self.lvcoshared[0][1][i][1]][1][0] #PS
                            tmpndiv = int(tmpvco/(tmppfd*tpmps))
                            tmppsmode = int(self.lfreq[self.lvcoshared[0][1][i][0]].lvco[self.lvcoshared[0][1][i][1]][1][0]) -4
                            pll_psfb.iValue = tmppsmode
                            pll_ndiv.iValue = tmpndiv #PLL NDIV
                            break
                elif self.tfRef.ivco>=1:
                    dummy           = self.tfRef.lvco[ibestvco][1][0]
                    tmpvco          = self.tfRef.lvco[ibestvco][0]
                    tmpps           = self.tfRef.lvco[ibestvco][1][0]
                    tmppfd          = ibestpfd
                    pll_psfb.iValue = self.tfRef.lvco[ibestvco][1][0] -4
                    pll_ndiv.iValue = int(tmpvco/(tmpps*tmppfd))
                else:
                    UpdateStatusBar("Frequency Planner: Assignment Error PLL Parameters.")
                #pll powerdowns
                lpds = ["pfd","lockdet","vco","vcobuf","vcobuf2","psfb"]
                gv["pdn_ref"].iValue = 0
                gv["pdn_pll_fodclk"].iValue = 1 #force fodclk power disabled
                gv["pdn_pll_psa"].iValue    = 1 #force ps power disabled
                gv["pdn_pll_psb"].iValue    = 1 #force ps power disabled
                for pd in lpds:
                    gv["pdn_pll_"+ pd ].iValue = 0
                for i in  range(1,5):
                    gv["pdn_ch%i" %i].iValue     = 1
                    gv["ch%i_iod_div" %i].iValue = 0
                    gv["ch%i_iod_mux" %i].iValue = 0
                #loop filter code 
                UpdateStatusBar("Please check PLL bandwidth and stability!")
                #transfer clock distribution
                #need to sort otherwise the mux is painful
                lps = []
                ips = 2
                iNewCh = 0
                lsorted = []
                ii = 0
                while len(lsorted) <=imax and ii <=16:
                    iloopy = ltfnr[ii%imax]
                    if iloopy == iNewCh:
                        iapp = ii%imax
                        lsorted.append(iapp)
                        iNewCh +=1
                    if len(lsorted)==imax:
                        break
                    ii +=1
                iNewCh = 1
                #assign pre-scalers
                dummy3 = pll_psa.iValue
                dummy4 = pll_psb.iValue
                #set output channel
                for i in range(0,imax):
                    #STARTING HERE USE lsorted[i] AS INDEX TO WALK THROUGH THE LISTS!!!
                    # AND iNewCh to assign to a bit
                    if ltftyp[lsorted[i]]==True:
                        #integer setting
                        if not (ltfsetps[lsorted[i]] in lps) and ips>=0:
                            if ips ==2:
                                pll_psa.iValue     = int(ltfsetps[lsorted[i]] - 4)
                                pdn_pll_psa.iValue = 0
                            elif ips==1:
                                pll_psb.iValue = int(ltfsetps[lsorted[i]] - 4)
                                pdn_pll_psb.iValue = 0
                            else:
                                UpdateStatusBar("Frequency Planner: Pre-Scaler Error")
                            ips -=1
                            lps.append(ltfsetps[lsorted[i]])
                        # channel pre-scaler, iod
                        if ips ==1:
                            #PSA
                            gv["ch%i_iod_mux" %iNewCh].iValue = 0
                        elif ips ==0:
                            #PSB
                            gv["ch%i_iod_mux" %iNewCh].iValue = 1
                        gv["pdn_ch%i_fod"%iNewCh].iValue     = 1 #force power enabled
                    #elif
                    # MISSING CASE  TODO
                    # ODD INTEGER MULTIPLES OF OTHER OUTPUTS
                    # e.g. 125/3 = 41.666 will slip through with 25 ref (no gcd with 25!)
                    else:
                        # full fractional setting
                        dummy2 = "ch%i_fod_msb"%iNewCh
                        gv["ch%i_fod_msb"%iNewCh].iValue     = ltffodmsb[lsorted[i]]
                        gv["ch%i_fod"%iNewCh].iValue         = ltffod[lsorted[i]]
                        gv["fod_clk_ch%i"%iNewCh].iValue     = ltffodclk[lsorted[i]]
                        gv["ch%i_iod_mux" %iNewCh].iValue    = 2
                        gv["ch%i_fod_dlymode"%iNewCh].iValue = 0 #force synthesize
                        gv["pdn_ch%i_fod"%iNewCh].iValue     = 0 #force power enabled
                        if gv["pdn_pll_fodclk"].iValue ==1:
                            gv["pdn_pll_fodclk"].iValue      = 0 #force fodclk power enabled
                    #channel iod
                    gv["ch%i_iod_div" %iNewCh].iValue = ltfsetiod[lsorted[i]]
                    gv["pdn_ch%i" %iNewCh].iValue     = 0 #force power enabled
                    # use other channels to shift
                    # start channum = 0 (outside outer loop)
                    # run a loop with
                    #    channum+1 as start
                    #    ltfcnt[lsorted[i]] as stop
                    #    if same chan make mux =1
                    #    greater make 0
                    # end of loop
                    # incr channum
                    iNewChMax = iNewCh + ltfcnt[lsorted[i]]
                    for l in range(iNewCh,iNewChMax):
                        if l==iNewCh:
                            tmpstr = "ch%i_mux" %l
                            gv["ch%i_mux" %l].iValue     = 1
                            gv["ch%i_sync_en" %l].iValue = 1 #force sync enabled
                        else:
                            tmpstr = "ch%i_mux" %l
                            gv["ch%i_mux" %l].iValue     = 0
                            gv["pdn_ch%i" %l].iValue     = 0 #force power enabled
                            gv["ch%i_iod_div" %l].iValue = 0
                            gv["ch%i_sync_en" %l].iValue = 0 #force sync disabled
                            if ips ==1:
                                #PSA
                                tmpstr2 = "ch%i_iod_mux" %l
                                gv["ch%i_iod_mux" %l].iValue = 0
                            elif ips ==0:
                                #PSB
                                tmpstr2 = "ch%i_iod_mux" %l
                                gv["ch%i_iod_mux" %l].iValue = 1
                            iNewCh +=1
                    iNewCh +=1
        VisualUpdate()
        FREQ_Update()
                    # WORKING HERE
    def prettyprint(self):
        dbg2txt("Frequency Planner")
        dbg2txt("Ref MHz\tTarget MHz\tbInt\tVCO MHz\tPS\tIOD\tPFD")
        for i in range(0,self.ifreq):
            for j in range(0,self.lfreq[i].ivco):
                if self.lfreq[i].ivco:
                    for k in range(0,len(self.lfreq[i].lvco[j][1])):
                        strtmp = str(self.ref)+"\t"+str(self.lfreq[i].fractargetfreq)+"\t"
                        strtmp = strtmp +str(self.lfreq[i].bInt)+"\t"+str(self.lfreq[i].lvco[j][0])+"\t"
                        strtmp = strtmp +str(self.lfreq[i].lvco[j][1][k])+"\t"+str(self.lfreq[i].lvco[j][2][k])+"\t"+str(self.lfreq[i].lvco[j][3][k])
                        dbg2txt(strtmp)

class sixtytwofourteen(object):
    def __init__(self):
        self._strName  = "CDCE6214"
        self.ref       = cFraction()
        self.refmin    = cFraction(1.0)
        self.refmax    = cFraction(250.0)
        self.xin       = cFraction()
        self.xinmin    = cFraction(8.0)
        self.xinmax    = cFraction(50.0)
        self.fb        = cFraction()
        self.refmux    = cFraction()
        self.bypmux    = cFraction()
        self.pfdref    = cFraction()
        self.pfdmin    = cFraction(1.0)
        self.pfdmax    = cFraction(100.0)
        self.pfdfb     = cFraction()
        self.vco       = cFraction()
        self.vcomin    = cFraction(2350.0)
        self.vcomax    = cFraction(2850.0)
        self.ps        = cFraction()
        self.psa       = cFraction()
        self.psb       = cFraction()
        self.fodmin    = cFraction()
        self.fodmax    = cFraction()
        self.fodclk    = cFraction()
        self.chxmin    = cFraction(0.0001)
        self.chxmax    = cFraction(700.0)
        self.ch0buf    = cFraction()
        self.ch1clk    = cFraction()
        self.ch1iod    = cFraction()
        self.ch1buf    = cFraction()
        self.ch2clk    = cFraction()
        self.ch2iod    = cFraction()
        self.ch2buf    = cFraction()
        self.ch3clk    = cFraction()
        self.ch3iod    = cFraction()
        self.ch3buf    = cFraction()
        self.ch4clk    = cFraction()
        self.ch4iod    = cFraction()
        self.ch4buf    = cFraction()
        self.omux      = muxscheme(4,1,1,1,1)
        self.fodmsbmax = 49152
        self.fodmsbmin = 24576
        self.xtal      = xosccload()

class xosccload(object):
    def __init__(self):
        self.xin     = [7.266, 7.642, 8.04, 8.408, 8.812, 9.186, 9.584, 9.948, 10.38, 10.754, 11.15, 11.516, 11.924, 12.296, 12.692, 13.062, 13.462, 13.836, 14.24, 14.602, 15.01, 15.384, 15.778, 16.142, 16.56, 16.934, 17.332, 17.694, 18.104, 18.474, 18.866, 19.228]
        self.xout    = [5.198, 5.538, 5.956, 6.33, 6.734, 7.09, 7.488, 7.854, 8.28, 8.642, 9.044, 9.412, 9.814, 10.19, 10.58, 10.948, 11.366, 11.738, 12.118, 12.496, 12.898, 13.264, 13.658, 14.018, 14.43, 14.804, 15.214, 15.556, 15.974, 16.326, 16.73, 17.096]
        self.cstray  = 1.0
        self.capext  = 0.0
        self.xtal_cl = 8.0

    def setexternal(self,cs,cext):
        retval = True
        if cs >= 0.0:
            self.cstray  = cs
            retval = retval & True
        else:
            retval = retval & False
        if cext >= 0.0:
            self.capext  = cext
            retval = retval & True
        else:
            retval = retval & False
        return retval
    def recommend(self,cl):
        #        cload,capext
        retval = -1
        clmin = cl * 0.98
        clmax = cl * 1.02
        for i in range(0,32):
            pinxin  = self.cstray + self.capext + self.xin[i]
            pinxout = self.cstray + self.capext + self.xout[i]
            cltmp   = (pinxin * pinxout) / (pinxin + pinxout)
            if (cltmp >= clmin) and (cltmp <=clmax):
                retval = i
                break
        return retval

class daisymux(object):
    def __init__(self):
        self.dic = {4:[[1,1,1,1]],3:[[1,1,0,1],[1,0,1,1],[1,1,1,0],[1,2,1,1],[2,1,1,1],[1,1,2,1]],2:[[1,0,1,0],[2,1,1,0],[1,0,2,1],[2,1,2,1],[1,0,0,1],[2,1,0,1],[2,2,1,1],[1,1,0,0],[1,2,1,0],[1,2,2,1]],1:[[1,0,0,0],[2,1,0,0],[2,2,1,0],[2,2,2,1]]}

class muxscheme(object):
    def __init__(self,ifr,i1,i2,i3,i4):
        self.freqs = ifr
        self.m1 = mux(1,i1,cFraction("1"))
        self.m2 = mux(2,i2,cFraction("2"))
        self.m3 = mux(3,i3,cFraction("3"))
        self.m4 = mux(4,i4,cFraction("4"))
        self.m1.setnext(self.m2)
        self.m2.setnext(self.m3)
        self.m3.setnext(self.m4)
        self.m4.setprev(self.m3)
        self.m3.setprev(self.m2)
        self.m2.setprev(self.m1)
    def setmux(self,imux,isetting):
        retval = False
        if isetting in range(0,3):
            if   imux==1:
                self.m1.set(isetting)
            elif imux==2:
                self.m2.set(isetting)
            elif imux==3:
                self.m3.set(isetting)
            elif imux==4:
                self.m4.set(isetting)
            else:
                self.m1.set(isetting)
                self.m2.set(isetting)
                self.m3.set(isetting)
                self.m4.set(isetting)
            retval = True
    def setfreq(self,imux,cf):
        retval = False
        if   imux==1:
            self.m1.setfr(cf)
        elif imux==2:
            self.m2.setfr(cf)
        elif imux==3:
            self.m3.setfr(cf)
        elif imux==4:
            self.m4.setfr(cf)
        else:
            self.m1.setfr(cf)
            self.m2.setfr(cf)
            self.m3.setfr(cf)
            self.m4.setfr(cf)
            retval = True
        return retval
    def getfreq(self,imux):
        retval = False
        if   imux==1:
            retval = [self.m1.get()]
        elif imux==2:
            retval = [self.m2.get()]
        elif imux==3:
            retval = [self.m3.get()]
        elif imux==4:
            retval = [self.m4.get()]
        else:
            retval = [self.m1.get(),self.m2.get(),self.m3.get(),self.m4.get()]
        return retval
class mux(object):
    def __init__(self,iNR,iSet,cfFreq):
        self.setting = iSet
        self.dict    = {0:"prev",1:"dir",2:"next"}
        self.cffreq  = cfFreq
        self.nr      = iNR
        self.prev    = None
        self.next    = None
    def setfr(self,cf):
        self.cffreq = cf
    def set(self,iN):
        if   iN == 0 and self.nr!=1:
            self.setting = 0
        elif iN == 1:
            self.setting = 1
        elif iN == 2 and self.nr!=4:
            self.setting = 2
        else:
            self.setting = 1
        return self.setting
    def setprev(self,prev):
        self.prev = prev
    def setnext(self,next):
        self.next = next
    def get(self):
        retval = ""
        if   self.setting == 0 and self.nr!=1:
            ip = -1
            ptr = self.prev
            while ip != None:
                if ptr.setting!=1:
                    ip = ptr.nr
                    ptr = ptr.prev
                else:
                    ip = None
                    break
            retval = ptr.cffreq
        elif self.setting == 1:
            retval = self.cffreq
        elif self.setting == 2 and self.nr!=4:
            ip = -1
            ptr = self.next
            while ip != None:
                if ptr.setting!=1:
                    ip = ptr.nr
                    ptr = ptr.next
                else:
                    ip = None
                    break
            retval = ptr.cffreq
        else:
            retval = cFraction("0")
        return retval

class GlobalVariables(object):
    def __init__(self):
        self.strName         = "CDCI6214"
        self.dDate           = "2017-11-15"
        self.dbg             = 0
        self.linkcp          = 1
        self.hideeng         = 1
        self.foden           = 0
        self.showHz          = 1
        self.Version         = ""
        self.BuildDate       = ""
        self.INIVersion      = ""
        self.strdec9         = "{0:2.9f}"
        self.strdec6         = "{0:2.6f}"
        self.strdec3         = "{0:2.3f}"
        self.i2cslaveaddress = 0
        self._frqs           = sixtytwofourteen()
        self.lblbg           = SolidColorBrush(ColorConverter.ConvertFromString("#00FFFFFF"))
        self.lblwbg          = SolidColorBrush(ColorConverter.ConvertFromString("#FFFFFFFF"))
        self.btnbg           = LinearGradientBrush()
        self.btnbb           = LinearGradientBrush()
        self.ctrlbgerr       = SolidColorBrush(ColorConverter.ConvertFromString("#FFDD0000")) #ti alert
        self.ctrlbberr       = SolidColorBrush(ColorConverter.ConvertFromString("#FFC0C0C0"))
        self.ctrlbgsucc      = SolidColorBrush(ColorConverter.ConvertFromString("#FF4CAF50"))
        self.ctrlbbsucc      = SolidColorBrush(ColorConverter.ConvertFromString("#FFC0C0C0"))
        self.ctrlbghigh      = SolidColorBrush(ColorConverter.ConvertFromString("#FFF3CD34"))
        self.ctrlbbhigh      = SolidColorBrush(ColorConverter.ConvertFromString("#FFC0C0C0"))
        self.ctrlbgstby      = SolidColorBrush(ColorConverter.ConvertFromString("#FFCCCCCC"))
        self.ctrlbbstby      = SolidColorBrush(ColorConverter.ConvertFromString("#FFC0C0C0"))
        self.txtblack        = SolidColorBrush(ColorConverter.ConvertFromString("#FF000000"))
        self._strEEFile      = ""
        self.fp              = freqplan(cFraction("25"),[[cFraction("100"),4]])
        self.wizardstate     = 0
        self.wizpipe         = [range(0,10),range(0,10),range(0,10),range(0,10),range(0,10)]
    def setdbg(self,val=0):
        self.dbg = val
    def printfrqs(self,bStatus=0):        
        if bStatus:
            UpdateStatusBar("internal freq class")
            for ele in self._frqs:
                UpdateStatusBar(str(ele))
        else:
            dbg2txt("internal freq class\n")
            strtmp = ""
            strtmp = strtmp + "ref   "  + "\t"
            strtmp = strtmp + "xin   "  + "\t"
            strtmp = strtmp + "fb    "  + "\t"
            strtmp = strtmp + "refmux"  + "\t"
            strtmp = strtmp + "bypmux"  + "\t"
            strtmp = strtmp + "pfdref"  + "\t"
            strtmp = strtmp + "pfdfb "  + "\t"
            strtmp = strtmp + "vco   "  + "\t"
            strtmp = strtmp + "ps    "  + "\t"
            strtmp = strtmp + "psa   "  + "\t"
            strtmp = strtmp + "psb   "  + "\t"
            strtmp = strtmp + "fodmin"  + "\t"
            strtmp = strtmp + "fodmax"  + "\t"
            strtmp = strtmp + "ch0buf"  + "\t"
            strtmp = strtmp + "ch1clk"  + "\t"
            strtmp = strtmp + "ch1iod"  + "\t"
            strtmp = strtmp + "ch1buf"  + "\t"
            strtmp = strtmp + "ch2clk"  + "\t"
            strtmp = strtmp + "ch2iod"  + "\t"
            strtmp = strtmp + "ch2buf"  + "\t"
            strtmp = strtmp + "ch3clk"  + "\t"
            strtmp = strtmp + "ch3iod"  + "\t"
            strtmp = strtmp + "ch3buf"  + "\t"
            strtmp = strtmp + "ch4clk"  + "\t"
            strtmp = strtmp + "ch4iod"  + "\t"
            strtmp = strtmp + "ch4buf"  + "\t" 
            strtmp = strtmp + "omux m1"  + "\t" 
            strtmp = strtmp + "omux m2"  + "\t" 
            strtmp = strtmp + "omux m3"  + "\t" 
            strtmp = strtmp + "omux m4"  + "\t" + "\n"
            strtmp = strtmp + str(g._frqs.ref   )  + "\t"
            strtmp = strtmp + str(g._frqs.xin   )  + "\t"
            strtmp = strtmp + str(g._frqs.fb    )  + "\t"
            strtmp = strtmp + str(g._frqs.refmux)  + "\t"
            strtmp = strtmp + str(g._frqs.bypmux)  + "\t"
            strtmp = strtmp + str(g._frqs.pfdref)  + "\t"
            strtmp = strtmp + str(g._frqs.pfdfb )  + "\t"
            strtmp = strtmp + str(g._frqs.vco   )  + "\t"
            strtmp = strtmp + str(g._frqs.ps    )  + "\t"
            strtmp = strtmp + str(g._frqs.psa   )  + "\t"
            strtmp = strtmp + str(g._frqs.psb   )  + "\t"
            strtmp = strtmp + str(g._frqs.fodmin)  + "\t"
            strtmp = strtmp + str(g._frqs.fodmax)  + "\t"
            strtmp = strtmp + str(g._frqs.ch0buf)  + "\t"
            strtmp = strtmp + str(g._frqs.ch1clk)  + "\t"
            strtmp = strtmp + str(g._frqs.ch1iod)  + "\t"
            strtmp = strtmp + str(g._frqs.ch1buf)  + "\t"
            strtmp = strtmp + str(g._frqs.ch2clk)  + "\t"
            strtmp = strtmp + str(g._frqs.ch2iod)  + "\t"
            strtmp = strtmp + str(g._frqs.ch2buf)  + "\t"
            strtmp = strtmp + str(g._frqs.ch3clk)  + "\t"
            strtmp = strtmp + str(g._frqs.ch3iod)  + "\t"
            strtmp = strtmp + str(g._frqs.ch3buf)  + "\t"
            strtmp = strtmp + str(g._frqs.ch4clk)  + "\t"
            strtmp = strtmp + str(g._frqs.ch4iod)  + "\t"
            strtmp = strtmp + str(g._frqs.ch4buf)  + "\t" 
            strtmp = strtmp + str(g._frqs.omux.m1.get())  + "\t" 
            strtmp = strtmp + str(g._frqs.omux.m2.get())  + "\t" 
            strtmp = strtmp + str(g._frqs.omux.m3.get())  + "\t" 
            strtmp = strtmp + str(g._frqs.omux.m4.get())  + "\t" + "\n"
            strtmp = strtmp + str(REF_FREQ.sValue) + "\t"         
            strtmp = strtmp + str(XIN_FREQ.sValue) + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(PFD_freq.sValue)      + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(VCO_FREQ.sValue)      + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(PSA_freq.sValue)      + "\t"         
            strtmp = strtmp + str(PSB_freq.sValue)      + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(Y0_freq.sValue)       + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(Y1_FREQ.sValue)       + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(Y2_FREQ.sValue)       + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(Y3_FREQ.sValue)  + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp +""                    + "\t"         
            strtmp = strtmp + str(Y4_FREQ.sValue)       + "\t" + "\n"  
            dbg2txt(strtmp)
g = GlobalVariables()

def dbg2txt(msg):
    if g.dbg:
        try:
            msg = str(msg)
            strFile = g.strName + ".log"
            strDir = Path.GetDirectoryName(__file__)
            strFullPath = Path.Combine(strDir, strFile)
            fh = open(strFullPath,"a")
            fh.write(ctime() + "\t" + msg + "\n")
            fh.close()
            fh = None
        except IOError as errdetails:
            UpdateStatusBar("Log File Error: {%1}".format(errdetails.errno, errdetails.strerror))

def GUI_Mod():
    if g.hideeng:
        do = Hide
    else:
        do = Show
    for ctrl in [pll_cp_up,ip_xo_gm_fine,update_crc,nvmlcrc,BTN_UPDATE_CRC,BTN_UPDATE_VERSION,TICS_VERSION,TICS_VERSION_NOTE,ch1_1p8vdet,ch2_1p8vdet,ch3_1p8vdet,ch4_1p8vdet]:
        do(ctrl)
    for ctrl in [UIC_XIN_FREQ,UIC_REF_FREQ,UIC_VCO_FREQ,UIC_PSA_freq,UIC_PSB_freq,UIC_Y0_freq,UIC_Y1_FREQ,UIC_Y2_FREQ,UIC_Y3_FREQ,UIC_Y4_FREQ,UIC_BYP_freq,UIC_Y1_freq,UIC_Y2_freq,UIC_Y3_freq,UIC_Y4_freq]:
        ctrl.TextAlignment = TextAlignment.Right
    UIC_PFD_freq.TextAlignment = TextAlignment.Center
    UIC_Config_Info.Background = g.lblwbg
    UIC_lock_det_Info.Foreground = g.txtblack
    btnlabels()
    BTN_Backannotate()
    TICS_VERSION.sValue      = ""
    TICS_VERSION_NOTE.sValue = ""
    clockwizard_01_GUI_Init()
def btnlabels():
    #apply some default values
    BTN_EVM_DUT_PWR_EN.Content          = "off"
    BTN_PIN_EEPROMSEL.Content           = "Low"
    BTN_PIN_EEPROMSEL_M.Content         = "HiZ"
    BTN_PIN_REFSEL.Content              = "Low"
    BTN_PIN_REFSEL_M.Content            = "HiZ"
    BTN_PIN_RESETNSYNC.Content          = "Low"
    BTN_PIN_GPIO4.Content               = "High"
    BTN_PIN_GPIO1.Content               = "Low"
    BTN_RECAL.Content                   = "Re-CAL"
    BTN_SYNC.Content                    = "Sync"
    BTN_FREQ_INC.Content                = "+"
    BTN_FREQ_DEC.Content                = "-"
    BTN_FREQ_INC.FontWeight             = FontWeights.Bold
    BTN_FREQ_DEC.FontWeight             = FontWeights.Bold
    BTN_XTALREC.Content                 = "Apply"
    BTN_UPDATE_VERSION.Content          = "Update"

def BTN_Backannotate():
    #dbg2txt("BTN_Backannotate\t" + str(GetPin("EVM_LDO_EN"))   + "\t"+ str(GetPin("EVM_DCDC_EN"))  + "\t"+ str(GetPin("RESETN_SYNC"))  + "\t"+ str(GetPin("OE_GPIO4"))     + "\t"+ str(GetPin("EEPROMSEL_LH")) + "\t"+ str(GetPin("REFSEL_LH"))    + "\t"+ str(GetPin("EEPROMSEL_M"))  + "\t"+ str(GetPin("REFSEL_M"))     + "\t"+ str(GetPin("STATUS_GPIO1")) + "\n")
    if   GetPin("EEPROMSEL_HIZ_N")==1 and GetPin("EEPROMSEL")==0:
        BTN_PIN_EEPROMSEL.Background    = g.ctrlbgstby
        BTN_PIN_EEPROMSEL.BorderBrush   = g.ctrlbbstby
        BTN_PIN_EEPROMSEL_M.Background  = g.ctrlbgstby
        BTN_PIN_EEPROMSEL_M.BorderBrush = g.ctrlbbstby
        BTN_PIN_EEPROMSEL_M.Content     = "On"
        BTN_PIN_EEPROMSEL.Content       = "Low"
        Show(BTN_PIN_EEPROMSEL)
    elif GetPin("EEPROMSEL_HIZ_N")==1 and GetPin("EEPROMSEL")==1:
        BTN_PIN_EEPROMSEL.Background    = g.ctrlbghigh
        BTN_PIN_EEPROMSEL.BorderBrush   = g.ctrlbbhigh
        BTN_PIN_EEPROMSEL_M.Background  = g.ctrlbgstby
        BTN_PIN_EEPROMSEL_M.BorderBrush = g.ctrlbbstby
        BTN_PIN_EEPROMSEL_M.Content     = "On"
        BTN_PIN_EEPROMSEL.Content       = "High"
        Show(BTN_PIN_EEPROMSEL)
    else:
        BTN_PIN_EEPROMSEL.Background    = g.ctrlbgstby
        BTN_PIN_EEPROMSEL.BorderBrush   = g.ctrlbbstby
        BTN_PIN_EEPROMSEL_M.Background  = g.ctrlbghigh
        BTN_PIN_EEPROMSEL_M.BorderBrush = g.ctrlbbhigh
        BTN_PIN_EEPROMSEL_M.Content     = "HiZ"
        Hide(BTN_PIN_EEPROMSEL)
    if   GetPin("REFSEL_HIZ_N")==1 and GetPin("REFSEL")==0:
        BTN_PIN_REFSEL.Background    = g.ctrlbgstby
        BTN_PIN_REFSEL.BorderBrush   = g.ctrlbbstby
        BTN_PIN_REFSEL_M.Background  = g.ctrlbgstby
        BTN_PIN_REFSEL_M.BorderBrush = g.ctrlbbstby
        BTN_PIN_REFSEL_M.Content     = "On"
        BTN_PIN_REFSEL.Content       = "Low"
        RefSelMux()
        Show(BTN_PIN_REFSEL)
    elif GetPin("REFSEL_HIZ_N")==1 and GetPin("REFSEL")==1:
        BTN_PIN_REFSEL.Background    = g.ctrlbghigh
        BTN_PIN_REFSEL.BorderBrush   = g.ctrlbbhigh
        BTN_PIN_REFSEL_M.Background  = g.ctrlbgstby
        BTN_PIN_REFSEL_M.BorderBrush = g.ctrlbbstby
        BTN_PIN_REFSEL_M.Content     = "On"
        BTN_PIN_REFSEL.Content       = "High"
        RefSelMux()
        Show(BTN_PIN_REFSEL)
    else:
        BTN_PIN_REFSEL.Background    = g.ctrlbgstby
        BTN_PIN_REFSEL.BorderBrush   = g.ctrlbbstby
        BTN_PIN_REFSEL_M.Background  = g.ctrlbghigh
        BTN_PIN_REFSEL_M.BorderBrush = g.ctrlbbhigh
        BTN_PIN_REFSEL_M.Content     = "HiZ"
        Hide(BTN_PIN_REFSEL)
    if   GetPin("RESETN_SYNC_GPO")==0:
        BTN_PIN_RESETNSYNC.Background  = g.ctrlbgstby
        BTN_PIN_RESETNSYNC.BorderBrush = g.ctrlbbstby
        BTN_PIN_RESETNSYNC.Content = "Low"
    else:
        BTN_PIN_RESETNSYNC.Background  = g.ctrlbghigh
        BTN_PIN_RESETNSYNC.BorderBrush = g.ctrlbbhigh
        BTN_PIN_RESETNSYNC.Content = "High"
    if   GetPin("GPIO1")==0:
        BTN_PIN_GPIO1.Background  = g.ctrlbgstby
        BTN_PIN_GPIO1.BorderBrush = g.ctrlbbstby
        BTN_PIN_GPIO1.Content = "Low"
    else:
        BTN_PIN_GPIO1.Background  = g.ctrlbghigh
        BTN_PIN_GPIO1.BorderBrush = g.ctrlbbhigh
        BTN_PIN_GPIO1.Content = "High"
    if   GetPin("GPIO4")==0:
        BTN_PIN_GPIO4.Background  = g.ctrlbgstby
        BTN_PIN_GPIO4.BorderBrush = g.ctrlbbstby
        BTN_PIN_GPIO4.Content = "Low"
    else:
        BTN_PIN_GPIO4.Background  = g.ctrlbghigh
        BTN_PIN_GPIO4.BorderBrush = g.ctrlbbhigh
        BTN_PIN_GPIO4.Content = "High"
    if   GetPin("DUT_PWR_EN")==0:
        BTN_EVM_DUT_PWR_EN.Background  = g.ctrlbgstby
        BTN_EVM_DUT_PWR_EN.BorderBrush = g.ctrlbbstby
        BTN_EVM_DUT_PWR_EN.Content     = "off"
    else:
        BTN_EVM_DUT_PWR_EN.Background  = g.ctrlbghigh
        BTN_EVM_DUT_PWR_EN.BorderBrush = g.ctrlbbhigh
        BTN_EVM_DUT_PWR_EN.Content     = "on"
    if len(g._strEEFile)==0:
        Hide(BTN_EEP_DIR_WRITE2DEVICE)
    EEFILE_Info.sValue = Path.GetFileNameWithoutExtension(g._strEEFile)

"""
def retversionstring():
    return str(BTN_SYNC.Parent.Parent.Parent.Parent.Parent.Parent.Parent.Version)+", "+str(BTN_SYNC.Parent.Parent.Parent.Parent.Parent.Parent.Parent.BuildDate)+' INI:'+str(INIContents.ReadValue("SETUP","VERSION"))+' PY:'+str(g.dDate)
def tpfilever():
    g.Version = str(UIC_mode.Parent.Parent.Parent.Parent.Parent.Parent.Parent.Version)
    g.BuildDate = str(UIC_mode.Parent.Parent.Parent.Parent.Parent.Parent.Parent.BuildDate)
    g.INIVersion = str(INIContents.ReadValue("SETUP","VERSION"))
def ticsversion():
    if len(TICS_VERSION.sValue):
        if TICS_VERSION.sValue != retversionstring():
            UIC_TICS_VERSION.Background = g.ctrlbgerr
            Show(TICS_VERSION)
            Show(BTN_UPDATE_VERSION)
        else:
            Hide(TICS_VERSION)
            Hide(BTN_UPDATE_VERSION)
    else:
        BTN_UPDATE_VERSION_Update()
def BTN_UPDATE_VERSION_Update():
    TICS_VERSION.sValue = retversionstring()
    Hide(TICS_VERSION)
    #Hide(TICS_VERSION_NOTE)
    Hide(BTN_UPDATE_VERSION)
"""
def ClearFrqEntries():
    gv = globals()
    lctrl = ["XIN_FREQ","REF_FREQ","VCO_FREQ","Y0_freq","Y1_FREQ","Y2_FREQ","Y3_FREQ","Y4_FREQ"]
    for ctrl in lctrl:
        gv[ctrl].sValue = ""

def limitcheck(dcheck,dmin,dmax):
    retval = False
    dcheck = float(dcheck)
    dmin   = float(dmin)
    dmax   = float(dmax)
    if (dcheck >= dmin) and (dcheck <= dmax):
        retval = True
    return retval
    
def bFindAddress_Update():
    UpdateStatusBar("Scanning for I2C address...")
    result = ScanDevices(g.i2cslaveaddress);
    dbg2txt(communicationInterface)
    if (result[0] == ""):   
        statusMsg = 'Device found at 0x%x' % result[1] +'.  Address will be updated.';
        #MessageBox.Show(statusMsg, "Scan Result", MessageBoxButtons.OK);
        UpdateStatusBar(statusMsg)
        #TICSPROINC00213 - I2C Address issues - Not saving I2C address when Find I2C address is pressed on EZ Config page, I2C Address issues - After "Setting" I2C address,EZ Config Find I2C address should work
        AppGlobals.I2CAddress = "0x%x" % result[1];
    else:
        MessageBox.Show("No device found!!", "Scan Result", MessageBoxButtons.OK);
    pass
######### CALCULATIONS
def FREQ_Update():
    g._frqs.xin = cFraction(XIN_FREQ.sValue)
    g._frqs.ref = cFraction(REF_FREQ.sValue)
    EVM_XIN_freq.sValue = XIN_FREQ.sValue
    EVM_REF_freq.sValue = REF_FREQ.sValue
    if   ref_mux_src.iValue == 0 and GetPin("REFSEL_HIZ_N") == True:
        #Pin
        iRefSel = int(GetPin("REFSEL")) 
    elif ref_mux_src.iValue == 0 and GetPin("REFSEL_HIZ_N") == False:
        #Pin (force)
        iRefSel = 0
    else :
        #BitField
        iRefSel = ref_mux.iValue 
    dbg2txt("REFMUXFREQ\t" + str(iRefSel))
    if iRefSel:
        #REF
        g._frqs.refmux = cFraction(g._frqs.ref)
    else:
        #XIN
        g._frqs.refmux = cFraction(g._frqs.xin)
    if ip_rdiv.iValue:
        g._frqs.pfdref = g._frqs.refmux / cFraction(ip_rdiv.iValue)
    else:
        g._frqs.pfdref = g._frqs.refmux * cFraction(2)
    if ip_byp_mux.iValue:
        g._frqs.bypmux = g._frqs.pfdref
    else:
        g._frqs.bypmux = g._frqs.refmux
    g._frqs.ps      = g._frqs.pfdref * cFraction(pll_ndiv.iValue)
    g._frqs.vco     = g._frqs.ps * cFraction(pll_psfb.iValue  + 4)
    g._frqs.psa     = g._frqs.vco / cFraction(pll_psa.iValue + 4)
    g._frqs.psb     = g._frqs.vco / cFraction(pll_psb.iValue + 4)
    g._frqs.fodclk  = g._frqs.vco / cFraction(8)
    if g.foden:
        FODIN_freq.sValue  = str(g._frqs.fodclk)
    g._frqs.fodmin = cFraction(g._frqs.vco / cFraction(12.0))
    g._frqs.fodmax = cFraction(g._frqs.vco / cFraction(6.0))
    if g.showHz:
        PFD_freq.sValue = g.strdec6.format(float(g._frqs.pfdref))
        BYP_freq.sValue = g.strdec6.format(float(g._frqs.bypmux))
        VCO_FREQ.sValue = g.strdec6.format(float(g._frqs.vco))
        PSA_freq.sValue = g.strdec6.format(float(g._frqs.psa))
        PSB_freq.sValue = g.strdec6.format(float(g._frqs.psb))
    else:
        PFD_freq.sValue = g.strdec9.format(float(g._frqs.pfdref))
        BYP_freq.sValue = g.strdec9.format(float(g._frqs.bypmux))
        VCO_FREQ.sValue = g.strdec9.format(float(g._frqs.vco))
        PSA_freq.sValue = g.strdec9.format(float(g._frqs.psa))
        PSB_freq.sValue = g.strdec9.format(float(g._frqs.psb))
    PLLlock()
    ChannelFreq(-1)
    
def ChannelFreq(iCH):
    gv = globals()
    if iCH >= 0 and iCH < 5:
        #valid output channel        
        if iCH:
            #1-4
            #iod_mux 0..3 A B SSC REF
            imux = gv["ch%i_iod_mux" % iCH].iValue
            if   imux == 0:
                # PSA
                 ps = g._frqs.psa
            elif imux == 1:
                # PSB
                ps = g._frqs.psb
            elif imux == 2:
                # FOD
                if gv["ch%i_fod_dlymode"%iCH].iValue:
                    #delay
                    ps = g._frqs.fodclk
                else:
                    #synth
                    lfod = FOD_REG2FREQ(g._frqs.vco,gv["ch%i_fod_msb"%iCH].iValue,gv["ch%i_fod"%iCH].iValue,gv["ch%i_iod_div"%iCH].iValue,gv["fod_clk_ch%i"%iCH].iValue)
                    ps = lfod[1] * cFraction(lfod[2])
            elif imux == 3:
                # REF
                ps = g._frqs.bypmux
            else:
                UpdateStatusBar("invalid mux config")
            gv["UIC_ch%i_sync_delay" % iCH].ToolTip = "Step = " + g.strdec9.format(1e3/float(ps)) +" ns"
            if gv["ch%i_iod_div" % iCH].iValue:
                iod = cFraction( ps / cFraction(gv["ch%i_iod_div" % iCH].iValue))
            else:
                iod = cFraction('0')
            #daisy chain mux
            if   ((gv["ch%i_mux" % iCH].iValue == 0) and (iCH == 1)) or ((gv["ch%i_mux" % iCH].iValue == 3) and (iCH == 4)):
                gv["Y%i_FREQ" % iCH].sValue = ''
            elif (gv["ch%i_mux" % iCH].iValue == 0) and (iCH > 1 and iCH <4):
                gv["Y%i_FREQ" % iCH].sValue = gv["Y%i_FREQ" % (iCH-1)].sValue
            elif gv["ch%i_mux" % iCH].iValue == 1:
                if g.showHz:
                    gv["Y%i_FREQ" % iCH].sValue = g.strdec6.format(float( iod ))
                else:
                    gv["Y%i_FREQ" % iCH].sValue = g.strdec9.format(float( iod ))
            elif gv["ch%i_mux" % iCH].iValue == 2:
                gv["Y%i_FREQ" % iCH].sValue = gv["Y%i_FREQ" % (iCH+1)].sValue
        else:
            #0
            if ch0_lvcmos_drv.iValue:
                g._frqs.ch0buf = g._frqs.bypmux
            else:
                g._frqs.ch0buf = cFraction(0)
            Y0_freq.sValue = str(g._frqs.ch0buf)
            EVM_Y0_freq.sValue = Y0_freq.sValue
    else:
        #update all
        #0
        #g.setdbg(1)
        #UpdateStatusBar("dlymode iV\t" + str(ch1_fod_dlymode.iValue)+ "/" +str(ch2_fod_dlymode.iValue)+ "/" + str(ch3_fod_dlymode.iValue)+ "/" + str(ch4_fod_dlymode.iValue))
        #UpdateStatusBar("dlymode gv\t" + str(gv["ch1_fod_dlymode"].iValue)+ "/" +str(gv["ch2_fod_dlymode"].iValue)+ "/" + str(gv["ch3_fod_dlymode"].iValue)+ "/" + str(gv["ch4_fod_dlymode"].iValue))
        #UpdateStatusBar("dlymode GF\t" + str(GetFieldValue("ch1_fod_dlymode"))+ "/" +str(GetFieldValue("ch2_fod_dlymode"))+ "/" + str(GetFieldValue("ch3_fod_dlymode"))+ "/" + str(GetFieldValue("ch4_fod_dlymode")))
        if ch0_lvcmos_drv.iValue:
            g._frqs.ch0buf = g._frqs.bypmux
        else:
            g._frqs.ch0buf = cFraction('0')
        Y0_freq.sValue = str(g._frqs.ch0buf)
        iod = []
        ps = cFraction()
        i=-1
        for i in range(1,5):
            imux = gv["ch%i_iod_mux" % i].iValue
            if   imux == 0:
                # PSA
                 ps = g._frqs.psa
            elif imux == 1:
                # PSB
                ps = g._frqs.psb
            elif imux == 2:
                # FOD
                if gv["ch%i_fod_dlymode"%i].iValue:
                    #delay
                    ps = g._frqs.fodclk
                else:
                    #synth
                    lfod = FOD_REG2FREQ(g._frqs.vco,gv["ch%i_fod_msb"%i].iValue,gv["ch%i_fod"%i].iValue,gv["ch%i_iod_div"%i].iValue,gv["fod_clk_ch%i"%i].iValue)
                    ps = lfod[1] * cFraction(lfod[2])
            elif imux == 3:
                # REF
                ps = g._frqs.bypmux
            else:
                UpdateStatusBar("invalid mux config")
            if ps > cFraction("0"):
                gv["UIC_ch%i_sync_delay" % i].ToolTip = "Step = " + g.strdec3.format(1e3/float(ps)) +" ns"
            if gv["ch%i_iod_div" % i].iValue:
                cftemp = cFraction( ps / cFraction(gv["ch%i_iod_div" % i].iValue))
            else:
                cftemp = cFraction('0')
            iod.append(cftemp)
            if imux == 2:
                Show("ch%i_fod_msb" %i)
                Show("ch%i_fod" %i)
                Show("fod_clk_ch%i" %i)
            else:
                Hide("ch%i_fod_msb" %i)
                Hide("ch%i_fod" %i)
                Hide("fod_clk_ch%i" %i)
            g._frqs.omux.setfreq(i,cftemp)
            g._frqs.omux.setmux(i,gv["ch%i_mux" % i].iValue)
            dbg2txt("chfreq(-1),i: " + str(i)+" "+str(cftemp) +" "+ str(gv["ch%i_mux" % i].iValue))
        j = -1
        for j in range(1,5):
            cftmp = g._frqs.omux.getfreq(j)[0]
            ishowhz = g.showHz   
            ftmp = float(g._frqs.omux.getfreq(j)[0])
            if ishowhz:
                gv["Y%i_freq" % j].sValue = g.strdec6.format(ftmp)
            else:                
                gv["Y%i_freq" % j].sValue = g.strdec9.format(ftmp)
            dbg2txt("chfreq(-1),j: " + str(j)+" "+str(ftmp))
    #g.setdbg(0)
    EVM_Y0_freq.sValue = Y0_freq.sValue
    EVM_Y1_freq.sValue = Y1_freq.sValue
    EVM_Y2_freq.sValue = Y2_freq.sValue
    EVM_Y3_freq.sValue = Y3_freq.sValue
    EVM_Y4_freq.sValue = Y4_freq.sValue

def ChanOpt(iCH):
    gv = globals()
    # bypass buffer
    if (gv["ip_byp_en_ch%i" %iCH].iValue==1) and (gv["ch%i_iod_mux" %iCH].iValue <3):
        gv["ip_byp_en_ch%i" %iCH].iValue = 0
    elif (gv["ip_byp_en_ch%i" %iCH].iValue==0) and (gv["ch%i_iod_mux" %iCH].iValue==3):
        gv["ip_byp_en_ch%i" %iCH].iValue = 1
        UpdateStatusBar("Optimizer: Bypass buffer in channel %i powered up."%iCH)
    # FOD powerdown
    if (gv["ch%i_iod_mux"%iCH].iValue == 2) and (gv["ch%i_mux"%iCH].iValue == 1) and (gv["pdn_ch%i_fod"%iCH].iValue==1):
        gv["pdn_ch%i_fod"%iCH].iValue = 0
        UpdateStatusBar("Optimizer: FOD in channel %i powered up."%iCH)
    # FOD Synth Mode
    if (gv["ch%i_iod_mux"%iCH].iValue == 2) and (gv["ch%i_mux"%iCH].iValue == 1) and (gv["pdn_ch%i_fod"%iCH].iValue==0) and (gv["ch%i_fod_dlymode"%iCH].iValue==1):
        UpdateStatusBar("Optimizer: FOD in channel %i in delay mode, not frequency synthesis."%iCH)
def xtalload():
    g._frqs.xtal.setexternal(xtal_cstray.dValue,xtal_clext.dValue)
    return g._frqs.xtal.recommend(xtal_cl.dValue)
def PLLlock():
    lock_det_Info.sValue = '>> reading <<'
    if ReadParameter("lock_det"):
        UIC_lock_det_Info.Foreground = g.ctrlbgsucc
        lock_det_Info.sValue = 'locked'
    else:
        UIC_lock_det_Info.Foreground = g.ctrlbgerr
        lock_det_Info.sValue = 'unlocked'

def FOD_FREQ2REG(cfVCO,cfOUT,iIOD,iFB=0):
    retval  = [False,0x8000,0x0000,iFB]
    if float(cfOUT) >0 and iIOD >0:
        if iFB:
            dbg2txt("FOD feedback open")
            #UpdateStatusBar("FOD feedback open")
            cfOUT = cFraction(iIOD) * cfOUT
            iIOD = cFraction("1.0")
        A1 = (((float(cfVCO)/(8.0 * float(cfOUT) * float(iIOD))) - 1.0) * float(iIOD)) + 1.0
        fod_num = int(A1 * 2**15)
        fod_den = int(round((A1 * 2**24) - (fod_num * 2**9)))
        dbg2txt("A1="+str(A1))
        if (fod_num >= 24576) and (fod_num <= 49152):
            retval[0] = True
            retval[1] = fod_num
            retval[2] = fod_den
            #dbg2txt("valid=yes")
        #else:
        #    dbg2txt("valid=no")
        #    if fod_num < 0 or fod_den < 0:
        #        dbg2txt("NEGATIVE num="+'{:#08x}'.format(abs(fod_num)) + " den="+'{:#08x}'.format(abs(fod_den)))
        #    else:
        #        dbg2txt("num="+'{:#08x}'.format(fod_num) + " den="+'{:#08x}'.format(fod_den))
    return retval

def FOD_REG2FREQ(cfVCO,iNUM,iDEN,iIOD,iFB=0):
    #dbg2txt("FOD_REG2FREQ start " + str(cfVCO) + ' '+ str(iNUM) + ' '+ str(iDEN) + ' '+ str(iIOD) + ' '+ str(iFB))
    retval  = [False,cfVCO/cFraction(8.0),iIOD,iFB]
    #         [  0  ,          1         ,  2 , 3 ]
    #         [valid,   fodclk--> fodout , iod,fb ]
    iPost = 1
    if iIOD>0:
        if iFB:
            #dbg2txt("FOD feedback open")
            #UpdateStatusBar("FOD feedback open")
            iPost = iIOD
            iIOD  = 1
        if (iNUM >= g._frqs.fodmsbmin) and (iNUM <= g._frqs.fodmsbmax):
            A1 = (((iNUM * float(2**9) + float(iDEN))/ float(2**24)) - 1.0)/float(iIOD) + 1.0
            #a = float(iNUM)
            #b = float(2**9)
            #c = float(iDEN)
            #d = float(2**24)
            #e = float(1)
            #f = float(iIOD)
            #h = float((((a*b+c)/d-e)/f)+e)
            #dbg2txt(str(a) + "\t" + str(b)+ "\t" + str(c)+ "\t" + str(d)+ "\t" + str(e)+ "\t" + str(f)+ "\t=" + str(g))
            cfOUT = cFraction(round(float(cfVCO / (cFraction(8.0) * cFraction(iIOD) * cFraction(A1))),9 - g.showHz * 3))
            #dbg2txt("A1 / cfOUT " + str(A1) + " " + str(cfOUT))
            retval[0] = True
            retval[1] = cfOUT / cFraction(iPost)
        else:
            dbg2txt("no valid num & den")
        #dbg2txt(str(retval[0]) + " " + str(retval[1]) + ' ' + str(retval[2]) + " " + str(retval[3]))
    return retval
def fraccalc(ref,liste):
    g.fp = freqplan(ref,liste)
### RAW Registers 
def CheckReadback():
    pass
def EnableReadback():
    pass

def bFindAddress_Update():
    UpdateStatusBar("Scanning for I2C address...")
    result = ScanDevices(g.i2cslaveaddress);
    print communicationInterface
    if (result[0] == ""):   
        statusMsg = 'Device found at 0x%x' % result[1] +'.  Address will be updated.';
        #MessageBox.Show(statusMsg, "Scan Result", MessageBoxButtons.OK);
        UpdateStatusBar(statusMsg)
        #TICSPROINC00213 - I2C Address issues - Not saving I2C address when Find I2C address is pressed on EZ Config page, I2C Address issues - After "Setting" I2C address,EZ Config Find I2C address should work
        AppGlobals.I2CAddress = "0x%x" % result[1];
    else:
        MessageBox.Show("No device found!!", "Scan Result", MessageBoxButtons.OK);
    pass
def eewait(val):
    '''waits for time in sec and checks the time stamp to ensure minimum wait time.'''
    retval=0
    rb =1
    tDiff = 1
    while rb==1 and tDiff >= 0.008 and retval >0:
        tBefore = clock()
        sleep(val)
        rb = int(ReadParameter("nvmbusy"))
        tAfter = clock()
        tDiff = tAfter - tBefore
        retval +=1
    #UpdateStatusBar("nvmbusy wait " + str(retval) + "   " + str(tDiff))
    return retval
def waitonly(val):
    '''waits for time in sec and checks the time stamp to ensure minimum wait time.'''
    retval=0
    tDiff = 0.0000001
    while tDiff <= val:
        tBefore = clock()
        sleep(val)
        tAfter = clock()
        tDiff = tAfter - tBefore
        retval +=1
    return retval
def rbwait(val,bitfield,bUI=True):
    '''waits for time in sec and checks the time stamp to ensure minimum wait time.'''
    retval=-1
    tDiff = 0.000001
    while tDiff <= val:
        tBefore = clock()
        sleep(val)
        tAfter = clock()
        tDiff = tAfter - tBefore
    if bUI:
        retval = ReadParameterAndUpdateUI(bitfield)
    else:
        retval = ReadParameter(bitfield)
    return retval
def jedec_crc16(lEEPROM,iFileCRC,bCheckFileCRC):
    '''CRC Calculation for the EEPROM. Provide a list of integers with the full EEPROM image.
       CCITT-CRC16: x^16 + x^12 + x^5 + x^0
       Shankar's implemendation from PERL
       returns list with calculated crc and checked file CRC'''
    retval = [-1,-1] # Calculated CRC, file CRC
    ilen = len(lEEPROM)
    if ilen:
        iCRC = 0x0000
        iVal = 0x0000
        iStr = ""
        for i in range(0,ilen-1):       # n-1 bug in a0
            iVal = lEEPROM[i] ^ iCRC
            jCRC = 0
            iRST = 0
            iPOL = 0x1021
            iStr = iStr + '{:#06x}'.format(lEEPROM[i])+"\t"+'{:#06x}'.format(iVal) + "\t"
            for j in range(0,16):
                iRST = MSB(iVal) ^ MSB(jCRC)
                jCRC = (jCRC <<1 ) & 0xFFFF
                if iRST:
                    jCRC = jCRC ^ iPOL
                iVal = iVal << 1
            iCRC = jCRC
            iStr = iStr + str(i)+"\t"+ '{:#06x}'.format(lEEPROM[i])+"\t"+'{:#06x}'.format(iCRC) + "\n"
        retval[0] = iCRC & 0xFFFF
        dbg2txt(iStr)
        if bCheckFileCRC:
            retval[1] = iFileCRC & 0xFFFF
        dbg2txt('JEDEC CRC: ' + '{:#06x}'.format(retval[0]) + ' / '+'{:#06x}'.format(retval[1]))
    else:
        dbg2txt("jedec crc - image length mismatch " + str(len(lEEPROM)))
    return retval
def MSB(val):
    retval = 0
    if val & 0x8000:
        retval = 1
    return retval

def eereaddirect():
    '''Save the whole EEPROM to a text file. Method is direct EEPROM access'''
    dialog = SaveFileDialog()
    dialog.Filter = "All Files (*.*)|*.*|EEPROM HEX Files (*.hxt)|*.hxt"
    dialog.FilterIndex = 2
    dialog.Title = "Export Unit EEPROM to HEX Image"
    if dialog.ShowDialog() == DialogResult.OK:   
        print "EEPROM read to file " + dialog.FileName
        l = []
        eeb  = []
        eep0 = []
        eep1 = []
        lbf = ["nvmbusy","nvmcrcerr","nvm_wr_error","nvm_rd_error","nvmlcrc","nvmscrc","nvm_rd_addr","nvm_rd_data","nvm_wr_addr","nvm_wr_data"]
        for bf in lbf:
            l.append(ReadParameter(bf))
        UpdateStatusBar("Reading EEPROM... please wait.")
        for i in range(0,12):
            WriteParameter("nvm_rd_addr",i)
            eeb.append(ReadParameter("nvm_rd_data"))
            eewait(0.005) #wait 5msec
        for i in range(12,38):
            WriteParameter("nvm_rd_addr",i)
            eep0.append(ReadParameter("nvm_rd_data"))
            eewait(0.005) #wait 5msec
        for i in range(38,64):
            WriteParameter("nvm_rd_addr",i)
            eep1.append(ReadParameter("nvm_rd_data"))
            eewait(0.005) #wait 5msec
        UpdateStatusBar("EEPROM read done. Save to file.")
        fh = open(dialog.FileName,"w")
        fh.write("----- CDCI6214 EEPROM HEX TEXT FILE ------\n")
        fh.write("Header Info\t" + ctime()+"\n")
        ilen = len(l)
        for i in range(0,ilen):
            fh.write(lbf[i] + "\t" + '{:#06x}'.format(int(l[i])) +"\n")
        fh.write("\n----- BASE   PAGE   ------\n")
        i=0
        for word in eeb:
            fh.write('{:#02d}'.format(i) + '\t' +  '{:#06x}'.format(int(word))+ '\t'+ str(int(word))+'\n')
            i +=1
        fh.write("\n----- CONFIG PAGE 0 ------\n")
        for word in eep0:
            fh.write('{:#02d}'.format(i)+ '\t' +  '{:#06x}'.format(int(word)) + '\t' + str(int(word))+ '\n')
            i +=1
        fh.write("\n----- CONFIG PAGE 1 ------\n")
        for word in eep1:
            fh.write('{:#02d}'.format(i)+ '\t' + '{:#06x}'.format(int(word))+ '\t' +  str(int(word))+ '\n')
            i +=1
        fh.write("----- END EEPROM HEX TEXT FILE ------")
        fh.close()
        UpdateStatusBar("EEPROM file saved (" + dialog.FileName+ ")")
    else:
        UpdateStatusBar("EEPROM read aborted (" + dialog.FileName + ")")
    pass

def eewritedirect():
    if eewriteconfirm():
        # write image
        # prep device
        waitval = 0.01
        iCRCfromFILE = 0
        iCRC = 0
        UpdateStatusBar("Writing EEPROM File " + g._strEEFile)
        WriteParameter("ee_lock",5)
        eewait(waitval)
        strHXT = ""
        if len(g._strEEFile) > 4:
            fh = open(g._strEEFile,"r")
            for line in fh:
                strHXT = strHXT + line
            fh.close()
            lHXT = re.findall(r'([0-9][0-9])\t0x([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f])\t([0-9][0-9]*)',strHXT)
            if len(lHXT)==64:
                # create list for crc calc
                liEE = []
                for i in range(0,64):
                    if len(lHXT[i])==3:
                        liEE.append(int(lHXT[i][1][0:2],16))
                        liEE.append(int(lHXT[i][1][2:4],16))
                    else:
                        dbg2txt('hxt format issue len=' +str(len(lHXT[i])) + ' '+str(lHXT[i]))
                dbg2txt(str(len(liEE)) +' '+ str(liEE))
                lCRC = jedec_crc16(liEE,int(lHXT[0][2]),True)
                dbg2txt("reg2ee calc CRC vs NVMSCRC " + '{:#06x}'.format(lCRC[0]) + ":" + '{:#06x}'.format(lCRC[1]))
                # actual ee write
                for i in range(0,64):
                    if len(lHXT[i])==3:
                        WriteParameter("nvm_wr_addr",int(lHXT[i][0]))
                        eewait(waitval)
                        if i==63:
                            iCRCfromFILE = int(lHXT[i][2])
                            WriteParameter("nvm_wr_data",iCRCfromFILE)
                        else:
                            WriteParameter("nvm_wr_data",int(lHXT[i][2]))
                        eewait(waitval)
            else:
                UpdateStatusBar("HXT File has not 64 words. Canceled.")
                g.retval = g.retval & False
            # crosscheck device crc to ensure transfer was successful
            eewait(0.1)
            WriteParameter("update_crc",1)
            eewait(waitval)
            iCRC = int(ReadParameter("nvmlcrc"))
            strlivecrc = '{:#06x}'.format(iCRC)
            eewait(waitval)
            UpdateStatusBar("EEPROM written, CRC of FILE / DEVICE / CRCERR " + '{:#06x}'.format(iCRCfromFILE) + " / " + strlivecrc + " / " + '{:#06x}'.format(int(ReadParameter("nvmcrcerr"))))   
    pass

def eeselectfile():
    dialog = OpenFileDialog()
    dialog.Filter = "All Files (*.*)|*.*|EEPROM HEX Files (*.hxt)|*.hxt"
    dialog.FilterIndex = 2
    dialog.Title = "Select EEPROM Image"
    if dialog.ShowDialog() == DialogResult.OK:
        g._strEEFile = dialog.FileName
        UpdateStatusBar("EEPROM Image is \n" + g._strEEFile)
        Show(BTN_EEP_DIR_WRITE2DEVICE)
    else:
        retval = MessageBox.Show("Do you want to\nclear the filename (yes)\nor\nkeep it (no)?", "EEPROM Write File Name", MessageBoxButtons.YesNo, MessageBoxIcon.Question)
        if retval == DialogResult.Yes:
            g._strEEFile = ""
            Hide(BTN_EEP_DIR_WRITE2DEVICE)
        else:
            MessageBox.Show("EEPROM File Name as before:\n" + g._strEEFile)
    EEFILE_Info.sValue = Path.GetFileNameWithoutExtension(g._strEEFile)
    pass
def reg2ee(iPage=0,bClear=False):
    '''Register map is converted to EEPROM image format and saved into the device INI in the EEIMAGE section. Another text file copy is written, too.'''
    #Convert Registermap to EEPROM IMAGE
    #Get BitField List
    #Create binary string
    #Loop Bitfields
    #Update saved BitField values FOR LATER
    #Concatenate to binary string
    #Loop through image
    #cut and convert to value
    lEE_Keys = INIContents.ReadKeys("EEPROM_EETYPE_DEFINITION")
    EEPROMImageKeys = INIContents.ReadKeys("EEPROM_IMAGE")
    strIMAGE = ""
    if bClear:
        eeimageiniclear()
    #build temp file name
    strFile = "reg2ee" + ".txt"
    strDir = Path.GetDirectoryName(__file__)
    strFullPath = Path.Combine(strDir, strFile)
    #concatenate bitfield binary string
    for i in range(0,len(lEE_Keys)):
        if  re.match('^EETYPE-(BASE|PAGEZERO)_IDX[0-9][0-9]*',lEE_Keys[i]):
            strBF = INIContents.ReadValue("EEPROM_EETYPE_DEFINITION",lEE_Keys[i])
            if strBF[0:7] == "PADDING":
                iPadLen = int(strBF[8:len(strBF)])
                strFMT = "{:#0" + str(2+iPadLen) + "b}"
                strTMP = strFMT.format(0)
            else:
                strFMT = "{:#0" + str(2+int(ReadFieldLength(strBF))) + "b}"
                strTMP = strFMT.format(int(ReadFieldValue(strBF)))
            dbg2txt('reg2ee\ti\tbits\tbitfield\teekey\t' + str(i) + '\t'+str(strTMP[2:])+ '\t'+str(strBF) + '\t' + lEE_Keys[i])
            strIMAGE = strIMAGE + strTMP[2:]
    dbg2txt('reg2ee\tfullimage\t' + strIMAGE)
    fh = open(strFullPath,"w")
    fh.write("image length=" + str(len(strIMAGE)) +"\n" + strIMAGE +"\n")
    fh.close()
    liEE = []
    #init image
    for i in range(0,64):
        liEE.append(0)
    # regmap -> base + one page
    if len(strIMAGE) == 608:
        j=0
        #base page
        for i in range(11,-1,-1):
            fh = open(strFullPath,"a")
            fh.write('{:#02d}'.format(i) + '\t' + '{:#06x}'.format(int(strIMAGE[j:j+16],2))+ '\t' + str(int(strIMAGE[j:j+16],2))+ '\n')
            fh.close()                
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2), str(int(strIMAGE[j:j+16],2)))
            j+=16
        #select which page
        if iPage==0:
            for i in range(37,11,-1):
                fh = open(strFullPath,"a")
                fh.write('{:#02d}'.format(i) + '\t' + '{:#06x}'.format(int(strIMAGE[j:j+16],2))+ '\t' + str(int(strIMAGE[j:j+16],2))+ '\n')
                fh.close()                
                if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                    INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2), str(int(strIMAGE[j:j+16],2)))
                j+=16
        else:
            for i in range(63,37,-1):
                fh = open(strFullPath,"a")
                fh.write('{:#02d}'.format(i) + '\t' + '{:#06x}'.format(int(strIMAGE[j:j+16],2))+ '\t' + str(int(strIMAGE[j:j+16],2))+ '\n')
                fh.close()                
                if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                    INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2), str(int(strIMAGE[j:j+16],2)))
                j+=16
    dbg2txt('reg2ee ' + str(len(liEE)) + ' '+ str(liEE))
    ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath)
    iCRC = jedec_crc16_ini()
    INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX63", str(iCRC))
    ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath)
def eeimageiniclear():
    for i in range(0,64):
        INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX%02d"%i, "0")
    ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath)



if __name__ == "__main__":
    print "TICS Pro CDCE6214 EXTRA Scripts"
