""" 
 * Copyright (C) 2018 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED 
"""



import sys

device_path = sys.path[-1]                          #[cust_path, eng_path][eng_mode]
exefile = device_path + r'\LMK05X18_ROM_Gen.exe'
matfile = device_path + r'\matlab_inputs_lmk05x18.m'
outfile = device_path + r'\romdump.txt'   # init only
outfile_old = device_path + r'\romdump_old.txt'
regmaskfile = device_path + r'\rom_regmask.txt'

# imports IronPython std libs
sys.path.insert(0, device_path + r'\ipy_stdlib.zip')    # sys.path.append(r"C:\Program Files (x86)\IronPython 2.7\Lib")


#import os; TICSPROBUG018 - Remove import os in _eeprom.py 
import time
import re
import math
import clr
#import datetime    # remove this, since included in _inputs_plls.py
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon,OpenFileDialog,SaveFileDialog
from INIParser import ConfigFileParser
from System import Array,Byte

from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon, OpenFileDialog, SaveFileDialog # https://msdn.microsoft.com/en-us/library/system.windows.forms.openfiledialog(v=vs.110).aspx
from collections import OrderedDict              # OrderedDict
from math import ceil, log  
from time import sleep,ctime

# This is "(1a) Commit Registers to GUI Map/SRAM PAGE"
def bREG2EE_Update():
    UpdateStatusBar("Committing Registers to SRAM and GUI Map...")
    copyreg2ee(0,int(0b11000),"BASEPAGE")          # Args: SRAM BASE idx = 0, SLAVEADR[7:3]=0b11000, SRAM partition name "BASE" 
    #copyreg2ee(REGCOMMIT_PG.iValue,int(0x00),"PAGE")   # Args: SRAM PAGE idx, SLAVEADR[7:3]=0b11000, SRAM partition name "PAGE" 
    updateEEPROMmtc()                       # update multitextbox 
    WriteParameter("REGCOMMIT",1)
    WriteParameter("REGCOMMIT",0)
    
    bCOMMIT_EXTRA_BYTES_TO_SRAM_Update()
    #UpdateStatusBar("Registers committed!  Ready to Program EEPROM or Export GUI Map.")
    UpdateStatusBar("Registers & extra bytes committed!  Ready to Program EEPROM.")

# Button script: "(2) Write All SRAM with GUI Map"
def bCOPYEEMAP_Update():
    copyeemap(int(0xAC),"A9:AA")        # Integer value of RAMDAT register (0xAC), MEMADR_BY[1:0] (0xA9:0xAA) 
    pass

# Button script: "(3) Program EEPROM from SRAM"
def bPROGRAMEEPROM_Update():
    UpdateStatusBar("Programming EEPROM from SRAM...")
    WriteParameter("NVMUNLK",int(0xEA))     # Write 0xEA to Unlock NVM 
    WriteAddressData(157,3)                 #WriteParameter("NVM_ERASE_PROG",3)      # Set NVMPROG/NVMERASE bits to Execute NVM Erase/Programming cycles
    WriteParameter("NVMUNLK",0)             # Write 0x0 to Lock NVM
    WriteAddressData(157,0)                 #WriteParameter("NVM_ERASE_PROG",0)      # Clear NVMPROG/NVMERASE
    #nvmcount = int(ReadParameter("NVMCNT")) + 1
    UpdateStatusBar("EEPROM programmed!")   #UpdateStatusBar("EEPROM programmed!  %d out of 100 cycles programmed." % nvmcount)

    
    
# Button script: "Read All EEPROM to GUI Map"
def bREADBACKEEPROM_Update():
    readmemspace("EEPROM Data Read from Device",398,int(0x98),"96:97")  # Number of rows for EEPROM read, integer value of NVMDAT register addr (0x98, MEMADR_BY[1:0] (0x96:0x97) 
    pass

# Button script: "Read All SRAM to GUI Map"
def bREADBACKSRAM_Update():
    readmemspace("SRAM Data Read from Device",398,int(0x99),"96:97")    # Number of rows for SRAM read, integer value of RAMDAT register addr (0x99), MEMADR_BY[1:0] (0x96:0x97) 
    pass

# Button script: "Read All ROM to GUI Map"
def bREADBACKROM_Update():
    readmemspace("ROM Data Read from Device",398,int(0x9A),"96:97")     # Number of rows for ROM read, integer value of ROMDAT register addr (0x9A), MEMADR_BY[1:0] (0x96:0x97) 
    pass

# Button script: "Export GUI Map to EEPROM File"
def bEXPORTEEPROMFILE_Update():
    bREG2EE_Update()        # Added 2018-06-07.  Was removed, added back in 2019-05-13
    export_eeprom_file(tc_DESIGNNAME, mtc_USERNOTES)
    pass

# Button script: "(1b) Import EEPROM File to GUI Map"
def bIMPORTEEPROMFILE_Update():
    import_eeprom_file()
    pass

def bREAD_ADC_Update():
    ADCCurrent =  getADCcurrent()
    ADC0 = float(ADCCurrent[0])
    ADC1 = float(ADCCurrent[1])
    IDD_ADC0.dValue = round((ADC0/4095.0)*1100,1)       # Idd measurement in mA, where I = (ADC_code / 4095.0) * 3.3V / (Gain_U2A_U7 * Rshunt * Gain_INA214B), Gain_U7=2V/V (in U2A module), Rshunt=0.015ohm and Gain_INA214B=100V/V (on EVM)
    IDDO_ADC1.dValue = round((ADC1/4095.0)*1100,1)      # Iddo measurement in mA, where I = (ADC_code / 4095.0) * 3.3V / (Gain_U2A_U7 * Rshunt * Gain_INA214B), Gain_U7=2V/V (in U2A module), Rshunt=0.015ohm and Gain_INA214B=100V/V (on EVM)
    IDD_TOTAL.dValue = IDD_ADC0.dValue + IDDO_ADC1.dValue
            
# ================================================ VBA Utilities ====================================================

def getADCcurrent():
    Data = Array[Byte]([0,0,0,0,0,0,0,0,0,0,0,0])

    #Data = Array(12)
    ADCCurrent = [0,0]    
    ret = communicationInterface.FindADCCurrent(Data)
    
    Data = ret[1]

    ADCCurrent[0] = Data[1] * 256 + Data[2]
    ADCCurrent[1] = Data[3] * 256 + Data[4]
    return ADCCurrent

def copyreg2ee(arg1,arg2,strArg1): 
    UpdateStatusBar("")

    pulledField =""
    bankPos = arg1

    EEPROMDefinitionKeys = INIContents.ReadKeys("EEPROM_EETYPE_DEFINITION")
    i = 0
    
    missing_fields = []

    while True:
        if "EETYPE-" + strArg1 + "_IDX" + str(i).zfill(2) in EEPROMDefinitionKeys:
            pulledField = INIContents.ReadValue("EEPROM_EETYPE_DEFINITION", "EETYPE-" + strArg1 + "_IDX" + str(i).zfill(2))
        else:
            pulledField = ""
        # UpdateStatusBar('i {}, pulledField {}, arg1 {}, arg2 {}, strArg1 {}'.format(i, pulledField, arg1, arg2, strArg1))
        
        if pulledField[0:7] == "PADDING":
            INIContents.IncludeValue("EEPROM_DATA", "EETYPE-" + strArg1 + "_BANK" + str(bankPos).zfill(1) + "_IDX" + str(i).zfill(2) + "_" + pulledField, "0")
            """
            elif pulledField[0:4].upper() == "FLEX:":
                UpdateStatusBar("Match FLEX:")
                m = re.search(pulledField, ":([0-9]+):(.+)").groups()
                pulledLength = int(m[0])
                pulledFlexField = m[1]
                val = GetText(pulledFlexField)
                UpdateStatusBar("Read {} for {} in {}.".format(val, pulledFlexField, pulledField))
                if val != "-1":
                    INIContents.IncludeValue("EEPROM_DATA", "EETYPE-" + strArg1 + "_BANK" + str(bankPos).zfill(1) + "_IDX" + str(i).zfill(2) + "_" + pulledFlexField, val)
                else:
                    missing_fields.append(pulledField)
                    #MessageBox.Show("Missing Field "+pulledField+" in copyreg2ee")
            """
        elif pulledField != "" :
            val = str(ReadFieldValue(pulledField))
            if val != "-1":
                INIContents.IncludeValue("EEPROM_DATA", "EETYPE-" + strArg1 + "_BANK" + str(bankPos).zfill(1) + "_IDX" + str(i).zfill(2) + "_" + pulledField, val)
            else:
                missing_fields.append(pulledField)
                #MessageBox.Show("Missing Field "+pulledField+" in copyreg2ee")
        else:
            break
        i = i + 1




        #print str(pulledField)
    ### 8-31: Commented out... causing long GUI delays ### ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath)
    pass
    if missing_fields:
        """
        f1 = open(r"c:\t\missing_fields.txt", "w")
        for m in missing_fields:
            if m:
                f1.write(m.strip() + "\n")
        f1.close()
        """
        MessageBox.Show("Missing Field "+"\n".join(missing_fields)+" in copyreg2ee")
        

def copyeemap(iVal,strVal):
    i = 0
    sramData = 0
    dataLength = 0
    rowCount = 0
    outputStr = ""
    fa = mtc_EEPROMdump.sValue
    
    programminglocations = strVal.split(":")            #  parsed in argument
    
    EEPROMImageKeys  = INIContents.ReadKeys("EEPROM_IMAGE")

    if not "COUNT" in EEPROMImageKeys:
        MessageBox.Show("Aborted.  EEPROM Data does not exist in INI file yet.")
        return

    nBytes = int(INIContents.ReadValue("EEPROM_IMAGE", "COUNT"))
        
    dataLength = 8
    
    date_time = str(time.asctime( time.localtime(time.time()) ))
    
    #outputStr = "# ==============================================================" + g.vbCrLf
    outputStr = "# " + date_time + g.vbCrLf
    outputStr = outputStr + "# GUI Map Data Copied to SRAM" + g.vbCrLf + "#" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
    progMask =int(math.pow(2,dataLength)) - 1
        
    nBytes_array = [None] * (nBytes + 2)
    
    for rowCount in range(0,nBytes):
        if "EEPROM_IMG_IDX" + str(rowCount).zfill(2)  in EEPROMImageKeys:
            sramData = INIContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(rowCount).zfill(2))
        else:
            sramData ="-1"

        print ("EEMAP CPY: " + str(int(rowCount / math.pow(math.pow(2,dataLength), (len(programminglocations) - 0))) & progMask) + ":" + str(str(int(rowCount / math.pow(math.pow(2,dataLength),(len(programminglocations) - 1))) & progMask)) + "  =  " + str(sramData))

        for i in range(0,len(programminglocations)):
            regAddress = "0x" + programminglocations[i]
            #TICSPROBUG038 - The value calculation fix - Write GUI Map -> SRAM (or) Program EEPROM <- SRAM doesnot work properly
            regValue = format(int(rowCount / (math.pow(math.pow(2, dataLength), (len(programminglocations)-1 - i)))) & progMask,'02X')
            regData = int(regAddress + regValue,16)
            ret = communicationInterface.WriteRegisterByte(regData) #  Shift rowCount down then mask
            
        # write to ramdat
        ret = communicationInterface.WriteRegisterByte(int(hex(iVal) +format(int(sramData),'02X'),16))

        tempStr = str(format(rowCount,'02X')).zfill(4).upper()
        lenTempStr = len(tempStr)
        tempStrSram = str(format(int(sramData),'02X')).replace("L","").zfill(1).upper()
        lenTempStrSram = len(tempStrSram)
      
        outputStr = outputStr + "" + g.vbTab +tempStr[lenTempStr-4:lenTempStr][0:2] + g.vbTab + tempStr[lenTempStr-4:lenTempStr][2:4]+ g.vbTab + tempStrSram[lenTempStrSram-2:lenTempStrSram]+ g.vbTab + "" + str(rowCount) + g.vbCrLf
        nBytes_array[rowCount + 1] = int(sramData)
        
        if 0 == (rowCount % 40) :
            UpdateStatusBar("Copying GUI Map to SRAM... " + str(int(round(float(rowCount) / float(int(nBytes) - 1) * 100.0))) + "%")
    
    UpdateStatusBar("GUI Map copied to SRAM!  Ready to Program EEPROM or Export GUI Map.")
    mtc_EEPROMdump.sValue = outputStr
    pass

def readmemspace(strLocation,R1,R2,MLSB):
    ret = 0
    readback_name = ""

    outputStr = ""
    
    readback_name = strLocation
    ret = 0
    nBytes = R1
    
    dataLength = 8
    
    #UpdateStatusBar(readback_name + "...")
    date_time = str(time.asctime( time.localtime(time.time()) ))
    
    #outputStr = "# ==============================================================" + g.vbCrLf
    outputStr = "# " + date_time + g.vbCrLf
    outputStr = outputStr + "# " + readback_name + g.vbCrLf + "#" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
    date_time = str(time.asctime( time.localtime(time.time()) ))
    
    programminglocations = MLSB.split(":") #  parsed in argument; My understanding is MSB:LSB for row write.; so programminglocations(0) = MSB.
    progMask = int(math.pow(2,dataLength)) - 1
     
    for rowCount in range(0,nBytes): #  from 0 to n byte (MSB to LSB)
        
    #''''''''''''''' Comment out the below to rely on auto inc.
        for i in range(0 ,len(programminglocations)):
            regAddress = "0x" + programminglocations[i]
            regValue = format((int(rowCount / (math.pow((math.pow(2,dataLength)), (len(programminglocations)-1 - i)))) & progMask),'02X');
            regData = int(regAddress + regValue,16)
            ret = communicationInterface.WriteRegisterByte(regData)   #  Shift rowCount down then mask
        
        # read from desired memory space
        ret = communicationInterface.ReadRegisterByte(int(hex(R2)+"00",16))
        #UpdateStatusBar("communicationInterface ReadRegister ret_str = " + str(ret))   ###TESTING on 9/2

        if (ret[0]!="") :
            UpdateStatusBar("USB Communication Error, " + str(ret[0]))
            MessageBox.Show("USB Communication Error, " + str(ret[0]))
            return

        tempStr = str(hex(rowCount)[2:len(hex(rowCount))]).zfill(4).upper()
        lenTempStr = len(tempStr)
        tempStrRet = str(hex(ret[1])[2:len(hex(ret[1]))]).replace("L","").zfill(4).upper()
        lentempStrRet = len(tempStrRet)
        
        outputStr = outputStr + "" + g.vbTab +tempStr[lenTempStr-4:lenTempStr][0:2] + g.vbTab + tempStr[lenTempStr-4:lenTempStr][2:4] + g.vbTab + tempStrRet[lentempStrRet-2:lentempStrRet]+ g.vbTab + "" + str(rowCount) + g.vbCrLf
        
        if ((("SRAM" in readback_name) or ("EEPROM" in readback_name)) and nBytes == int(INIContents.ReadValue("EEPROM_IMAGE", "COUNT"))):
            INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(rowCount).zfill(2) ,str(int(hex(ret[1])[4:6],16)))
        
        if 0 == (rowCount % 40):
            UpdateStatusBar(readback_name + "... " + str(int(round(float(rowCount) / float(int(nBytes) - 1) * 100.0))) + "%")
    
    
    if (("SRAM" in readback_name) or ("EEPROM" in readback_name)) and nBytes == int(INIContents.ReadValue("EEPROM_IMAGE", "COUNT")):
        write_EEPROM_IMAGE_to_EEPROM_DATA()
            
    
    UpdateStatusBar(readback_name + "... Done!")
    
    mtc_EEPROMdump.sValue = outputStr
    ### 8-31: Commented out... causing long GUI delays ### ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath);
    pass

def updateEEPROMmtc():
    typeSearch = ""
    typePosition = ""
    positionSearch =""
    pulledField =""
    pulledValue = 0
    pulledLength = 0
    sramData = 0
    
    pagestring = str(REGCOMMIT_PG.iValue)
    
    dataLength = 8
    # if Part.ifACE = "I2C" : dataLength = dataLength - 1
    eemap = [None]* dataLength
    rowCount = 0
    colCount = 0
    i = 0
    idx = 0
    EEPROMPARTTABLEKeys = INIContents.ReadKeys("EEPROM_PART_TABLE")
    EEPROMEETYPEDEFINITIONKeys = INIContents.ReadKeys("EEPROM_EETYPE_DEFINITION")
    EEPROMDATAKeys = INIContents.ReadKeys("EEPROM_DATA")
    EEPROMIMAGEKeys = INIContents.ReadKeys("EEPROM_IMAGE")
    
    gd_keys = globals().keys()
    globals()['orderadded'] = ""
    globals()['bitsout'] = ""

    while True:
        if "TYPE" + str(i).zfill(2) in EEPROMPARTTABLEKeys:
            typeSearch = INIContents.ReadValue( "EEPROM_PART_TABLE", "TYPE" + str(i).zfill(2)) # returns BASE or PAGE for now
        else:
            typeSearch = ""

        if "POSITION" + str(i).zfill(2) in EEPROMPARTTABLEKeys:
            positionSearch = INIContents.ReadValue( "EEPROM_PART_TABLE", "POSITION" + str(i).zfill(2)) # returns 1, 2, etc
        else:
            positionSearch = ""
        
        if (typeSearch != "" and positionSearch != "") : # make sure we haven't exhausted our choices here
            idx = 0 # idx number reset
            while True:
                #  Get the field name at this index from the EETYPE definition. TT
                if "EETYPE-" + typeSearch + "_IDX" + str(idx).zfill(2) in EEPROMEETYPEDEFINITIONKeys:
                    pulledField = INIContents.ReadValue( "EEPROM_EETYPE_DEFINITION", "EETYPE-" + typeSearch + "_IDX" + str(idx).zfill(2)) # field name
                else:
                    pulledField = ""
                 
                if pulledField[0:7] == "PADDING":
                    pulledValue = 0
                    pulledLength = int(pulledField[8:len(pulledField)]) # parse number of bits to pad with
                    """
                    if pulledField[0:4] == "FLEX:":
                        pulledValue = 0
                        m = re.search(pulledField, ":([0-9]+):(.+)").groups()
                        pulledLength = int(m[0])
                        pulledFlexField = m[1]
                        pulledValue = int(GetText(pulledFlexField))  # TT TODO: Error checking here.
                    """
                elif pulledField != "" : # Read from the EEPROM_DATA map so that we can create the EEPROM_IMAGE with this newly pulledValue and Length. TT
                    if "EETYPE-" + typeSearch + "_BANK" + positionSearch + "_IDX" + str(idx).zfill(2) + "_" + pulledField in EEPROMDATAKeys:
                        pulledValue = int(INIContents.ReadValue( "EEPROM_DATA", "EETYPE-" + typeSearch + "_BANK" + positionSearch + "_IDX" + str(idx).zfill(2) + "_" + pulledField))
                    else:
                        pulledValue = ""

                    #UpdateStatusBar("Pulled Field = >{}<".format(pulledField))
                    try:
                        fieldLength = ReadFieldLength(pulledField)
                    except:
                        UpdateStatusBar("Failed to read field length of {}".format(pulledField))
                        raise
                        
                    if fieldLength!=0:
                        pulledLength = fieldLength 

                    if pulledField == "SLAVEADR_GPIO1_SW" or pulledField == "SLAVEADR" :
                        pulledLength = 5
                        
                else:
                    break


                globals()['orderadded'] += str([pulledField, pulledLength]) + '\n'
                    
                # Do the magic of sticking bits into the EEPROM image.... 1 bit at a time. TT
                for  onBit in range(pulledLength,0,-1) : # count the current bit we are on of field
                    MSBmask = int(math.pow(2, (onBit - 1))) # make a mask
                    if (pulledValue & MSBmask) > 0 :
                        eemap[colCount] = 1
                        globals()['bitsout'] += "1"
                    else:
                        eemap[colCount] = 0
                        globals()['bitsout'] += "0"
                    
                    colCount = colCount + 1 # next col
                    
                    if colCount > dataLength - 1 :
                        globals()['bitsout'] += "\n"
                        sramData = 0
                        for colCount in range(0,dataLength):
                            sramData = sramData * 2 + eemap[colCount]
                        INIContents.IncludeValue( "EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(rowCount).zfill(2), str(sramData))
                        rowCount = rowCount + 1
                        colCount = 0
                
                idx = idx + 1 # next IDX
        else:
            INIContents.IncludeValue( "EEPROM_IMAGE", "COUNT", str(rowCount))
            break
                
        i = i + 1 # next item in part table
        
        
    

    date_time = str(time.asctime( time.localtime(time.time()) ))
    
    idx = 0
    j = 0
    startPoint = 0
    outputStr = ""
    #outputStr = "# ==============================================================" + g.vbCrLf
    outputStr = "# " + date_time + g.vbCrLf
    outputStr = outputStr + "# Registers Committed to SRAM and GUI Map: Base and Page " + pagestring + g.vbCrLf + "#" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
    outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
    while True :
        if "TYPE" + str(idx).zfill(2) in EEPROMPARTTABLEKeys:
            typeSearch = INIContents.ReadValue( "EEPROM_PART_TABLE", "TYPE" + str(idx).zfill(2)) # returns BASE or PAGE for now
        else:
            typeSearch = ""

        if "POSITION" + str(idx).zfill(2) in EEPROMPARTTABLEKeys:
            typePosition = INIContents.ReadValue( "EEPROM_PART_TABLE", "POSITION" + str(idx).zfill(2))
        else:
            typePosition = ""
        
        if (typeSearch != "" and typePosition != "") :   # make sure we haven't exhausted our choices here
            if "LENGTH" + str(idx).zfill(2) in EEPROMPARTTABLEKeys:
                typeLength = int(INIContents.ReadValue( "EEPROM_PART_TABLE", "LENGTH" + str(idx).zfill(2)))
            else:
                typeLength = 42

            outputStr = outputStr + "# EEPROM " + typeSearch + " " + typePosition + g.vbCrLf
            for j in range(startPoint,startPoint + typeLength):
                if j == startPoint :
                    print (typeSearch + typePosition + " starts at " + str(startPoint))
                    
                tempStr = str(format(j,'02X')).zfill(4).upper()
                lenTempStr = len(tempStr)
                tempVal = 0

                if "EEPROM_IMG_IDX" + str(j).zfill(2) in EEPROMIMAGEKeys:
                    tempVal = int(INIContents.ReadValue( "EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(j).zfill(2)))

                tempStrRet = str(format(tempVal,'02X')).replace("L","").zfill(1).upper()
                lentempStrRet = len(tempStrRet)

                outputStr = outputStr + "" + g.vbTab + tempStr[lenTempStr-4:lenTempStr][0:2]  + g.vbTab + tempStr[lenTempStr-4:lenTempStr][2:4] + g.vbTab + tempStrRet[lentempStrRet-2:lentempStrRet]+ g.vbTab + "" + str(j) + g.vbCrLf
            startPoint = j+1
        else:
            break
        
        idx = idx + 1


    # Add Extra EEPROM bytes...
    outputStr += "\n--== Set by Extra EEPROM Bytes ==--\n"
    gd = globals()
    for addr in [10, 11, 249, 250, 251, 252]:
        dowrite = True
        try:
            if globals()["cbWrite_ADR{}".format(addr)].iValue == 0:
                dowrite = False
        except:
            pass
        
        if dowrite:
            val = get_string_to_int("ADDR_%d" % addr)
            if (val == None):
                UpdateStatusBar("Value of address %d is invalid, setting to 0" % addr)
                gd["ADDR_%d" % addr].sValue = "0"
                val = 0
            else:
                UpdateStatusBar("Get value of %d" % val)
        
            j += 1
            outputStr = outputStr + g.vbTab + "%02X" % ((addr >> 256)&0xff) + g.vbTab + "%02X" % (addr&0xff) + g.vbTab + ("%02X" % val) + g.vbTab + "" + str(j) + g.vbCrLf
        
        
    mtc_EEPROMdump.sValue = outputStr
    ### 8-31: Commented out... causing long GUI delays ### ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath)
    pass

def write_EEPROM_IMAGE_to_EEPROM_DATA():
    pulledLength = 0
    eeprom_image_data_in =0
    new_field_data = 0

    pagestring = REGCOMMIT_PG.sValue
    
    startPoint = 0
    
    dataLength = 8
    eemap = [None]* dataLength

    idx = 0
    rowCount = 0
    colCount = 0
    idx_eeprom_table = 0
    eemap_bits_to_read = 0

    typeSearch = ""
    positionSearch = ""
    typePosition = ""
    pulledField = ""

    EEPROMPARTTABLEKeys = INIContents.ReadKeys("EEPROM_PART_TABLE")
    EEPROMEETYPEDEFINITIONKeys =  INIContents.ReadKeys("EEPROM_EETYPE_DEFINITION")
    EEPROMIMAGEKeys = INIContents.ReadKeys("EEPROM_IMAGE")
    
    #  TT: For every entry in the EEPROM_PART_TYPE, which defines what EEPROM type and position for the entire EEPROM structure...
    while True:
        typeSearch = ""
        positionSearch = ""
        if "TYPE" + str(idx_eeprom_table).zfill(2) in EEPROMPARTTABLEKeys:
            typeSearch = INIContents.ReadValue( "EEPROM_PART_TABLE", "TYPE" + str(idx_eeprom_table).zfill(2)) # returns BASE or PAGE for now
        if "POSITION" + str(idx_eeprom_table).zfill(2) in EEPROMPARTTABLEKeys:
            positionSearch = INIContents.ReadValue( "EEPROM_PART_TABLE", "POSITION" + str(idx_eeprom_table).zfill(2)) # returns 1, 2, etc
        
        if (typeSearch != "" and positionSearch != "") : # make sure we haven't exhausted our choices here
            idx = 0 # idx number reset
            
            #  For every line in this part of EEPROM defined by typeSearch and positionSearch
            while True:
                #  Get the field name at this index from the EETYPE definition. TT.  Need to get this info from the EEMAP.
                pulledField = ""
                if "EETYPE-" + typeSearch + "_IDX" + str(idx).zfill(2) in EEPROMEETYPEDEFINITIONKeys:
                    pulledField = INIContents.ReadValue( "EEPROM_EETYPE_DEFINITION", "EETYPE-" + typeSearch + "_IDX" + str(idx).zfill(2)) # field name
                new_field_data = 0
                 
                if pulledField[0:7] == "PADDING" :
                    pulledLength =  int(pulledField[8:len(pulledField)]) #  parse number of bits to pad with
                elif pulledField != "" : #  Read from the EEPROM_DATA map so that we can create the EEPROM_IMAGE with this newly pulledValue and Length. TT
                    #if 1 = CheckFieldExists(pulledField, "write_EEPROM_IMAGE_to_EEPROM_DATA") :
                        #pulledLength = Part.PrgmBits(pulledField).Length

                    try:
                        fieldLength = ReadFieldLength(pulledField)
                    except:
                        UpdateStatusBar("Failed to read field length of".format(pulledField))
                        raise
                        
                    if fieldLength!=0:
                        pulledLength = fieldLength 

                    if pulledField == "SLAVEADR_GPIO1_SW" :
                        pulledLength = 5
                else:
                    break
                
                #  Do the magic of pulling bits from the EEPROM image.... 1 bit at a time into the EEPROM_DATA. TT
                for onBit in range(pulledLength, 0, -1): # count the current bit we are on of field
                    if (0 == eemap_bits_to_read) :
                        # Get more eemap_bits_to_read
                        if not "EEPROM_IMG_IDX" + str(rowCount).zfill(2) in EEPROMIMAGEKeys:
                            MessageBox.Show("Error updating EEPROM_DATA from EEPROM_IMAGE")
                            return
                        else:
                            eeprom_image_data_in = INIContents.ReadValue( "EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(rowCount).zfill(2))

                        rowCount = rowCount + 1
                        #  eeprom_image_data_in now contains the next set of bits
                        for colCount in range(0,dataLength):
                            eemap[colCount] = int(eeprom_image_data_in) & 1
                            # Debug.Print eemap(colCount) & "  " & eeprom_image_data_in
                            eeprom_image_data_in = int(eeprom_image_data_in) / 2
                        
                        eemap_bits_to_read = dataLength                   
                    
                    if 1 == eemap[eemap_bits_to_read - 1] :
                        new_field_data = new_field_data + int(math.pow(2, (onBit - 1)))

                    eemap_bits_to_read = eemap_bits_to_read - 1                

                tempStr = "                        " + pulledField
                lenTempStr = len(tempStr)
                tempStr1 = "   " + str(pulledLength)
                lenTempStr1 = len(tempStr1)
                tempStr2 = "    " + str(new_field_data)
                lenTempStr2 = len(tempStr2)
                
                print ("Saving...  " +tempStr[lenTempStr-20:lenTempStr] + ", of length = " +tempStr1[lenTempStr1-3:lenTempStr1] + ", with value = " +tempStr2[lenTempStr2-4:lenTempStr2]+ ".  eemap_bits_to_read=" + str(eemap_bits_to_read))
                #if 1 == frmPart.debug_log :
                    #Open "log.txt" For Append As #1
                    #Print #1, "Saving...  " & right("                        " & pulledField, 20) & ", of length = " & right("   " & CStr(pulledLength), 3) & ", with value = " & right("    " & new_field_data, 4) & ".  eemap_bits_to_read=" & eemap_bits_to_read
                    #Close #1

                if pulledField[0:7] != "PADDING" :
                    INIContents.IncludeValue( "EEPROM_DATA", "EETYPE-" + typeSearch + "_BANK" + positionSearch + "_IDX" + str(idx).zfill(2) + "_" + pulledField, str(new_field_data))
                else:
                    print ("padding.  eemap_bits_to_read = ", eemap_bits_to_read)

                idx = idx + 1 # next IDX
        else:
            return
                
        idx_eeprom_table = idx_eeprom_table + 1  # next item in part table

    pass

def import_eeprom_file():
    EEPROMImageKeys = INIContents.ReadKeys("EEPROM_IMAGE")
    
    dialog = OpenFileDialog()
    dialog.Filter = "All Files (*.*)|*.*|EEPROM Files (*.epr)|*.epr"
    dialog.FilterIndex = 2
    dialog.Title = "Import EEPROM File"

    if dialog.ShowDialog() == DialogResult.OK:
        print ("Reading " + dialog.FileName)
        UpdateStatusBar("Importing EEPROM file: %s" % dialog.FileName)

        EEPROMImportFileContents = ConfigFileParser.ReadConfiguration(dialog.FileName)

        nBytes = -1
        if "COUNT" in EEPROMImageKeys:
            nBytes = int(EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "COUNT"))
        
        date_time = ""
        date_time = EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "DATE_TIME")

        if nBytes == -1:            # or nBytes != EEPROMImageCount: # comment-out EEPROMImageCount is redundant to nBytes
            UpdateStatusBar("Error importing EEPROM File")
            MessageBox.Show("Error importing EEPROM File")
            return
        
        #outputStr = "# ==============================================================" + g.vbCrLf
        #outputStr = outputStr + "# " + "Loaded " + frmPart.objComDialog.filename + "to GUI Map" + vbCrLf + "#" + vbCrLf
        outputStr = "# " + "EEPROM file originally exported: " + date_time + g.vbCrLf
        outputStr = outputStr + "# " + "Restored to GUI Map from: " + dialog.FileName + g.vbCrLf + "#" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
    
        for i in range(0, nBytes):
            Data = "-1"
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                Data = EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2))

            INIContents.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2), Data)

            tempStr = str(hex(i)[2:len(hex(i))]).zfill(4).upper()
            lenTempStr = len(tempStr)
            tempStr1 = ""
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                tempStr1 = EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2))
            
            tempStr1 = hex(int(tempStr1))[2:len(hex(int(tempStr1)))].replace("L","").zfill(4).upper()

            lentempStr1 = len(tempStr1)

            outputStr = outputStr + "" + g.vbTab +str(tempStr)[lenTempStr-4:lenTempStr][0:2] + g.vbTab + str(tempStr)[lenTempStr-4:lenTempStr][2:4] + g.vbTab + str(tempStr1)[lentempStr1-2:lentempStr1] + g.vbTab + "" + str(i) + g.vbCrLf
        
        temptcDESIGNNAME = ""
        if "DESIGN_NAME" in "EEPROM_IMAGE":
            temptcDESIGNNAME = EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "DESIGN_NAME", "")
        tc_DESIGNNAME.sValue =  temptcDESIGNNAME

        tempmtc_USERNOTES = ""
        if "USER_NOTES" in "EEPROM_IMAGE":
            tempmtc_USERNOTES = EEPROMImportFileContents.ReadValue("EEPROM_IMAGE", "USER_NOTES")
        mtc_USERNOTES.sValue = tempmtc_USERNOTES
    
        write_EEPROM_IMAGE_to_EEPROM_DATA()
    
        mtc_EEPROMdump.sValue = outputStr
        ### 8-31: Commented out... causing long GUI delays ### ConfigFileParser.WriteConfiguration(INIContents,INIContents.currentINIFilePath);
        UpdateStatusBar("Imported EEPROM file: " + dialog.FileName)
    pass

def export_eeprom_file(tc_DESIGNNAME,mtc_USERNOTES):
    dialog = SaveFileDialog()
    dialog.Filter = "All Files (*.*)|*.*|EEPROM Files (*.epr)|*.epr"
    dialog.FilterIndex = 2
    dialog.Title = "Export EEPROM File"

    if dialog.ShowDialog() == DialogResult.OK:   
        print ("Writing " + dialog.FileName)
        UpdateStatusBar("Exporting EEPROM file: %s" % dialog.FileName)
        date_time = datetime.strftime(datetime.now(), '%Y-%m-%d, %H:%M:%S')
    
        nBytes = -1

        EEPROMImageKeys = INIContents.ReadKeys("EEPROM_IMAGE")

        if "COUNT" in EEPROMImageKeys:
            nBytes = int(INIContents.ReadValue("EEPROM_IMAGE", "COUNT"))
        if nBytes == -1 :
            UpdateStatusBar("Error exporting EEPROM File")
            MessageBox.Show("Error exporting EEPROM File")
            return    
    
        #outputStr = "# ==============================================================" + g.vbCrLf
        outputStr = "# " + date_time + g.vbCrLf
        outputStr = outputStr + "# " + "Exported GUI Map to: " + dialog.FileName + g.vbCrLf + "#" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
        exportFile =  ConfigFileParser()

        exportFile.IncludeSection("EEPROM_IMAGE")

        exportFile.IncludeValue("EEPROM_IMAGE","COUNT",str(nBytes))
        exportFile.IncludeValue("EEPROM_IMAGE","DATE_TIME",date_time)
        exportFile.IncludeValue("EEPROM_IMAGE","DESIGN_NAME",tc_DESIGNNAME.sValue)

        print (mtc_USERNOTES.sValue)
        
        exportFile.IncludeValue("EEPROM_IMAGE", "USER_NOTES", mtc_USERNOTES.sValue)
        for i in range(0,nBytes):
            Data = "-1"
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                Data = INIContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" +  str(i).zfill(2))
            exportFile.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" +str(i).zfill(2), Data)
            strOfI = "0000" + format(i,'0X')
            tempStrOfI = strOfI[len(strOfI)-4:len(strOfI)]
            outputStr = outputStr + "" + g.vbTab + tempStrOfI[0:2] + g.vbTab
            outputStr = outputStr + tempStrOfI[len(tempStrOfI)-2:len(tempStrOfI)] + g.vbTab
            imgIdx = ""
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                imgIdx = INIContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2)) 
                temp = "0" + format(int(imgIdx),'0X')
                outputStr = outputStr + temp[len(temp)-2:len(temp)]
            outputStr = outputStr + g.vbTab + "" + str(i) + g.vbCrLf
        
        
        exportFile.IncludeSection("META")
        exportFile.IncludeValue("META", "DEVICE", "LMK05318")
        exportFile.IncludeValue("META", "DATA", "SRAM")
        exportFile.IncludeValue("META", "WORD_SIZE_BITS", "24")
        exportFile.IncludeValue("META", "RAMDAT_ADDR", "R162[7:0]")
        exportFile.IncludeValue("META", "MEMDAT_ADDR", "R159[4:0], R159[7:0]")
        exportFile.IncludeValue("META", "PART_ID_ADDR", "R3[7:0], R2[7:0]")
        exportFile.IncludeValue("META", "PART_ID_VALUE", "0x1135")
        
        
        
        mtc_EEPROMdump.sValue = outputStr
        ConfigFileParser.WriteConfiguration(exportFile, dialog.FileName);
        UpdateStatusBar("Exported EEPROM File: " + dialog.FileName)
    pass
    
    

def write_eeprom_file_to_sram(filename):
    dialog = OpenFileDialog()
    dialog.Filter = "All Files (*.*)|*.*|EEPROM Files (*.epr)|*.epr"
    dialog.FilterIndex = 2
    dialog.Title = "Export EEPROM File"

    if dialog.ShowDialog() == DialogResult.OK:   
        print ("Reading " + dialog.FileName)
        UpdateStatusBar("Exporting EEPROM file: %s" % dialog.FileName)
        date_time = datetime.strftime(datetime.now(), '%Y-%m-%d, %H:%M:%S')
    
        nBytes = -1

        EEPROMImageKeys = INIContents.ReadKeys("EEPROM_IMAGE")

        if "COUNT" in EEPROMImageKeys:
            nBytes = int(INIContents.ReadValue("EEPROM_IMAGE", "COUNT"))
        if nBytes == -1 :
            UpdateStatusBar("Error exporting EEPROM File")
            MessageBox.Show("Error exporting EEPROM File")
            return    
    
        #outputStr = "# ==============================================================" + g.vbCrLf
        outputStr = "# " + date_time + g.vbCrLf
        outputStr = outputStr + "# " + "Exported GUI Map to: " + dialog.FileName + g.vbCrLf + "#" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "HADR" + g.vbTab + "LADR" + g.vbTab + "DATA" + g.vbTab + "BYTE" + g.vbCrLf
        outputStr = outputStr + "#" + g.vbTab + "-------" + g.vbTab + "-------" + g.vbTab + "--------" + g.vbTab + "---------------" + g.vbCrLf
    
        exportFile =  ConfigFileParser()

        exportFile.IncludeSection("EEPROM_IMAGE")

        exportFile.IncludeValue("EEPROM_IMAGE","COUNT",str(nBytes))
        exportFile.IncludeValue("EEPROM_IMAGE","DATE_TIME",date_time)
        exportFile.IncludeValue("EEPROM_IMAGE","DESIGN_NAME",tc_DESIGNNAME.sValue)

        print (mtc_USERNOTES.sValue)
        
        exportFile.IncludeValue("EEPROM_IMAGE", "USER_NOTES", mtc_USERNOTES.sValue)
        for i in range(0,nBytes):
            Data = "-1"
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                Data = INIContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" +  str(i).zfill(2))
            exportFile.IncludeValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" +str(i).zfill(2), Data)
            strOfI = "0000" + format(i,'0X')
            tempStrOfI = strOfI[len(strOfI)-4:len(strOfI)]
            outputStr = outputStr + "" + g.vbTab + tempStrOfI[0:2] + g.vbTab
            outputStr = outputStr + tempStrOfI[len(tempStrOfI)-2:len(tempStrOfI)] + g.vbTab
            imgIdx = ""
            if "EEPROM_IMG_IDX" + str(i).zfill(2) in EEPROMImageKeys:
                imgIdx = INIContents.ReadValue("EEPROM_IMAGE", "EEPROM_IMG_IDX" + str(i).zfill(2)) 
                temp = "0" + format(int(imgIdx),'0X')
                outputStr = outputStr + temp[len(temp)-2:len(temp)]
            outputStr = outputStr + g.vbTab + "" + str(i) + g.vbCrLf
        
        mtc_EEPROMdump.sValue = outputStr
        ConfigFileParser.WriteConfiguration(exportFile,dialog.FileName);
        UpdateStatusBar("Exported EEPROM File: " + dialog.FileName)
    pass
    
    
def bUpdate_ExtraEEPROM_Bytes_Update():
    UpdateStatusBar("Reading extra EEPROM bytes from EEPROM")
    gd = globals()
    for addr in [10, 11, 249, 250, 251, 252]:
        MEMADR.iValue = addr; WriteParameter("MEMADR", MEMADR.iValue)
        val = ReadParameterAndUpdateUI("NVMDAT")
        gd["ADDR_%d" % addr].sValue = str(val)
    UpdateStatusBar("Read extra EEPROM bytes from EEPROM")
        
def get_string_to_int(control_name):
    gd = globals()
    value = gd[control_name].sValue
    try:
        if "0x" in value:
            value = value.replace("0x", "")
            value = int(value, 16)
        elif "0b" in value:
            value = value.replace("0b", "")
            value = int(value, 2)
        else:
            value = int(value)
    except:
        value = None
    return value

        
def bCOMMIT_EXTRA_BYTES_TO_SRAM_Update():
    gd = globals()
    
    if 1 == cbWrite_ADR10.iValue:
        addr = 10
        MEMADR.iValue = addr; WriteParameter("MEMADR", MEMADR.iValue)
        value = get_string_to_int("ADDR_%d" % addr)
        RAMDAT.iValue = value; WriteParameter("RAMDAT", RAMDAT.iValue)

    if 1 == cbWrite_ADR11.iValue:
        addr = 11
        MEMADR.iValue = addr; WriteParameter("MEMADR", MEMADR.iValue)
        value = get_string_to_int("ADDR_%d" % addr)
        RAMDAT.iValue = value; WriteParameter("RAMDAT", RAMDAT.iValue)
    
    for addr in [249, 250, 251, 252]:
        MEMADR.iValue = addr; WriteParameter("MEMADR", MEMADR.iValue)
        value = get_string_to_int("ADDR_%d" % addr)
        RAMDAT.iValue = value; WriteParameter("RAMDAT", RAMDAT.iValue)
        
    
    #UpdateStatusBar("Extra EEPROM bytes committed!  Ready to Program EEPROM.")

def ADDR_249_Update():
    SRAM_ADDR_doUpdate(249)
        
def ADDR_250_Update():
    SRAM_ADDR_doUpdate(250)
        
def ADDR_251_Update():
    SRAM_ADDR_doUpdate(251)
        
def ADDR_252_Update():
    SRAM_ADDR_doUpdate(252)
        
def SRAM_ADDR_doUpdate(addr):
    gd = globals()
    val = gd["ADDR_%d" % addr].sValue
    try:
        val = int(val)
    except:
        try:
            val = int(re.search("[0-9]+", val).group())
        except:
            val = 0
            
        gd["ADDR_%d" % addr].sValue = str(val)
    
    if val < 0:
        gd["ADDR_%d" % addr].sValue = "0"
    elif val > 255:
        gd["ADDR_%d" % addr].sValue = "255"
           
        
def bPROGRAMEEPROM2_Update():
    UpdateStatusBar("Programming EEPROM from SRAM...")
    WriteParameter("NVMBASEUNLK",int(81))     # Write 81 to Unlock Base NVM 
    
    #UpdateStatusBar("Scanning for I2C address...")
    slave_address = 0
    result = ScanDevices(slave_address);
    if (result[0] == ""):   
        statusMsg = 'Device found at 0x%x' % result[1] +'.  Address will be updated.';
        #UpdateStatusBar(statusMsg)
        AppGlobals.I2CAddress = "0x%x" % result[1];
    else:
        UpdateStatusBar("No device found!!")

        
    UpdateStatusBar("Programming EEPROM from SRAM...")
    WriteParameter("NVMUNLK",int(0xEA))     # Write 0xEA to Unlock NVM 
    WriteAddressData(157,3)                 #WriteParameter("NVM_ERASE_PROG",3)      # Set NVMPROG/NVMERASE bits to Execute NVM Erase/Programming cycles
    WriteParameter("NVMUNLK",0)             # Write 0x0 to Lock NVM
    WriteAddressData(157,0)                 #WriteParameter("NVM_ERASE_PROG",0)      # Clear NVMPROG/NVMERASE
    #nvmcount = int(ReadParameter("NVMCNT")) + 1
    UpdateStatusBar("EEPROM programmed!")   #UpdateStatusBar("EEPROM programmed!  %d out of 100 cycles programmed." % nvmcount)

    ###
    WriteParameter("NVMBASEUNLK",int(0))
    
    #UpdateStatusBar("Scanning for I2C address...")
    slave_address = 0
    result = ScanDevices(slave_address);
    if (result[0] == ""):   
        statusMsg = 'Device found at 0x%x' % result[1] +'.  Address will be updated.';
        #UpdateStatusBar(statusMsg)
        AppGlobals.I2CAddress = "0x%x" % result[1];
    else:
        UpdateStatusBar("No device found!!")

    UpdateStatusBar("EEPROM programmed!")   #UpdateStatusBar("EEPROM programmed!  %d out of 100 cycles programmed." % nvmcount)
