""" 
 * Copyright (C) 2018 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED 
"""
from collections import OrderedDict
import re

# TODO: error handling and return warning or error messages from matlab exe to GUI?

class MatlabInterface:
    # This class implements Matlab interfaces to/from Matlab, based on agreed convention

    def __init__(self, total_num_dpll = 2, total_num_inputs = 4):
        self.total_num_dpll = total_num_dpll
        self.total_num_inputs = total_num_inputs
        self.device_matlab_obj = "LMK05X18_DPLL"
        self.dpll_ref_common_div = []
        self.dpll_xo_freq = []
        self.apll_freq = []  # APLL1 Phase detector frequency
        self.dpll_peak = []
        self.dpll_peak_error = []
        self.dpll_bw_accuracy =[]       # example: 0.01 means 1% accuracy/error = (target_bw-computed_bw)/target_bw 
        #self.dpll_market_segments = []
        self.dpll_max_tdc_freq = []
        self.dpll_refclk_freq = []
        self.dpll_refclk_num = []
        self.dpll_refclk_pri = []
        self.dpll_mode = []
        self.dpll_type = []
        self.dpll_type_include = []
        self.dpll_bandwidth = []
        self.dpll_pdiv_pri = []
        self.dpll_vco_freq = []
        self.dpll_dco_ppb = []
        self.dpll_ppm_settings = []
        self.dpll_max_meas_time = []
        
        self.tr_fn_offset = []
        self.err_fn_offset = []
        self.tr_fn_value = []
        self.err_fn_value = []

        for i in range(self.total_num_dpll):
            self.dpll_ref_common_div.append("100e3")
            self.dpll_xo_freq.append("48e6")
            self.apll_freq.append("48e6")
            self.dpll_peak.append("0.1")
            self.dpll_peak_error.append("10")
            self.dpll_bw_accuracy.append("0.01")
            #self.dpll_market_segments.append("1")
            self.dpll_max_tdc_freq.append("26e6")
            refclk_freq_list = []
            refclk_num_list = []
            refclk_pri_list = []
            for j in range(self.total_num_inputs):
                refclk_freq_list.append("0")    # 0 = unused
                refclk_num_list.append(j)       # integer list
                refclk_pri_list.append("0")     # 0 = ignore
            self.dpll_refclk_freq.append("[{}]".format(', '.join(refclk_freq_list)))   
            self.dpll_refclk_num.append(str(refclk_num_list))                           
            self.dpll_refclk_pri.append("[{}]".format(', '.join(refclk_pri_list)))     
            self.dpll_mode.append("0")
            self.dpll_type.append("1")
            self.dpll_type_include.append(0)
            self.dpll_bandwidth.append("[10, 100]")
            self.dpll_pdiv_pri.append("4")
            self.dpll_vco_freq.append("0")
            self.dpll_dco_ppb.append("0.01")
            self.dpll_ppm_settings.append("[20, 26]")
            self.dpll_max_meas_time.append("1")
            
            self.tr_fn_offset.append("100")
            self.err_fn_offset.append("1")
            self.tr_fn_value.append("n/a")
            self.err_fn_value.append("n/a")
            

    def WriteMatlab(self, filename=r'matlab_inputs_lmk05x18.m', old_matlab = 0):
        outstr = "% Market segments\n"
        outstr += "%\n"
        outstr += "\n"
        outstr += "% Mandatory initialization of the DPLL objects\n"
        outstr += "dpll_obj(1) = %s;\n" % self.device_matlab_obj
        outstr += "\n"
        outstr += "dpll_obj(1).dpll_num = 1;\n"
        outstr += "\n"
        outstr += "% Setup to deal with ugly fraction\n"
        outstr += "dpll_obj(1).ref_common_div = %s;\n" % self.dpll_ref_common_div[0]
        outstr += "\n"
        outstr += "%\n"
        outstr += "% Generic that is common to both DPLL but duplicated\n"
        outstr += "%\n"
        outstr += "dpll_obj(1).xo_freq = %s;\n" % self.dpll_xo_freq[0]
        outstr += "dpll_obj(1).apll_freq = %s;\n" % self.apll_freq[0]
        outstr += "\n"
        outstr += "dpll_obj(1).peak = %s;\n" % self.dpll_peak[0]
        
        if old_matlab == 0:
            outstr += "dpll_obj(1).peak_err = %s;\n" % self.dpll_peak_error[0]
            outstr += "\n"
            outstr += "dpll_obj(1).tr_fn_offset = %s;\n" % self.tr_fn_offset[0]
            outstr += "dpll_obj(1).err_fn_offset = %s;\n" % self.err_fn_offset[0]
        outstr += "\n"
        outstr += "dpll_obj(1).dpll_bw_accuracy = %s;\n" % self.dpll_bw_accuracy[0]
        outstr += "\n"
        outstr += "%\n"
        outstr += "% DPLL\n"
        outstr += "%\n"
        outstr += "\n"
        outstr += "% Market Segements\n"
        #outstr += "dpll_obj(1).market_segments = %s;\n" % self.dpll_market_segments[0]
        outstr += "dpll_obj(1).max_tdc_freq = %s;\n" % self.dpll_max_tdc_freq[0]
        outstr += "\n"
        outstr += "% DPLL setup\n"
        outstr += "dpll_obj(1).dpll_mode = %s; %% 0 for 2 loops, 1 for type 2 3 loops (not used), 2 for type 3 (not used), 4 for APLL DCO, 5 for DCXO (not used)\n" % self.dpll_mode[0]
        if self.dpll_type_include[0] == 0:  
            outstr += "%"   # comment-out the next line
        outstr += "dpll_obj(1).dpll_opt.dpll_obj.dpll_type = %s;\n" % self.dpll_type[0]
        outstr += "\n"
        outstr += "% Input Frequency setup. \n"
        outstr += "%\n"
        outstr += "% If DCO mode, set dpll_obj(1).refclk_freq = [];\n"
        outstr += "%\n"
        outstr += "dpll_obj(1).refclk_freq = %s;\n" % self.dpll_refclk_freq[0]
        outstr += "dpll_obj(1).refclk_num = %s;\n" % self.dpll_refclk_num[0]
        #outstr += "dpll_obj(1).refclk_num = [1,2];\n"
        outstr += "dpll_obj(1).refclk_pri = %s;\n" % self.dpll_refclk_pri[0]
        outstr += "\n"
        outstr += "dpll_obj(1).bandwidth = %s; %% first position is bandwidth of DPLL, second position is the banwdidth of TCXO\n" % self.dpll_bandwidth[0] 
        outstr += "% dpll_obj(1).bandwidth = 10; % Automatic mode if you have TCXO.\n"
        outstr += "\n"
        outstr += "dpll_obj(1).dpll_opt.fix_prescale = %s;\n" % self.dpll_pdiv_pri[0]
        outstr += "\n"
        outstr += "dpll_obj(1).vco_freq = %s;\n" % self.dpll_vco_freq[0]
        outstr += "\n"
        outstr += "% Sets the increment to represent 0.01 ppb per jump max\n"
        outstr += "dpll_obj(1).dco_ppb = %s;\n" % self.dpll_dco_ppb[0]
        outstr += "\n"
        outstr += "dpll_obj(1).ppm_settings = %s; %% First element is the lock ppm, second element is out of lock ppm; 0 = automatic based on market segements\n" % self.dpll_ppm_settings[0]
        outstr += "\n"
        outstr += "dpll_obj(1).max_meas_time = %s; %% in seconds. 1 means 1 seconds, 50e-3 means 50e-3\n" % self.dpll_max_meas_time[0]
        outstr += "\n"
        
        f = open(filename, "w")
        f.write(outstr)
        f.close()

    def test_write(self):

        with open("test2.m", "w") as file:

            file.write("test2")

    def set_dpll_refclk(self, refclk_freq=["0","0"], refclk_asst=[0,0]):
        # y = dpll index, x = ref index
        for y in range(self.total_num_dpll):
            dpll_refclk_freq = []
            dpll_refclk_num = []
            if len(refclk_freq) != self.total_num_inputs:
                print ("# refclk_freq != {}".format(self.total_num_inputs))
            elif len(refclk_asst) != self.total_num_inputs:
                print ("# refclk_asst != {}".format(self.total_num_inputs))
            else:
                for x in range(self.total_num_inputs):
                    if refclk_asst[x]==0 or refclk_freq[x].strip(" ")=='0':
                        # input assignment==unused or leading char=='0'!  Do not add to freq/num lists
                        pass    
                    elif(((refclk_asst[x] & (1+y))>>y)==1):
                        # elif statement is TRUE when refclk_asst is associated with y (=DPLL#-1)
                        dpll_refclk_freq.append(refclk_freq[x])
                        dpll_refclk_num.append(x)   
            if len(dpll_refclk_freq) == 0:  # ensures list is not empty (avoid matlab input error)
                dpll_refclk_freq = ['25e6']    
                dpll_refclk_num = [0]
            self.dpll_refclk_freq[y] = "[{}]".format(', '.join(dpll_refclk_freq))
            self.dpll_refclk_num[y] = str(dpll_refclk_num)
            # print y, self.dpll_refclk_freq[y], self.dpll_refclk_num[y]
            pass
            
            #UpdateStatusBar("Set dpll_refclk_freq[y=%d]=%s" % (y, str(self.dpll_refclk_freq[y])))
            #UpdateStatusBar("Set dpll_refclk_num[y=%d]=%s" % (y, str(self.dpll_refclk_num[y])))
            


    def CallMatlabTest(self, cmd_args=['LMK05X18_ROM_Gen.exe', 'matlab_inputs_lmk05x18.m', 'output.txt']):
        print ("\nStarting Matlab exe...")
        subprocess.Popen(cmd_args)

test_mat_obj = MatlabInterface(total_num_dpll = 1, total_num_inputs = 2)

def test_matlab():
    test_mat_obj.device_matlab_obj = "test_matlab"
    
    # [0] = DPLL1
    test_mat_obj.dpll_ref_common_div[0] = str("1e5")
    test_mat_obj.dpll_xo_freq[0] = str("49.152e6")
    test_mat_obj.apll_freq[0] = test_mat_obj.dpll_xo_freq[0]
    test_mat_obj.dpll_peak[0] = str(0.1)
    test_mat_obj.dpll_peak_error[0] = str(10)
    test_mat_obj.dpll_bw_accuracy[0] = str(0.01)
    #test_mat_obj.dpll_market_segments[0] = str(1)    
    test_mat_obj.dpll_max_tdc_freq[0] = "26e6"
    test_mat_obj.dpll_mode[0] = str(0)
    test_mat_obj.dpll_bandwidth[0] = str(12)
    test_mat_obj.dpll_pdiv_pri[0] = str(5)
    test_mat_obj.dpll_vco_freq[0] = str(5e9)
    test_mat_obj.dpll_dco_ppb[0] = str(1)
    test_mat_obj.dpll_ppm_settings[0] = str(30)
    test_mat_obj.dpll_max_meas_time[0] = str(0.1)

    # set dpll refclk freq/num for both DPLLs
    ref_freq = ["1e6","2e6"]
    ref_asst = [0,1]
    test_mat_obj.set_dpll_refclk(refclk_freq=ref_freq, refclk_asst=ref_asst)



