% Market segments
%

% Mandatory initialization of the DPLL objects
dpll_obj(1) = LMK05X18_DPLL;

dpll_obj(1).dpll_num = 1;

% Setup to deal with ugly fraction
dpll_obj(1).ref_common_div = 1e9;

%
% Generic that is common to both DPLL but duplicated
%
dpll_obj(1).xo_freq = 48004800;
dpll_obj(1).apll_freq = 48004800;

dpll_obj(1).peak = 0.1;
dpll_obj(1).peak_err = 1.0;

dpll_obj(1).tr_fn_offset = 100;
dpll_obj(1).err_fn_offset = 1;

dpll_obj(1).dpll_bw_accuracy = 0.01;

%
% DPLL
%

% Market Segements
dpll_obj(1).max_tdc_freq = 26000000.0;

% DPLL setup
dpll_obj(1).dpll_mode = 0; % 0 for 2 loops, 1 for type 2 3 loops (not used), 2 for type 3 (not used), 4 for APLL DCO, 5 for DCXO (not used)
%dpll_obj(1).dpll_opt.dpll_obj.dpll_type = 1;

% Input Frequency setup. 
%
% If DCO mode, set dpll_obj(1).refclk_freq = [];
%
dpll_obj(1).refclk_freq = [25000000, 25000000];
dpll_obj(1).refclk_num = [0, 1];
dpll_obj(1).refclk_pri = [1, 2];

dpll_obj(1).bandwidth = 100.0; % first position is bandwidth of DPLL, second position is the banwdidth of TCXO
% dpll_obj(1).bandwidth = 10; % Automatic mode if you have TCXO.

dpll_obj(1).dpll_opt.fix_prescale = 2;

dpll_obj(1).vco_freq = 2500000000;

% Sets the increment to represent 0.01 ppb per jump max
dpll_obj(1).dco_ppb = 0.001;

dpll_obj(1).ppm_settings = [1, 10]; % First element is the lock ppm, second element is out of lock ppm; 0 = automatic based on market segements

dpll_obj(1).max_meas_time = 0.05; % in seconds. 1 means 1 seconds, 50e-3 means 50e-3

