""" 
 * Copyright (C) 2018 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED 
"""

import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import MessageBox,MessageBoxButtons,MessageBoxIcon,DialogResult
from System.Diagnostics import Process

def bReadAllRegs():
    ReadAllRegisters()
    bUpdate_ExtraEEPROM_Bytes_Update()

def bWriteAllRegs():
    WriteAllRegisters()

def bIMPORTROM():
    bIMPORT_ROMFILE_Update()

def bEXPORTROM():
    bEXPORT_ROMFILE_Update()
    
def bSWRST():
    WriteParameter("RESET_SW",1)
    WriteParameter("RESET_SW",0)

def bProgramEEPROM():
    bREG2EE_Update()
    message = "Are you sure you want to Program EEPROM?"
    caption = "Program EEPROM"
    result = MessageBox.Show(message, caption, MessageBoxButtons.YesNo, MessageBoxIcon.Question)
    if result == DialogResult.Yes:
        bPROGRAMEEPROM_Update()
    else:
        UpdateStatusBar("EEPROM programming cancelled by user.")

def bProgramEEPROMwithPLL1ICP():
    bREG2EE_Update()
    message = "Are you sure you want to Program EEPROM?"
    caption = "Program EEPROM"
    result = MessageBox.Show(message, caption, MessageBoxButtons.YesNo, MessageBoxIcon.Question)
    if result == DialogResult.Yes:
        bPROGRAMEEPROM2_Update()
    else:
        UpdateStatusBar("EEPROM programming cancelled by user.")
    
        
def bSetReadback():
    global g
    SetFieldValue('LOR1_MUX_SEL', 0)
    SetFieldValue('LOR1_INT_MUX', 122)
    SetPin('DIS_M1',1)

    
def bFindAddress_Update():
    UpdateStatusBar("Scanning for I2C address...")
    slave_address = 0
    result = ScanDevices(slave_address);
    if (result[0] == ""):   
        statusMsg = 'Device found at 0x%x' % result[1] +'.  Address will be updated.';
        UpdateStatusBar(statusMsg)
        AppGlobals.I2CAddress = "0x%x" % result[1];
    else:
        UpdateStatusBar("No device found!!")
    pass


