"""
Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/ 
ALL RIGHTS RESERVED 
"""

from System.Windows.Media import SolidColorBrush, Color, Colors

from System.Windows.Controls import(ComboBox,ComboBoxItem)
from System.Windows import TextAlignment,FontWeights

import sys
import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon

import math


brush_warning = SolidColorBrush(Color.FromArgb(255,204,0,0))
brush_white = SolidColorBrush(Color.FromArgb(255,255,255,255))
brush_alert = SolidColorBrush(Color.FromArgb(255,253,205,52))

text_grey = SolidColorBrush(Color.FromArgb(153,153,153,0))
text_warning = SolidColorBrush(Color.FromArgb(255,204,0,0))
text_black = SolidColorBrush(Colors.Black)

# Note: In some places elements are accessed using UIC_Control (UI Control Element) because of the clash with controls in User Controls Page

    
class GlobalVariables(object):
	def __init__(self):
		self.VCO_freq_state = "";
g = GlobalVariables();

def System_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    ValidateFrequencies()

def System_Update_Loaded_Mode():
    Fpd_FREQ_Update()
    UpdateVCOFrequency() 
    ValidateFrequencies()


def System_Update_Run_Once():
    UIC_Fpd_FREQ.TextAlignment = TextAlignment.Right

    UIC_flexKVCO.TextAlignment = TextAlignment.Left
    UIC_Fvco_FREQ.TextAlignment = TextAlignment.Right
    UIC_flexSYSREF_INTERPOL_FREQ.TextAlignment=TextAlignment.Right
    
    UIC_FoutA_FREQ.TextAlignment = TextAlignment.Left
    UIC_FoutB_FREQ.TextAlignment = TextAlignment.Left
    
    UIC_JESD_DAC1_CTRL.Foreground=text_grey
    UIC_JESD_DAC2_CTRL.Foreground=text_grey
    UIC_JESD_DAC3_CTRL.Foreground=text_grey
    UIC_JESD_DAC4_CTRL.Foreground=text_grey
    
    UIC_flexSYSREFPHASESHIFT.ToolTip="This is not a programmable field for the actual device, but calculates the four settings below to adjust the phase shift.  Valid values are 0 to 224."
	
    Fpd_FREQ_Update()
    UpdateVCOFrequency() 
    ValidateFrequencies()
    
        
def Fosc_FREQ_Update():
    UpdateInputPath()
    
def Fosc_FREQ_Update_UI():
    ValidateFrequencies()

def OSC_2X_Update():
    UpdateInputPath()
    UpdateCurrent()
    
def OSC_2X_Update_UI():
    ValidateFrequencies()
    
def PLL_R_PRE_Update():
    UpdateInputPath()
    UpdateCurrent()

def PLL_R_PRE_Update_UI():
    ValidateFrequencies()
    
def MULT_Update():
    UpdateInputPath()
    UpdateCurrent()
    
def MULT_Update_UI():
    ValidateFrequencies()

def PLL_R_Update():
    UpdateInputPath()
    UpdateCurrent()

def PLL_R_Update_UI():
    ValidateFrequencies()
    
def FoutA_FREQ_Update():
    if (OUTA_MUX.iValue==0):
        Fout=FoutA_FREQ.dValue
        Divide = GetCHANDIV(CHDIV.iValue)
        if Divide < 0:
            Divide=1
        if (Divide*Fout>3200) and (Divide*Fout<6400):
            Fvco_FREQ.dValue= round(Divide*FoutA_FREQ.dValue,10)
        else:
            FoundMatch=0
            for i in range(0,14):
                if (GetCHANDIV(i)*Fout>3200):
                    Fvco_FREQ.dValue = GetCHANDIV(i)*Fout
                    CHDIV.iValue=i
                    FoundMatch=1
                    break;
                    
            if (FoundMatch==0):
                Fvco_FREQ.dValue=3200
                CHDIV.iValue=0
    elif (OUTA_MUX.iValue==2):
        Fvco_FREQ.dValue=round(FoutA_FREQ.dValue/2,10)
    else:
        Fvco_FREQ.dValue=round(FoutA_FREQ.dValue,10)
    
    Fvco_FREQ_Update()
    UpdateCurrent()
 
def FoutB_FREQ_Update():
    if (OUTB_MUX.iValue==0):
        Fout=FoutB_FREQ.dValue
        Divide = GetCHANDIV(CHDIV.iValue)
        if (Divide<0):
            Divide=1
        if (Divide*Fout>3200):
            Fvco_FREQ.dValue= round(Divide*FoutB_FREQ.dValue,10)
        else:
            FoundMatch=0
            for i in range(0,14):
                if (GetCHANDIV(i)*Fout>3200) and (Divide*Fout<6400):
                    Fvco_FREQ.dValue = GetCHANDIV(i)*Fout
                    CHDIV.iValue=i
                    FoundMatch=1
                    break;
                    
            if (FoundMatch==0):
                Fvco_FREQ.dValue=3200
                CHDIV.iValue=17
    else:
        Fvco_FREQ.dValue=round(FoutB_FREQ.dValue,10)
 
    Fvco_FREQ_Update()
    UpdateCurrent()
    

def FoutA_FREQ_Update_UI():
    ValidateFrequencies()
 
def FoutB_FREQ_Update_UI():
    ValidateFrequencies()
 
    
def UpdateInputPath():
    PreR = PLL_R_PRE.iValue
    if (PreR<1):
        PreR=1
    MultOut = Fosc_FREQ.dValue*(OSC_2X.iValue+1)*MULT.iValue/PreR
    if (MultOut<0.000001):
        MultOut = Fosc_FREQ.iValue
        
    Rdiv=PLL_R.iValue
    if (Rdiv<1):
        Rdiv=1

    Fpd_FREQ.dValue=round(MultOut/Rdiv,10)
    UpdateNDivider()
    UpdateVCOFrequency() 

       
def Fpd_FREQ_Update():
    Fpd = Fpd_FREQ.dValue
    if (Fpd<0.000001):
        Fpd=1
    PreR = PLL_R_PRE.iValue
    if (PreR<1):
        PreR=1
    MultOut = Fosc_FREQ.dValue*(OSC_2X.iValue+1)*MULT.iValue/PreR
    if (MultOut<0.000001):
        MultOut = Fosc_FREQ.iValue
        
    Rdiv=MultOut/Fpd
    if Rdiv>128:
        Rdiv=128      
    if Rdiv<1:
        Rdiv=1
    PLL_R.iValue=int(Rdiv+0.5)
    
    UpdateInputPath() 
    UpdateCurrent()

def Fpd_FREQ_Update_UI():
    ValidateFrequencies()
   
def PLL_NUM_Update():
    UpdateVCOFrequency() 
    UpdateCurrent()
    
def PLL_NUM_Update_UI():
    ValidateFrequencies()
    UpdateCurrent()

def PLL_DEN_Update():
    UpdateVCOFrequency() 
    UpdateCurrent()
    
def PLL_DEN_Update_UI():
    ValidateFrequencies()

def PLL_N_Update():
    UpdateVCOFrequency() 
    UpdateCurrent()

def PLL_N_UPdate_UI():
    ValidateFrequencies()
    
    
def MASH_SYNC_EN_Update_UI():
    ValidateFrequencies()
    
def VCO_PHASE_SYNC_EN_Update():
    UpdateIncludedDivide()
    UpdateNDivider() 
    UpdateVCOFrequency()
    UpdateVCOGain() 
    UpdateDistribution()   
    
def MULT_HI_Update_UI():
    ValidateFrequencies()

def VCO_PHASE_SYNC_EN_Update_UI():
    ValidateFrequencies()
    UpdateSYNCStatus()

def SYSREF_EN_Update():
    UpdateIncludedDivide()
    UpdateNDivider() 
    UpdateVCOFrequency()
    UpdateVCOGain() 
    UpdateDistribution() 

def SYSREF_EN_Update_UI():
    ValidateFrequencies()   
    
def SYSREF_REPEAT_Update_UI():
    ValidateFrequencies()

def SYSREF_DIV_PRE_Update():
    UpdateNDivider() 
    UpdateVCOFrequency()
    UpdateVCOGain() 
    UpdateDistribution() 
    
def SYSREF_DIV_PRE_Update_UI():
    ValidateFrequencies() 

def SYSREF_DIV_Update():
    UpdateNDivider() 
    UpdateVCOFrequency()
    UpdateVCOGain() 
    UpdateDistribution() 
    
def SYSREF_DIV_Update_UI():
    ValidateFrequencies() 
    
def SYSREF_PULSE_Update_UI():
    ValidateFrequencies()
   

def VCO_SEL_Update():
    ValidateFrequencies()
    

def UpdateVCOFrequency():
    Fden=PLL_DEN.iValue
    TotalR=PLL_R_PRE.iValue*PLL_R.iValue
    if (TotalR<1):
        TotalR=1
    TotalMult=(1+OSC_2X.iValue)*MULT.iValue
    if (TotalMult<1):
        TotalMult=1
    #   Be cautions to use calculations that do not cause round-off error problems or VCO frequency
    if (Fden<1):
        Fden=1
    TotalN=1.0*PLL_N.iValue+PLL_NUM.iValue*1.0/Fden
    Fvco_FREQ.dValue=round(TotalMult*flexINCLUDED_DIVIDE.iValue*TotalN*Fosc_FREQ.dValue/TotalR,10)
    
    UpdateVCOGain()
    UpdateDistribution()
    
    btn_CalibrateVCO.Background=brush_alert
    btn_CalibrateVCO.ToolTip = "After the VCO frequency is changed, the VCO needs to be calibrated by programming the register R0.  This is what this button does."
    pass

def Fvco_FREQ_Update():
    UpdateNDivider() 
    UpdateVCOFrequency()
    UpdateVCOGain() 
    UpdateDistribution()
    UpdateCurrent()
   
def Fvco_FREQ_Update_UI():
    ValidateFrequencies()

def UpdateIncludedDivide():
    if (VCO_PHASE_SYNC_EN.iValue==0):
        flexINCLUDED_DIVIDE.iValue=1
    elif (OUTA_MUX.iValue==1) and (OUTB_MUX.iValue==1):
        flexINCLUDED_DIVIDE.iValue=1
    elif (OUTA_MUX.iValue==1) and (OUTB_MUX.iValue==2):
        flexINCLUDED_DIVIDE.iValue=1
    else:
        flexINCLUDED_DIVIDE.iValue=2
    
    UpdateSYSREFInterpolator();

def UpdateNDivider():
    Fvco=Fvco_FREQ.dValue
    Fden=PLL_DEN.iValue
    if (Fden<1):
        Fden=1
        PLL_DEN.iValue=1
    Fpd=Fpd_FREQ.dValue
    if (Fpd<0.0000001):
        Fpd_FREQ.dValue=1
        Fpd=1
        
    PreR = PLL_R_PRE.iValue
    if (PreR<1):
        PreR=1
    MultOut = Fosc_FREQ.dValue*(OSC_2X.iValue+1)*MULT.iValue/PreR
    if (MultOut<0.000001):
        MultOut = Fosc_FREQ.iValue
        
    Rdiv=PLL_R.iValue
    if (Rdiv<1):
        Rdiv=1        

    #   Note, do not use Fpd_Freq as it has been rounded off and can cause an infinite loop
    FracN=Rdiv*Fvco/(MultOut*flexINCLUDED_DIVIDE.iValue)
    N=math.floor(FracN)
    PLL_N.iValue=N
    PLL_NUM.iValue=round(Fden*(FracN-N))
    
    pass    
 
   
    
def UpdateSYSREFInterpolator():
    flexSYSREF_IncludeDivide.iValue=flexINCLUDED_DIVIDE.iValue
    DIV = flexINCLUDED_DIVIDE.iValue
    
    if (SYSREF_DIV_PRE.iValue==1) or (SYSREF_DIV_PRE.iValue==2) or (SYSREF_DIV_PRE.iValue==4):
        DIV=DIV*SYSREF_DIV_PRE.iValue
    
    if (DIV<1):
        DIV=1
    
    flexSYSREF_INTERPOL_FREQ.dValue = Fvco_FREQ.dValue/DIV
    
    
def UpdateVCOGain():
    Fvco=Fvco_FREQ.dValue
    
    if (Fvco<3200):
        Kvco = 32
    elif (Fvco<3650):
        Kvco = 32+(47-32)*(Fvco-3200)/(3650-3200)
    elif (Fvco<4200):
        Kvco = 35+(54-35)*(Fvco-3650)/(4200-3650)        
    elif (Fvco<4650):
        Kvco = 47 +(64-47)*(Fvco-4200)/(4650-4200)
    elif (Fvco<5200):
        Kvco = 50 +(73-50)*(Fvco-4650)/(5200-4650)
    elif (Fvco<5750):
        Kvco = 61+(82-61)*(Fvco-5200)/(5750-5200)
    elif (Fvco<6400):
        Kvco = 57+(79-57)*(Fvco-5750)/(6400-5750)
    else:
        Kvco = 79
        
    flexKVCO.dValue=round(Kvco)
    

def ValidateFrequencies():
    Fosc=Fosc_FREQ.dValue
    Fpd =Fpd_FREQ.dValue
    Fvco=Fvco_FREQ.dValue


    #   Validate OSCin
    if (Fosc<5):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Minimum Fosc is 5 MHz"
    elif (Fosc>250):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Maximum Fosc is 250 MHz"
    else:
        UIC_Fosc_FREQ.Background = brush_white
        UIC_Fosc_FREQ.ToolTip=None  

    #   Validate OSCin Doubler
    if  (OSC_2X.iValue>0) and (Fosc>125) :
        UIC_OSC_2X.Background = brush_warning
        UIC_OSC_2X.ToolTip = "Maximum Input Frequency for the OSCin doubler is 125 MHz."
    else:
        UIC_OSC_2X.Background = brush_white
        UIC_OSC_2X.ToolTip=None
        
    #   Validate Multiplier  
    PreR=PLL_R_PRE.iValue
    if (0==PreR):
        PreR=1
    MultIn = (OSC_2X.iValue+1)*Fosc/PreR
    MultOut = MultIn*MULT.iValue  
         
    if  (MULT.iValue==1):
        UIC_MULT.Background = brush_white
        UIC_MULT.ToolTip=None
    elif (MULT.iValue==2):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="A Multiply value of 2 is not supported.  However this can be done with the OSCin doubler."
    elif (MULT.iValue>7):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Multiply Values of greater than 7 are not supported." 
    elif (MultIn<10):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Minimum input frequency to the Multiplier is 10 MHz"
    elif (MultIn>35):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="Maximum input frequency to the Multiplier is 35 MHz"
    elif (MultOut<60):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="When the multiplier is engaged, the output frequency has to be at least 60 MHz."
    elif (MultOut>200):
        UIC_MULT.Background = brush_warning
        UIC_MULT.ToolTip="When the multiplier is engaged, the output frequency can not be greater than 200 MHz."  
    else:
        UIC_MULT.Background = brush_white
        UIC_MULT.ToolTip=None
    
    #Validate MULT_HI
    if (MultOut>100) and (MULT_HI.iValue==0) and (MULT.iValue>1):
        UIC_MULT_HI.Background = brush_warning
        UIC_MULT_HI.ToolTip="MULT_HI should be checked whenever the multiplier is enaged with a frequency greater than 100 MHz."
    elif (MultOut<=100) and (MULT_HI.iValue==1) and (MULT.iValue>1):
        UIC_MULT_HI.Background = brush_warning
        UIC_MULT_HI.ToolTip="MULT_HI should be unchecked whenever the multiplier is enaged with a frequency less than or equal to 100 MHz."    
    else:
        UIC_MULT_HI.Background = brush_white
        UIC_MULT_HI.ToolTip=None       
    
    #   Validate PostR Divider
    if (MultOut>250) and (PLL_R.iValue>1):
        UIC_PLL_R.GetTextBox().Background = brush_warning
        UIC_PLL_R.ToolTip="The PLL_R divider maximum input freqeuncy is 250 MHz.  The PLL_R_PRE divider needs to to reduce this input frequency."
    else:
        UIC_PLL_R.GetTextBox().Background = brush_white
        UIC_PLL_R.ToolTip=None
        

        
    #   Validate FCAL_LPFD_ADJ
    if (Fpd<2.5):
        TargetIndex=3
    elif (Fpd<5):
        TargetIndex=2
    elif (Fpd<10):
        TargetIndex=1
    else:
        TargetIndex=0
        
    if (FCAL_LPFD_ADJ.iValue<>TargetIndex):
        UIC_FCAL_LPFD_ADJ.Background=brush_warning
        UIC_FCAL_LPFD_ADJ.ToolTip="This value should be set to "+str(TargetIndex)+" for this phase detector frequency."
    else:
        UIC_FCAL_LPFD_ADJ.Background=brush_white
        UIC_FCAL_LPFD_ADJ.ToolTip=None   
        
        
    #   Validate FCAL_HPFD_ADJ
    if (Fpd>100):
        TargetIndex=3
    elif (Fpd>75):
        TargetIndex=2
    elif (Fpd>37.5):
        TargetIndex=1
    else:
        TargetIndex=0    
        
    if (FCAL_HPFD_ADJ.iValue<>TargetIndex):
        UIC_FCAL_HPFD_ADJ.Background=brush_warning
        UIC_FCAL_HPFD_ADJ.ToolTip="This value should be set to "+str(TargetIndex)+" for this phase detector frequency."
    else:
        UIC_FCAL_HPFD_ADJ.Background=brush_white
        UIC_FCAL_HPFD_ADJ.ToolTip=None       
        
    #   Validate CAL_CLK_DIV
    if (Fosc>200):
        TargetIndex=1
    else:
        TargetIndex=0    
        
    if (CAL_CLK_DIV.iValue<TargetIndex):
        UIC_CAL_CLK_DIV.Background=brush_warning
        UIC_CAL_CLK_DIV.ToolTip="For this OSCin freuqency, this value needs to be adjusted up to "+str(TargetIndex)+" for proper VCO Calibration."
    elif (CAL_CLK_DIV.iValue>TargetIndex):
        UIC_CAL_CLK_DIV.Background=brush_alert
        UIC_CAL_CLK_DIV.ToolTip="Although this setting will work, the VCO calibration time can be improved by adjusting this setting down to "+str(TargetIndex)+"."   
    else:
        UIC_CAL_CLK_DIV.Background=brush_white
        UIC_CAL_CLK_DIV.ToolTip=None       

#   Check N Divider, Order, and PFD_DLY
    N=PLL_N.iValue
    Order = MASH_ORDER.iValue
    Nmin=1
    PFD_DLYnew=0
    Fvco=Fvco_FREQ.dValue  
    FpdMax=275
    
    #   Validate PLL_N, PFD_DLY, and Fpd
    if (Order==0):
        FpdMax=250
        if (Fvco<4000-0.0001):
            Nmin=20
            PFD_DLYnew=0
        else:
            Nmin=24
            PFD_DLYnew=1
    elif (Order==1):
        FpdMax=200
        if (Fvco<4000-0.0001):
            Nmin=25
            PFD_DLYnew=1
        else:
            Nmin=29
            PFD_DLYnew=2
    elif (Order==2):
        FpdMax=200
        if (Fvco<4000-0.0001):
            Nmin=26
            PFD_DLYnew=1
        else:
            Nmin=30
            PFD_DLYnew=2
    elif (Order==3):
        FpdMax=160
        if (Fvco<4900.0001):
            Nmin=32
            PFD_DLYnew=2
        else:
            Nmin=36
            PFD_DLYnew=3
    elif (Order==4):
        FpdMax=120
        if (Fvco<4900.0001):
            Nmin=44
            PFD_DLYnew=4
        else:
            Nmin=48
            PFD_DLYnew=5
       
    if (N<20):
        UIC_PLL_N.ToolTip="PLL_N values below 20 are not supported."
        UIC_PLL_N.GetTextBox().Background = brush_warning
        UIC_MASH_ORDER.ToolTip=None
        UIC_MASH_ORDER.Background=brush_white
    elif (N<Nmin):
        UIC_PLL_N.ToolTip="This PLL_N value is too low for this MASH_ORDER, but could be supported if the MASH_ORDER is reduced.\n\n  For this VCO Frequency and MASH_ORDER, the minimum N value is "+str(Nmin)+" and the PFD_DLY_SEL setting should be "+str(PFD_DLYnew)
        UIC_PLL_N.GetTextBox().Background = brush_alert
        UIC_MASH_ORDER.Background=brush_alert   
    else:
        UIC_PLL_N.ToolTip= None
        UIC_PLL_N.GetTextBox().Background = brush_white      
        UIC_MASH_ORDER.ToolTip=None
        UIC_MASH_ORDER.Background=brush_white
        
    if (PFD_DLY_SEL.iValue==PFD_DLYnew):
        UIC_PFD_DLY_SEL.GetTextBox().ToolTip= None
        UIC_PFD_DLY_SEL.GetTextBox().Background=brush_white
    else:
        UIC_PFD_DLY_SEL.GetTextBox().ToolTip="PFD_DLY_SEL should be changed to state " + str(PFD_DLYnew) 
        UIC_PFD_DLY_SEL.GetTextBox().Background = brush_alert
        
    #   Validate Fpd
    if (Fpd_FREQ.dValue>FpdMax):
        UIC_Fpd_FREQ.Background = brush_warning
        UIC_Fpd_FREQ.ToolTip="Maximum Phase Detector Frequency for this MASH_ORDER is "+str(FpdMax)+ " MHz"
    else:
        UIC_Fpd_FREQ.Background = brush_white
        UIC_Fpd_FREQ.ToolTip=None
        
    #   Validate Fnum
    UIC_MASH_RESET_N.Background=brush_white
    UIC_MASH_RESET_N.ToolTip="This box should be checked if the fractional numerator is non-zero"
    
    if (PLL_NUM.iValue>0) and ((MASH_ORDER.iValue==0) or (MASH_RESET_N.iValue==0)):
        UIC_PLL_NUM.GetTextBox().Background=brush_warning
        UIC_PLL_NUM.ToolTip="This fractional numerator will be ignored until both MASH_ORDER>0 and MASH_RESET_N=1"
        if (MASH_RESET_N.iValue==0):
            UIC_MASH_RESET_N.Background=brush_warning
            UIC_MASH_RESET_N.ToolTip="This box should be checked if the fractional numerator is non-zero"
    else:
        UIC_PLL_NUM.GetTextBox().Background=brush_white
        UIC_PLL_NUM.ToolTip=None 
    
    #   Validate OUTA_MUX
    if (OUTA_PD.iValue==1) and (OUTB_PD.iValue==0) and (OUTA_MUX.iValue<>OUTB_MUX.iValue):
        UIC_OUTA_MUX.ToolTip="OUTA is powered down.  For minium crosstalk and current consumption, set OUTA_MUX=OUTB_MUX."
        UIC_OUTA_MUX.Background=brush_alert
    else:
        UIC_OUTA_MUX.ToolTip=None
        UIC_OUTA_MUX.Background=brush_white

    #   Validate VCO Frequency
    UIC_Fvco_FREQ.Background = brush_white
    UIC_Fvco_FREQ.ToolTip=None
    if (Fvco_FREQ.dValue<3200):
        UIC_Fvco_FREQ.ToolTip="Minimum VCO Frequency is 3.2 GHz"
        UIC_Fvco_FREQ.Background = brush_warning 
    elif (Fvco_FREQ.dValue>6400):
        UIC_Fvco_FREQ.Background = brush_warning
        UIC_Fvco_FREQ.ToolTip="Maximum VCO Frequency is 6.4 GHz"
        

    #   Validate SYSREF Mux and OUTB
    if (OUTB_MUX.iValue==2) and ((SYSREF_EN.iValue==0) or (VCO_PHASE_SYNC_EN.iValue==0)):
        UIC_OUTB_MUX.Background=brush_warning
        UIC_OUTB_MUX.ToolTip = "For SYSREF to work, it is required that SYSREF_EN=1 and VCO_PHASE_SYNC_EN=1."
    else:
        UIC_OUTB_MUX.Background=brush_white
        UIC_OUTB_MUX.ToolTip=None    
        
        
    #   Validate  SYSREF
    if (SYSREF_EN.iValue==0):
        Dim(SYSREF_REPEAT)
        Dim(SYSREF_PULSE)
        Dim(SYSREF_DIV_PRE)
        Dim(SYSREF_DIV)
        Dim(SYSREF_PULSE_CNT)
        Dim(flexSYSREF_INTERPOL_FREQ)
        Dim(flexSYSREF_IncludeDivide)
        Dim(flexSYSREFPHASESHIFT)
        UIC_flexSYSREF_IncludeDivide.Foreground=text_grey
        UIC_flexSYSREF_INTERPOL_FREQ.Foreground=text_grey
        
        UIC_SYSREF_EN.Background=brush_white
        UIC_SYSREF_EN.ToolTip=None
   
    else:
        UnDim(SYSREF_REPEAT)
        UnDim(SYSREF_DIV_PRE)
        UnDim(flexSYSREF_INTERPOL_FREQ)
        UnDim(flexSYSREF_IncludeDivide)
        UnDim(flexSYSREFPHASESHIFT)
        UIC_flexSYSREF_IncludeDivide.Foreground=text_black
        UIC_flexSYSREF_INTERPOL_FREQ.Foreground=text_black
               
        if (VCO_PHASE_SYNC_EN.iValue==0):
            UIC_SYSREF_EN.Background=brush_warning
            UIC_SYSREF_EN.ToolTip="VCO_PHASE_SYNC_EN needs to be enabled for SYSREF to work."
        elif (SYSREF_REPEAT.iValue==0) and (SYSREF_PULSE.iValue==0)and (GetPin("SysRefReq")==0):
            UIC_SYSREF_EN.Background=brush_alert
            UIC_SYSREF_EN.ToolTip="The SysRefReq pin needs to be high in master continuous mode to get an output."
        else:
            UIC_SYSREF_EN.Background=brush_white
            UIC_SYSREF_EN.ToolTip=None

        if (SYSREF_REPEAT.iValue==0):
            UnDim(SYSREF_DIV)  
            UnDim(SYSREF_PULSE) 
            
            if (SYSREF_PULSE.iValue==0):
                Dim(SYSREF_PULSE_CNT)
            else:
                UnDim(SYSREF_PULSE_CNT)

            if (SYSREF_DIV_PRE.iValue==1) or (SYSREF_DIV_PRE.iValue == 2) or (SYSREF_DIV_PRE.iValue==4):
                UIC_SYSREF_DIV_PRE.ToolTip=None
                UIC_SYSREF_DIV_PRE.Background=brush_white
            else:
                UIC_SYSREF_DIV_PRE.ToolTip = "The only valid values for the SYSREF_DIV_PRE divider are 1, 2, and 4"
                UIC_SYSREF_DIV_PRE.Background=brush_alert
            
            
            if (flexSYSREF_INTERPOL_FREQ.dValue>799.9999999) and (flexSYSREF_INTERPOL_FREQ.dValue<1500.0000001):
                UIC_flexSYSREF_INTERPOL_FREQ.Foreground=text_black
                UIC_flexSYSREF_INTERPOL_FREQ.ToolTip=None
            else:
                UIC_flexSYSREF_INTERPOL_FREQ.Foreground=text_warning
                UIC_flexSYSREF_INTERPOL_FREQ.ToolTip="The SYSREF phase interpolator frequency needs to be between 800 and 1500 MHz."
        else:
            Dim(SYSREF_DIV)  
            Dim(SYSREF_PULSE)            
            Dim(SYSREF_PULSE_CNT)
        
        
    #Validate Output Divider
    VCOmax = 100000
    
    if (CHDIV.iValue<2):
        VCOmax=11500

    
    if (Fvco>VCOmax):
        UIC_CHDIV.Background=brush_warning
        UIC_CHDIV.ToolTip = "The maximum frequency of 11.5 GHz for this channel divide value has been exceeded."
    elif (CHDIV.iValue>15) and (VCO_PHASE_SYNC_EN.iValue==1):
        UIC_CHDIV.Background=brush_alert
        UIC_CHDIV.ToolTip = "The phase SYNC for channel divider does not work above a channel divide value of 256"
    else:
        UIC_CHDIV.Background=brush_white
        UIC_CHDIV.ToolTip=None
        
    #   Validate Output Buffer
    if (OUTA_PD.iValue==0):
        UIC_FoutA_FREQ.Foreground=text_black
        UnDim(OUTA_PWR)
    else:
        UIC_FoutA_FREQ.Foreground=text_grey
        Dim(OUTA_PWR)
    
    if (OUTB_PD.iValue==0):
        if (OUTB_MUX.iValue==2) and (SYSREF_REPEAT.iValue==1):
            UIC_FoutB_FREQ.Foreground=text_grey
        else:
            UIC_FoutB_FREQ.Foreground=text_black
        UnDim(OUTB_PWR)
    else:
        UIC_FoutB_FREQ.Foreground=text_grey
        Dim(OUTB_PWR)    
        
    #   Validate SYNC and SysRefReq Pins
    if (VCO_PHASE_SYNC_EN.iValue==1) and (INPIN_IGNORE.iValue==1):
        btn_ToggleSyncPin.Background=brush_alert
        btn_ToggleSyncPin.ToolTip="INPIN_IGNORE should be set to 0 if you want to use the SYNC pin."
    else:
        btn_ToggleSyncPin.Background=brush_white
        btn_ToggleSyncPin.ToolTip=None
    if (SYSREF_EN.iValue==1) and (INPIN_IGNORE.iValue==1):
        btn_ToggleSysRefPin.Background=brush_alert
        btn_ToggleSysRefPin.ToolTip="INPIN_IGNORE should be set to 0 if you want to use SYSREF feature."
    else:
        btn_ToggleSysRefPin.Background=brush_white
        btn_ToggleSysRefPin.ToolTip=None        

def btn_CalibrateVCO_Update_UI():
    WriteRegister("R0")
    UpdateStatusBar("Programming of R0 has run the VCO calibration routine.")
    btn_CalibrateVCO.Background=brush_white
    btn_CalibrateVCO.ToolTip = None

def btn_SimplifyFraction_Update_UI():
    Fnum=PLL_NUM.iValue
    Fden=PLL_DEN.iValue
    

    if  ((Fnum==0) or (Fden==0)):
        Fden=1
        Fnum=0
    else:      
        #   Remove 1 for Large Fraction
        if  (Fden>65536) and (Fnum%65536==0) and (Fden%65536==1):
            Fden=Fden-1
            
        Divisor = 2      
        while ( Divisor<Fnum+1):
            if (0 == (Fnum % Divisor)) and (0 == (Fden % Divisor)):
                Fnum=Fnum/Divisor
                Fden=Fden/Divisor
                UpdateStatusBar("Factor of "+str(Divisor))
            else:
                Divisor=Divisor+1
                
        if (Fden%Fnum==0):
            Fden=Fden/Fnum
            Fnum=1
    UpdateStatusBar("Fraction Simplified to "+str(Fnum)+"/"+str(Fden));     
    PLL_DEN.iValue=Fden
    PLL_NUM.iValue=Fnum  
    
def btn_UseLargeFraction_Update_UI():
    if (PLL_NUM.iValue>0) and (PLL_DEN.iValue>0):
        Extend = int(math.log(65536*65536.0/float(PLL_DEN.iValue),2))-1
        if Extend<1:
            Extend=1
        Extend=pow(2,Extend)
        PLL_DEN.iValue=PLL_DEN.iValue*Extend+1
        PLL_NUM.iValue=PLL_NUM.iValue*Extend 


def btn_VCOFASTCAL_Update_UI():
    Fvco=Fvco_FREQ.dValue
       
    if (Fvco<3200):
        VCOSEL=1
        VCOmin=3200
        VCOmax=3650
        AmpCalMin=138
        AmpCalMax=137
        CapCtrlMin=131
        CapCtrlMax=19    
    elif (Fvco<3650):
        VCOSEL=2
        VCOmin=3650
        VCOmax=4200
        AmpCalMin=162
        AmpCalMax=142
        CapCtrlMin=143
        CapCtrlMax=25
    elif (Fvco<4200):
        VCOSEL=3
        VCOmin=4200
        VCOmax=4650
        AmpCalMin=126
        AmpCalMax=114
        CapCtrlMin=135
        CapCtrlMax=34  
    elif (Fvco<4650):
        VCOSEL=4 
        VCOmin=4650
        VCOmax=5200
        AmpCalMin=195
        AmpCalMax=172
        CapCtrlMin=136
        CapCtrlMax=25
    elif (Fvco<5200):
        VCOSEL=5
        VCOmin=5200
        VCOmax=5750
        AmpCalMin=190
        AmpCalMax=163
        CapCtrlMin=133
        CapCtrlMax=20      
    elif (Fvco<6400):
        VCOSEL=6
        VCOmin=5750
        VCOmax=6400
        AmpCalMin=256
        AmpCalMax=204
        CapCtrlMin=151
        CapCtrlMax=27  
    else:
        VCOSEL=6
        VCOmin=5750
        VCOmax=6400
        AmpCalMin=204
        AmpCalMax=204
        CapCtrlMin=27
        CapCtrlMax=27     

    CapCode=CapCtrlMin - int( (CapCtrlMin-CapCtrlMax)*(VCOmax-Fvco)/(VCOmax-VCOmin) )
    AmpCal = AmpCalMin+int( (AmpCalMax-AmpCalMin)*(Fvco-VCOmin)/(VCOmax-VCOmin) )
    
    if (CapCode<0):
        CapCode=0
    if (CapCode>183):
        CapCode=183
    if (AmpCal<0):
        AmpCal=0
    if (AmpCal>511):
        AmpCal=511
        
    VCO_SEL.iValue=VCOSEL
    VCO_CAPCTRL_STRT.iValue=CapCode
    VCO_DACISET_STRT.iValue=AmpCal
    
def btn_ToggleSyncPin_Update_UI(): 
    if INPIN_IGNORE.iValue==1:
        UpdateStatusBar("INPIN_IGNORE needs to be 0 so that SYNC pin is not ignored.\nSetting INPIN_IGNORE bit to 0.")
        INPIN_IGNORE.iValue=0
        
    UpdateStatusBar("Toggled SYNC Pin") 
    if (GetPin("SYNC")==1):
        SetPin("SYNC",0)
        SetPin("SYNC",1)
    else:
        SetPin("SYNC",1)
        SetPin("SYNC",0)    

def btn_ToggleSysRefPin_Update_UI():  

    if INPIN_IGNORE.iValue==1:
        UpdateStatusBar("INPIN_IGNORE needs to be 0 so that SysRefReq pin is not ignored.\nSetting INPIN_IGNORE bit to 0.")
        INPIN_IGNORE.iValue=0

    UpdateStatusBar("Toggled SysRefReq Pin") 
    if (GetPin("SysRefReq")==1):
        SetPin("SysRefReq",0)
        SetPin("SysRefReq",1)
    else:
        SetPin("SysRefReq",1)
        SetPin("SysRefReq",0)
        
def flexSYSREFPHASESHIFT_old_Update():
    if (flexSYSREFPHASESHIFT.iValue<=0):
        flexSYSREFPHASESHIFT.iValue=0
        Value=0
    elif (flexSYSREFPHASESHIFT.iValue>=251):
        flexSYSREFPHASESHIFT.iValue=251
        Value=251
    else:
        Value = flexSYSREFPHASESHIFT.iValue
    
    if (Value<64):
        JESD_DAC1_CTRL.iValue=63-Value
        JESD_DAC2_CTRL.iValue=63-JESD_DAC1_CTRL.iValue
        JESD_DAC3_CTRL.iValue=0
        JESD_DAC4_CTRL.iValue=0
    elif (Value<127):
        JESD_DAC1_CTRL.iValue=0
        JESD_DAC2_CTRL.iValue=126-Value
        JESD_DAC3_CTRL.iValue=63-JESD_DAC2_CTRL.iValue
        JESD_DAC4_CTRL.iValue=0
    elif (Value<190):
        JESD_DAC1_CTRL.iValue=0
        JESD_DAC2_CTRL.iValue=0
        JESD_DAC3_CTRL.iValue=189-Value
        JESD_DAC4_CTRL.iValue=63-JESD_DAC3_CTRL.iValue
    else:
        JESD_DAC4_CTRL.iValue=252-Value
        JESD_DAC2_CTRL.iValue=0
        JESD_DAC3_CTRL.iValue=0
        JESD_DAC1_CTRL.iValue=63-JESD_DAC4_CTRL.iValue

def flexSYSREFPHASESHIFT_Update():
    if (flexSYSREFPHASESHIFT.iValue<=0):
        flexSYSREFPHASESHIFT.iValue=0
    elif (flexSYSREFPHASESHIFT.iValue>=247):
        flexSYSREFPHASESHIFT.iValue=247

    if flexSYSREFPHASESHIFT.iValue>224:
        Value=flexSYSREFPHASESHIFT.iValue-225
    else:
        Value = flexSYSREFPHASESHIFT.iValue+27
    
    if (Value<64):
        JESD_DAC1_CTRL.iValue=63-Value
        JESD_DAC2_CTRL.iValue=63-JESD_DAC1_CTRL.iValue
        JESD_DAC3_CTRL.iValue=0
        JESD_DAC4_CTRL.iValue=0
    elif (Value<127):
        JESD_DAC1_CTRL.iValue=0
        JESD_DAC2_CTRL.iValue=126-Value
        JESD_DAC3_CTRL.iValue=63-JESD_DAC2_CTRL.iValue
        JESD_DAC4_CTRL.iValue=0
    elif (Value<190):
        JESD_DAC1_CTRL.iValue=0
        JESD_DAC2_CTRL.iValue=0
        JESD_DAC3_CTRL.iValue=189-Value
        JESD_DAC4_CTRL.iValue=63-JESD_DAC3_CTRL.iValue
    else:
        JESD_DAC4_CTRL.iValue=252-Value
        JESD_DAC2_CTRL.iValue=0
        JESD_DAC3_CTRL.iValue=0
        JESD_DAC1_CTRL.iValue=63-JESD_DAC4_CTRL.iValue

def CHDIV_Update():
    UpdateDistribution()
    
    if (VCO_PHASE_SYNC_EN.iValue==1):
        UpdateIncludedDivide()
        UpdateNDivider() 
    pass
    
def CHDIV_Update_UI():
    ValidateFrequencies()
    UpdateCurrent()
    
def OUTA_MUX_Update():
    UpdateDistribution()
    UpdateCurrent()
    pass   

def OUTB_MUX_Update():
    UpdateDistribution()
    UpdateCurrent()
    pass      
    
    
def UpdateDistribution():
    Divide=1
    SEG1=1
    SEG2=1

    if (0==CHDIV.iValue):
        Divide=2
        SEG1=2
        SEG2=1
    elif (1==CHDIV.iValue):
        Divide=4
        SEG1=4
        SEG2=1      
    elif (2==CHDIV.iValue):
        Divide=4
        SEG1=4
        SEG2=1      
    elif (3==CHDIV.iValue):
        Divide=8
        SEG1=8
        SEG2=1
    elif (4==CHDIV.iValue):
        Divide=12
        Divide=8
        SEG1=8
        SEG2=1
    elif (5==CHDIV.iValue):
        Divide=16
        SEG1=8
        SEG2=2      
    elif (6==CHDIV.iValue):
        Divide=16
        SEG1=8
        SEG2=2 
    elif (7==CHDIV.iValue):
        Divide=32
        SEG1=8
        SEG2=4        
    elif (8==CHDIV.iValue):
        Divide=32
        SEG1=8
        SEG2=4 
    elif (9==CHDIV.iValue):
        Divide=64
        SEG1=8
        SEG2=8   
    elif (10==CHDIV.iValue):
        Divide=64
        SEG1=8
        SEG2=8 
    elif (11==CHDIV.iValue):
        Divide=64
        SEG1=8
        SEG2=8            
    if (12==CHDIV.iValue):
        Divide=128
        SEG1=8
        SEG2=16
    elif (13==CHDIV.iValue):
        Divide=128
        SEG1=8
        SEG2=16      
    if (13 < CHDIV.iValue):
        Divide=256
        SEG1=8
        SEG2=32
        SEG3=8

    
    flexSEG1.iValue=SEG1
    flexSEG2.iValue=SEG2
        
    Fvco=round(Fvco_FREQ.dValue,10)
    Fout = round(Fvco/Divide,10)
    
    if (OUTA_MUX.iValue==0):
        FoutA_FREQ.dValue=Fout
    else:
        FoutA_FREQ.dValue=Fvco
     
    if (OUTB_MUX.iValue==0):
        FoutB_FREQ.dValue=Fout
    elif (OUTB_MUX.iValue==2):
        SysRefDiv=SYSREF_DIV_PRE.iValue
        if (SysRefDiv==0) or (SysRefDiv==3) or (SysRefDiv>4):
            SysRefDiv=1
       
        SysRefDiv = SysRefDiv*(4+2*SYSREF_DIV.iValue)
        
        if (flexSEG1.iValue==3):
            SysRefDiv=6*SysRefDiv
        else:
            SysRefDiv=4*SysRefDiv
        
        FoutB_FREQ.dValue=round(Fvco/SysRefDiv,8)
    else:
        FoutB_FREQ.dValue=Fvco     
        
    if (SYSREF_EN.iValue==1):
        UpdateSYSREFInterpolator()
     
def MASH_ORDER_Update_UI():
    ValidateFrequencies()
    
def MASH_ORDER_Update_UI():
    ValidateFrequencies()
    
def MASH_RESET_N_Update_UI():
    ValidateFrequencies()       
    
    
def PFD_DLY_SEL_Update_UI():
    ValidateFrequencies()    
    
def CAL_CLK_DIV_Update_UI():
    ValidateFrequencies()
    
def FCAL_LPFD_ADJ_Update_UI():
    ValidateFrequencies()
    
def FCAL_HPFD_ADJ_Update_UI():
    ValidateFrequencies()
    
def UpdateCurrent():
    Current=-1
    if (POWERDOWN.iValue==1):
        Current=2.5
    elif (RESET.iValue==1):
        Current = 31
    else:
        #   Core Current based on VCO.  Higher for VCO6
        if (Fvco_FREQ.dValue>5750):
            Current = 60
        elif (Fvco_FREQ.dValue>5200):
            Current = 55
        elif (Fvco_FREQ.dValue>4650):
            Current = 55
        elif (Fvco_FREQ.dValue>4200):
            Current = 51
        elif (Fvco_FREQ.dValue>3650):
            Current = 54
        else:
            Current = 53

        #   Modify based on Fpd
        if (Fpd_FREQ.dValue>100):
            Current=Current+4
        elif (Fpd_FREQ.dValue>20):
            Current=Current+Fpd_FREQ.dValue/20-1.0
            
            
            
        #   Modify based on Kpd
        index=CPG.iValue
        if (index>7):
            index=index-4
        Current=Current-0.2+0.2*index

        #   Modify Based on Divider
        if (OUTA_MUX.iValue==0) or (OUTB_MUX.iValue==0):
            if (CHDIV.iValue>13):
                Current=Current+10
            elif (CHDIV.iValue>3):
                Current=Current+8
            else:
                Current=Current+7

        #   Outputs
        if OUTA_PD.iValue==0:
            Current=Current+10+0.25*OUTA_PWR.iValue

        if OUTB_PD.iValue==0:
            Current=Current+10+0.25*OUTB_PWR.iValue
   
    flexCurrent.dValue=round(Current)

    
def OUTA_PD_Update():
    UpdateCurrent()
    ValidateFrequencies()
    
def OUTB_PD_Update():
    UpdateCurrent()
    ValidateFrequencies()

def OUTA_PWR_Update():
    UpdateCurrent()
    
def OUTB_PWR_Update():
    UpdateCurrent()    
    
def UpdateSYNCStatus():
    if (VCO_PHASE_SYNC_EN.iValue==1):
        M = (OSC_2X.iValue+1)*MULT.iValue
        
        if (OUTA_PD.iValue==0):
            Fout=FoutA_FREQ.dValue
        else:
            Fout=FoutB_FREQ.dValue
        
        Fosc=Fosc_FREQ.dValue
        if (Fosc<0.00001):
            Fosc=1.0
            
        Ratio  = math.floor((Fout+1e-10)/Fosc_FREQ.dValue)
        
        if (abs(Ratio*1.0-Fout/Fosc)<0.00000000001):
            TimingNonCritical=True
        else:
            TimingNonCritical=False

        if (CHDIV.iValue>15):
            UpdateStatusBar("Device in SYNC Category 4(SYNC not Possible):\nThis is because the channel divide is 512 or greater.")
        elif (M==1):
            if (TimingNonCritical==False):
                UpdateStatusBar("Device in SYNC Category 3(Timed SYNC Required):\nThis is because the output frequency is not a multiple of the input frequency.\nAlso check the datasheet for limitations on the maximum input frequency.")                
            elif (CHDIV.iValue>2):
                UpdateStatusBar("Device in SYNC Category 2(Non-Timed SYNC Required):\nSyncronization is required for the output divider, the timing is not critical.\nThis can be done with the SYNC pin with no timing concerns, or by toggling the VCO_PHASE_SYNC bit from 0 to 1.")
            else:
                UpdateStatusBar("Device in SYNC Category 1(No SYNC Required):\nAll division is in the loop and the output is a multiple of the input frequency, so the output will always be in SYNC with the input.")            
        else:
            if (Ratio % M == 0) and (PLL_NUM.iValue==0):
                UpdateStatusBar("Device in SYNC Category 1(No SYNC Required):\n\nAll division is in the loop and the output is a multiple of the input frequency, so the output will always be in SYNC with the input.\nIn this special case, although there multiplication in the input path and the timing for this is not determinsitic, it does not matter because all other elements are tracked out by the loop.")                
            else:
                UpdateStatusBar("Device in SYNC Category 4(SYNC not Possible):\nSYNC is not possible because timing for multiplication in the input path is not closed and this is only possible in integer mode and with the output divider entirely in the loop.")               

def GetCHANDIV(Index):
    i=int(Index)
    x=1
    if (i==0):
        x=2
    elif (i==1):
        x=4
    elif (i==2):
        x=-6
    elif (i==3):
        x=8
    elif (i==4):
        x=-12
    elif (i==5):
        x=16
    elif (i==6):
        x=-24
    elif (i==7):
        x=32
    elif (i==8):
        x=-48
    elif (i==9):
        x=64
    elif (i==10):
        x=-72
    elif (i==11):
        x=-96
    elif (i==12):
        x=128
    elif (i==13):
        x=-192
    elif (i==14):
        x=-256
    elif (i==15):
        x=-384
    elif (i==16):
        x=-512
    elif (x==17):
        x=-768
        
    return x
