"""
Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/ 
ALL RIGHTS RESERVED 
"""

from System.Windows.Media import SolidColorBrush, Color, Colors

from System.Windows.Controls import(ComboBox,ComboBoxItem)
from System.Windows import TextAlignment,FontWeights

import sys
import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import DialogResult, MessageBox, MessageBoxButtons, MessageBoxIcon

import math


brush_warning = SolidColorBrush(Color.FromArgb(255,204,0,0))
brush_white = SolidColorBrush(Color.FromArgb(255,255,255,255))
brush_alert = SolidColorBrush(Color.FromArgb(255,253,205,52))

# Note: In some places elements are accessed using UIC_Control (UI Control Element) because of the clash with controls in User Controls Page

    
class GlobalVariables(object):
	def __init__(self):
		self.VCO_freq_state = "";
g = GlobalVariables();

def System_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    ValidateFrequencies()

def System_Update_Loaded_Mode():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    ValidateFrequencies()
    
def System_Update_Run_Once():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    System_Update_Run_Once_UI()

def System_Update_Run_Once_UI():
    UIC_Fpd_FREQ.TextAlignment = TextAlignment.Right

    UIC_Kvco.TextAlignment = TextAlignment.Left
    UIC_Fvco_FREQ.TextAlignment = TextAlignment.Left
    
    UIC_FoutA_FREQ.TextAlignment = TextAlignment.Left
    UIC_FoutB_FREQ.TextAlignment = TextAlignment.Left
    ValidateFrequencies()
    
def UpdateFpdFrequency():
    R = PLL_R.iValue
    if (R<1):
        R=1
    Fpd = Fosc_FREQ.dValue/R*(1+OSC_2X.iValue)
    Fpd_FREQ.dValue=Fpd
    pass  
    


def UpdateVCOGain():
    Fvco=Fvco_FREQ.dValue
        
    if (Fvco<2168):
        VCOCoreSel=1
    elif (Fvco<2290.1):
        if (VCO_SEL.iValue==0):
            VCOCoreSel=1
        else:
            VCOCoreSel=2
    elif (Fvco<2743.1):
        if (VCO_SEL.iValue<3):
            VCOCoreSel=2
        else:
            VCOCoreSel=3
    elif (Fvco<3248.1):
        if (VCO_SEL.iValue<4):
            VCOCoreSel=3
        else:
            VCOCoreSel=4
    else:
        VCOCoreSel=4
        
    if (Fvco<1880):
        KvcoCalc = 12
    elif (Fvco>3760):
        KvcoCalc=37
    elif (VCOCoreSel==1):
        KvcoCalc = 12+(24-12)*(Fvco-1880)/(2290-1880)
    elif (VCOCoreSel==2):
        KvcoCalc = 15+(30-15)*(Fvco-2168)/(2743-2168)        
    elif (VCOCoreSel==3):
        KvcoCalc = 20+(37-20)*(Fvco-2650)/(3248-2650)
    else:
        KvcoCalc = 37+(37-21)*(Fvco-3126)/(3760-3126)
        
    VCOCore.dValue=VCOCoreSel
    Kvco.dValue=KvcoCalc

def ValidateFrequencies():
    Fosc=Fosc_FREQ.dValue
    Fpd =Fpd_FREQ.dValue
    Fvco=Fvco_FREQ.dValue
    
    #   Validate OSCin
    if (Fosc<5):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Minimum Fosc is 5 MHz"
    elif (Fosc>900):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Maximum Fosc is 900 MHz"
    elif (Fosc>250) and (OSC_2X.iValue==1):
        UIC_Fosc_FREQ.Background = brush_warning
        UIC_Fosc_FREQ.ToolTip="Maximum Fosc is 250 MHz with the OSCin doubler enabled."
    else:
        UIC_Fosc_FREQ.Background = brush_white
        UIC_Fosc_FREQ.ToolTip=None  

    #   Validate OSC_FREQ
    OldIndex=OSC_FREQ.iValue
    if (Fosc<64.01):
        NewIndex=0
    elif (Fosc<128.01):
        NewIndex=1
    elif (Fosc<256.01):
        NewIndex=2
    elif (Fosc<512.01):
        NewIndex=3
    else:
        NewIndex=4
        
    if (OldIndex==NewIndex):
        UIC_OSC_FREQ.Background = brush_white
        UIC_OSC_FREQ.ToolTip = None
    else:
        UIC_OSC_FREQ.Background = brush_alert
        UIC_OSC_FREQ.ToolTip = "OSC_FREQ Needs to Be adjusted new OSCin Frequency."    
            
    #   Validate OSCin Doubler
    if  (OSC_2X.iValue==1) and (Fosc>250):
        UIC_OSC_2X.Background = brush_warning
        UIC_OSC_2X.ToolTip = "Maximum Input Frequency for the OSCin doubler is 250 MHz."
    else:
        UIC_OSC_2X.Background = brush_white
        UIC_OSC_2X.ToolTip=None
    
    #   Validate Fpd
    if (Fpd_FREQ.dValue>200):
        UIC_Fpd_FREQ.Background = brush_warning
        UIC_Fpd_FREQ.ToolTip="Maximum Phase Detector Frequency is 200 MHz."
    else:
        UIC_Fpd_FREQ.Background = brush_white
        UIC_Fpd_FREQ.ToolTip=None
        
   
    #   Validate N Divider & Order
    N=PLL_N.iValue
    Order=FRAC_ORDER.iValue
    if (Order==0):
        Nmin=7
    elif (Order==1):
        Nmin=7
    elif (Order==2):
        Nmin=8
    elif (Order==3):
        Nmin=10
    elif (Order==4):
        Nmin=14
     
    if (N<7):
        UIC_PLL_N.ToolTip="PLL_N values below 7 are not supported (2016-05-02)"
        UIC_PLL_N.GetTextBox().Background = brush_warning
        UIC_FRAC_ORDER.ToolTip=None
        UIC_FRAC_ORDER.Background=brush_white
    elif (N<Nmin):
        UIC_PLL_N.ToolTip="This PLL_N value is too low for this FRAC_ORDER, but could be supported if the FRAC_ORDER is reduced."
        UIC_PLL_N.GetTextBox().Background = brush_warning 
        UIC_FRAC_ORDER.Background=brush_alert   
        if (N<8):
            UIC_FRAC_ORDER.ToolTip="Try using the 1st Order Modulator."
        elif (N<10):
            UIC_FRAC_ORDER.ToolTip="Try using the 2nd Order Modulator."
        elif (N<14):
            UIC_FRAC_ORDER.ToolTip="Try using the 3rd Order Modulator."
    else:
        UIC_PLL_N.ToolTip= None
        UIC_PLL_N.GetTextBox().Background = brush_white      
        UIC_FRAC_ORDER.ToolTip=None
        UIC_FRAC_ORDER.Background=brush_white
        
    #   Validate FRAC_DITHER
    UIC_FRAC_DITHER.Background=brush_white
    UIC_FRAC_DITHER.ToolTip=None
    
    if (FRAC_DITHER.iValue<3):
        Fnum=PLL_NUM.iValue
        Fden=PLL_DEN.iValue
        if (Fnum==0) or (Fden==0):
            Fden=1
            Fnum=0
        Divisor=2
        while (Divisor<4):
            if (0 == (Fnum%Divisor)) and (0==(Fden%Divisor)):
                Fnum=Fnum/Divisor
                Fden=Fden/Divisor
            else:
                Divisor=Divisor+1
            
        NoDither=0
        if (Fnum==0):
            NoDither=1
        if (FRAC_ORDER.iValue<2):
            NoDither=1
        if (0 < (Fden % 2)) and (FRAC_ORDER.iValue==2):
            NoDither=1
        if (0 <(Fden % 2)) and (0 <(Fden % 3)) and(FRAC_ORDER.iValue>2):
            NoDither=1

        if (NoDither==1) and (FRAC_DITHER.iValue<3):
            UIC_FRAC_DITHER.Background=brush_alert
            UIC_FRAC_DITHER.ToolTip="Dithering will likely not improve performance in this situation as there should be no sub-fractional spurs."
        else:
            UIC_FRAC_DITHER.Background=brush_white
            UIC_FRAC_DITHER.ToolTip="None"    
   
    #   Validate VCO Frequency
    UIC_Fvco_FREQ.Background = brush_white
    UIC_Fvco_FREQ.ToolTip=None
    if (Fvco_FREQ.dValue<1880):
        UIC_Fvco_FREQ.ToolTip="Minimum VCO Frequency is 1880 MHz."
        UIC_Fvco_FREQ.Background = brush_warning
    elif (Fvco_FREQ.dValue>3760):
        UIC_Fvco_FREQ.Background = brush_warning
        UIC_Fvco_FREQ.ToolTip="Maximum VCO Frequency is 3760 MHz." 
        


    #   Validate Outputs
    if ( (FoutA_FREQ.dValue<49.47) or (FoutA_FREQ.dValue>3760.1) ):
        UIC_FoutA_FREQ.ToolTip="Valid Frequency range is 49.47 to 3760 MHz."
        UIC_FoutA_FREQ.Background=brush_warning
    else:
        UIC_FoutA_FREQ.ToolTip=None
        UIC_FoutA_FREQ.Background=brush_white
        
    if ( (FoutB_FREQ.dValue<49.47) or (FoutB_FREQ.dValue>3760.1) ):
        UIC_FoutB_FREQ.ToolTip="Valid Frequency range is 49.47 to 3760 MHz."
        UIC_FoutB_FREQ.Background=brush_warning
    else:
        UIC_FoutB_FREQ.ToolTip=None
        UIC_FoutB_FREQ.Background=brush_white
    
  
    UIC_VCO_SEL.Background=brush_white
    
    #   Re-Validate for External VCO Mode
    if (MODE.iValue>0):
        
            #   Validate VCO Frequency
        UIC_Fvco_FREQ.Background = brush_white
        UIC_Fvco_FREQ.ToolTip=None
        if (Fvco_FREQ.dValue<500):
            UIC_Fvco_FREQ.ToolTip="Minimum VCO Frequency is 5000 MHz."
            UIC_Fvco_FREQ.Background = brush_warning
        elif (Fvco_FREQ.dValue>2200):
            UIC_Fvco_FREQ.Background = brush_warning
            UIC_Fvco_FREQ.ToolTip="Maximum VCO Frequency is 2200 MHz." 
    
    ValidatePFDandDLD()
    UpdatePowerSettings()

    
def btn_SimplifyFraction_Update_UI():
    Fnum=PLL_NUM.iValue
    Fden=PLL_DEN.iValue

    if  ((Fnum==0) or (Fden==0)):
        Fden=1
        Fnum=0
    else:
        Divisor = 2      
        while ( Divisor<Fnum+1):
            if (0 == (Fnum % Divisor)) and (0 == (Fden % Divisor)):
                Fnum=Fnum/Divisor
                Fden=Fden/Divisor
            else:
                Divisor=Divisor+1
                
        if (Fden%Fnum==0):
            Fden=Fden/Fnum
            Fnum=1
              
    UpdateStatusBar("Fraction Simplified to "+str(Fnum)+"/"+str(Fden))     
    PLL_DEN.iValue=Fden
    PLL_NUM.iValue=Fnum
    
def btn_SetupFastCal_Update_UI():
    Fvco=Fvco_FREQ.dValue
    if (Fvco<2280):
        VCOCore=0
        VCOCap=int(255.5-255*(Fvco-1827)/(2290-1827))
    elif (Fvco<2680):
        VCOCore=1
        VCOCap=int(255.5-255*(Fvco-2168)/(2743-2168))
    elif (Fvco<3220):
        VCOCore=2
        VCOCap=int(255.5-255*(Fvco-2650)/(3248-2650))
    else:
        VCOCore=3
        VCOCap=int(255.5-255*(Fvco-3126)/(3833-3126))
        
    if (VCOCap<0):
        VCOCap=0
    if (VCOCap>255):
        VCOCap=255
    
    if (VCO_SEL.iValue==VCOCore):
        UIC_VCO_SEL.Background=brush_white
        UIC_VCO_SEL.ToolTip=None
    else:
        VCO_SEL.iValue=VCOCore
        UIC_VCO_SEL.Background=brush_alert
        UIC_VCO_SEL.ToolTip="VCO_SEL was changed."
        UpdateStatusBar("VCO_SEL should be changed to "+str(VCOCore+1))

    if (VCO_CAPCODE.iValue==VCOCap):
        UIC_CAPCODE.Background=brush_white
        UIC_VCO_CAPCODE.ToolTip=None
    else:
        VCO_CAPCODE.iValue=VCOCap
        UIC_VCO_CAPCODE.Background=brush_alert
        UIC_VCO_CAPCODE.ToolTip="VCO_CAPCODE was changed."
        UpdateStatusBar("VCO_CAPCODE should be changed to "+str(VCOCap))      

    if (VCO_SEL_MODE.iValue<>1):
        UIC_VCO_SEL_MODE.Background=brush_alert
        UIC_VCO_SEL_MODE.ToolTip="Changed this to start at optimal point."
        UpdateStatusBar("Changing VCO_SEL_MODE to start at VCO_SEL Frequency.")
        VCO_SEL_MODE.iValue=1
    else:
        UIC_VCO_SEL_MODE.Background=brush_white
        UIC_VCO_SEL_MODE.ToolTip=None 

    UpdatePowerSettings()

def Fosc_FREQ_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
        
def Fosc_FREQ_UI():    
    ValidateFrequencies()  

def OSC_2X_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
    
def OSC_2X_Update_UI():
    ValidateFrequencies() 
    
def PLL_R_Update():
    UpdateFpdFrequency()
    UpdateVCOFrequency() 
   
def PLL_R_Update_UI():
    ValidateFrequencies()

def Fpd_FREQ_Update():
    Fpd = Fpd_FREQ.dValue
    Fosc = Fosc_FREQ.dValue*(OSC_2X.iValue+1)
    if (Fpd<0.000001):
        Fpd = Fosc/PLL_R.iValue
    Rdiv=Fosc/Fpd
    PLL_R.iValue=int(Rdiv+0.5)
    Fpd_FREQ.dValue=Fosc/PLL_R.iValue
    UpdateNDivider()
    UpdateVCOFrequency() 
    
def Fpd_FREQ_Update_UI():
    ValidateFrequencies()
    
def PLL_N_Update():
    UpdateVCOFrequency() 
        
def PLL_N_Update_UI():
    ValidateFrequencies() 
    
def PLL_NUM_Update():
    UpdateVCOFrequency() 

def PLL_NUM_Update_UI():
    ValidateFrequencies()
    
def PLL_DEN_Update():
    UpdateVCOFrequency() 

def PLL_DEN_Update_UI():
    ValidateFrequencies()
        
def Fvco_FREQ_Update():
    UpdateNDivider() 
    UpdateVCOGain()
        
def Fvco_FREQ_Update_UI():
    ValidateFrequencies()

def VCO_SEL_Update():
    UpdateVCOGain()
    ValidateFrequencies()
    
def VCO_DIV_Update():
    UpdateDistribution()
    ValidateFrequencies()
    
def OUTA_MUX_Update():
    UpdateDistribution()
    ValidateFrequencies()
    
def OUTB_MUX_Update():
    UpdateDistribution()
    ValidateFrequencies()
       
def OUTA_PWR_Update():
    ValidateFrequencies()

def OUTB_PWR_Update():
    ValidateFrequencies()
    
def OUTA_PD_Update():
    ValidateFrequencies()
    
def OUTB_PD_Update():
    ValidateFrequencies()
    

def FoutA_FREQ_Update():
    Fout = FoutA_FREQ.dValue
    FvcoMin=1880
    FvcoMax=3760
    if (Fout<49.47):
        Fout=50

    if (Fout>FvcoMin-0.001):
        OUTA_MUX.iValue=0
        Fvco_FREQ.dValue=Fout
    else:
        OUTA_MUX.iValue=1 
        DIV=2*int( (FvcoMin+FvcoMax)/(4*Fout)+0.5 )
        if (DIV<2):
            DIV=2
        if (DIV>38):
            DIV=38    

        Fvco_FREQ.dValue=DIV*Fout
        VCO_DIV.iValue=int(DIV/2)-1
        
    
    UpdateNDivider() 
    UpdateVCOGain()
    UpdateDistribution()
    
def FoutA_FREQ_Update_UI():
    ValidateFrequencies()
    
def FoutB_FREQ_Update():
    Fout = FoutB_FREQ.dValue
    FvcoMin=1880
    FvcoMax=3760
    if (Fout<49.47):
        Fout=50

    if (Fout>FvcoMin-0.001):
        OUTB_MUX.iValue=0
        Fvco_FREQ.dValue=Fout
    else:
        OUTB_MUX.iValue=1
        DIV=2*int( (FvcoMin+FvcoMax)/(4*Fout)+0.5 )
        if (DIV<2):
            DIV=2
        if (DIV>38):
            DIV=38    

        Fvco_FREQ.dValue=DIV*Fout
        VCO_DIV.iValue=int(DIV/2)-1
    
    UpdateNDivider() 
    UpdateVCOGain()
    UpdateDistribution()

def FoutB_FREQ_Update_UI():
    ValidateFrequencies()

def MODE_Update():
    ValidateFrequencies()
    
def OSC_FREQ_Update():
    ValidateFrequencies()
    
def DLD_TOL_Update():
    ValidateFrequencies()
    
def PFD_DLY_Update():
    ValidateFrequencies()
    
def FRAC_ORDER_Update():
    ValidatePFDandDLD()
    
def FRAC_DITHER_Update():
    ValidateFrequencies()
    
def UpdateVCOFrequency():
    Fnum=PLL_NUM.iValue
    Fden=PLL_DEN.iValue
    
    if (Fden<1):
        Fden=1
    N=PLL_N.iValue
    FracN=1.0*N+Fnum*1.0/Fden
    Fvco_FREQ.dValue=round(FracN*Fpd_FREQ.dValue,10)
        
    UpdateVCOGain()
    UpdateDistribution()
    pass

def UpdateNDivider():
    Fvco=Fvco_FREQ.dValue
    Fden=PLL_DEN.iValue
    if (Fden<1):
        Fden=1
        PLL_DEN.iValue=1
    Fpd=Fpd_FREQ.dValue
    if (Fpd<0.0000001):
        Fpd_FREQ.dValue=1
        Fpd=1
        
    FracN=Fvco/Fpd
    N=math.floor(FracN)
    PLL_N.iValue=N
    PLL_NUM.iValue=round(Fden*(FracN-N))
    UpdateVCOFrequency()
    pass
    
    
    
def UpdateDistribution():
    Fosc=Fosc_FREQ.dValue
    Fvco=Fvco_FREQ.dValue 
    
    CHDIV=2+2*VCO_DIV.iValue  
    Fout = Fvco/CHDIV
    
    if (OUTA_MUX.iValue==0):
        FoutA_FREQ.dValue=Fvco
    elif (OUTA_MUX.iValue==1):
        FoutA_FREQ.dValue=Fout
    else:
        FoutA_FREQ.dValue=Fosc
     
    if (OUTB_MUX.iValue==0):
        FoutB_FREQ.dValue=Fvco
    elif (OUTB_MUX.iValue==1):
        FoutB_FREQ.dValue=Fout
    else:
        FoutB_FREQ.dValue=Fosc
    pass
    
def ValidatePFDandDLD():
    Fvco=Fvco_FREQ.dValue
    
    if (Fvco<0.001):
        Tvco=0
    else:
        Tvco=1000000/Fvco
        
    Fpd=Fpd_FREQ.dValue
    if (Fpd<0.0001):
        Tpd=0
    else:
        Tpd=1000000.0/Fpd
    
    iPFD=PFD_DLY.iValue
    if (0==iPFD):
        Tpfd=370
    elif (1==iPFD):
        Tpfd=760
    elif (2==iPFD):
        Tpfd=1130
    elif (3==iPFD):
        Tpfd=1460
    elif (4==iPFD):
        Tpfd=1770
    elif (5==iPFD):
        Tpfd=2070
    elif (6==iPFD):
        Tpfd=2350
    else:
        Tpfd=2600

    if (Tpfd>Tpd/4):
        UIC_PFD_DLY.ToolTip="PFD_DLY needs to be adjusted to a value less than one-fourth of the phase detector period, which is " + str(Tpfd/4)
        UIC_PFD_DLY.Background=brush_alert
    elif (PFD_DLY.iValue>0) and (FRAC_DITHER.iValue==3):
        UIC_PFD_DLY.ToolTip="Using a PFD_DLY greater than the minimum value with dithering disabled typically has no benefit and may degrade PLL phase noise."
        UIC_PFD_DLY.Background=brush_alert
    else:
        UIC_PFD_DLY.ToolTip=None
        UIC_PFD_DLY.Background=brush_white

    #   Validate DLD_TOL
    iDLD=DLD_TOL.iValue
    if (0==iDLD):
        Tdld=1000
    elif (1==iDLD):
        Tdld=1700
    elif (2==iDLD):
        Tdld=3000
    elif (3==iDLD):
        Tdld=6000
    elif (4==iDLD):
        Tdld=10000
    else:
        Tdld=18000

    if (FRAC_ORDER.iValue==0):
        Deviation=0
    elif (FRAC_ORDER.iValue==1):
        Deviation=1
    elif (FRAC_ORDER.iValue==2):
        Deviation=2
    elif (FRAC_ORDER.iValue==3):
        Deviation=4
    else:
        Deviation=8
         
    TdldMin=Deviation*Tvco
     
    if (TdldMin<1001):
        MinIndex=0
    elif (TdldMin<1701):
        MinIndex=1
    elif (TdldMin<3001):
        MinIndex=2
    elif (TdldMin<6001):
        MinIndex=3
    elif (TdldMin<10001):
        MinIndex=4
    elif (TdldMin<18001):
        MinIndex=5
    else:
        MinIndex=-1
     
    TdldMax=Tpd/2 
    if (TdldMax>17999):
        MaxIndex=5
    elif (TdldMax>9999):
        MaxIndex=4
    elif (TdldMax>5999):
        MaxIndex=3
    elif (TdldMin>2999):
        MaxIndex=2
    elif (TdldMax>1699):
        MaxIndex=1
    elif (TdldMin>999):
        MaxIndex=0
    else:
        MaxIndex=-1     
    
    BestTime=-1
    if (MinIndex==-1):
        BestIndex=0
    elif (MaxIndex==-1):
        BestIndex=5
    else:
        BestIndex=int( (MinIndex+MaxIndex)/2  )
        if (BestIndex==0):
            BestTime=1
        elif (BestIndex==1):
            BestTime=1.7
        elif (BestIndex==2):
            BestTime=3
        elif (BestIndex==3):
            BestTime=6
        elif (BestIndex==4):
            BestTime=10
        else:
            BestTime=18
            
             
    if (MinIndex==-1):
        UIC_DLD_TOL.ToolTip="The modulator order must be reduced in order for Digital Lock Detect to work."
        UIC_DLD_TOL.Background=brush_alert
    elif (MaxIndex==-1):
        UIC_DLD_TOL.ToolTip="The phase detector freqeuncy must be reduced in order for Digital Lock Detect to work."
        UIC_DLD_TOL.Background=brush_alert
    elif (iDLD<MinIndex):    
        UIC_DLD_TOL.ToolTip="For FRAC_ORDER="+str(FRAC_ORDER.iValue)+", DLD_TOL should be at least "+str(Deviation)+" VCO Cycles, which is "+str(TdldMin)+" ps."
        UIC_DLD_TOL.Background=brush_alert
    elif (iDLD>MaxIndex):
        UIC_DLD_TOL.ToolTip="For a phase detector of "+str(Fpd)+" MHz, DLD_TOL should be no more than half of a phase detector period which is " +str(TdldMax)+" ps."
        UIC_DLD_TOL.Background=brush_alert

    else:
        UIC_DLD_TOL.ToolTip=None
        UIC_DLD_TOL.Background=brush_white
    
def UpdatePowerSettings():
    if (MODE.iValue==1):
        SumCurrent=85
    else:
        SumCurrent=134
  
    if ((OUTA_MUX.iValue<>0) and (OUTA_PD.iValue==0)) or ((OUTB_MUX.iValue<>0) and (OUTB_PD.iValue==0)):
        SumCurrent=SumCurrent+20
        UnDim(VCO_DIV)
    else:
        Dim(VCO_DIV)
        
    if (OUTA_PD.iValue==0):
        SumCurrent= SumCurrent + 44 + (1.0*OUTA_PWR.iValue-15)
        if (OUTA_PWR.iValue<6):
            SumCurrent=SumCurrent-1
        UnDim(OUTA_MUX)
        UnDim(OUTA_PWR)
        UnDim(FoutA_FREQ)
    else:
        Dim(OUTA_MUX)
        Dim(OUTA_PWR)
        Dim(FoutA_FREQ)
            
    if (OUTB_PD.iValue==0):
        SumCurrent= SumCurrent + 44 + (1.0*OUTB_PWR.iValue-15)
        if (OUTB_PWR.iValue<6):
            SumCurrent=SumCurrent-1
        UnDim(OUTB_MUX)
        UnDim(OUTB_PWR)
        UnDim(FoutB_FREQ)
    else:
        Dim(OUTB_MUX)
        Dim(OUTB_PWR)
        Dim(FoutB_FREQ)
        
    Current.dValue=SumCurrent

    


    
